% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_restore_certificate_authority}
\alias{acmpca_restore_certificate_authority}
\title{Restores a certificate authority (CA) that is in the DELETED state}
\usage{
acmpca_restore_certificate_authority(CertificateAuthorityArn)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called the
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}
action. This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}
}
\value{
An empty list.
}
\description{
Restores a certificate authority (CA) that is in the \code{DELETED} state.
You can restore a CA during the period that you defined in the
\strong{PermanentDeletionTimeInDays} parameter of the
\code{\link[=acmpca_delete_certificate_authority]{delete_certificate_authority}}
action. Currently, you can specify 7 to 30 days. If you did not specify
a \strong{PermanentDeletionTimeInDays} value, by default you can restore the
CA at any time in a 30 day period. You can check the time remaining in
the restoration period of a private CA in the \code{DELETED} state by calling
the
\code{\link[=acmpca_describe_certificate_authority]{describe_certificate_authority}}
or \code{\link[=acmpca_list_certificate_authorities]{list_certificate_authorities}}
actions. The status of a restored CA is set to its pre-deletion status
when the \strong{RestoreCertificateAuthority} action returns. To change its
status to \code{ACTIVE}, call the
\code{\link[=acmpca_update_certificate_authority]{update_certificate_authority}}
action. If the private CA was in the \code{PENDING_CERTIFICATE} state at
deletion, you must use the
\code{\link[=acmpca_import_certificate_authority_certificate]{import_certificate_authority_certificate}}
action to import a certificate authority into the private CA before it
can be activated. You cannot restore a CA after the restoration period
has ended.
}
\section{Request syntax}{
\preformatted{svc$restore_certificate_authority(
  CertificateAuthorityArn = "string"
)
}
}

\keyword{internal}
