% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_rule}
\alias{wafregional_delete_rule}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_delete_rule(RuleId, ChangeToken)
}
\arguments{
\item{RuleId}{[required] The \code{RuleId} of the Rule that you want to delete. \code{RuleId} is returned
by CreateRule and by ListRules.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a Rule. You can't delete a \code{Rule} if it's still used
in any \code{WebACL} objects or if it still includes any predicates, such as
\code{ByteMatchSet} objects.

If you just want to remove a \code{Rule} from a \code{WebACL}, use UpdateWebACL.

To permanently delete a \code{Rule} from AWS WAF, perform the following
steps:
\enumerate{
\item Update the \code{Rule} to remove predicates, if any. For more
information, see UpdateRule.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteRule} request.
\item Submit a \code{DeleteRule} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_rule(
  RuleId = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes a rule with the ID WAFRule-1-Example.
svc$delete_rule(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  RuleId = "WAFRule-1-Example"
)
}

}
\keyword{internal}
