% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_access_key}
\alias{iam_create_access_key}
\title{Creates a new AWS secret access key and corresponding AWS access key ID
for the specified user}
\usage{
iam_create_access_key(UserName)
}
\arguments{
\item{UserName}{The name of the IAM user that the new key will belong to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}
}
\description{
Creates a new AWS secret access key and corresponding AWS access key ID
for the specified user. The default status for new keys is \code{Active}.

If you do not specify a user name, IAM determines the user name
implicitly based on the AWS access key ID signing the request. This
operation works for access keys under the AWS account. Consequently, you
can use this operation to manage AWS account root user credentials. This
is true even if the AWS account has no associated users.

The number and size of IAM resources in an AWS account are limited. For
more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html}{IAM and STS Quotas}
in the \emph{IAM User Guide}.

To ensure the security of your AWS account, the secret access key is
accessible only during key and user creation. You must save the key (for
example, in a text file) if you want to be able to access it again. If a
secret key is lost, you can delete the access keys for the associated
user and then create new keys.
}
\section{Request syntax}{
\preformatted{svc$create_access_key(
  UserName = "string"
)
}
}

\examples{
\dontrun{
# The following command creates an access key (access key ID and secret
# access key) for the IAM user named Bob.
svc$create_access_key(
  UserName = "Bob"
)
}

}
\keyword{internal}
