# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include apigateway_service.R
NULL

#' Create an ApiKey resource
#'
#' @description
#' Create an ApiKey resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_api_key/](https://www.paws-r-sdk.com/docs/apigateway_create_api_key/) for full documentation.
#'
#' @param name The name of the ApiKey.
#' @param description The description of the ApiKey.
#' @param enabled Specifies whether the ApiKey can be used by callers.
#' @param generateDistinctId Specifies whether (`true`) or not (`false`) the key identifier is
#' distinct from the created API key value. This parameter is deprecated
#' and should not be used.
#' @param value Specifies a value of the API key.
#' @param stageKeys DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API
#' key.
#' @param customerId An Amazon Web Services Marketplace customer identifier, when integrating
#' with the Amazon Web Services SaaS Marketplace.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_api_key
apigateway_create_api_key <- function(name = NULL, description = NULL, enabled = NULL, generateDistinctId = NULL, value = NULL, stageKeys = NULL, customerId = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateApiKey",
    http_method = "POST",
    http_path = "/apikeys",
    paginator = list()
  )
  input <- .apigateway$create_api_key_input(name = name, description = description, enabled = enabled, generateDistinctId = generateDistinctId, value = value, stageKeys = stageKeys, customerId = customerId, tags = tags)
  output <- .apigateway$create_api_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_api_key <- apigateway_create_api_key

#' Adds a new Authorizer resource to an existing RestApi resource
#'
#' @description
#' Adds a new Authorizer resource to an existing RestApi resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_authorizer/](https://www.paws-r-sdk.com/docs/apigateway_create_authorizer/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param name &#91;required&#93; The name of the authorizer.
#' @param type &#91;required&#93; The authorizer type. Valid values are `TOKEN` for a Lambda function
#' using a single authorization token submitted in a custom header,
#' `REQUEST` for a Lambda function using incoming request parameters, and
#' `COGNITO_USER_POOLS` for using an Amazon Cognito user pool.
#' @param providerARNs A list of the Amazon Cognito user pool ARNs for the `COGNITO_USER_POOLS`
#' authorizer. Each element is of this format:
#' `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`. For
#' a `TOKEN` or `REQUEST` authorizer, this is not defined.
#' @param authType Optional customer-defined field, used in OpenAPI imports and exports
#' without functional impact.
#' @param authorizerUri Specifies the authorizer's Uniform Resource Identifier (URI). For
#' `TOKEN` or `REQUEST` authorizers, this must be a well-formed Lambda
#' function URI, for example,
#' `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations`.
#' In general, the URI has this form
#' `arn:aws:apigateway:{region}:lambda:path/{service_api}`, where
#' `{region}` is the same as the region hosting the Lambda function, `path`
#' indicates that the remaining substring in the URI should be treated as
#' the path to the resource, including the initial `/`. For Lambda
#' functions, this is usually of the form
#' `/2015-03-31/functions/[FunctionARN]/invocations`.
#' @param authorizerCredentials Specifies the required credentials as an IAM role for API Gateway to
#' invoke the authorizer. To specify an IAM role for API Gateway to assume,
#' use the role's Amazon Resource Name (ARN). To use resource-based
#' permissions on the Lambda function, specify null.
#' @param identitySource The identity source for which authorization is requested. For a `TOKEN`
#' or `COGNITO_USER_POOLS` authorizer, this is required and specifies the
#' request header mapping expression for the custom header holding the
#' authorization token submitted by the client. For example, if the token
#' header name is `Auth`, the header mapping expression is
#' `method.request.header.Auth`. For the `REQUEST` authorizer, this is
#' required when authorization caching is enabled. The value is a
#' comma-separated string of one or more mapping expressions of the
#' specified request parameters. For example, if an `Auth` header, a `Name`
#' query string parameter are defined as identity sources, this value is
#' `method.request.header.Auth, method.request.querystring.Name`. These
#' parameters will be used to derive the authorization caching key and to
#' perform runtime validation of the `REQUEST` authorizer by verifying all
#' of the identity-related request parameters are present, not null and
#' non-empty. Only when this is true does the authorizer invoke the
#' authorizer Lambda function, otherwise, it returns a 401 Unauthorized
#' response without calling the Lambda function. The valid value is a
#' string of comma-separated mapping expressions of the specified request
#' parameters. When the authorization caching is not enabled, this property
#' is optional.
#' @param identityValidationExpression A validation expression for the incoming identity token. For `TOKEN`
#' authorizers, this value is a regular expression. For
#' `COGNITO_USER_POOLS` authorizers, API Gateway will match the `aud` field
#' of the incoming token from the client against the specified regular
#' expression. It will invoke the authorizer's Lambda function when there
#' is a match. Otherwise, it will return a 401 Unauthorized response
#' without calling the Lambda function. The validation expression does not
#' apply to the `REQUEST` authorizer.
#' @param authorizerResultTtlInSeconds The TTL in seconds of cached authorizer results. If it equals 0,
#' authorization caching is disabled. If it is greater than 0, API Gateway
#' will cache authorizer responses. If this field is not set, the default
#' value is 300. The maximum value is 3600, or 1 hour.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_authorizer
apigateway_create_authorizer <- function(restApiId, name, type, providerARNs = NULL, authType = NULL, authorizerUri = NULL, authorizerCredentials = NULL, identitySource = NULL, identityValidationExpression = NULL, authorizerResultTtlInSeconds = NULL) {
  op <- new_operation(
    name = "CreateAuthorizer",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/authorizers",
    paginator = list()
  )
  input <- .apigateway$create_authorizer_input(restApiId = restApiId, name = name, type = type, providerARNs = providerARNs, authType = authType, authorizerUri = authorizerUri, authorizerCredentials = authorizerCredentials, identitySource = identitySource, identityValidationExpression = identityValidationExpression, authorizerResultTtlInSeconds = authorizerResultTtlInSeconds)
  output <- .apigateway$create_authorizer_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_authorizer <- apigateway_create_authorizer

#' Creates a new BasePathMapping resource
#'
#' @description
#' Creates a new BasePathMapping resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_base_path_mapping/](https://www.paws-r-sdk.com/docs/apigateway_create_base_path_mapping/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name of the BasePathMapping resource to create.
#' @param basePath The base path name that callers of the API must provide as part of the
#' URL after the domain name. This value must be unique for all of the
#' mappings across a single API. Specify '(none)' if you do not want
#' callers to specify a base path name after the domain name.
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stage The name of the API's stage that you want to use for this mapping.
#' Specify '(none)' if you want callers to explicitly specify the stage
#' name after any base path name.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_base_path_mapping
apigateway_create_base_path_mapping <- function(domainName, basePath = NULL, restApiId, stage = NULL) {
  op <- new_operation(
    name = "CreateBasePathMapping",
    http_method = "POST",
    http_path = "/domainnames/{domain_name}/basepathmappings",
    paginator = list()
  )
  input <- .apigateway$create_base_path_mapping_input(domainName = domainName, basePath = basePath, restApiId = restApiId, stage = stage)
  output <- .apigateway$create_base_path_mapping_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_base_path_mapping <- apigateway_create_base_path_mapping

#' Creates a Deployment resource, which makes a specified RestApi callable
#' over the internet
#'
#' @description
#' Creates a Deployment resource, which makes a specified RestApi callable over the internet.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_deployment/](https://www.paws-r-sdk.com/docs/apigateway_create_deployment/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName The name of the Stage resource for the Deployment resource to create.
#' @param stageDescription The description of the Stage resource for the Deployment resource to
#' create.
#' @param description The description for the Deployment resource to create.
#' @param cacheClusterEnabled Enables a cache cluster for the Stage resource specified in the input.
#' @param cacheClusterSize The stage's cache capacity in GB. For more information about choosing a
#' cache size, see [Enabling API caching to enhance
#' responsiveness](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html).
#' @param variables A map that defines the stage variables for the Stage resource that is
#' associated with the new deployment. Variable names can have alphanumeric
#' and underscore characters, and the values must match
#' `[A-Za-z0-9-._~:/?#&=,]+`.
#' @param canarySettings The input configuration for the canary deployment when the deployment is
#' a canary release deployment.
#' @param tracingEnabled Specifies whether active tracing with X-ray is enabled for the Stage.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_deployment
apigateway_create_deployment <- function(restApiId, stageName = NULL, stageDescription = NULL, description = NULL, cacheClusterEnabled = NULL, cacheClusterSize = NULL, variables = NULL, canarySettings = NULL, tracingEnabled = NULL) {
  op <- new_operation(
    name = "CreateDeployment",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/deployments",
    paginator = list()
  )
  input <- .apigateway$create_deployment_input(restApiId = restApiId, stageName = stageName, stageDescription = stageDescription, description = description, cacheClusterEnabled = cacheClusterEnabled, cacheClusterSize = cacheClusterSize, variables = variables, canarySettings = canarySettings, tracingEnabled = tracingEnabled)
  output <- .apigateway$create_deployment_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_deployment <- apigateway_create_deployment

#' Creates a documentation part
#'
#' @description
#' Creates a documentation part.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_documentation_part/](https://www.paws-r-sdk.com/docs/apigateway_create_documentation_part/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param location &#91;required&#93; The location of the targeted API entity of the to-be-created
#' documentation part.
#' @param properties &#91;required&#93; The new documentation content map of the targeted API entity. Enclosed
#' key-value pairs are API-specific, but only OpenAPI-compliant key-value
#' pairs can be exported and, hence, published.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_documentation_part
apigateway_create_documentation_part <- function(restApiId, location, properties) {
  op <- new_operation(
    name = "CreateDocumentationPart",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/documentation/parts",
    paginator = list()
  )
  input <- .apigateway$create_documentation_part_input(restApiId = restApiId, location = location, properties = properties)
  output <- .apigateway$create_documentation_part_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_documentation_part <- apigateway_create_documentation_part

#' Creates a documentation version
#'
#' @description
#' Creates a documentation version
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_documentation_version/](https://www.paws-r-sdk.com/docs/apigateway_create_documentation_version/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationVersion &#91;required&#93; The version identifier of the new snapshot.
#' @param stageName The stage name to be associated with the new documentation snapshot.
#' @param description A description about the new documentation snapshot.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_documentation_version
apigateway_create_documentation_version <- function(restApiId, documentationVersion, stageName = NULL, description = NULL) {
  op <- new_operation(
    name = "CreateDocumentationVersion",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/documentation/versions",
    paginator = list()
  )
  input <- .apigateway$create_documentation_version_input(restApiId = restApiId, documentationVersion = documentationVersion, stageName = stageName, description = description)
  output <- .apigateway$create_documentation_version_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_documentation_version <- apigateway_create_documentation_version

#' Creates a new domain name
#'
#' @description
#' Creates a new domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_domain_name/](https://www.paws-r-sdk.com/docs/apigateway_create_domain_name/) for full documentation.
#'
#' @param domainName &#91;required&#93; The name of the DomainName resource.
#' @param certificateName The user-friendly name of the certificate that will be used by
#' edge-optimized endpoint for this domain name.
#' @param certificateBody \[Deprecated\] The body of the server certificate that will be used by
#' edge-optimized endpoint for this domain name provided by your
#' certificate authority.
#' @param certificatePrivateKey \[Deprecated\] Your edge-optimized endpoint's domain name certificate's
#' private key.
#' @param certificateChain \[Deprecated\] The intermediate certificates and optionally the root
#' certificate, one after the other without any blank lines, used by an
#' edge-optimized endpoint for this domain name. If you include the root
#' certificate, your certificate chain must start with intermediate
#' certificates and end with the root certificate. Use the intermediate
#' certificates that were provided by your certificate authority. Do not
#' include any intermediaries that are not in the chain of trust path.
#' @param certificateArn The reference to an Amazon Web Services-managed certificate that will be
#' used by edge-optimized endpoint for this domain name. Certificate
#' Manager is the only supported source.
#' @param regionalCertificateName The user-friendly name of the certificate that will be used by regional
#' endpoint for this domain name.
#' @param regionalCertificateArn The reference to an Amazon Web Services-managed certificate that will be
#' used by regional endpoint for this domain name. Certificate Manager is
#' the only supported source.
#' @param endpointConfiguration The endpoint configuration of this DomainName showing the endpoint types
#' of the domain name.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#' @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this
#' DomainName. The valid values are `TLS_1_0` and `TLS_1_2`.
#' @param mutualTlsAuthentication 
#' @param ownershipVerificationCertificateArn The ARN of the public certificate issued by ACM to validate ownership of
#' your custom domain. Only required when configuring mutual TLS and using
#' an ACM imported or private CA certificate ARN as the
#' regionalCertificateArn.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_domain_name
apigateway_create_domain_name <- function(domainName, certificateName = NULL, certificateBody = NULL, certificatePrivateKey = NULL, certificateChain = NULL, certificateArn = NULL, regionalCertificateName = NULL, regionalCertificateArn = NULL, endpointConfiguration = NULL, tags = NULL, securityPolicy = NULL, mutualTlsAuthentication = NULL, ownershipVerificationCertificateArn = NULL) {
  op <- new_operation(
    name = "CreateDomainName",
    http_method = "POST",
    http_path = "/domainnames",
    paginator = list()
  )
  input <- .apigateway$create_domain_name_input(domainName = domainName, certificateName = certificateName, certificateBody = certificateBody, certificatePrivateKey = certificatePrivateKey, certificateChain = certificateChain, certificateArn = certificateArn, regionalCertificateName = regionalCertificateName, regionalCertificateArn = regionalCertificateArn, endpointConfiguration = endpointConfiguration, tags = tags, securityPolicy = securityPolicy, mutualTlsAuthentication = mutualTlsAuthentication, ownershipVerificationCertificateArn = ownershipVerificationCertificateArn)
  output <- .apigateway$create_domain_name_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_domain_name <- apigateway_create_domain_name

#' Adds a new Model resource to an existing RestApi resource
#'
#' @description
#' Adds a new Model resource to an existing RestApi resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_model/](https://www.paws-r-sdk.com/docs/apigateway_create_model/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The RestApi identifier under which the Model will be created.
#' @param name &#91;required&#93; The name of the model. Must be alphanumeric.
#' @param description The description of the model.
#' @param schema The schema for the model. For `application/json` models, this should be
#' JSON schema draft 4 model.
#' @param contentType &#91;required&#93; The content-type for the model.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_model
apigateway_create_model <- function(restApiId, name, description = NULL, schema = NULL, contentType) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/models",
    paginator = list()
  )
  input <- .apigateway$create_model_input(restApiId = restApiId, name = name, description = description, schema = schema, contentType = contentType)
  output <- .apigateway$create_model_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_model <- apigateway_create_model

#' Creates a RequestValidator of a given RestApi
#'
#' @description
#' Creates a RequestValidator of a given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_request_validator/](https://www.paws-r-sdk.com/docs/apigateway_create_request_validator/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param name The name of the to-be-created RequestValidator.
#' @param validateRequestBody A Boolean flag to indicate whether to validate request body according to
#' the configured model schema for the method (`true`) or not (`false`).
#' @param validateRequestParameters A Boolean flag to indicate whether to validate request parameters,
#' `true`, or not `false`.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_request_validator
apigateway_create_request_validator <- function(restApiId, name = NULL, validateRequestBody = NULL, validateRequestParameters = NULL) {
  op <- new_operation(
    name = "CreateRequestValidator",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/requestvalidators",
    paginator = list()
  )
  input <- .apigateway$create_request_validator_input(restApiId = restApiId, name = name, validateRequestBody = validateRequestBody, validateRequestParameters = validateRequestParameters)
  output <- .apigateway$create_request_validator_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_request_validator <- apigateway_create_request_validator

#' Creates a Resource resource
#'
#' @description
#' Creates a Resource resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_resource/](https://www.paws-r-sdk.com/docs/apigateway_create_resource/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param parentId &#91;required&#93; The parent resource's identifier.
#' @param pathPart &#91;required&#93; The last path segment for this resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_resource
apigateway_create_resource <- function(restApiId, parentId, pathPart) {
  op <- new_operation(
    name = "CreateResource",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/resources/{parent_id}",
    paginator = list()
  )
  input <- .apigateway$create_resource_input(restApiId = restApiId, parentId = parentId, pathPart = pathPart)
  output <- .apigateway$create_resource_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_resource <- apigateway_create_resource

#' Creates a new RestApi resource
#'
#' @description
#' Creates a new RestApi resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_rest_api/](https://www.paws-r-sdk.com/docs/apigateway_create_rest_api/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the RestApi.
#' @param description The description of the RestApi.
#' @param version A version identifier for the API.
#' @param cloneFrom The ID of the RestApi that you want to clone from.
#' @param binaryMediaTypes The list of binary media types supported by the RestApi. By default, the
#' RestApi supports only UTF-8-encoded text payloads.
#' @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative
#' between 0 and 10485760 (10M) bytes, inclusive) or disable compression
#' (with a null value) on an API. When compression is enabled, compression
#' or decompression is not applied on the payload if the payload size is
#' smaller than this value. Setting it to zero allows compression for any
#' payload size.
#' @param apiKeySource The source of the API key for metering requests according to a usage
#' plan. Valid values are: `HEADER` to read the API key from the
#' `X-API-Key` header of a request. `AUTHORIZER` to read the API key from
#' the `UsageIdentifierKey` from a custom authorizer.
#' @param endpointConfiguration The endpoint configuration of this RestApi showing the endpoint types of
#' the API.
#' @param policy A stringified JSON policy document that applies to this RestApi
#' regardless of the caller and Method configuration.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#' @param disableExecuteApiEndpoint Specifies whether clients can invoke your API by using the default
#' `execute-api` endpoint. By default, clients can invoke your API with the
#' default `https://{api_id}.execute-api.{region}.amazonaws.com` endpoint.
#' To require that clients use a custom domain name to invoke your API,
#' disable the default endpoint
#'
#' @keywords internal
#'
#' @rdname apigateway_create_rest_api
apigateway_create_rest_api <- function(name, description = NULL, version = NULL, cloneFrom = NULL, binaryMediaTypes = NULL, minimumCompressionSize = NULL, apiKeySource = NULL, endpointConfiguration = NULL, policy = NULL, tags = NULL, disableExecuteApiEndpoint = NULL) {
  op <- new_operation(
    name = "CreateRestApi",
    http_method = "POST",
    http_path = "/restapis",
    paginator = list()
  )
  input <- .apigateway$create_rest_api_input(name = name, description = description, version = version, cloneFrom = cloneFrom, binaryMediaTypes = binaryMediaTypes, minimumCompressionSize = minimumCompressionSize, apiKeySource = apiKeySource, endpointConfiguration = endpointConfiguration, policy = policy, tags = tags, disableExecuteApiEndpoint = disableExecuteApiEndpoint)
  output <- .apigateway$create_rest_api_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_rest_api <- apigateway_create_rest_api

#' Creates a new Stage resource that references a pre-existing Deployment
#' for the API
#'
#' @description
#' Creates a new Stage resource that references a pre-existing Deployment for the API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_stage/](https://www.paws-r-sdk.com/docs/apigateway_create_stage/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name for the Stage resource. Stage names can only contain
#' alphanumeric characters, hyphens, and underscores. Maximum length is 128
#' characters.
#' @param deploymentId &#91;required&#93; The identifier of the Deployment resource for the Stage resource.
#' @param description The description of the Stage resource.
#' @param cacheClusterEnabled Whether cache clustering is enabled for the stage.
#' @param cacheClusterSize The stage's cache capacity in GB. For more information about choosing a
#' cache size, see [Enabling API caching to enhance
#' responsiveness](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html).
#' @param variables A map that defines the stage variables for the new Stage resource.
#' Variable names can have alphanumeric and underscore characters, and the
#' values must match `[A-Za-z0-9-._~:/?#&=,]+`.
#' @param documentationVersion The version of the associated API documentation.
#' @param canarySettings The canary deployment settings of this stage.
#' @param tracingEnabled Specifies whether active tracing with X-ray is enabled for the Stage.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_stage
apigateway_create_stage <- function(restApiId, stageName, deploymentId, description = NULL, cacheClusterEnabled = NULL, cacheClusterSize = NULL, variables = NULL, documentationVersion = NULL, canarySettings = NULL, tracingEnabled = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateStage",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/stages",
    paginator = list()
  )
  input <- .apigateway$create_stage_input(restApiId = restApiId, stageName = stageName, deploymentId = deploymentId, description = description, cacheClusterEnabled = cacheClusterEnabled, cacheClusterSize = cacheClusterSize, variables = variables, documentationVersion = documentationVersion, canarySettings = canarySettings, tracingEnabled = tracingEnabled, tags = tags)
  output <- .apigateway$create_stage_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_stage <- apigateway_create_stage

#' Creates a usage plan with the throttle and quota limits, as well as the
#' associated API stages, specified in the payload
#'
#' @description
#' Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_usage_plan/](https://www.paws-r-sdk.com/docs/apigateway_create_usage_plan/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the usage plan.
#' @param description The description of the usage plan.
#' @param apiStages The associated API stages of the usage plan.
#' @param throttle The throttling limits of the usage plan.
#' @param quota The quota of the usage plan.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_usage_plan
apigateway_create_usage_plan <- function(name, description = NULL, apiStages = NULL, throttle = NULL, quota = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateUsagePlan",
    http_method = "POST",
    http_path = "/usageplans",
    paginator = list()
  )
  input <- .apigateway$create_usage_plan_input(name = name, description = description, apiStages = apiStages, throttle = throttle, quota = quota, tags = tags)
  output <- .apigateway$create_usage_plan_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_usage_plan <- apigateway_create_usage_plan

#' Creates a usage plan key for adding an existing API key to a usage plan
#'
#' @description
#' Creates a usage plan key for adding an existing API key to a usage plan.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_usage_plan_key/](https://www.paws-r-sdk.com/docs/apigateway_create_usage_plan_key/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the UsagePlan resource representing the usage plan containing
#' the to-be-created UsagePlanKey resource representing a plan customer.
#' @param keyId &#91;required&#93; The identifier of a UsagePlanKey resource for a plan customer.
#' @param keyType &#91;required&#93; The type of a UsagePlanKey resource for a plan customer.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_usage_plan_key
apigateway_create_usage_plan_key <- function(usagePlanId, keyId, keyType) {
  op <- new_operation(
    name = "CreateUsagePlanKey",
    http_method = "POST",
    http_path = "/usageplans/{usageplanId}/keys",
    paginator = list()
  )
  input <- .apigateway$create_usage_plan_key_input(usagePlanId = usagePlanId, keyId = keyId, keyType = keyType)
  output <- .apigateway$create_usage_plan_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_usage_plan_key <- apigateway_create_usage_plan_key

#' Creates a VPC link, under the caller's account in a selected region, in
#' an asynchronous operation that typically takes 2-4 minutes to complete
#' and become operational
#'
#' @description
#' Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_create_vpc_link/](https://www.paws-r-sdk.com/docs/apigateway_create_vpc_link/) for full documentation.
#'
#' @param name &#91;required&#93; The name used to label and identify the VPC link.
#' @param description The description of the VPC link.
#' @param targetArns &#91;required&#93; The ARN of the network load balancer of the VPC targeted by the VPC
#' link. The network load balancer must be owned by the same Amazon Web
#' Services account of the API owner.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#'
#' @keywords internal
#'
#' @rdname apigateway_create_vpc_link
apigateway_create_vpc_link <- function(name, description = NULL, targetArns, tags = NULL) {
  op <- new_operation(
    name = "CreateVpcLink",
    http_method = "POST",
    http_path = "/vpclinks",
    paginator = list()
  )
  input <- .apigateway$create_vpc_link_input(name = name, description = description, targetArns = targetArns, tags = tags)
  output <- .apigateway$create_vpc_link_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$create_vpc_link <- apigateway_create_vpc_link

#' Deletes the ApiKey resource
#'
#' @description
#' Deletes the ApiKey resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_api_key/](https://www.paws-r-sdk.com/docs/apigateway_delete_api_key/) for full documentation.
#'
#' @param apiKey &#91;required&#93; The identifier of the ApiKey resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_api_key
apigateway_delete_api_key <- function(apiKey) {
  op <- new_operation(
    name = "DeleteApiKey",
    http_method = "DELETE",
    http_path = "/apikeys/{api_Key}",
    paginator = list()
  )
  input <- .apigateway$delete_api_key_input(apiKey = apiKey)
  output <- .apigateway$delete_api_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_api_key <- apigateway_delete_api_key

#' Deletes an existing Authorizer resource
#'
#' @description
#' Deletes an existing Authorizer resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_authorizer/](https://www.paws-r-sdk.com/docs/apigateway_delete_authorizer/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param authorizerId &#91;required&#93; The identifier of the Authorizer resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_authorizer
apigateway_delete_authorizer <- function(restApiId, authorizerId) {
  op <- new_operation(
    name = "DeleteAuthorizer",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/authorizers/{authorizer_id}",
    paginator = list()
  )
  input <- .apigateway$delete_authorizer_input(restApiId = restApiId, authorizerId = authorizerId)
  output <- .apigateway$delete_authorizer_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_authorizer <- apigateway_delete_authorizer

#' Deletes the BasePathMapping resource
#'
#' @description
#' Deletes the BasePathMapping resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_base_path_mapping/](https://www.paws-r-sdk.com/docs/apigateway_delete_base_path_mapping/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name of the BasePathMapping resource to delete.
#' @param basePath &#91;required&#93; The base path name of the BasePathMapping resource to delete.
#' 
#' To specify an empty base path, set this parameter to `'(none)'`.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_base_path_mapping
apigateway_delete_base_path_mapping <- function(domainName, basePath) {
  op <- new_operation(
    name = "DeleteBasePathMapping",
    http_method = "DELETE",
    http_path = "/domainnames/{domain_name}/basepathmappings/{base_path}",
    paginator = list()
  )
  input <- .apigateway$delete_base_path_mapping_input(domainName = domainName, basePath = basePath)
  output <- .apigateway$delete_base_path_mapping_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_base_path_mapping <- apigateway_delete_base_path_mapping

#' Deletes the ClientCertificate resource
#'
#' @description
#' Deletes the ClientCertificate resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_client_certificate/](https://www.paws-r-sdk.com/docs/apigateway_delete_client_certificate/) for full documentation.
#'
#' @param clientCertificateId &#91;required&#93; The identifier of the ClientCertificate resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_client_certificate
apigateway_delete_client_certificate <- function(clientCertificateId) {
  op <- new_operation(
    name = "DeleteClientCertificate",
    http_method = "DELETE",
    http_path = "/clientcertificates/{clientcertificate_id}",
    paginator = list()
  )
  input <- .apigateway$delete_client_certificate_input(clientCertificateId = clientCertificateId)
  output <- .apigateway$delete_client_certificate_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_client_certificate <- apigateway_delete_client_certificate

#' Deletes a Deployment resource
#'
#' @description
#' Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated with it.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_deployment/](https://www.paws-r-sdk.com/docs/apigateway_delete_deployment/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param deploymentId &#91;required&#93; The identifier of the Deployment resource to delete.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_deployment
apigateway_delete_deployment <- function(restApiId, deploymentId) {
  op <- new_operation(
    name = "DeleteDeployment",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/deployments/{deployment_id}",
    paginator = list()
  )
  input <- .apigateway$delete_deployment_input(restApiId = restApiId, deploymentId = deploymentId)
  output <- .apigateway$delete_deployment_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_deployment <- apigateway_delete_deployment

#' Deletes a documentation part
#'
#' @description
#' Deletes a documentation part
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_documentation_part/](https://www.paws-r-sdk.com/docs/apigateway_delete_documentation_part/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationPartId &#91;required&#93; The identifier of the to-be-deleted documentation part.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_documentation_part
apigateway_delete_documentation_part <- function(restApiId, documentationPartId) {
  op <- new_operation(
    name = "DeleteDocumentationPart",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/documentation/parts/{part_id}",
    paginator = list()
  )
  input <- .apigateway$delete_documentation_part_input(restApiId = restApiId, documentationPartId = documentationPartId)
  output <- .apigateway$delete_documentation_part_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_documentation_part <- apigateway_delete_documentation_part

#' Deletes a documentation version
#'
#' @description
#' Deletes a documentation version.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_documentation_version/](https://www.paws-r-sdk.com/docs/apigateway_delete_documentation_version/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationVersion &#91;required&#93; The version identifier of a to-be-deleted documentation snapshot.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_documentation_version
apigateway_delete_documentation_version <- function(restApiId, documentationVersion) {
  op <- new_operation(
    name = "DeleteDocumentationVersion",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/documentation/versions/{doc_version}",
    paginator = list()
  )
  input <- .apigateway$delete_documentation_version_input(restApiId = restApiId, documentationVersion = documentationVersion)
  output <- .apigateway$delete_documentation_version_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_documentation_version <- apigateway_delete_documentation_version

#' Deletes the DomainName resource
#'
#' @description
#' Deletes the DomainName resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_domain_name/](https://www.paws-r-sdk.com/docs/apigateway_delete_domain_name/) for full documentation.
#'
#' @param domainName &#91;required&#93; The name of the DomainName resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_domain_name
apigateway_delete_domain_name <- function(domainName) {
  op <- new_operation(
    name = "DeleteDomainName",
    http_method = "DELETE",
    http_path = "/domainnames/{domain_name}",
    paginator = list()
  )
  input <- .apigateway$delete_domain_name_input(domainName = domainName)
  output <- .apigateway$delete_domain_name_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_domain_name <- apigateway_delete_domain_name

#' Clears any customization of a GatewayResponse of a specified response
#' type on the given RestApi and resets it with the default settings
#'
#' @description
#' Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_gateway_response/](https://www.paws-r-sdk.com/docs/apigateway_delete_gateway_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param responseType &#91;required&#93; The response type of the associated GatewayResponse.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_gateway_response
apigateway_delete_gateway_response <- function(restApiId, responseType) {
  op <- new_operation(
    name = "DeleteGatewayResponse",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/gatewayresponses/{response_type}",
    paginator = list()
  )
  input <- .apigateway$delete_gateway_response_input(restApiId = restApiId, responseType = responseType)
  output <- .apigateway$delete_gateway_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_gateway_response <- apigateway_delete_gateway_response

#' Represents a delete integration
#'
#' @description
#' Represents a delete integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_integration/](https://www.paws-r-sdk.com/docs/apigateway_delete_integration/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a delete integration request's resource identifier.
#' @param httpMethod &#91;required&#93; Specifies a delete integration request's HTTP method.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_integration
apigateway_delete_integration <- function(restApiId, resourceId, httpMethod) {
  op <- new_operation(
    name = "DeleteIntegration",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
    paginator = list()
  )
  input <- .apigateway$delete_integration_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod)
  output <- .apigateway$delete_integration_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_integration <- apigateway_delete_integration

#' Represents a delete integration response
#'
#' @description
#' Represents a delete integration response.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_integration_response/](https://www.paws-r-sdk.com/docs/apigateway_delete_integration_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a delete integration response request's resource identifier.
#' @param httpMethod &#91;required&#93; Specifies a delete integration response request's HTTP method.
#' @param statusCode &#91;required&#93; Specifies a delete integration response request's status code.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_integration_response
apigateway_delete_integration_response <- function(restApiId, resourceId, httpMethod, statusCode) {
  op <- new_operation(
    name = "DeleteIntegrationResponse",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$delete_integration_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode)
  output <- .apigateway$delete_integration_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_integration_response <- apigateway_delete_integration_response

#' Deletes an existing Method resource
#'
#' @description
#' Deletes an existing Method resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_method/](https://www.paws-r-sdk.com/docs/apigateway_delete_method/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the Method resource.
#' @param httpMethod &#91;required&#93; The HTTP verb of the Method resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_method
apigateway_delete_method <- function(restApiId, resourceId, httpMethod) {
  op <- new_operation(
    name = "DeleteMethod",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
    paginator = list()
  )
  input <- .apigateway$delete_method_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod)
  output <- .apigateway$delete_method_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_method <- apigateway_delete_method

#' Deletes an existing MethodResponse resource
#'
#' @description
#' Deletes an existing MethodResponse resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_method_response/](https://www.paws-r-sdk.com/docs/apigateway_delete_method_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the MethodResponse resource.
#' @param httpMethod &#91;required&#93; The HTTP verb of the Method resource.
#' @param statusCode &#91;required&#93; The status code identifier for the MethodResponse resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_method_response
apigateway_delete_method_response <- function(restApiId, resourceId, httpMethod, statusCode) {
  op <- new_operation(
    name = "DeleteMethodResponse",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$delete_method_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode)
  output <- .apigateway$delete_method_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_method_response <- apigateway_delete_method_response

#' Deletes a model
#'
#' @description
#' Deletes a model.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_model/](https://www.paws-r-sdk.com/docs/apigateway_delete_model/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param modelName &#91;required&#93; The name of the model to delete.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_model
apigateway_delete_model <- function(restApiId, modelName) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/models/{model_name}",
    paginator = list()
  )
  input <- .apigateway$delete_model_input(restApiId = restApiId, modelName = modelName)
  output <- .apigateway$delete_model_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_model <- apigateway_delete_model

#' Deletes a RequestValidator of a given RestApi
#'
#' @description
#' Deletes a RequestValidator of a given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_request_validator/](https://www.paws-r-sdk.com/docs/apigateway_delete_request_validator/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param requestValidatorId &#91;required&#93; The identifier of the RequestValidator to be deleted.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_request_validator
apigateway_delete_request_validator <- function(restApiId, requestValidatorId) {
  op <- new_operation(
    name = "DeleteRequestValidator",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
    paginator = list()
  )
  input <- .apigateway$delete_request_validator_input(restApiId = restApiId, requestValidatorId = requestValidatorId)
  output <- .apigateway$delete_request_validator_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_request_validator <- apigateway_delete_request_validator

#' Deletes a Resource resource
#'
#' @description
#' Deletes a Resource resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_resource/](https://www.paws-r-sdk.com/docs/apigateway_delete_resource/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The identifier of the Resource resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_resource
apigateway_delete_resource <- function(restApiId, resourceId) {
  op <- new_operation(
    name = "DeleteResource",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}",
    paginator = list()
  )
  input <- .apigateway$delete_resource_input(restApiId = restApiId, resourceId = resourceId)
  output <- .apigateway$delete_resource_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_resource <- apigateway_delete_resource

#' Deletes the specified API
#'
#' @description
#' Deletes the specified API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_rest_api/](https://www.paws-r-sdk.com/docs/apigateway_delete_rest_api/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_rest_api
apigateway_delete_rest_api <- function(restApiId) {
  op <- new_operation(
    name = "DeleteRestApi",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}",
    paginator = list()
  )
  input <- .apigateway$delete_rest_api_input(restApiId = restApiId)
  output <- .apigateway$delete_rest_api_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_rest_api <- apigateway_delete_rest_api

#' Deletes a Stage resource
#'
#' @description
#' Deletes a Stage resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_stage/](https://www.paws-r-sdk.com/docs/apigateway_delete_stage/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the Stage resource to delete.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_stage
apigateway_delete_stage <- function(restApiId, stageName) {
  op <- new_operation(
    name = "DeleteStage",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}",
    paginator = list()
  )
  input <- .apigateway$delete_stage_input(restApiId = restApiId, stageName = stageName)
  output <- .apigateway$delete_stage_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_stage <- apigateway_delete_stage

#' Deletes a usage plan of a given plan Id
#'
#' @description
#' Deletes a usage plan of a given plan Id.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_usage_plan/](https://www.paws-r-sdk.com/docs/apigateway_delete_usage_plan/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the to-be-deleted usage plan.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_usage_plan
apigateway_delete_usage_plan <- function(usagePlanId) {
  op <- new_operation(
    name = "DeleteUsagePlan",
    http_method = "DELETE",
    http_path = "/usageplans/{usageplanId}",
    paginator = list()
  )
  input <- .apigateway$delete_usage_plan_input(usagePlanId = usagePlanId)
  output <- .apigateway$delete_usage_plan_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_usage_plan <- apigateway_delete_usage_plan

#' Deletes a usage plan key and remove the underlying API key from the
#' associated usage plan
#'
#' @description
#' Deletes a usage plan key and remove the underlying API key from the associated usage plan.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_usage_plan_key/](https://www.paws-r-sdk.com/docs/apigateway_delete_usage_plan_key/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the UsagePlan resource representing the usage plan containing
#' the to-be-deleted UsagePlanKey resource representing a plan customer.
#' @param keyId &#91;required&#93; The Id of the UsagePlanKey resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_usage_plan_key
apigateway_delete_usage_plan_key <- function(usagePlanId, keyId) {
  op <- new_operation(
    name = "DeleteUsagePlanKey",
    http_method = "DELETE",
    http_path = "/usageplans/{usageplanId}/keys/{keyId}",
    paginator = list()
  )
  input <- .apigateway$delete_usage_plan_key_input(usagePlanId = usagePlanId, keyId = keyId)
  output <- .apigateway$delete_usage_plan_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_usage_plan_key <- apigateway_delete_usage_plan_key

#' Deletes an existing VpcLink of a specified identifier
#'
#' @description
#' Deletes an existing VpcLink of a specified identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_delete_vpc_link/](https://www.paws-r-sdk.com/docs/apigateway_delete_vpc_link/) for full documentation.
#'
#' @param vpcLinkId &#91;required&#93; The identifier of the VpcLink. It is used in an Integration to reference
#' this VpcLink.
#'
#' @keywords internal
#'
#' @rdname apigateway_delete_vpc_link
apigateway_delete_vpc_link <- function(vpcLinkId) {
  op <- new_operation(
    name = "DeleteVpcLink",
    http_method = "DELETE",
    http_path = "/vpclinks/{vpclink_id}",
    paginator = list()
  )
  input <- .apigateway$delete_vpc_link_input(vpcLinkId = vpcLinkId)
  output <- .apigateway$delete_vpc_link_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$delete_vpc_link <- apigateway_delete_vpc_link

#' Flushes all authorizer cache entries on a stage
#'
#' @description
#' Flushes all authorizer cache entries on a stage.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_flush_stage_authorizers_cache/](https://www.paws-r-sdk.com/docs/apigateway_flush_stage_authorizers_cache/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the stage to flush.
#'
#' @keywords internal
#'
#' @rdname apigateway_flush_stage_authorizers_cache
apigateway_flush_stage_authorizers_cache <- function(restApiId, stageName) {
  op <- new_operation(
    name = "FlushStageAuthorizersCache",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}/cache/authorizers",
    paginator = list()
  )
  input <- .apigateway$flush_stage_authorizers_cache_input(restApiId = restApiId, stageName = stageName)
  output <- .apigateway$flush_stage_authorizers_cache_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$flush_stage_authorizers_cache <- apigateway_flush_stage_authorizers_cache

#' Flushes a stage's cache
#'
#' @description
#' Flushes a stage's cache.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_flush_stage_cache/](https://www.paws-r-sdk.com/docs/apigateway_flush_stage_cache/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the stage to flush its cache.
#'
#' @keywords internal
#'
#' @rdname apigateway_flush_stage_cache
apigateway_flush_stage_cache <- function(restApiId, stageName) {
  op <- new_operation(
    name = "FlushStageCache",
    http_method = "DELETE",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}/cache/data",
    paginator = list()
  )
  input <- .apigateway$flush_stage_cache_input(restApiId = restApiId, stageName = stageName)
  output <- .apigateway$flush_stage_cache_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$flush_stage_cache <- apigateway_flush_stage_cache

#' Generates a ClientCertificate resource
#'
#' @description
#' Generates a ClientCertificate resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_generate_client_certificate/](https://www.paws-r-sdk.com/docs/apigateway_generate_client_certificate/) for full documentation.
#'
#' @param description The description of the ClientCertificate.
#' @param tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#'
#' @keywords internal
#'
#' @rdname apigateway_generate_client_certificate
apigateway_generate_client_certificate <- function(description = NULL, tags = NULL) {
  op <- new_operation(
    name = "GenerateClientCertificate",
    http_method = "POST",
    http_path = "/clientcertificates",
    paginator = list()
  )
  input <- .apigateway$generate_client_certificate_input(description = description, tags = tags)
  output <- .apigateway$generate_client_certificate_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$generate_client_certificate <- apigateway_generate_client_certificate

#' Gets information about the current Account resource
#'
#' @description
#' Gets information about the current Account resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_account/](https://www.paws-r-sdk.com/docs/apigateway_get_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_account
apigateway_get_account <- function() {
  op <- new_operation(
    name = "GetAccount",
    http_method = "GET",
    http_path = "/account",
    paginator = list()
  )
  input <- .apigateway$get_account_input()
  output <- .apigateway$get_account_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_account <- apigateway_get_account

#' Gets information about the current ApiKey resource
#'
#' @description
#' Gets information about the current ApiKey resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_api_key/](https://www.paws-r-sdk.com/docs/apigateway_get_api_key/) for full documentation.
#'
#' @param apiKey &#91;required&#93; The identifier of the ApiKey resource.
#' @param includeValue A boolean flag to specify whether (`true`) or not (`false`) the result
#' contains the key value.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_api_key
apigateway_get_api_key <- function(apiKey, includeValue = NULL) {
  op <- new_operation(
    name = "GetApiKey",
    http_method = "GET",
    http_path = "/apikeys/{api_Key}",
    paginator = list()
  )
  input <- .apigateway$get_api_key_input(apiKey = apiKey, includeValue = includeValue)
  output <- .apigateway$get_api_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_api_key <- apigateway_get_api_key

#' Gets information about the current ApiKeys resource
#'
#' @description
#' Gets information about the current ApiKeys resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_api_keys/](https://www.paws-r-sdk.com/docs/apigateway_get_api_keys/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#' @param nameQuery The name of queried API keys.
#' @param customerId The identifier of a customer in Amazon Web Services Marketplace or an
#' external system, such as a developer portal.
#' @param includeValues A boolean flag to specify whether (`true`) or not (`false`) the result
#' contains key values.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_api_keys
apigateway_get_api_keys <- function(position = NULL, limit = NULL, nameQuery = NULL, customerId = NULL, includeValues = NULL) {
  op <- new_operation(
    name = "GetApiKeys",
    http_method = "GET",
    http_path = "/apikeys",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_api_keys_input(position = position, limit = limit, nameQuery = nameQuery, customerId = customerId, includeValues = includeValues)
  output <- .apigateway$get_api_keys_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_api_keys <- apigateway_get_api_keys

#' Describe an existing Authorizer resource
#'
#' @description
#' Describe an existing Authorizer resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_authorizer/](https://www.paws-r-sdk.com/docs/apigateway_get_authorizer/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param authorizerId &#91;required&#93; The identifier of the Authorizer resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_authorizer
apigateway_get_authorizer <- function(restApiId, authorizerId) {
  op <- new_operation(
    name = "GetAuthorizer",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/authorizers/{authorizer_id}",
    paginator = list()
  )
  input <- .apigateway$get_authorizer_input(restApiId = restApiId, authorizerId = authorizerId)
  output <- .apigateway$get_authorizer_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_authorizer <- apigateway_get_authorizer

#' Describe an existing Authorizers resource
#'
#' @description
#' Describe an existing Authorizers resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_authorizers/](https://www.paws-r-sdk.com/docs/apigateway_get_authorizers/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_authorizers
apigateway_get_authorizers <- function(restApiId, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetAuthorizers",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/authorizers",
    paginator = list()
  )
  input <- .apigateway$get_authorizers_input(restApiId = restApiId, position = position, limit = limit)
  output <- .apigateway$get_authorizers_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_authorizers <- apigateway_get_authorizers

#' Describe a BasePathMapping resource
#'
#' @description
#' Describe a BasePathMapping resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_base_path_mapping/](https://www.paws-r-sdk.com/docs/apigateway_get_base_path_mapping/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name of the BasePathMapping resource to be described.
#' @param basePath &#91;required&#93; The base path name that callers of the API must provide as part of the
#' URL after the domain name. This value must be unique for all of the
#' mappings across a single API. Specify '(none)' if you do not want
#' callers to specify any base path name after the domain name.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_base_path_mapping
apigateway_get_base_path_mapping <- function(domainName, basePath) {
  op <- new_operation(
    name = "GetBasePathMapping",
    http_method = "GET",
    http_path = "/domainnames/{domain_name}/basepathmappings/{base_path}",
    paginator = list()
  )
  input <- .apigateway$get_base_path_mapping_input(domainName = domainName, basePath = basePath)
  output <- .apigateway$get_base_path_mapping_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_base_path_mapping <- apigateway_get_base_path_mapping

#' Represents a collection of BasePathMapping resources
#'
#' @description
#' Represents a collection of BasePathMapping resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_base_path_mappings/](https://www.paws-r-sdk.com/docs/apigateway_get_base_path_mappings/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name of a BasePathMapping resource.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_base_path_mappings
apigateway_get_base_path_mappings <- function(domainName, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetBasePathMappings",
    http_method = "GET",
    http_path = "/domainnames/{domain_name}/basepathmappings",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_base_path_mappings_input(domainName = domainName, position = position, limit = limit)
  output <- .apigateway$get_base_path_mappings_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_base_path_mappings <- apigateway_get_base_path_mappings

#' Gets information about the current ClientCertificate resource
#'
#' @description
#' Gets information about the current ClientCertificate resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_client_certificate/](https://www.paws-r-sdk.com/docs/apigateway_get_client_certificate/) for full documentation.
#'
#' @param clientCertificateId &#91;required&#93; The identifier of the ClientCertificate resource to be described.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_client_certificate
apigateway_get_client_certificate <- function(clientCertificateId) {
  op <- new_operation(
    name = "GetClientCertificate",
    http_method = "GET",
    http_path = "/clientcertificates/{clientcertificate_id}",
    paginator = list()
  )
  input <- .apigateway$get_client_certificate_input(clientCertificateId = clientCertificateId)
  output <- .apigateway$get_client_certificate_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_client_certificate <- apigateway_get_client_certificate

#' Gets a collection of ClientCertificate resources
#'
#' @description
#' Gets a collection of ClientCertificate resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_client_certificates/](https://www.paws-r-sdk.com/docs/apigateway_get_client_certificates/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_client_certificates
apigateway_get_client_certificates <- function(position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetClientCertificates",
    http_method = "GET",
    http_path = "/clientcertificates",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_client_certificates_input(position = position, limit = limit)
  output <- .apigateway$get_client_certificates_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_client_certificates <- apigateway_get_client_certificates

#' Gets information about a Deployment resource
#'
#' @description
#' Gets information about a Deployment resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_deployment/](https://www.paws-r-sdk.com/docs/apigateway_get_deployment/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param deploymentId &#91;required&#93; The identifier of the Deployment resource to get information about.
#' @param embed A query parameter to retrieve the specified embedded resources of the
#' returned Deployment resource in the response. In a REST API call, this
#' `embed` parameter value is a list of comma-separated strings, as in
#' `GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2`.
#' The SDK and other platform-dependent libraries might use a different
#' format for the list. Currently, this request supports only retrieval of
#' the embedded API summary this way. Hence, the parameter value must be a
#' single-valued list containing only the `"apisummary"` string. For
#' example,
#' `GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary`.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_deployment
apigateway_get_deployment <- function(restApiId, deploymentId, embed = NULL) {
  op <- new_operation(
    name = "GetDeployment",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/deployments/{deployment_id}",
    paginator = list()
  )
  input <- .apigateway$get_deployment_input(restApiId = restApiId, deploymentId = deploymentId, embed = embed)
  output <- .apigateway$get_deployment_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_deployment <- apigateway_get_deployment

#' Gets information about a Deployments collection
#'
#' @description
#' Gets information about a Deployments collection.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_deployments/](https://www.paws-r-sdk.com/docs/apigateway_get_deployments/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_deployments
apigateway_get_deployments <- function(restApiId, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetDeployments",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/deployments",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_deployments_input(restApiId = restApiId, position = position, limit = limit)
  output <- .apigateway$get_deployments_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_deployments <- apigateway_get_deployments

#' Gets a documentation part
#'
#' @description
#' Gets a documentation part.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_documentation_part/](https://www.paws-r-sdk.com/docs/apigateway_get_documentation_part/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationPartId &#91;required&#93; The string identifier of the associated RestApi.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_documentation_part
apigateway_get_documentation_part <- function(restApiId, documentationPartId) {
  op <- new_operation(
    name = "GetDocumentationPart",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/documentation/parts/{part_id}",
    paginator = list()
  )
  input <- .apigateway$get_documentation_part_input(restApiId = restApiId, documentationPartId = documentationPartId)
  output <- .apigateway$get_documentation_part_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_documentation_part <- apigateway_get_documentation_part

#' Gets documentation parts
#'
#' @description
#' Gets documentation parts.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_documentation_parts/](https://www.paws-r-sdk.com/docs/apigateway_get_documentation_parts/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param type The type of API entities of the to-be-retrieved documentation parts.
#' @param nameQuery The name of API entities of the to-be-retrieved documentation parts.
#' @param path The path of API entities of the to-be-retrieved documentation parts.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#' @param locationStatus The status of the API documentation parts to retrieve. Valid values are
#' `DOCUMENTED` for retrieving DocumentationPart resources with content and
#' `UNDOCUMENTED` for DocumentationPart resources without content.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_documentation_parts
apigateway_get_documentation_parts <- function(restApiId, type = NULL, nameQuery = NULL, path = NULL, position = NULL, limit = NULL, locationStatus = NULL) {
  op <- new_operation(
    name = "GetDocumentationParts",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/documentation/parts",
    paginator = list()
  )
  input <- .apigateway$get_documentation_parts_input(restApiId = restApiId, type = type, nameQuery = nameQuery, path = path, position = position, limit = limit, locationStatus = locationStatus)
  output <- .apigateway$get_documentation_parts_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_documentation_parts <- apigateway_get_documentation_parts

#' Gets a documentation version
#'
#' @description
#' Gets a documentation version.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_documentation_version/](https://www.paws-r-sdk.com/docs/apigateway_get_documentation_version/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationVersion &#91;required&#93; The version identifier of the to-be-retrieved documentation snapshot.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_documentation_version
apigateway_get_documentation_version <- function(restApiId, documentationVersion) {
  op <- new_operation(
    name = "GetDocumentationVersion",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/documentation/versions/{doc_version}",
    paginator = list()
  )
  input <- .apigateway$get_documentation_version_input(restApiId = restApiId, documentationVersion = documentationVersion)
  output <- .apigateway$get_documentation_version_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_documentation_version <- apigateway_get_documentation_version

#' Gets documentation versions
#'
#' @description
#' Gets documentation versions.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_documentation_versions/](https://www.paws-r-sdk.com/docs/apigateway_get_documentation_versions/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_documentation_versions
apigateway_get_documentation_versions <- function(restApiId, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetDocumentationVersions",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/documentation/versions",
    paginator = list()
  )
  input <- .apigateway$get_documentation_versions_input(restApiId = restApiId, position = position, limit = limit)
  output <- .apigateway$get_documentation_versions_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_documentation_versions <- apigateway_get_documentation_versions

#' Represents a domain name that is contained in a simpler, more intuitive
#' URL that can be called
#'
#' @description
#' Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_domain_name/](https://www.paws-r-sdk.com/docs/apigateway_get_domain_name/) for full documentation.
#'
#' @param domainName &#91;required&#93; The name of the DomainName resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_domain_name
apigateway_get_domain_name <- function(domainName) {
  op <- new_operation(
    name = "GetDomainName",
    http_method = "GET",
    http_path = "/domainnames/{domain_name}",
    paginator = list()
  )
  input <- .apigateway$get_domain_name_input(domainName = domainName)
  output <- .apigateway$get_domain_name_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_domain_name <- apigateway_get_domain_name

#' Represents a collection of DomainName resources
#'
#' @description
#' Represents a collection of DomainName resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_domain_names/](https://www.paws-r-sdk.com/docs/apigateway_get_domain_names/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_domain_names
apigateway_get_domain_names <- function(position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetDomainNames",
    http_method = "GET",
    http_path = "/domainnames",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_domain_names_input(position = position, limit = limit)
  output <- .apigateway$get_domain_names_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_domain_names <- apigateway_get_domain_names

#' Exports a deployed version of a RestApi in a specified format
#'
#' @description
#' Exports a deployed version of a RestApi in a specified format.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_export/](https://www.paws-r-sdk.com/docs/apigateway_get_export/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the Stage that will be exported.
#' @param exportType &#91;required&#93; The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and
#' 'swagger' for Swagger/OpenAPI 2.0.
#' @param parameters A key-value map of query string parameters that specify properties of
#' the export, depending on the requested `exportType`. For `exportType`
#' `oas30` and `swagger`, any combination of the following parameters are
#' supported: `extensions='integrations'` or `extensions='apigateway'` will
#' export the API with x-amazon-apigateway-integration extensions.
#' `extensions='authorizers'` will export the API with
#' x-amazon-apigateway-authorizer extensions. `postman` will export the API
#' with Postman extensions, allowing for import to the Postman tool
#' @param accepts The content-type of the export, for example `application/json`.
#' Currently `application/json` and `application/yaml` are supported for
#' `exportType` of`oas30` and `swagger`. This should be specified in the
#' `Accept` header for direct API requests.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_export
apigateway_get_export <- function(restApiId, stageName, exportType, parameters = NULL, accepts = NULL) {
  op <- new_operation(
    name = "GetExport",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}/exports/{export_type}",
    paginator = list()
  )
  input <- .apigateway$get_export_input(restApiId = restApiId, stageName = stageName, exportType = exportType, parameters = parameters, accepts = accepts)
  output <- .apigateway$get_export_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_export <- apigateway_get_export

#' Gets a GatewayResponse of a specified response type on the given RestApi
#'
#' @description
#' Gets a GatewayResponse of a specified response type on the given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_gateway_response/](https://www.paws-r-sdk.com/docs/apigateway_get_gateway_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param responseType &#91;required&#93; The response type of the associated GatewayResponse.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_gateway_response
apigateway_get_gateway_response <- function(restApiId, responseType) {
  op <- new_operation(
    name = "GetGatewayResponse",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/gatewayresponses/{response_type}",
    paginator = list()
  )
  input <- .apigateway$get_gateway_response_input(restApiId = restApiId, responseType = responseType)
  output <- .apigateway$get_gateway_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_gateway_response <- apigateway_get_gateway_response

#' Gets the GatewayResponses collection on the given RestApi
#'
#' @description
#' Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_gateway_responses/](https://www.paws-r-sdk.com/docs/apigateway_get_gateway_responses/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set. The
#' GatewayResponse collection does not support pagination and the position
#' does not apply here.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500. The GatewayResponses collection does not
#' support pagination and the limit does not apply here.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_gateway_responses
apigateway_get_gateway_responses <- function(restApiId, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetGatewayResponses",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/gatewayresponses",
    paginator = list()
  )
  input <- .apigateway$get_gateway_responses_input(restApiId = restApiId, position = position, limit = limit)
  output <- .apigateway$get_gateway_responses_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_gateway_responses <- apigateway_get_gateway_responses

#' Get the integration settings
#'
#' @description
#' Get the integration settings.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_integration/](https://www.paws-r-sdk.com/docs/apigateway_get_integration/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a get integration request's resource identifier
#' @param httpMethod &#91;required&#93; Specifies a get integration request's HTTP method.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_integration
apigateway_get_integration <- function(restApiId, resourceId, httpMethod) {
  op <- new_operation(
    name = "GetIntegration",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
    paginator = list()
  )
  input <- .apigateway$get_integration_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod)
  output <- .apigateway$get_integration_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_integration <- apigateway_get_integration

#' Represents a get integration response
#'
#' @description
#' Represents a get integration response.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_integration_response/](https://www.paws-r-sdk.com/docs/apigateway_get_integration_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a get integration response request's resource identifier.
#' @param httpMethod &#91;required&#93; Specifies a get integration response request's HTTP method.
#' @param statusCode &#91;required&#93; Specifies a get integration response request's status code.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_integration_response
apigateway_get_integration_response <- function(restApiId, resourceId, httpMethod, statusCode) {
  op <- new_operation(
    name = "GetIntegrationResponse",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$get_integration_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode)
  output <- .apigateway$get_integration_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_integration_response <- apigateway_get_integration_response

#' Describe an existing Method resource
#'
#' @description
#' Describe an existing Method resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_method/](https://www.paws-r-sdk.com/docs/apigateway_get_method/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the Method resource.
#' @param httpMethod &#91;required&#93; Specifies the method request's HTTP method type.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_method
apigateway_get_method <- function(restApiId, resourceId, httpMethod) {
  op <- new_operation(
    name = "GetMethod",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
    paginator = list()
  )
  input <- .apigateway$get_method_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod)
  output <- .apigateway$get_method_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_method <- apigateway_get_method

#' Describes a MethodResponse resource
#'
#' @description
#' Describes a MethodResponse resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_method_response/](https://www.paws-r-sdk.com/docs/apigateway_get_method_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the MethodResponse resource.
#' @param httpMethod &#91;required&#93; The HTTP verb of the Method resource.
#' @param statusCode &#91;required&#93; The status code for the MethodResponse resource.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_method_response
apigateway_get_method_response <- function(restApiId, resourceId, httpMethod, statusCode) {
  op <- new_operation(
    name = "GetMethodResponse",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$get_method_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode)
  output <- .apigateway$get_method_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_method_response <- apigateway_get_method_response

#' Describes an existing model defined for a RestApi resource
#'
#' @description
#' Describes an existing model defined for a RestApi resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_model/](https://www.paws-r-sdk.com/docs/apigateway_get_model/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The RestApi identifier under which the Model exists.
#' @param modelName &#91;required&#93; The name of the model as an identifier.
#' @param flatten A query parameter of a Boolean value to resolve (`true`) all external
#' model references and returns a flattened model schema or not (`false`)
#' The default is `false`.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_model
apigateway_get_model <- function(restApiId, modelName, flatten = NULL) {
  op <- new_operation(
    name = "GetModel",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/models/{model_name}",
    paginator = list()
  )
  input <- .apigateway$get_model_input(restApiId = restApiId, modelName = modelName, flatten = flatten)
  output <- .apigateway$get_model_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_model <- apigateway_get_model

#' Generates a sample mapping template that can be used to transform a
#' payload into the structure of a model
#'
#' @description
#' Generates a sample mapping template that can be used to transform a payload into the structure of a model.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_model_template/](https://www.paws-r-sdk.com/docs/apigateway_get_model_template/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param modelName &#91;required&#93; The name of the model for which to generate a template.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_model_template
apigateway_get_model_template <- function(restApiId, modelName) {
  op <- new_operation(
    name = "GetModelTemplate",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/models/{model_name}/default_template",
    paginator = list()
  )
  input <- .apigateway$get_model_template_input(restApiId = restApiId, modelName = modelName)
  output <- .apigateway$get_model_template_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_model_template <- apigateway_get_model_template

#' Describes existing Models defined for a RestApi resource
#'
#' @description
#' Describes existing Models defined for a RestApi resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_models/](https://www.paws-r-sdk.com/docs/apigateway_get_models/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_models
apigateway_get_models <- function(restApiId, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetModels",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/models",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_models_input(restApiId = restApiId, position = position, limit = limit)
  output <- .apigateway$get_models_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_models <- apigateway_get_models

#' Gets a RequestValidator of a given RestApi
#'
#' @description
#' Gets a RequestValidator of a given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_request_validator/](https://www.paws-r-sdk.com/docs/apigateway_get_request_validator/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param requestValidatorId &#91;required&#93; The identifier of the RequestValidator to be retrieved.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_request_validator
apigateway_get_request_validator <- function(restApiId, requestValidatorId) {
  op <- new_operation(
    name = "GetRequestValidator",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
    paginator = list()
  )
  input <- .apigateway$get_request_validator_input(restApiId = restApiId, requestValidatorId = requestValidatorId)
  output <- .apigateway$get_request_validator_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_request_validator <- apigateway_get_request_validator

#' Gets the RequestValidators collection of a given RestApi
#'
#' @description
#' Gets the RequestValidators collection of a given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_request_validators/](https://www.paws-r-sdk.com/docs/apigateway_get_request_validators/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_request_validators
apigateway_get_request_validators <- function(restApiId, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetRequestValidators",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/requestvalidators",
    paginator = list()
  )
  input <- .apigateway$get_request_validators_input(restApiId = restApiId, position = position, limit = limit)
  output <- .apigateway$get_request_validators_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_request_validators <- apigateway_get_request_validators

#' Lists information about a resource
#'
#' @description
#' Lists information about a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_resource/](https://www.paws-r-sdk.com/docs/apigateway_get_resource/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The identifier for the Resource resource.
#' @param embed A query parameter to retrieve the specified resources embedded in the
#' returned Resource representation in the response. This `embed` parameter
#' value is a list of comma-separated strings. Currently, the request
#' supports only retrieval of the embedded Method resources this way. The
#' query parameter value must be a single-valued list and contain the
#' `"methods"` string. For example,
#' `GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods`.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_resource
apigateway_get_resource <- function(restApiId, resourceId, embed = NULL) {
  op <- new_operation(
    name = "GetResource",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}",
    paginator = list()
  )
  input <- .apigateway$get_resource_input(restApiId = restApiId, resourceId = resourceId, embed = embed)
  output <- .apigateway$get_resource_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_resource <- apigateway_get_resource

#' Lists information about a collection of Resource resources
#'
#' @description
#' Lists information about a collection of Resource resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_resources/](https://www.paws-r-sdk.com/docs/apigateway_get_resources/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#' @param embed A query parameter used to retrieve the specified resources embedded in
#' the returned Resources resource in the response. This `embed` parameter
#' value is a list of comma-separated strings. Currently, the request
#' supports only retrieval of the embedded Method resources this way. The
#' query parameter value must be a single-valued list and contain the
#' `"methods"` string. For example,
#' `GET /restapis/{restapi_id}/resources?embed=methods`.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_resources
apigateway_get_resources <- function(restApiId, position = NULL, limit = NULL, embed = NULL) {
  op <- new_operation(
    name = "GetResources",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/resources",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_resources_input(restApiId = restApiId, position = position, limit = limit, embed = embed)
  output <- .apigateway$get_resources_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_resources <- apigateway_get_resources

#' Lists the RestApi resource in the collection
#'
#' @description
#' Lists the RestApi resource in the collection.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_rest_api/](https://www.paws-r-sdk.com/docs/apigateway_get_rest_api/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_rest_api
apigateway_get_rest_api <- function(restApiId) {
  op <- new_operation(
    name = "GetRestApi",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}",
    paginator = list()
  )
  input <- .apigateway$get_rest_api_input(restApiId = restApiId)
  output <- .apigateway$get_rest_api_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_rest_api <- apigateway_get_rest_api

#' Lists the RestApis resources for your collection
#'
#' @description
#' Lists the RestApis resources for your collection.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_rest_apis/](https://www.paws-r-sdk.com/docs/apigateway_get_rest_apis/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_rest_apis
apigateway_get_rest_apis <- function(position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetRestApis",
    http_method = "GET",
    http_path = "/restapis",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_rest_apis_input(position = position, limit = limit)
  output <- .apigateway$get_rest_apis_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_rest_apis <- apigateway_get_rest_apis

#' Generates a client SDK for a RestApi and Stage
#'
#' @description
#' Generates a client SDK for a RestApi and Stage.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_sdk/](https://www.paws-r-sdk.com/docs/apigateway_get_sdk/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the Stage that the SDK will use.
#' @param sdkType &#91;required&#93; The language for the generated SDK. Currently `java`, `javascript`,
#' `android`, `objectivec` (for iOS), `swift` (for iOS), and `ruby` are
#' supported.
#' @param parameters A string-to-string key-value map of query parameters `sdkType`-dependent
#' properties of the SDK. For `sdkType` of `objectivec` or `swift`, a
#' parameter named `classPrefix` is required. For `sdkType` of `android`,
#' parameters named `groupId`, `artifactId`, `artifactVersion`, and
#' `invokerPackage` are required. For `sdkType` of `java`, parameters named
#' `serviceName` and `javaPackageName` are required.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_sdk
apigateway_get_sdk <- function(restApiId, stageName, sdkType, parameters = NULL) {
  op <- new_operation(
    name = "GetSdk",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}/sdks/{sdk_type}",
    paginator = list()
  )
  input <- .apigateway$get_sdk_input(restApiId = restApiId, stageName = stageName, sdkType = sdkType, parameters = parameters)
  output <- .apigateway$get_sdk_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_sdk <- apigateway_get_sdk

#' Gets an SDK type
#'
#' @description
#' Gets an SDK type.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_sdk_type/](https://www.paws-r-sdk.com/docs/apigateway_get_sdk_type/) for full documentation.
#'
#' @param id &#91;required&#93; The identifier of the queried SdkType instance.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_sdk_type
apigateway_get_sdk_type <- function(id) {
  op <- new_operation(
    name = "GetSdkType",
    http_method = "GET",
    http_path = "/sdktypes/{sdktype_id}",
    paginator = list()
  )
  input <- .apigateway$get_sdk_type_input(id = id)
  output <- .apigateway$get_sdk_type_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_sdk_type <- apigateway_get_sdk_type

#' Gets SDK types
#'
#' @description
#' Gets SDK types
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_sdk_types/](https://www.paws-r-sdk.com/docs/apigateway_get_sdk_types/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_sdk_types
apigateway_get_sdk_types <- function(position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetSdkTypes",
    http_method = "GET",
    http_path = "/sdktypes",
    paginator = list()
  )
  input <- .apigateway$get_sdk_types_input(position = position, limit = limit)
  output <- .apigateway$get_sdk_types_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_sdk_types <- apigateway_get_sdk_types

#' Gets information about a Stage resource
#'
#' @description
#' Gets information about a Stage resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_stage/](https://www.paws-r-sdk.com/docs/apigateway_get_stage/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the Stage resource to get information about.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_stage
apigateway_get_stage <- function(restApiId, stageName) {
  op <- new_operation(
    name = "GetStage",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}",
    paginator = list()
  )
  input <- .apigateway$get_stage_input(restApiId = restApiId, stageName = stageName)
  output <- .apigateway$get_stage_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_stage <- apigateway_get_stage

#' Gets information about one or more Stage resources
#'
#' @description
#' Gets information about one or more Stage resources.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_stages/](https://www.paws-r-sdk.com/docs/apigateway_get_stages/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param deploymentId The stages' deployment identifiers.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_stages
apigateway_get_stages <- function(restApiId, deploymentId = NULL) {
  op <- new_operation(
    name = "GetStages",
    http_method = "GET",
    http_path = "/restapis/{restapi_id}/stages",
    paginator = list()
  )
  input <- .apigateway$get_stages_input(restApiId = restApiId, deploymentId = deploymentId)
  output <- .apigateway$get_stages_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_stages <- apigateway_get_stages

#' Gets the Tags collection for a given resource
#'
#' @description
#' Gets the Tags collection for a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_tags/](https://www.paws-r-sdk.com/docs/apigateway_get_tags/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of a resource that can be tagged.
#' @param position (Not currently supported) The current pagination position in the paged
#' result set.
#' @param limit (Not currently supported) The maximum number of returned results per
#' page. The default value is 25 and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_tags
apigateway_get_tags <- function(resourceArn, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetTags",
    http_method = "GET",
    http_path = "/tags/{resource_arn}",
    paginator = list()
  )
  input <- .apigateway$get_tags_input(resourceArn = resourceArn, position = position, limit = limit)
  output <- .apigateway$get_tags_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_tags <- apigateway_get_tags

#' Gets the usage data of a usage plan in a specified time interval
#'
#' @description
#' Gets the usage data of a usage plan in a specified time interval.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_usage/](https://www.paws-r-sdk.com/docs/apigateway_get_usage/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the usage plan associated with the usage data.
#' @param keyId The Id of the API key associated with the resultant usage data.
#' @param startDate &#91;required&#93; The starting date (e.g., 2016-01-01) of the usage data.
#' @param endDate &#91;required&#93; The ending date (e.g., 2016-12-31) of the usage data.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_usage
apigateway_get_usage <- function(usagePlanId, keyId = NULL, startDate, endDate, position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetUsage",
    http_method = "GET",
    http_path = "/usageplans/{usageplanId}/usage",
    paginator = list(input_token = "position", limit_key = "limit", non_aggregate_keys = list( "usagePlanId", "startDate", "endDate"), output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_usage_input(usagePlanId = usagePlanId, keyId = keyId, startDate = startDate, endDate = endDate, position = position, limit = limit)
  output <- .apigateway$get_usage_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_usage <- apigateway_get_usage

#' Gets a usage plan of a given plan identifier
#'
#' @description
#' Gets a usage plan of a given plan identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_usage_plan/](https://www.paws-r-sdk.com/docs/apigateway_get_usage_plan/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The identifier of the UsagePlan resource to be retrieved.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_usage_plan
apigateway_get_usage_plan <- function(usagePlanId) {
  op <- new_operation(
    name = "GetUsagePlan",
    http_method = "GET",
    http_path = "/usageplans/{usageplanId}",
    paginator = list()
  )
  input <- .apigateway$get_usage_plan_input(usagePlanId = usagePlanId)
  output <- .apigateway$get_usage_plan_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_usage_plan <- apigateway_get_usage_plan

#' Gets a usage plan key of a given key identifier
#'
#' @description
#' Gets a usage plan key of a given key identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_usage_plan_key/](https://www.paws-r-sdk.com/docs/apigateway_get_usage_plan_key/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the UsagePlan resource representing the usage plan containing
#' the to-be-retrieved UsagePlanKey resource representing a plan customer.
#' @param keyId &#91;required&#93; The key Id of the to-be-retrieved UsagePlanKey resource representing a
#' plan customer.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_usage_plan_key
apigateway_get_usage_plan_key <- function(usagePlanId, keyId) {
  op <- new_operation(
    name = "GetUsagePlanKey",
    http_method = "GET",
    http_path = "/usageplans/{usageplanId}/keys/{keyId}",
    paginator = list()
  )
  input <- .apigateway$get_usage_plan_key_input(usagePlanId = usagePlanId, keyId = keyId)
  output <- .apigateway$get_usage_plan_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_usage_plan_key <- apigateway_get_usage_plan_key

#' Gets all the usage plan keys representing the API keys added to a
#' specified usage plan
#'
#' @description
#' Gets all the usage plan keys representing the API keys added to a specified usage plan.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_usage_plan_keys/](https://www.paws-r-sdk.com/docs/apigateway_get_usage_plan_keys/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the UsagePlan resource representing the usage plan containing
#' the to-be-retrieved UsagePlanKey resource representing a plan customer.
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#' @param nameQuery A query parameter specifying the name of the to-be-returned usage plan
#' keys.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_usage_plan_keys
apigateway_get_usage_plan_keys <- function(usagePlanId, position = NULL, limit = NULL, nameQuery = NULL) {
  op <- new_operation(
    name = "GetUsagePlanKeys",
    http_method = "GET",
    http_path = "/usageplans/{usageplanId}/keys",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_usage_plan_keys_input(usagePlanId = usagePlanId, position = position, limit = limit, nameQuery = nameQuery)
  output <- .apigateway$get_usage_plan_keys_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_usage_plan_keys <- apigateway_get_usage_plan_keys

#' Gets all the usage plans of the caller's account
#'
#' @description
#' Gets all the usage plans of the caller's account.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_usage_plans/](https://www.paws-r-sdk.com/docs/apigateway_get_usage_plans/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param keyId The identifier of the API key associated with the usage plans.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_usage_plans
apigateway_get_usage_plans <- function(position = NULL, keyId = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetUsagePlans",
    http_method = "GET",
    http_path = "/usageplans",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_usage_plans_input(position = position, keyId = keyId, limit = limit)
  output <- .apigateway$get_usage_plans_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_usage_plans <- apigateway_get_usage_plans

#' Gets a specified VPC link under the caller's account in a region
#'
#' @description
#' Gets a specified VPC link under the caller's account in a region.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_vpc_link/](https://www.paws-r-sdk.com/docs/apigateway_get_vpc_link/) for full documentation.
#'
#' @param vpcLinkId &#91;required&#93; The identifier of the VpcLink. It is used in an Integration to reference
#' this VpcLink.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_vpc_link
apigateway_get_vpc_link <- function(vpcLinkId) {
  op <- new_operation(
    name = "GetVpcLink",
    http_method = "GET",
    http_path = "/vpclinks/{vpclink_id}",
    paginator = list()
  )
  input <- .apigateway$get_vpc_link_input(vpcLinkId = vpcLinkId)
  output <- .apigateway$get_vpc_link_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_vpc_link <- apigateway_get_vpc_link

#' Gets the VpcLinks collection under the caller's account in a selected
#' region
#'
#' @description
#' Gets the VpcLinks collection under the caller's account in a selected region.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_get_vpc_links/](https://www.paws-r-sdk.com/docs/apigateway_get_vpc_links/) for full documentation.
#'
#' @param position The current pagination position in the paged result set.
#' @param limit The maximum number of returned results per page. The default value is 25
#' and the maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname apigateway_get_vpc_links
apigateway_get_vpc_links <- function(position = NULL, limit = NULL) {
  op <- new_operation(
    name = "GetVpcLinks",
    http_method = "GET",
    http_path = "/vpclinks",
    paginator = list(input_token = "position", limit_key = "limit", output_token = "position", result_key = "items")
  )
  input <- .apigateway$get_vpc_links_input(position = position, limit = limit)
  output <- .apigateway$get_vpc_links_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$get_vpc_links <- apigateway_get_vpc_links

#' Import API keys from an external source, such as a CSV-formatted file
#'
#' @description
#' Import API keys from an external source, such as a CSV-formatted file.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_import_api_keys/](https://www.paws-r-sdk.com/docs/apigateway_import_api_keys/) for full documentation.
#'
#' @param body &#91;required&#93; The payload of the POST request to import API keys. For the payload
#' format, see API Key File Format.
#' @param format &#91;required&#93; A query parameter to specify the input format to imported API keys.
#' Currently, only the `csv` format is supported.
#' @param failOnWarnings A query parameter to indicate whether to rollback ApiKey importation
#' (`true`) or not (`false`) when error is encountered.
#'
#' @keywords internal
#'
#' @rdname apigateway_import_api_keys
apigateway_import_api_keys <- function(body, format, failOnWarnings = NULL) {
  op <- new_operation(
    name = "ImportApiKeys",
    http_method = "POST",
    http_path = "/apikeys?mode=import",
    paginator = list()
  )
  input <- .apigateway$import_api_keys_input(body = body, format = format, failOnWarnings = failOnWarnings)
  output <- .apigateway$import_api_keys_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$import_api_keys <- apigateway_import_api_keys

#' Imports documentation parts
#'
#' @description
#' Imports documentation parts
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_import_documentation_parts/](https://www.paws-r-sdk.com/docs/apigateway_import_documentation_parts/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param mode A query parameter to indicate whether to overwrite (`overwrite`) any
#' existing DocumentationParts definition or to merge (`merge`) the new
#' definition into the existing one. The default value is `merge`.
#' @param failOnWarnings A query parameter to specify whether to rollback the documentation
#' importation (`true`) or not (`false`) when a warning is encountered. The
#' default value is `false`.
#' @param body &#91;required&#93; Raw byte array representing the to-be-imported documentation parts. To
#' import from an OpenAPI file, this is a JSON object.
#'
#' @keywords internal
#'
#' @rdname apigateway_import_documentation_parts
apigateway_import_documentation_parts <- function(restApiId, mode = NULL, failOnWarnings = NULL, body) {
  op <- new_operation(
    name = "ImportDocumentationParts",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}/documentation/parts",
    paginator = list()
  )
  input <- .apigateway$import_documentation_parts_input(restApiId = restApiId, mode = mode, failOnWarnings = failOnWarnings, body = body)
  output <- .apigateway$import_documentation_parts_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$import_documentation_parts <- apigateway_import_documentation_parts

#' A feature of the API Gateway control service for creating a new API from
#' an external API definition file
#'
#' @description
#' A feature of the API Gateway control service for creating a new API from an external API definition file.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_import_rest_api/](https://www.paws-r-sdk.com/docs/apigateway_import_rest_api/) for full documentation.
#'
#' @param failOnWarnings A query parameter to indicate whether to rollback the API creation
#' (`true`) or not (`false`) when a warning is encountered. The default
#' value is `false`.
#' @param parameters A key-value map of context-specific query string parameters specifying
#' the behavior of different API importing operations. The following shows
#' operation-specific parameters and their supported values.
#' 
#' To exclude DocumentationParts from the import, set `parameters` as
#' `ignore=documentation`.
#' 
#' To configure the endpoint type, set `parameters` as
#' `endpointConfigurationTypes=EDGE`,
#' `endpointConfigurationTypes=REGIONAL`, or
#' `endpointConfigurationTypes=PRIVATE`. The default endpoint type is
#' `EDGE`.
#' 
#' To handle imported `basepath`, set `parameters` as `basepath=ignore`,
#' `basepath=prepend` or `basepath=split`.
#' @param body &#91;required&#93; The POST request body containing external API definitions. Currently,
#' only OpenAPI definition JSON/YAML files are supported. The maximum size
#' of the API definition file is 6MB.
#'
#' @keywords internal
#'
#' @rdname apigateway_import_rest_api
apigateway_import_rest_api <- function(failOnWarnings = NULL, parameters = NULL, body) {
  op <- new_operation(
    name = "ImportRestApi",
    http_method = "POST",
    http_path = "/restapis?mode=import",
    paginator = list()
  )
  input <- .apigateway$import_rest_api_input(failOnWarnings = failOnWarnings, parameters = parameters, body = body)
  output <- .apigateway$import_rest_api_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$import_rest_api <- apigateway_import_rest_api

#' Creates a customization of a GatewayResponse of a specified response
#' type and status code on the given RestApi
#'
#' @description
#' Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_put_gateway_response/](https://www.paws-r-sdk.com/docs/apigateway_put_gateway_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param responseType &#91;required&#93; The response type of the associated GatewayResponse
#' @param statusCode The HTTP status code of the GatewayResponse.
#' @param responseParameters Response parameters (paths, query strings and headers) of the
#' GatewayResponse as a string-to-string map of key-value pairs.
#' @param responseTemplates Response templates of the GatewayResponse as a string-to-string map of
#' key-value pairs.
#'
#' @keywords internal
#'
#' @rdname apigateway_put_gateway_response
apigateway_put_gateway_response <- function(restApiId, responseType, statusCode = NULL, responseParameters = NULL, responseTemplates = NULL) {
  op <- new_operation(
    name = "PutGatewayResponse",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}/gatewayresponses/{response_type}",
    paginator = list()
  )
  input <- .apigateway$put_gateway_response_input(restApiId = restApiId, responseType = responseType, statusCode = statusCode, responseParameters = responseParameters, responseTemplates = responseTemplates)
  output <- .apigateway$put_gateway_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$put_gateway_response <- apigateway_put_gateway_response

#' Sets up a method's integration
#'
#' @description
#' Sets up a method's integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_put_integration/](https://www.paws-r-sdk.com/docs/apigateway_put_integration/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a put integration request's resource ID.
#' @param httpMethod &#91;required&#93; Specifies the HTTP method for the integration.
#' @param type &#91;required&#93; Specifies a put integration input's type.
#' @param integrationHttpMethod The HTTP method for the integration.
#' @param uri Specifies Uniform Resource Identifier (URI) of the integration endpoint.
#' For HTTP or `HTTP_PROXY` integrations, the URI must be a fully formed,
#' encoded HTTP(S) URL according to the RFC-3986 specification, for either
#' standard integration, where `connectionType` is not `VPC_LINK`, or
#' private integration, where `connectionType` is `VPC_LINK`. For a private
#' HTTP integration, the URI is not used for routing. For `AWS` or
#' `AWS_PROXY` integrations, the URI is of the form
#' `arn:aws:apigateway:\{region\}:\{subdomain.service|service\}:path|action/\{service_api`\}.
#' Here, \{Region\} is the API Gateway region (e.g., us-east-1);
#' \{service\} is the name of the integrated Amazon Web Services service
#' (e.g., s3); and \{subdomain\} is a designated subdomain supported by
#' certain Amazon Web Services service for fast host-name lookup. action
#' can be used for an Amazon Web Services service action-based API, using
#' an Action=\{name\}&\{p1\}=\{v1\}&p2=\{v2\}... query string. The
#' ensuing \{service_api\} refers to a supported action \{name\} plus
#' any required input parameters. Alternatively, path can be used for an
#' Amazon Web Services service path-based API. The ensuing service_api
#' refers to the path to an Amazon Web Services service resource, including
#' the region of the integrated Amazon Web Services service, if applicable.
#' For example, for integration with the S3 API of `GetObject`, the `uri`
#' can be either
#' `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}`
#' or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`.
#' @param connectionType The type of the network connection to the integration endpoint. The
#' valid value is `INTERNET` for connections through the public routable
#' internet or `VPC_LINK` for private connections between API Gateway and a
#' network load balancer in a VPC. The default value is `INTERNET`.
#' @param connectionId The ID of the VpcLink used for the integration. Specify this value only
#' if you specify `VPC_LINK` as the connection type.
#' @param credentials Specifies whether credentials are required for a put integration.
#' @param requestParameters A key-value map specifying request parameters that are passed from the
#' method request to the back end. The key is an integration request
#' parameter name and the associated value is a method request parameter
#' value or static value that must be enclosed within single quotes and
#' pre-encoded as required by the back end. The method request parameter
#' value must match the pattern of `method.request.{location}.{name}`,
#' where `location` is `querystring`, `path`, or `header` and `name` must
#' be a valid and unique method request parameter name.
#' @param requestTemplates Represents a map of Velocity templates that are applied on the request
#' payload based on the value of the Content-Type header sent by the
#' client. The content type value is the key in this map, and the template
#' (as a String) is the value.
#' @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the
#' Content-Type header in the request, and the available mapping templates
#' specified as the `requestTemplates` property on the Integration
#' resource. There are three valid values: `WHEN_NO_MATCH`,
#' `WHEN_NO_TEMPLATES`, and `NEVER`.
#' @param cacheNamespace Specifies a group of related cached parameters. By default, API Gateway
#' uses the resource ID as the `cacheNamespace`. You can specify the same
#' `cacheNamespace` across resources to return the same cached data for
#' requests to different resources.
#' @param cacheKeyParameters A list of request parameters whose values API Gateway caches. To be
#' valid values for `cacheKeyParameters`, these parameters must also be
#' specified for Method `requestParameters`.
#' @param contentHandling Specifies how to handle request payload content type conversions.
#' Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the
#' following behaviors:
#' 
#' If this property is not defined, the request payload will be passed
#' through from the method request to integration request without
#' modification, provided that the `passthroughBehavior` is configured to
#' support payload pass-through.
#' @param timeoutInMillis Custom timeout between 50 and 29,000 milliseconds. The default value is
#' 29,000 milliseconds or 29 seconds.
#' @param tlsConfig 
#'
#' @keywords internal
#'
#' @rdname apigateway_put_integration
apigateway_put_integration <- function(restApiId, resourceId, httpMethod, type, integrationHttpMethod = NULL, uri = NULL, connectionType = NULL, connectionId = NULL, credentials = NULL, requestParameters = NULL, requestTemplates = NULL, passthroughBehavior = NULL, cacheNamespace = NULL, cacheKeyParameters = NULL, contentHandling = NULL, timeoutInMillis = NULL, tlsConfig = NULL) {
  op <- new_operation(
    name = "PutIntegration",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
    paginator = list()
  )
  input <- .apigateway$put_integration_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, type = type, integrationHttpMethod = integrationHttpMethod, uri = uri, connectionType = connectionType, connectionId = connectionId, credentials = credentials, requestParameters = requestParameters, requestTemplates = requestTemplates, passthroughBehavior = passthroughBehavior, cacheNamespace = cacheNamespace, cacheKeyParameters = cacheKeyParameters, contentHandling = contentHandling, timeoutInMillis = timeoutInMillis, tlsConfig = tlsConfig)
  output <- .apigateway$put_integration_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$put_integration <- apigateway_put_integration

#' Represents a put integration
#'
#' @description
#' Represents a put integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_put_integration_response/](https://www.paws-r-sdk.com/docs/apigateway_put_integration_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a put integration response request's resource identifier.
#' @param httpMethod &#91;required&#93; Specifies a put integration response request's HTTP method.
#' @param statusCode &#91;required&#93; Specifies the status code that is used to map the integration response
#' to an existing MethodResponse.
#' @param selectionPattern Specifies the selection pattern of a put integration response.
#' @param responseParameters A key-value map specifying response parameters that are passed to the
#' method response from the back end. The key is a method response header
#' parameter name and the mapped value is an integration response header
#' value, a static value enclosed within a pair of single quotes, or a JSON
#' expression from the integration response body. The mapping key must
#' match the pattern of `method.response.header.{name}`, where `name` is a
#' valid and unique header name. The mapped non-static value must match the
#' pattern of `integration.response.header.{name}` or
#' `integration.response.body.{JSON-expression}`, where `name` must be a
#' valid and unique response header name and `JSON-expression` a valid JSON
#' expression without the `$` prefix.
#' @param responseTemplates Specifies a put integration response's templates.
#' @param contentHandling Specifies how to handle response payload content type conversions.
#' Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the
#' following behaviors:
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the method response without
#' modification.
#'
#' @keywords internal
#'
#' @rdname apigateway_put_integration_response
apigateway_put_integration_response <- function(restApiId, resourceId, httpMethod, statusCode, selectionPattern = NULL, responseParameters = NULL, responseTemplates = NULL, contentHandling = NULL) {
  op <- new_operation(
    name = "PutIntegrationResponse",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$put_integration_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode, selectionPattern = selectionPattern, responseParameters = responseParameters, responseTemplates = responseTemplates, contentHandling = contentHandling)
  output <- .apigateway$put_integration_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$put_integration_response <- apigateway_put_integration_response

#' Add a method to an existing Resource resource
#'
#' @description
#' Add a method to an existing Resource resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_put_method/](https://www.paws-r-sdk.com/docs/apigateway_put_method/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the new Method resource.
#' @param httpMethod &#91;required&#93; Specifies the method request's HTTP method type.
#' @param authorizationType &#91;required&#93; The method's authorization type. Valid values are `NONE` for open
#' access, `AWS_IAM` for using AWS IAM permissions, `CUSTOM` for using a
#' custom authorizer, or `COGNITO_USER_POOLS` for using a Cognito user
#' pool.
#' @param authorizerId Specifies the identifier of an Authorizer to use on this Method, if the
#' type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is
#' generated by API Gateway when you created the authorizer.
#' @param apiKeyRequired Specifies whether the method required a valid ApiKey.
#' @param operationName A human-friendly operation identifier for the method. For example, you
#' can assign the `operationName` of `ListPets` for the `GET /pets` method
#' in the `PetStore` example.
#' @param requestParameters A key-value map defining required or optional method request parameters
#' that can be accepted by API Gateway. A key defines a method request
#' parameter name matching the pattern of
#' `method.request.{location}.{name}`, where `location` is `querystring`,
#' `path`, or `header` and `name` is a valid and unique parameter name. The
#' value associated with the key is a Boolean flag indicating whether the
#' parameter is required (`true`) or optional (`false`). The method request
#' parameter names defined here are available in Integration to be mapped
#' to integration request parameters or body-mapping templates.
#' @param requestModels Specifies the Model resources used for the request's content type.
#' Request models are represented as a key/value map, with a content type
#' as the key and a Model name as the value.
#' @param requestValidatorId The identifier of a RequestValidator for validating the method request.
#' @param authorizationScopes A list of authorization scopes configured on the method. The scopes are
#' used with a `COGNITO_USER_POOLS` authorizer to authorize the method
#' invocation. The authorization works by matching the method scopes
#' against the scopes parsed from the access token in the incoming request.
#' The method invocation is authorized if any method scopes matches a
#' claimed scope in the access token. Otherwise, the invocation is not
#' authorized. When the method scope is configured, the client must provide
#' an access token instead of an identity token for authorization purposes.
#'
#' @keywords internal
#'
#' @rdname apigateway_put_method
apigateway_put_method <- function(restApiId, resourceId, httpMethod, authorizationType, authorizerId = NULL, apiKeyRequired = NULL, operationName = NULL, requestParameters = NULL, requestModels = NULL, requestValidatorId = NULL, authorizationScopes = NULL) {
  op <- new_operation(
    name = "PutMethod",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
    paginator = list()
  )
  input <- .apigateway$put_method_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, authorizationType = authorizationType, authorizerId = authorizerId, apiKeyRequired = apiKeyRequired, operationName = operationName, requestParameters = requestParameters, requestModels = requestModels, requestValidatorId = requestValidatorId, authorizationScopes = authorizationScopes)
  output <- .apigateway$put_method_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$put_method <- apigateway_put_method

#' Adds a MethodResponse to an existing Method resource
#'
#' @description
#' Adds a MethodResponse to an existing Method resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_put_method_response/](https://www.paws-r-sdk.com/docs/apigateway_put_method_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the Method resource.
#' @param httpMethod &#91;required&#93; The HTTP verb of the Method resource.
#' @param statusCode &#91;required&#93; The method response's status code.
#' @param responseParameters A key-value map specifying required or optional response parameters that
#' API Gateway can send back to the caller. A key defines a method response
#' header name and the associated value is a Boolean flag indicating
#' whether the method response parameter is required or not. The method
#' response header names must match the pattern of
#' `method.response.header.{name}`, where `name` is a valid and unique
#' header name. The response parameter names defined here are available in
#' the integration response to be mapped from an integration response
#' header expressed in `integration.response.header.{name}`, a static value
#' enclosed within a pair of single quotes (e.g., `'application/json'`), or
#' a JSON expression from the back-end response payload in the form of
#' `integration.response.body.{JSON-expression}`, where `JSON-expression`
#' is a valid JSON expression without the `$` prefix.)
#' @param responseModels Specifies the Model resources used for the response's content type.
#' Response models are represented as a key/value map, with a content type
#' as the key and a Model name as the value.
#'
#' @keywords internal
#'
#' @rdname apigateway_put_method_response
apigateway_put_method_response <- function(restApiId, resourceId, httpMethod, statusCode, responseParameters = NULL, responseModels = NULL) {
  op <- new_operation(
    name = "PutMethodResponse",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$put_method_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode, responseParameters = responseParameters, responseModels = responseModels)
  output <- .apigateway$put_method_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$put_method_response <- apigateway_put_method_response

#' A feature of the API Gateway control service for updating an existing
#' API with an input of external API definitions
#'
#' @description
#' A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_put_rest_api/](https://www.paws-r-sdk.com/docs/apigateway_put_rest_api/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param mode The `mode` query parameter to specify the update mode. Valid values are
#' "merge" and "overwrite". By default, the update mode is "merge".
#' @param failOnWarnings A query parameter to indicate whether to rollback the API update
#' (`true`) or not (`false`) when a warning is encountered. The default
#' value is `false`.
#' @param parameters Custom header parameters as part of the request. For example, to exclude
#' DocumentationParts from an imported API, set `ignore=documentation` as a
#' `parameters` value, as in the AWS CLI command of
#' `aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'`.
#' @param body &#91;required&#93; The PUT request body containing external API definitions. Currently,
#' only OpenAPI definition JSON/YAML files are supported. The maximum size
#' of the API definition file is 6MB.
#'
#' @keywords internal
#'
#' @rdname apigateway_put_rest_api
apigateway_put_rest_api <- function(restApiId, mode = NULL, failOnWarnings = NULL, parameters = NULL, body) {
  op <- new_operation(
    name = "PutRestApi",
    http_method = "PUT",
    http_path = "/restapis/{restapi_id}",
    paginator = list()
  )
  input <- .apigateway$put_rest_api_input(restApiId = restApiId, mode = mode, failOnWarnings = failOnWarnings, parameters = parameters, body = body)
  output <- .apigateway$put_rest_api_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$put_rest_api <- apigateway_put_rest_api

#' Adds or updates a tag on a given resource
#'
#' @description
#' Adds or updates a tag on a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_tag_resource/](https://www.paws-r-sdk.com/docs/apigateway_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of a resource that can be tagged.
#' @param tags &#91;required&#93; The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=._:/\]. The tag key can be up to 128 characters and must not
#' start with `aws:`. The tag value can be up to 256 characters.
#'
#' @keywords internal
#'
#' @rdname apigateway_tag_resource
apigateway_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/tags/{resource_arn}",
    paginator = list()
  )
  input <- .apigateway$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .apigateway$tag_resource_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$tag_resource <- apigateway_tag_resource

#' Simulate the execution of an Authorizer in your RestApi with headers,
#' parameters, and an incoming request body
#'
#' @description
#' Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_test_invoke_authorizer/](https://www.paws-r-sdk.com/docs/apigateway_test_invoke_authorizer/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param authorizerId &#91;required&#93; Specifies a test invoke authorizer request's Authorizer ID.
#' @param headers A key-value map of headers to simulate an incoming invocation request.
#' This is where the incoming authorization token, or identity source,
#' should be specified.
#' @param multiValueHeaders The headers as a map from string to list of values to simulate an
#' incoming invocation request. This is where the incoming authorization
#' token, or identity source, may be specified.
#' @param pathWithQueryString The URI path, including query string, of the simulated invocation
#' request. Use this to specify path parameters and query string
#' parameters.
#' @param body The simulated request body of an incoming invocation request.
#' @param stageVariables A key-value map of stage variables to simulate an invocation on a
#' deployed Stage.
#' @param additionalContext A key-value map of additional context variables.
#'
#' @keywords internal
#'
#' @rdname apigateway_test_invoke_authorizer
apigateway_test_invoke_authorizer <- function(restApiId, authorizerId, headers = NULL, multiValueHeaders = NULL, pathWithQueryString = NULL, body = NULL, stageVariables = NULL, additionalContext = NULL) {
  op <- new_operation(
    name = "TestInvokeAuthorizer",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/authorizers/{authorizer_id}",
    paginator = list()
  )
  input <- .apigateway$test_invoke_authorizer_input(restApiId = restApiId, authorizerId = authorizerId, headers = headers, multiValueHeaders = multiValueHeaders, pathWithQueryString = pathWithQueryString, body = body, stageVariables = stageVariables, additionalContext = additionalContext)
  output <- .apigateway$test_invoke_authorizer_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$test_invoke_authorizer <- apigateway_test_invoke_authorizer

#' Simulate the invocation of a Method in your RestApi with headers,
#' parameters, and an incoming request body
#'
#' @description
#' Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_test_invoke_method/](https://www.paws-r-sdk.com/docs/apigateway_test_invoke_method/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies a test invoke method request's resource ID.
#' @param httpMethod &#91;required&#93; Specifies a test invoke method request's HTTP method.
#' @param pathWithQueryString The URI path, including query string, of the simulated invocation
#' request. Use this to specify path parameters and query string
#' parameters.
#' @param body The simulated request body of an incoming invocation request.
#' @param headers A key-value map of headers to simulate an incoming invocation request.
#' @param multiValueHeaders The headers as a map from string to list of values to simulate an
#' incoming invocation request.
#' @param clientCertificateId A ClientCertificate identifier to use in the test invocation. API
#' Gateway will use the certificate when making the HTTPS request to the
#' defined back-end endpoint.
#' @param stageVariables A key-value map of stage variables to simulate an invocation on a
#' deployed Stage.
#'
#' @keywords internal
#'
#' @rdname apigateway_test_invoke_method
apigateway_test_invoke_method <- function(restApiId, resourceId, httpMethod, pathWithQueryString = NULL, body = NULL, headers = NULL, multiValueHeaders = NULL, clientCertificateId = NULL, stageVariables = NULL) {
  op <- new_operation(
    name = "TestInvokeMethod",
    http_method = "POST",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
    paginator = list()
  )
  input <- .apigateway$test_invoke_method_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, pathWithQueryString = pathWithQueryString, body = body, headers = headers, multiValueHeaders = multiValueHeaders, clientCertificateId = clientCertificateId, stageVariables = stageVariables)
  output <- .apigateway$test_invoke_method_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$test_invoke_method <- apigateway_test_invoke_method

#' Removes a tag from a given resource
#'
#' @description
#' Removes a tag from a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_untag_resource/](https://www.paws-r-sdk.com/docs/apigateway_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of a resource that can be tagged.
#' @param tagKeys &#91;required&#93; The Tag keys to delete.
#'
#' @keywords internal
#'
#' @rdname apigateway_untag_resource
apigateway_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resource_arn}",
    paginator = list()
  )
  input <- .apigateway$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .apigateway$untag_resource_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$untag_resource <- apigateway_untag_resource

#' Changes information about the current Account resource
#'
#' @description
#' Changes information about the current Account resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_account/](https://www.paws-r-sdk.com/docs/apigateway_update_account/) for full documentation.
#'
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_account
apigateway_update_account <- function(patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateAccount",
    http_method = "PATCH",
    http_path = "/account",
    paginator = list()
  )
  input <- .apigateway$update_account_input(patchOperations = patchOperations)
  output <- .apigateway$update_account_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_account <- apigateway_update_account

#' Changes information about an ApiKey resource
#'
#' @description
#' Changes information about an ApiKey resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_api_key/](https://www.paws-r-sdk.com/docs/apigateway_update_api_key/) for full documentation.
#'
#' @param apiKey &#91;required&#93; The identifier of the ApiKey resource to be updated.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_api_key
apigateway_update_api_key <- function(apiKey, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateApiKey",
    http_method = "PATCH",
    http_path = "/apikeys/{api_Key}",
    paginator = list()
  )
  input <- .apigateway$update_api_key_input(apiKey = apiKey, patchOperations = patchOperations)
  output <- .apigateway$update_api_key_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_api_key <- apigateway_update_api_key

#' Updates an existing Authorizer resource
#'
#' @description
#' Updates an existing Authorizer resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_authorizer/](https://www.paws-r-sdk.com/docs/apigateway_update_authorizer/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param authorizerId &#91;required&#93; The identifier of the Authorizer resource.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_authorizer
apigateway_update_authorizer <- function(restApiId, authorizerId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateAuthorizer",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/authorizers/{authorizer_id}",
    paginator = list()
  )
  input <- .apigateway$update_authorizer_input(restApiId = restApiId, authorizerId = authorizerId, patchOperations = patchOperations)
  output <- .apigateway$update_authorizer_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_authorizer <- apigateway_update_authorizer

#' Changes information about the BasePathMapping resource
#'
#' @description
#' Changes information about the BasePathMapping resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_base_path_mapping/](https://www.paws-r-sdk.com/docs/apigateway_update_base_path_mapping/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name of the BasePathMapping resource to change.
#' @param basePath &#91;required&#93; The base path of the BasePathMapping resource to change.
#' 
#' To specify an empty base path, set this parameter to `'(none)'`.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_base_path_mapping
apigateway_update_base_path_mapping <- function(domainName, basePath, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateBasePathMapping",
    http_method = "PATCH",
    http_path = "/domainnames/{domain_name}/basepathmappings/{base_path}",
    paginator = list()
  )
  input <- .apigateway$update_base_path_mapping_input(domainName = domainName, basePath = basePath, patchOperations = patchOperations)
  output <- .apigateway$update_base_path_mapping_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_base_path_mapping <- apigateway_update_base_path_mapping

#' Changes information about an ClientCertificate resource
#'
#' @description
#' Changes information about an ClientCertificate resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_client_certificate/](https://www.paws-r-sdk.com/docs/apigateway_update_client_certificate/) for full documentation.
#'
#' @param clientCertificateId &#91;required&#93; The identifier of the ClientCertificate resource to be updated.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_client_certificate
apigateway_update_client_certificate <- function(clientCertificateId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateClientCertificate",
    http_method = "PATCH",
    http_path = "/clientcertificates/{clientcertificate_id}",
    paginator = list()
  )
  input <- .apigateway$update_client_certificate_input(clientCertificateId = clientCertificateId, patchOperations = patchOperations)
  output <- .apigateway$update_client_certificate_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_client_certificate <- apigateway_update_client_certificate

#' Changes information about a Deployment resource
#'
#' @description
#' Changes information about a Deployment resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_deployment/](https://www.paws-r-sdk.com/docs/apigateway_update_deployment/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param deploymentId &#91;required&#93; The replacement identifier for the Deployment resource to change
#' information about.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_deployment
apigateway_update_deployment <- function(restApiId, deploymentId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateDeployment",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/deployments/{deployment_id}",
    paginator = list()
  )
  input <- .apigateway$update_deployment_input(restApiId = restApiId, deploymentId = deploymentId, patchOperations = patchOperations)
  output <- .apigateway$update_deployment_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_deployment <- apigateway_update_deployment

#' Updates a documentation part
#'
#' @description
#' Updates a documentation part.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_documentation_part/](https://www.paws-r-sdk.com/docs/apigateway_update_documentation_part/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationPartId &#91;required&#93; The identifier of the to-be-updated documentation part.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_documentation_part
apigateway_update_documentation_part <- function(restApiId, documentationPartId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateDocumentationPart",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/documentation/parts/{part_id}",
    paginator = list()
  )
  input <- .apigateway$update_documentation_part_input(restApiId = restApiId, documentationPartId = documentationPartId, patchOperations = patchOperations)
  output <- .apigateway$update_documentation_part_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_documentation_part <- apigateway_update_documentation_part

#' Updates a documentation version
#'
#' @description
#' Updates a documentation version.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_documentation_version/](https://www.paws-r-sdk.com/docs/apigateway_update_documentation_version/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param documentationVersion &#91;required&#93; The version identifier of the to-be-updated documentation version.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_documentation_version
apigateway_update_documentation_version <- function(restApiId, documentationVersion, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateDocumentationVersion",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/documentation/versions/{doc_version}",
    paginator = list()
  )
  input <- .apigateway$update_documentation_version_input(restApiId = restApiId, documentationVersion = documentationVersion, patchOperations = patchOperations)
  output <- .apigateway$update_documentation_version_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_documentation_version <- apigateway_update_documentation_version

#' Changes information about the DomainName resource
#'
#' @description
#' Changes information about the DomainName resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_domain_name/](https://www.paws-r-sdk.com/docs/apigateway_update_domain_name/) for full documentation.
#'
#' @param domainName &#91;required&#93; The name of the DomainName resource to be changed.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_domain_name
apigateway_update_domain_name <- function(domainName, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateDomainName",
    http_method = "PATCH",
    http_path = "/domainnames/{domain_name}",
    paginator = list()
  )
  input <- .apigateway$update_domain_name_input(domainName = domainName, patchOperations = patchOperations)
  output <- .apigateway$update_domain_name_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_domain_name <- apigateway_update_domain_name

#' Updates a GatewayResponse of a specified response type on the given
#' RestApi
#'
#' @description
#' Updates a GatewayResponse of a specified response type on the given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_gateway_response/](https://www.paws-r-sdk.com/docs/apigateway_update_gateway_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param responseType &#91;required&#93; The response type of the associated GatewayResponse.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_gateway_response
apigateway_update_gateway_response <- function(restApiId, responseType, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateGatewayResponse",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/gatewayresponses/{response_type}",
    paginator = list()
  )
  input <- .apigateway$update_gateway_response_input(restApiId = restApiId, responseType = responseType, patchOperations = patchOperations)
  output <- .apigateway$update_gateway_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_gateway_response <- apigateway_update_gateway_response

#' Represents an update integration
#'
#' @description
#' Represents an update integration.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_integration/](https://www.paws-r-sdk.com/docs/apigateway_update_integration/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Represents an update integration request's resource identifier.
#' @param httpMethod &#91;required&#93; Represents an update integration request's HTTP method.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_integration
apigateway_update_integration <- function(restApiId, resourceId, httpMethod, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateIntegration",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
    paginator = list()
  )
  input <- .apigateway$update_integration_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, patchOperations = patchOperations)
  output <- .apigateway$update_integration_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_integration <- apigateway_update_integration

#' Represents an update integration response
#'
#' @description
#' Represents an update integration response.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_integration_response/](https://www.paws-r-sdk.com/docs/apigateway_update_integration_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; Specifies an update integration response request's resource identifier.
#' @param httpMethod &#91;required&#93; Specifies an update integration response request's HTTP method.
#' @param statusCode &#91;required&#93; Specifies an update integration response request's status code.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_integration_response
apigateway_update_integration_response <- function(restApiId, resourceId, httpMethod, statusCode, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateIntegrationResponse",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$update_integration_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode, patchOperations = patchOperations)
  output <- .apigateway$update_integration_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_integration_response <- apigateway_update_integration_response

#' Updates an existing Method resource
#'
#' @description
#' Updates an existing Method resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_method/](https://www.paws-r-sdk.com/docs/apigateway_update_method/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the Method resource.
#' @param httpMethod &#91;required&#93; The HTTP verb of the Method resource.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_method
apigateway_update_method <- function(restApiId, resourceId, httpMethod, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateMethod",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
    paginator = list()
  )
  input <- .apigateway$update_method_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, patchOperations = patchOperations)
  output <- .apigateway$update_method_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_method <- apigateway_update_method

#' Updates an existing MethodResponse resource
#'
#' @description
#' Updates an existing MethodResponse resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_method_response/](https://www.paws-r-sdk.com/docs/apigateway_update_method_response/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The Resource identifier for the MethodResponse resource.
#' @param httpMethod &#91;required&#93; The HTTP verb of the Method resource.
#' @param statusCode &#91;required&#93; The status code for the MethodResponse resource.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_method_response
apigateway_update_method_response <- function(restApiId, resourceId, httpMethod, statusCode, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateMethodResponse",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
    paginator = list()
  )
  input <- .apigateway$update_method_response_input(restApiId = restApiId, resourceId = resourceId, httpMethod = httpMethod, statusCode = statusCode, patchOperations = patchOperations)
  output <- .apigateway$update_method_response_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_method_response <- apigateway_update_method_response

#' Changes information about a model
#'
#' @description
#' Changes information about a model.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_model/](https://www.paws-r-sdk.com/docs/apigateway_update_model/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param modelName &#91;required&#93; The name of the model to update.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_model
apigateway_update_model <- function(restApiId, modelName, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateModel",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/models/{model_name}",
    paginator = list()
  )
  input <- .apigateway$update_model_input(restApiId = restApiId, modelName = modelName, patchOperations = patchOperations)
  output <- .apigateway$update_model_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_model <- apigateway_update_model

#' Updates a RequestValidator of a given RestApi
#'
#' @description
#' Updates a RequestValidator of a given RestApi.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_request_validator/](https://www.paws-r-sdk.com/docs/apigateway_update_request_validator/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param requestValidatorId &#91;required&#93; The identifier of RequestValidator to be updated.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_request_validator
apigateway_update_request_validator <- function(restApiId, requestValidatorId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateRequestValidator",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
    paginator = list()
  )
  input <- .apigateway$update_request_validator_input(restApiId = restApiId, requestValidatorId = requestValidatorId, patchOperations = patchOperations)
  output <- .apigateway$update_request_validator_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_request_validator <- apigateway_update_request_validator

#' Changes information about a Resource resource
#'
#' @description
#' Changes information about a Resource resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_resource/](https://www.paws-r-sdk.com/docs/apigateway_update_resource/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param resourceId &#91;required&#93; The identifier of the Resource resource.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_resource
apigateway_update_resource <- function(restApiId, resourceId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateResource",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/resources/{resource_id}",
    paginator = list()
  )
  input <- .apigateway$update_resource_input(restApiId = restApiId, resourceId = resourceId, patchOperations = patchOperations)
  output <- .apigateway$update_resource_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_resource <- apigateway_update_resource

#' Changes information about the specified API
#'
#' @description
#' Changes information about the specified API.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_rest_api/](https://www.paws-r-sdk.com/docs/apigateway_update_rest_api/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_rest_api
apigateway_update_rest_api <- function(restApiId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateRestApi",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}",
    paginator = list()
  )
  input <- .apigateway$update_rest_api_input(restApiId = restApiId, patchOperations = patchOperations)
  output <- .apigateway$update_rest_api_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_rest_api <- apigateway_update_rest_api

#' Changes information about a Stage resource
#'
#' @description
#' Changes information about a Stage resource.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_stage/](https://www.paws-r-sdk.com/docs/apigateway_update_stage/) for full documentation.
#'
#' @param restApiId &#91;required&#93; The string identifier of the associated RestApi.
#' @param stageName &#91;required&#93; The name of the Stage resource to change information about.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_stage
apigateway_update_stage <- function(restApiId, stageName, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateStage",
    http_method = "PATCH",
    http_path = "/restapis/{restapi_id}/stages/{stage_name}",
    paginator = list()
  )
  input <- .apigateway$update_stage_input(restApiId = restApiId, stageName = stageName, patchOperations = patchOperations)
  output <- .apigateway$update_stage_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_stage <- apigateway_update_stage

#' Grants a temporary extension to the remaining quota of a usage plan
#' associated with a specified API key
#'
#' @description
#' Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_usage/](https://www.paws-r-sdk.com/docs/apigateway_update_usage/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the usage plan associated with the usage data.
#' @param keyId &#91;required&#93; The identifier of the API key associated with the usage plan in which a
#' temporary extension is granted to the remaining quota.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_usage
apigateway_update_usage <- function(usagePlanId, keyId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateUsage",
    http_method = "PATCH",
    http_path = "/usageplans/{usageplanId}/keys/{keyId}/usage",
    paginator = list()
  )
  input <- .apigateway$update_usage_input(usagePlanId = usagePlanId, keyId = keyId, patchOperations = patchOperations)
  output <- .apigateway$update_usage_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_usage <- apigateway_update_usage

#' Updates a usage plan of a given plan Id
#'
#' @description
#' Updates a usage plan of a given plan Id.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_usage_plan/](https://www.paws-r-sdk.com/docs/apigateway_update_usage_plan/) for full documentation.
#'
#' @param usagePlanId &#91;required&#93; The Id of the to-be-updated usage plan.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_usage_plan
apigateway_update_usage_plan <- function(usagePlanId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateUsagePlan",
    http_method = "PATCH",
    http_path = "/usageplans/{usageplanId}",
    paginator = list()
  )
  input <- .apigateway$update_usage_plan_input(usagePlanId = usagePlanId, patchOperations = patchOperations)
  output <- .apigateway$update_usage_plan_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_usage_plan <- apigateway_update_usage_plan

#' Updates an existing VpcLink of a specified identifier
#'
#' @description
#' Updates an existing VpcLink of a specified identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/apigateway_update_vpc_link/](https://www.paws-r-sdk.com/docs/apigateway_update_vpc_link/) for full documentation.
#'
#' @param vpcLinkId &#91;required&#93; The identifier of the VpcLink. It is used in an Integration to reference
#' this VpcLink.
#' @param patchOperations For more information about supported patch operations, see [Patch
#' Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
#'
#' @keywords internal
#'
#' @rdname apigateway_update_vpc_link
apigateway_update_vpc_link <- function(vpcLinkId, patchOperations = NULL) {
  op <- new_operation(
    name = "UpdateVpcLink",
    http_method = "PATCH",
    http_path = "/vpclinks/{vpclink_id}",
    paginator = list()
  )
  input <- .apigateway$update_vpc_link_input(vpcLinkId = vpcLinkId, patchOperations = patchOperations)
  output <- .apigateway$update_vpc_link_output()
  config <- get_config()
  svc <- .apigateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigateway$operations$update_vpc_link <- apigateway_update_vpc_link
