# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include directconnect_service.R
NULL

#' Accepts a proposal request to attach a virtual private gateway or
#' transit gateway to a Direct Connect gateway
#'
#' @description
#' Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_accept_direct_connect_gateway_association_proposal/](https://www.paws-r-sdk.com/docs/directconnect_accept_direct_connect_gateway_association_proposal/) for full documentation.
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#' @param proposalId &#91;required&#93; The ID of the request proposal.
#' @param associatedGatewayOwnerAccount &#91;required&#93; The ID of the Amazon Web Services account that owns the virtual private
#' gateway or transit gateway.
#' @param overrideAllowedPrefixesToDirectConnectGateway Overrides the Amazon VPC prefixes advertised to the Direct Connect
#' gateway.
#' 
#' For information about how to set the prefixes, see [Allowed
#' Prefixes](https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
#' in the *Direct Connect User Guide*.
#'
#' @keywords internal
#'
#' @rdname directconnect_accept_direct_connec_gatewa_associ_propos
directconnect_accept_direct_connect_gateway_association_proposal <- function(directConnectGatewayId, proposalId, associatedGatewayOwnerAccount, overrideAllowedPrefixesToDirectConnectGateway = NULL) {
  op <- new_operation(
    name = "AcceptDirectConnectGatewayAssociationProposal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$accept_direct_connect_gateway_association_proposal_input(directConnectGatewayId = directConnectGatewayId, proposalId = proposalId, associatedGatewayOwnerAccount = associatedGatewayOwnerAccount, overrideAllowedPrefixesToDirectConnectGateway = overrideAllowedPrefixesToDirectConnectGateway)
  output <- .directconnect$accept_direct_connect_gateway_association_proposal_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$accept_direct_connect_gateway_association_proposal <- directconnect_accept_direct_connect_gateway_association_proposal

#' Deprecated
#'
#' @description
#' Deprecated. Use [`allocate_hosted_connection`][directconnect_allocate_hosted_connection] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_allocate_connection_on_interconnect/](https://www.paws-r-sdk.com/docs/directconnect_allocate_connection_on_interconnect/) for full documentation.
#'
#' @param bandwidth &#91;required&#93; The bandwidth of the connection. The possible values are 50Mbps,
#' 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and
#' 10Gbps. Note that only those Direct Connect Partners who have met
#' specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or
#' 10Gbps hosted connection.
#' @param connectionName &#91;required&#93; The name of the provisioned connection.
#' @param ownerAccount &#91;required&#93; The ID of the Amazon Web Services account of the customer for whom the
#' connection will be provisioned.
#' @param interconnectId &#91;required&#93; The ID of the interconnect on which the connection will be provisioned.
#' @param vlan &#91;required&#93; The dedicated VLAN provisioned to the connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_connection_on_interconnect
directconnect_allocate_connection_on_interconnect <- function(bandwidth, connectionName, ownerAccount, interconnectId, vlan) {
  op <- new_operation(
    name = "AllocateConnectionOnInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_connection_on_interconnect_input(bandwidth = bandwidth, connectionName = connectionName, ownerAccount = ownerAccount, interconnectId = interconnectId, vlan = vlan)
  output <- .directconnect$allocate_connection_on_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_connection_on_interconnect <- directconnect_allocate_connection_on_interconnect

#' Creates a hosted connection on the specified interconnect or a link
#' aggregation group (LAG) of interconnects
#'
#' @description
#' Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_allocate_hosted_connection/](https://www.paws-r-sdk.com/docs/directconnect_allocate_hosted_connection/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the interconnect or LAG.
#' @param ownerAccount &#91;required&#93; The ID of the Amazon Web Services account ID of the customer for the
#' connection.
#' @param bandwidth &#91;required&#93; The bandwidth of the connection. The possible values are 50Mbps,
#' 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and
#' 10Gbps. Note that only those Direct Connect Partners who have met
#' specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or
#' 10Gbps hosted connection.
#' @param connectionName &#91;required&#93; The name of the hosted connection.
#' @param vlan &#91;required&#93; The dedicated VLAN provisioned to the hosted connection.
#' @param tags The tags associated with the connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_hosted_connection
directconnect_allocate_hosted_connection <- function(connectionId, ownerAccount, bandwidth, connectionName, vlan, tags = NULL) {
  op <- new_operation(
    name = "AllocateHostedConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_hosted_connection_input(connectionId = connectionId, ownerAccount = ownerAccount, bandwidth = bandwidth, connectionName = connectionName, vlan = vlan, tags = tags)
  output <- .directconnect$allocate_hosted_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_hosted_connection <- directconnect_allocate_hosted_connection

#' Provisions a private virtual interface to be owned by the specified
#' Amazon Web Services account
#'
#' @description
#' Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_allocate_private_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_allocate_private_virtual_interface/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection on which the private virtual interface is
#' provisioned.
#' @param ownerAccount &#91;required&#93; The ID of the Amazon Web Services account that owns the virtual private
#' interface.
#' @param newPrivateVirtualInterfaceAllocation &#91;required&#93; Information about the private virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_private_virtual_interface
directconnect_allocate_private_virtual_interface <- function(connectionId, ownerAccount, newPrivateVirtualInterfaceAllocation) {
  op <- new_operation(
    name = "AllocatePrivateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_private_virtual_interface_input(connectionId = connectionId, ownerAccount = ownerAccount, newPrivateVirtualInterfaceAllocation = newPrivateVirtualInterfaceAllocation)
  output <- .directconnect$allocate_private_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_private_virtual_interface <- directconnect_allocate_private_virtual_interface

#' Provisions a public virtual interface to be owned by the specified
#' Amazon Web Services account
#'
#' @description
#' Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_allocate_public_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_allocate_public_virtual_interface/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection on which the public virtual interface is
#' provisioned.
#' @param ownerAccount &#91;required&#93; The ID of the Amazon Web Services account that owns the public virtual
#' interface.
#' @param newPublicVirtualInterfaceAllocation &#91;required&#93; Information about the public virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_public_virtual_interface
directconnect_allocate_public_virtual_interface <- function(connectionId, ownerAccount, newPublicVirtualInterfaceAllocation) {
  op <- new_operation(
    name = "AllocatePublicVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_public_virtual_interface_input(connectionId = connectionId, ownerAccount = ownerAccount, newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation)
  output <- .directconnect$allocate_public_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_public_virtual_interface <- directconnect_allocate_public_virtual_interface

#' Provisions a transit virtual interface to be owned by the specified
#' Amazon Web Services account
#'
#' @description
#' Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_allocate_transit_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_allocate_transit_virtual_interface/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection on which the transit virtual interface is
#' provisioned.
#' @param ownerAccount &#91;required&#93; The ID of the Amazon Web Services account that owns the transit virtual
#' interface.
#' @param newTransitVirtualInterfaceAllocation &#91;required&#93; Information about the transit virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_allocate_transit_virtual_interface
directconnect_allocate_transit_virtual_interface <- function(connectionId, ownerAccount, newTransitVirtualInterfaceAllocation) {
  op <- new_operation(
    name = "AllocateTransitVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$allocate_transit_virtual_interface_input(connectionId = connectionId, ownerAccount = ownerAccount, newTransitVirtualInterfaceAllocation = newTransitVirtualInterfaceAllocation)
  output <- .directconnect$allocate_transit_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$allocate_transit_virtual_interface <- directconnect_allocate_transit_virtual_interface

#' Associates an existing connection with a link aggregation group (LAG)
#'
#' @description
#' Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_associate_connection_with_lag/](https://www.paws-r-sdk.com/docs/directconnect_associate_connection_with_lag/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param lagId &#91;required&#93; The ID of the LAG with which to associate the connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_connection_with_lag
directconnect_associate_connection_with_lag <- function(connectionId, lagId) {
  op <- new_operation(
    name = "AssociateConnectionWithLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_connection_with_lag_input(connectionId = connectionId, lagId = lagId)
  output <- .directconnect$associate_connection_with_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_connection_with_lag <- directconnect_associate_connection_with_lag

#' Associates a hosted connection and its virtual interfaces with a link
#' aggregation group (LAG) or interconnect
#'
#' @description
#' Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_associate_hosted_connection/](https://www.paws-r-sdk.com/docs/directconnect_associate_hosted_connection/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the hosted connection.
#' @param parentConnectionId &#91;required&#93; The ID of the interconnect or the LAG.
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_hosted_connection
directconnect_associate_hosted_connection <- function(connectionId, parentConnectionId) {
  op <- new_operation(
    name = "AssociateHostedConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_hosted_connection_input(connectionId = connectionId, parentConnectionId = parentConnectionId)
  output <- .directconnect$associate_hosted_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_hosted_connection <- directconnect_associate_hosted_connection

#' Associates a MAC Security (MACsec) Connection Key Name (CKN)/
#' Connectivity Association Key (CAK) pair with an Direct Connect dedicated
#' connection
#'
#' @description
#' Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_associate_mac_sec_key/](https://www.paws-r-sdk.com/docs/directconnect_associate_mac_sec_key/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG
#' (dxlag-xxxx).
#' 
#' You can use [`describe_connections`][directconnect_describe_connections]
#' or [`describe_lags`][directconnect_describe_lags] to retrieve connection
#' ID.
#' @param secretARN The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key
#' to associate with the dedicated connection.
#' 
#' You can use [`describe_connections`][directconnect_describe_connections]
#' or [`describe_lags`][directconnect_describe_lags] to retrieve the MAC
#' Security (MACsec) secret key.
#' 
#' If you use this request parameter, you do not use the `ckn` and `cak`
#' request parameters.
#' @param ckn The MAC Security (MACsec) CKN to associate with the dedicated
#' connection.
#' 
#' You can create the CKN/CAK pair using an industry standard tool.
#' 
#' The valid values are 64 hexadecimal characters (0-9, A-E).
#' 
#' If you use this request parameter, you must use the `cak` request
#' parameter and not use the `secretARN` request parameter.
#' @param cak The MAC Security (MACsec) CAK to associate with the dedicated
#' connection.
#' 
#' You can create the CKN/CAK pair using an industry standard tool.
#' 
#' The valid values are 64 hexadecimal characters (0-9, A-E).
#' 
#' If you use this request parameter, you must use the `ckn` request
#' parameter and not use the `secretARN` request parameter.
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_mac_sec_key
directconnect_associate_mac_sec_key <- function(connectionId, secretARN = NULL, ckn = NULL, cak = NULL) {
  op <- new_operation(
    name = "AssociateMacSecKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_mac_sec_key_input(connectionId = connectionId, secretARN = secretARN, ckn = ckn, cak = cak)
  output <- .directconnect$associate_mac_sec_key_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_mac_sec_key <- directconnect_associate_mac_sec_key

#' Associates a virtual interface with a specified link aggregation group
#' (LAG) or connection
#'
#' @description
#' Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_associate_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_associate_virtual_interface/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param connectionId &#91;required&#93; The ID of the LAG or connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_associate_virtual_interface
directconnect_associate_virtual_interface <- function(virtualInterfaceId, connectionId) {
  op <- new_operation(
    name = "AssociateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$associate_virtual_interface_input(virtualInterfaceId = virtualInterfaceId, connectionId = connectionId)
  output <- .directconnect$associate_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$associate_virtual_interface <- directconnect_associate_virtual_interface

#' Confirms the creation of the specified hosted connection on an
#' interconnect
#'
#' @description
#' Confirms the creation of the specified hosted connection on an interconnect.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_confirm_connection/](https://www.paws-r-sdk.com/docs/directconnect_confirm_connection/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the hosted connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_connection
directconnect_confirm_connection <- function(connectionId) {
  op <- new_operation(
    name = "ConfirmConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_connection_input(connectionId = connectionId)
  output <- .directconnect$confirm_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_connection <- directconnect_confirm_connection

#' The confirmation of the terms of agreement when creating the
#' connection/link aggregation group (LAG)
#'
#' @description
#' The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_confirm_customer_agreement/](https://www.paws-r-sdk.com/docs/directconnect_confirm_customer_agreement/) for full documentation.
#'
#' @param agreementName The name of the customer agreement.
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_customer_agreement
directconnect_confirm_customer_agreement <- function(agreementName = NULL) {
  op <- new_operation(
    name = "ConfirmCustomerAgreement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_customer_agreement_input(agreementName = agreementName)
  output <- .directconnect$confirm_customer_agreement_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_customer_agreement <- directconnect_confirm_customer_agreement

#' Accepts ownership of a private virtual interface created by another
#' Amazon Web Services account
#'
#' @description
#' Accepts ownership of a private virtual interface created by another Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_confirm_private_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_confirm_private_virtual_interface/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param virtualGatewayId The ID of the virtual private gateway.
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_private_virtual_interface
directconnect_confirm_private_virtual_interface <- function(virtualInterfaceId, virtualGatewayId = NULL, directConnectGatewayId = NULL) {
  op <- new_operation(
    name = "ConfirmPrivateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_private_virtual_interface_input(virtualInterfaceId = virtualInterfaceId, virtualGatewayId = virtualGatewayId, directConnectGatewayId = directConnectGatewayId)
  output <- .directconnect$confirm_private_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_private_virtual_interface <- directconnect_confirm_private_virtual_interface

#' Accepts ownership of a public virtual interface created by another
#' Amazon Web Services account
#'
#' @description
#' Accepts ownership of a public virtual interface created by another Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_confirm_public_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_confirm_public_virtual_interface/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_public_virtual_interface
directconnect_confirm_public_virtual_interface <- function(virtualInterfaceId) {
  op <- new_operation(
    name = "ConfirmPublicVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_public_virtual_interface_input(virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$confirm_public_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_public_virtual_interface <- directconnect_confirm_public_virtual_interface

#' Accepts ownership of a transit virtual interface created by another
#' Amazon Web Services account
#'
#' @description
#' Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_confirm_transit_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_confirm_transit_virtual_interface/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_confirm_transit_virtual_interface
directconnect_confirm_transit_virtual_interface <- function(virtualInterfaceId, directConnectGatewayId) {
  op <- new_operation(
    name = "ConfirmTransitVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$confirm_transit_virtual_interface_input(virtualInterfaceId = virtualInterfaceId, directConnectGatewayId = directConnectGatewayId)
  output <- .directconnect$confirm_transit_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$confirm_transit_virtual_interface <- directconnect_confirm_transit_virtual_interface

#' Creates a BGP peer on the specified virtual interface
#'
#' @description
#' Creates a BGP peer on the specified virtual interface.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_bgp_peer/](https://www.paws-r-sdk.com/docs/directconnect_create_bgp_peer/) for full documentation.
#'
#' @param virtualInterfaceId The ID of the virtual interface.
#' @param newBGPPeer Information about the BGP peer.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_bgp_peer
directconnect_create_bgp_peer <- function(virtualInterfaceId = NULL, newBGPPeer = NULL) {
  op <- new_operation(
    name = "CreateBGPPeer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_bgp_peer_input(virtualInterfaceId = virtualInterfaceId, newBGPPeer = newBGPPeer)
  output <- .directconnect$create_bgp_peer_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_bgp_peer <- directconnect_create_bgp_peer

#' Creates a connection between a customer network and a specific Direct
#' Connect location
#'
#' @description
#' Creates a connection between a customer network and a specific Direct Connect location.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_connection/](https://www.paws-r-sdk.com/docs/directconnect_create_connection/) for full documentation.
#'
#' @param location &#91;required&#93; The location of the connection.
#' @param bandwidth &#91;required&#93; The bandwidth of the connection.
#' @param connectionName &#91;required&#93; The name of the connection.
#' @param lagId The ID of the LAG.
#' @param tags The tags to associate with the lag.
#' @param providerName The name of the service provider associated with the requested
#' connection.
#' @param requestMACSec Indicates whether you want the connection to support MAC Security
#' (MACsec).
#' 
#' MAC Security (MACsec) is only available on dedicated connections. For
#' information about MAC Security (MACsec) prerequisties, see [MACsec
#' prerequisties](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites)
#' in the *Direct Connect User Guide*.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_connection
directconnect_create_connection <- function(location, bandwidth, connectionName, lagId = NULL, tags = NULL, providerName = NULL, requestMACSec = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_connection_input(location = location, bandwidth = bandwidth, connectionName = connectionName, lagId = lagId, tags = tags, providerName = providerName, requestMACSec = requestMACSec)
  output <- .directconnect$create_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_connection <- directconnect_create_connection

#' Creates a Direct Connect gateway, which is an intermediate object that
#' enables you to connect a set of virtual interfaces and virtual private
#' gateways
#'
#' @description
#' Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_direct_connect_gateway/](https://www.paws-r-sdk.com/docs/directconnect_create_direct_connect_gateway/) for full documentation.
#'
#' @param directConnectGatewayName &#91;required&#93; The name of the Direct Connect gateway.
#' @param amazonSideAsn The autonomous system number (ASN) for Border Gateway Protocol (BGP) to
#' be configured on the Amazon side of the connection. The ASN must be in
#' the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
#' The default is 64512.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_direct_connect_gateway
directconnect_create_direct_connect_gateway <- function(directConnectGatewayName, amazonSideAsn = NULL) {
  op <- new_operation(
    name = "CreateDirectConnectGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_direct_connect_gateway_input(directConnectGatewayName = directConnectGatewayName, amazonSideAsn = amazonSideAsn)
  output <- .directconnect$create_direct_connect_gateway_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_direct_connect_gateway <- directconnect_create_direct_connect_gateway

#' Creates an association between a Direct Connect gateway and a virtual
#' private gateway
#'
#' @description
#' Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_direct_connect_gateway_association/](https://www.paws-r-sdk.com/docs/directconnect_create_direct_connect_gateway_association/) for full documentation.
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#' @param gatewayId The ID of the virtual private gateway or transit gateway.
#' @param addAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to advertise to the Direct Connect gateway
#' 
#' This parameter is required when you create an association to a transit
#' gateway.
#' 
#' For information about how to set the prefixes, see [Allowed
#' Prefixes](https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes)
#' in the *Direct Connect User Guide*.
#' @param virtualGatewayId The ID of the virtual private gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_direct_connect_gateway_association
directconnect_create_direct_connect_gateway_association <- function(directConnectGatewayId, gatewayId = NULL, addAllowedPrefixesToDirectConnectGateway = NULL, virtualGatewayId = NULL) {
  op <- new_operation(
    name = "CreateDirectConnectGatewayAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_direct_connect_gateway_association_input(directConnectGatewayId = directConnectGatewayId, gatewayId = gatewayId, addAllowedPrefixesToDirectConnectGateway = addAllowedPrefixesToDirectConnectGateway, virtualGatewayId = virtualGatewayId)
  output <- .directconnect$create_direct_connect_gateway_association_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_direct_connect_gateway_association <- directconnect_create_direct_connect_gateway_association

#' Creates a proposal to associate the specified virtual private gateway or
#' transit gateway with the specified Direct Connect gateway
#'
#' @description
#' Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_direct_connect_gateway_association_proposal/](https://www.paws-r-sdk.com/docs/directconnect_create_direct_connect_gateway_association_proposal/) for full documentation.
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#' @param directConnectGatewayOwnerAccount &#91;required&#93; The ID of the Amazon Web Services account that owns the Direct Connect
#' gateway.
#' @param gatewayId &#91;required&#93; The ID of the virtual private gateway or transit gateway.
#' @param addAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to advertise to the Direct Connect gateway.
#' @param removeAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to no longer advertise to the Direct Connect
#' gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_direct_connec_gatewa_associ_propos
directconnect_create_direct_connect_gateway_association_proposal <- function(directConnectGatewayId, directConnectGatewayOwnerAccount, gatewayId, addAllowedPrefixesToDirectConnectGateway = NULL, removeAllowedPrefixesToDirectConnectGateway = NULL) {
  op <- new_operation(
    name = "CreateDirectConnectGatewayAssociationProposal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_direct_connect_gateway_association_proposal_input(directConnectGatewayId = directConnectGatewayId, directConnectGatewayOwnerAccount = directConnectGatewayOwnerAccount, gatewayId = gatewayId, addAllowedPrefixesToDirectConnectGateway = addAllowedPrefixesToDirectConnectGateway, removeAllowedPrefixesToDirectConnectGateway = removeAllowedPrefixesToDirectConnectGateway)
  output <- .directconnect$create_direct_connect_gateway_association_proposal_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_direct_connect_gateway_association_proposal <- directconnect_create_direct_connect_gateway_association_proposal

#' Creates an interconnect between an Direct Connect Partner's network and
#' a specific Direct Connect location
#'
#' @description
#' Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_interconnect/](https://www.paws-r-sdk.com/docs/directconnect_create_interconnect/) for full documentation.
#'
#' @param interconnectName &#91;required&#93; The name of the interconnect.
#' @param bandwidth &#91;required&#93; The port bandwidth, in Gbps. The possible values are 1 and 10.
#' @param location &#91;required&#93; The location of the interconnect.
#' @param lagId The ID of the LAG.
#' @param tags The tags to associate with the interconnect.
#' @param providerName The name of the service provider associated with the interconnect.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_interconnect
directconnect_create_interconnect <- function(interconnectName, bandwidth, location, lagId = NULL, tags = NULL, providerName = NULL) {
  op <- new_operation(
    name = "CreateInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_interconnect_input(interconnectName = interconnectName, bandwidth = bandwidth, location = location, lagId = lagId, tags = tags, providerName = providerName)
  output <- .directconnect$create_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_interconnect <- directconnect_create_interconnect

#' Creates a link aggregation group (LAG) with the specified number of
#' bundled physical dedicated connections between the customer network and
#' a specific Direct Connect location
#'
#' @description
#' Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_lag/](https://www.paws-r-sdk.com/docs/directconnect_create_lag/) for full documentation.
#'
#' @param numberOfConnections &#91;required&#93; The number of physical dedicated connections initially provisioned and
#' bundled by the LAG. You can have a maximum of four connections when the
#' port speed is 1G or 10G, or two when the port speed is 100G.
#' @param location &#91;required&#93; The location for the LAG.
#' @param connectionsBandwidth &#91;required&#93; The bandwidth of the individual physical dedicated connections bundled
#' by the LAG. The possible values are 1Gbps and 10Gbps.
#' @param lagName &#91;required&#93; The name of the LAG.
#' @param connectionId The ID of an existing dedicated connection to migrate to the LAG.
#' @param tags The tags to associate with the LAG.
#' @param childConnectionTags The tags to associate with the automtically created LAGs.
#' @param providerName The name of the service provider associated with the LAG.
#' @param requestMACSec Indicates whether the connection will support MAC Security (MACsec).
#' 
#' All connections in the LAG must be capable of supporting MAC Security
#' (MACsec). For information about MAC Security (MACsec) prerequisties, see
#' [MACsec
#' prerequisties](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites)
#' in the *Direct Connect User Guide*.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_lag
directconnect_create_lag <- function(numberOfConnections, location, connectionsBandwidth, lagName, connectionId = NULL, tags = NULL, childConnectionTags = NULL, providerName = NULL, requestMACSec = NULL) {
  op <- new_operation(
    name = "CreateLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_lag_input(numberOfConnections = numberOfConnections, location = location, connectionsBandwidth = connectionsBandwidth, lagName = lagName, connectionId = connectionId, tags = tags, childConnectionTags = childConnectionTags, providerName = providerName, requestMACSec = requestMACSec)
  output <- .directconnect$create_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_lag <- directconnect_create_lag

#' Creates a private virtual interface
#'
#' @description
#' Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_private_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_create_private_virtual_interface/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param newPrivateVirtualInterface &#91;required&#93; Information about the private virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_private_virtual_interface
directconnect_create_private_virtual_interface <- function(connectionId, newPrivateVirtualInterface) {
  op <- new_operation(
    name = "CreatePrivateVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_private_virtual_interface_input(connectionId = connectionId, newPrivateVirtualInterface = newPrivateVirtualInterface)
  output <- .directconnect$create_private_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_private_virtual_interface <- directconnect_create_private_virtual_interface

#' Creates a public virtual interface
#'
#' @description
#' Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_public_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_create_public_virtual_interface/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param newPublicVirtualInterface &#91;required&#93; Information about the public virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_public_virtual_interface
directconnect_create_public_virtual_interface <- function(connectionId, newPublicVirtualInterface) {
  op <- new_operation(
    name = "CreatePublicVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_public_virtual_interface_input(connectionId = connectionId, newPublicVirtualInterface = newPublicVirtualInterface)
  output <- .directconnect$create_public_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_public_virtual_interface <- directconnect_create_public_virtual_interface

#' Creates a transit virtual interface
#'
#' @description
#' Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_create_transit_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_create_transit_virtual_interface/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param newTransitVirtualInterface &#91;required&#93; Information about the transit virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_create_transit_virtual_interface
directconnect_create_transit_virtual_interface <- function(connectionId, newTransitVirtualInterface) {
  op <- new_operation(
    name = "CreateTransitVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$create_transit_virtual_interface_input(connectionId = connectionId, newTransitVirtualInterface = newTransitVirtualInterface)
  output <- .directconnect$create_transit_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$create_transit_virtual_interface <- directconnect_create_transit_virtual_interface

#' Deletes the specified BGP peer on the specified virtual interface with
#' the specified customer address and ASN
#'
#' @description
#' Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_bgp_peer/](https://www.paws-r-sdk.com/docs/directconnect_delete_bgp_peer/) for full documentation.
#'
#' @param virtualInterfaceId The ID of the virtual interface.
#' @param asn The autonomous system (AS) number for Border Gateway Protocol (BGP)
#' configuration.
#' @param customerAddress The IP address assigned to the customer interface.
#' @param bgpPeerId The ID of the BGP peer.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_bgp_peer
directconnect_delete_bgp_peer <- function(virtualInterfaceId = NULL, asn = NULL, customerAddress = NULL, bgpPeerId = NULL) {
  op <- new_operation(
    name = "DeleteBGPPeer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_bgp_peer_input(virtualInterfaceId = virtualInterfaceId, asn = asn, customerAddress = customerAddress, bgpPeerId = bgpPeerId)
  output <- .directconnect$delete_bgp_peer_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_bgp_peer <- directconnect_delete_bgp_peer

#' Deletes the specified connection
#'
#' @description
#' Deletes the specified connection.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_connection/](https://www.paws-r-sdk.com/docs/directconnect_delete_connection/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_connection
directconnect_delete_connection <- function(connectionId) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_connection_input(connectionId = connectionId)
  output <- .directconnect$delete_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_connection <- directconnect_delete_connection

#' Deletes the specified Direct Connect gateway
#'
#' @description
#' Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_direct_connect_gateway/](https://www.paws-r-sdk.com/docs/directconnect_delete_direct_connect_gateway/) for full documentation.
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_direct_connect_gateway
directconnect_delete_direct_connect_gateway <- function(directConnectGatewayId) {
  op <- new_operation(
    name = "DeleteDirectConnectGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_direct_connect_gateway_input(directConnectGatewayId = directConnectGatewayId)
  output <- .directconnect$delete_direct_connect_gateway_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_direct_connect_gateway <- directconnect_delete_direct_connect_gateway

#' Deletes the association between the specified Direct Connect gateway and
#' virtual private gateway
#'
#' @description
#' Deletes the association between the specified Direct Connect gateway and virtual private gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_direct_connect_gateway_association/](https://www.paws-r-sdk.com/docs/directconnect_delete_direct_connect_gateway_association/) for full documentation.
#'
#' @param associationId The ID of the Direct Connect gateway association.
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param virtualGatewayId The ID of the virtual private gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_direct_connect_gateway_association
directconnect_delete_direct_connect_gateway_association <- function(associationId = NULL, directConnectGatewayId = NULL, virtualGatewayId = NULL) {
  op <- new_operation(
    name = "DeleteDirectConnectGatewayAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_direct_connect_gateway_association_input(associationId = associationId, directConnectGatewayId = directConnectGatewayId, virtualGatewayId = virtualGatewayId)
  output <- .directconnect$delete_direct_connect_gateway_association_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_direct_connect_gateway_association <- directconnect_delete_direct_connect_gateway_association

#' Deletes the association proposal request between the specified Direct
#' Connect gateway and virtual private gateway or transit gateway
#'
#' @description
#' Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_direct_connect_gateway_association_proposal/](https://www.paws-r-sdk.com/docs/directconnect_delete_direct_connect_gateway_association_proposal/) for full documentation.
#'
#' @param proposalId &#91;required&#93; The ID of the proposal.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_direct_connec_gatewa_associ_propos
directconnect_delete_direct_connect_gateway_association_proposal <- function(proposalId) {
  op <- new_operation(
    name = "DeleteDirectConnectGatewayAssociationProposal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_direct_connect_gateway_association_proposal_input(proposalId = proposalId)
  output <- .directconnect$delete_direct_connect_gateway_association_proposal_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_direct_connect_gateway_association_proposal <- directconnect_delete_direct_connect_gateway_association_proposal

#' Deletes the specified interconnect
#'
#' @description
#' Deletes the specified interconnect.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_interconnect/](https://www.paws-r-sdk.com/docs/directconnect_delete_interconnect/) for full documentation.
#'
#' @param interconnectId &#91;required&#93; The ID of the interconnect.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_interconnect
directconnect_delete_interconnect <- function(interconnectId) {
  op <- new_operation(
    name = "DeleteInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_interconnect_input(interconnectId = interconnectId)
  output <- .directconnect$delete_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_interconnect <- directconnect_delete_interconnect

#' Deletes the specified link aggregation group (LAG)
#'
#' @description
#' Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_lag/](https://www.paws-r-sdk.com/docs/directconnect_delete_lag/) for full documentation.
#'
#' @param lagId &#91;required&#93; The ID of the LAG.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_lag
directconnect_delete_lag <- function(lagId) {
  op <- new_operation(
    name = "DeleteLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_lag_input(lagId = lagId)
  output <- .directconnect$delete_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_lag <- directconnect_delete_lag

#' Deletes a virtual interface
#'
#' @description
#' Deletes a virtual interface.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_delete_virtual_interface/](https://www.paws-r-sdk.com/docs/directconnect_delete_virtual_interface/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_delete_virtual_interface
directconnect_delete_virtual_interface <- function(virtualInterfaceId) {
  op <- new_operation(
    name = "DeleteVirtualInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$delete_virtual_interface_input(virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$delete_virtual_interface_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$delete_virtual_interface <- directconnect_delete_virtual_interface

#' Deprecated
#'
#' @description
#' Deprecated. Use [`describe_loa`][directconnect_describe_loa] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_connection_loa/](https://www.paws-r-sdk.com/docs/directconnect_describe_connection_loa/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param providerName The name of the APN partner or service provider who establishes
#' connectivity on your behalf. If you specify this parameter, the LOA-CFA
#' lists the provider name alongside your company name as the requester of
#' the cross connect.
#' @param loaContentType The standard media type for the LOA-CFA document. The only supported
#' value is application/pdf.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_connection_loa
directconnect_describe_connection_loa <- function(connectionId, providerName = NULL, loaContentType = NULL) {
  op <- new_operation(
    name = "DescribeConnectionLoa",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_connection_loa_input(connectionId = connectionId, providerName = providerName, loaContentType = loaContentType)
  output <- .directconnect$describe_connection_loa_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_connection_loa <- directconnect_describe_connection_loa

#' Displays the specified connection or all connections in this Region
#'
#' @description
#' Displays the specified connection or all connections in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_connections/](https://www.paws-r-sdk.com/docs/directconnect_describe_connections/) for full documentation.
#'
#' @param connectionId The ID of the connection.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_connections
directconnect_describe_connections <- function(connectionId = NULL) {
  op <- new_operation(
    name = "DescribeConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "connections")
  )
  input <- .directconnect$describe_connections_input(connectionId = connectionId)
  output <- .directconnect$describe_connections_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_connections <- directconnect_describe_connections

#' Deprecated
#'
#' @description
#' Deprecated. Use [`describe_hosted_connections`][directconnect_describe_hosted_connections] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_connections_on_interconnect/](https://www.paws-r-sdk.com/docs/directconnect_describe_connections_on_interconnect/) for full documentation.
#'
#' @param interconnectId &#91;required&#93; The ID of the interconnect.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_connections_on_interconnect
directconnect_describe_connections_on_interconnect <- function(interconnectId) {
  op <- new_operation(
    name = "DescribeConnectionsOnInterconnect",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "connections")
  )
  input <- .directconnect$describe_connections_on_interconnect_input(interconnectId = interconnectId)
  output <- .directconnect$describe_connections_on_interconnect_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_connections_on_interconnect <- directconnect_describe_connections_on_interconnect

#' Get and view a list of customer agreements, along with their signed
#' status and whether the customer is an NNIPartner, NNIPartnerV2, or a
#' nonPartner
#'
#' @description
#' Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_customer_metadata/](https://www.paws-r-sdk.com/docs/directconnect_describe_customer_metadata/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname directconnect_describe_customer_metadata
directconnect_describe_customer_metadata <- function() {
  op <- new_operation(
    name = "DescribeCustomerMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_customer_metadata_input()
  output <- .directconnect$describe_customer_metadata_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_customer_metadata <- directconnect_describe_customer_metadata

#' Describes one or more association proposals for connection between a
#' virtual private gateway or transit gateway and a Direct Connect gateway
#'
#' @description
#' Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateway_association_proposals/](https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateway_association_proposals/) for full documentation.
#'
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param proposalId The ID of the proposal.
#' @param associatedGatewayId The ID of the associated gateway.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname directconnect_descri_direct_connec_gatewa_associ_propos
directconnect_describe_direct_connect_gateway_association_proposals <- function(directConnectGatewayId = NULL, proposalId = NULL, associatedGatewayId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGatewayAssociationProposals",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateway_association_proposals_input(directConnectGatewayId = directConnectGatewayId, proposalId = proposalId, associatedGatewayId = associatedGatewayId, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$describe_direct_connect_gateway_association_proposals_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateway_association_proposals <- directconnect_describe_direct_connect_gateway_association_proposals

#' Lists the associations between your Direct Connect gateways and virtual
#' private gateways and transit gateways
#'
#' @description
#' Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateway_associations/](https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateway_associations/) for full documentation.
#'
#' @param associationId The ID of the Direct Connect gateway association.
#' @param associatedGatewayId The ID of the associated gateway.
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token provided in the previous call to retrieve the next page.
#' @param virtualGatewayId The ID of the virtual private gateway or transit gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateway_associations
directconnect_describe_direct_connect_gateway_associations <- function(associationId = NULL, associatedGatewayId = NULL, directConnectGatewayId = NULL, maxResults = NULL, nextToken = NULL, virtualGatewayId = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGatewayAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateway_associations_input(associationId = associationId, associatedGatewayId = associatedGatewayId, directConnectGatewayId = directConnectGatewayId, maxResults = maxResults, nextToken = nextToken, virtualGatewayId = virtualGatewayId)
  output <- .directconnect$describe_direct_connect_gateway_associations_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateway_associations <- directconnect_describe_direct_connect_gateway_associations

#' Lists the attachments between your Direct Connect gateways and virtual
#' interfaces
#'
#' @description
#' Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateway_attachments/](https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateway_attachments/) for full documentation.
#'
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param virtualInterfaceId The ID of the virtual interface.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token provided in the previous call to retrieve the next page.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateway_attachments
directconnect_describe_direct_connect_gateway_attachments <- function(directConnectGatewayId = NULL, virtualInterfaceId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGatewayAttachments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateway_attachments_input(directConnectGatewayId = directConnectGatewayId, virtualInterfaceId = virtualInterfaceId, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$describe_direct_connect_gateway_attachments_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateway_attachments <- directconnect_describe_direct_connect_gateway_attachments

#' Lists all your Direct Connect gateways or only the specified Direct
#' Connect gateway
#'
#' @description
#' Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateways/](https://www.paws-r-sdk.com/docs/directconnect_describe_direct_connect_gateways/) for full documentation.
#'
#' @param directConnectGatewayId The ID of the Direct Connect gateway.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token provided in the previous call to retrieve the next page.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_direct_connect_gateways
directconnect_describe_direct_connect_gateways <- function(directConnectGatewayId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectConnectGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_direct_connect_gateways_input(directConnectGatewayId = directConnectGatewayId, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$describe_direct_connect_gateways_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_direct_connect_gateways <- directconnect_describe_direct_connect_gateways

#' Lists the hosted connections that have been provisioned on the specified
#' interconnect or link aggregation group (LAG)
#'
#' @description
#' Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_hosted_connections/](https://www.paws-r-sdk.com/docs/directconnect_describe_hosted_connections/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the interconnect or LAG.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_hosted_connections
directconnect_describe_hosted_connections <- function(connectionId) {
  op <- new_operation(
    name = "DescribeHostedConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_hosted_connections_input(connectionId = connectionId)
  output <- .directconnect$describe_hosted_connections_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_hosted_connections <- directconnect_describe_hosted_connections

#' Deprecated
#'
#' @description
#' Deprecated. Use [`describe_loa`][directconnect_describe_loa] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_interconnect_loa/](https://www.paws-r-sdk.com/docs/directconnect_describe_interconnect_loa/) for full documentation.
#'
#' @param interconnectId &#91;required&#93; The ID of the interconnect.
#' @param providerName The name of the service provider who establishes connectivity on your
#' behalf. If you supply this parameter, the LOA-CFA lists the provider
#' name alongside your company name as the requester of the cross connect.
#' @param loaContentType The standard media type for the LOA-CFA document. The only supported
#' value is application/pdf.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_interconnect_loa
directconnect_describe_interconnect_loa <- function(interconnectId, providerName = NULL, loaContentType = NULL) {
  op <- new_operation(
    name = "DescribeInterconnectLoa",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_interconnect_loa_input(interconnectId = interconnectId, providerName = providerName, loaContentType = loaContentType)
  output <- .directconnect$describe_interconnect_loa_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_interconnect_loa <- directconnect_describe_interconnect_loa

#' Lists the interconnects owned by the Amazon Web Services account or only
#' the specified interconnect
#'
#' @description
#' Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_interconnects/](https://www.paws-r-sdk.com/docs/directconnect_describe_interconnects/) for full documentation.
#'
#' @param interconnectId The ID of the interconnect.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_interconnects
directconnect_describe_interconnects <- function(interconnectId = NULL) {
  op <- new_operation(
    name = "DescribeInterconnects",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "interconnects")
  )
  input <- .directconnect$describe_interconnects_input(interconnectId = interconnectId)
  output <- .directconnect$describe_interconnects_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_interconnects <- directconnect_describe_interconnects

#' Describes all your link aggregation groups (LAG) or the specified LAG
#'
#' @description
#' Describes all your link aggregation groups (LAG) or the specified LAG.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_lags/](https://www.paws-r-sdk.com/docs/directconnect_describe_lags/) for full documentation.
#'
#' @param lagId The ID of the LAG.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_lags
directconnect_describe_lags <- function(lagId = NULL) {
  op <- new_operation(
    name = "DescribeLags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_lags_input(lagId = lagId)
  output <- .directconnect$describe_lags_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_lags <- directconnect_describe_lags

#' Gets the LOA-CFA for a connection, interconnect, or link aggregation
#' group (LAG)
#'
#' @description
#' Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_loa/](https://www.paws-r-sdk.com/docs/directconnect_describe_loa/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of a connection, LAG, or interconnect.
#' @param providerName The name of the service provider who establishes connectivity on your
#' behalf. If you specify this parameter, the LOA-CFA lists the provider
#' name alongside your company name as the requester of the cross connect.
#' @param loaContentType The standard media type for the LOA-CFA document. The only supported
#' value is application/pdf.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_loa
directconnect_describe_loa <- function(connectionId, providerName = NULL, loaContentType = NULL) {
  op <- new_operation(
    name = "DescribeLoa",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_loa_input(connectionId = connectionId, providerName = providerName, loaContentType = loaContentType)
  output <- .directconnect$describe_loa_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_loa <- directconnect_describe_loa

#' Lists the Direct Connect locations in the current Amazon Web Services
#' Region
#'
#' @description
#' Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling [`create_connection`][directconnect_create_connection] or [`create_interconnect`][directconnect_create_interconnect].
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_locations/](https://www.paws-r-sdk.com/docs/directconnect_describe_locations/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname directconnect_describe_locations
directconnect_describe_locations <- function() {
  op <- new_operation(
    name = "DescribeLocations",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "locations")
  )
  input <- .directconnect$describe_locations_input()
  output <- .directconnect$describe_locations_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_locations <- directconnect_describe_locations

#' Details about the router
#'
#' @description
#' Details about the router.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_router_configuration/](https://www.paws-r-sdk.com/docs/directconnect_describe_router_configuration/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface.
#' @param routerTypeIdentifier Identifies the router by a combination of vendor, platform, and software
#' version. For example, `CiscoSystemsInc-2900SeriesRouters-IOS124`.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_router_configuration
directconnect_describe_router_configuration <- function(virtualInterfaceId, routerTypeIdentifier = NULL) {
  op <- new_operation(
    name = "DescribeRouterConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_router_configuration_input(virtualInterfaceId = virtualInterfaceId, routerTypeIdentifier = routerTypeIdentifier)
  output <- .directconnect$describe_router_configuration_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_router_configuration <- directconnect_describe_router_configuration

#' Describes the tags associated with the specified Direct Connect
#' resources
#'
#' @description
#' Describes the tags associated with the specified Direct Connect resources.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_tags/](https://www.paws-r-sdk.com/docs/directconnect_describe_tags/) for full documentation.
#'
#' @param resourceArns &#91;required&#93; The Amazon Resource Names (ARNs) of the resources.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_tags
directconnect_describe_tags <- function(resourceArns) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$describe_tags_input(resourceArns = resourceArns)
  output <- .directconnect$describe_tags_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_tags <- directconnect_describe_tags

#' Lists the virtual private gateways owned by the Amazon Web Services
#' account
#'
#' @description
#' Lists the virtual private gateways owned by the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_virtual_gateways/](https://www.paws-r-sdk.com/docs/directconnect_describe_virtual_gateways/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname directconnect_describe_virtual_gateways
directconnect_describe_virtual_gateways <- function() {
  op <- new_operation(
    name = "DescribeVirtualGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "virtualGateways")
  )
  input <- .directconnect$describe_virtual_gateways_input()
  output <- .directconnect$describe_virtual_gateways_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_virtual_gateways <- directconnect_describe_virtual_gateways

#' Displays all virtual interfaces for an Amazon Web Services account
#'
#' @description
#' Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_describe_virtual_interfaces/](https://www.paws-r-sdk.com/docs/directconnect_describe_virtual_interfaces/) for full documentation.
#'
#' @param connectionId The ID of the connection.
#' @param virtualInterfaceId The ID of the virtual interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_describe_virtual_interfaces
directconnect_describe_virtual_interfaces <- function(connectionId = NULL, virtualInterfaceId = NULL) {
  op <- new_operation(
    name = "DescribeVirtualInterfaces",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "virtualInterfaces")
  )
  input <- .directconnect$describe_virtual_interfaces_input(connectionId = connectionId, virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$describe_virtual_interfaces_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$describe_virtual_interfaces <- directconnect_describe_virtual_interfaces

#' Disassociates a connection from a link aggregation group (LAG)
#'
#' @description
#' Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the [`delete_connection`][directconnect_delete_connection] request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_disassociate_connection_from_lag/](https://www.paws-r-sdk.com/docs/directconnect_disassociate_connection_from_lag/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the connection.
#' @param lagId &#91;required&#93; The ID of the LAG.
#'
#' @keywords internal
#'
#' @rdname directconnect_disassociate_connection_from_lag
directconnect_disassociate_connection_from_lag <- function(connectionId, lagId) {
  op <- new_operation(
    name = "DisassociateConnectionFromLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$disassociate_connection_from_lag_input(connectionId = connectionId, lagId = lagId)
  output <- .directconnect$disassociate_connection_from_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$disassociate_connection_from_lag <- directconnect_disassociate_connection_from_lag

#' Removes the association between a MAC Security (MACsec) security key and
#' an Direct Connect dedicated connection
#'
#' @description
#' Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_disassociate_mac_sec_key/](https://www.paws-r-sdk.com/docs/directconnect_disassociate_mac_sec_key/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG
#' (dxlag-xxxx).
#' 
#' You can use [`describe_connections`][directconnect_describe_connections]
#' or [`describe_lags`][directconnect_describe_lags] to retrieve connection
#' ID.
#' @param secretARN &#91;required&#93; The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
#' 
#' You can use [`describe_connections`][directconnect_describe_connections]
#' to retrieve the ARN of the MAC Security (MACsec) secret key.
#'
#' @keywords internal
#'
#' @rdname directconnect_disassociate_mac_sec_key
directconnect_disassociate_mac_sec_key <- function(connectionId, secretARN) {
  op <- new_operation(
    name = "DisassociateMacSecKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$disassociate_mac_sec_key_input(connectionId = connectionId, secretARN = secretARN)
  output <- .directconnect$disassociate_mac_sec_key_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$disassociate_mac_sec_key <- directconnect_disassociate_mac_sec_key

#' Lists the virtual interface failover test history
#'
#' @description
#' Lists the virtual interface failover test history.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_list_virtual_interface_test_history/](https://www.paws-r-sdk.com/docs/directconnect_list_virtual_interface_test_history/) for full documentation.
#'
#' @param testId The ID of the virtual interface failover test.
#' @param virtualInterfaceId The ID of the virtual interface that was tested.
#' @param bgpPeers The BGP peers that were placed in the DOWN state during the virtual
#' interface failover test.
#' @param status The status of the virtual interface failover test.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' If `MaxResults` is given a value larger than 100, only 100 results are
#' returned.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname directconnect_list_virtual_interface_test_history
directconnect_list_virtual_interface_test_history <- function(testId = NULL, virtualInterfaceId = NULL, bgpPeers = NULL, status = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualInterfaceTestHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$list_virtual_interface_test_history_input(testId = testId, virtualInterfaceId = virtualInterfaceId, bgpPeers = bgpPeers, status = status, maxResults = maxResults, nextToken = nextToken)
  output <- .directconnect$list_virtual_interface_test_history_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$list_virtual_interface_test_history <- directconnect_list_virtual_interface_test_history

#' Starts the virtual interface failover test that verifies your
#' configuration meets your resiliency requirements by placing the BGP
#' peering session in the DOWN state
#'
#' @description
#' Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_start_bgp_failover_test/](https://www.paws-r-sdk.com/docs/directconnect_start_bgp_failover_test/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface you want to test.
#' @param bgpPeers The BGP peers to place in the DOWN state.
#' @param testDurationInMinutes The time in minutes that the virtual interface failover test will last.
#' 
#' Maximum value: 4,320 minutes (72 hours).
#' 
#' Default: 180 minutes (3 hours).
#'
#' @keywords internal
#'
#' @rdname directconnect_start_bgp_failover_test
directconnect_start_bgp_failover_test <- function(virtualInterfaceId, bgpPeers = NULL, testDurationInMinutes = NULL) {
  op <- new_operation(
    name = "StartBgpFailoverTest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$start_bgp_failover_test_input(virtualInterfaceId = virtualInterfaceId, bgpPeers = bgpPeers, testDurationInMinutes = testDurationInMinutes)
  output <- .directconnect$start_bgp_failover_test_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$start_bgp_failover_test <- directconnect_start_bgp_failover_test

#' Stops the virtual interface failover test
#'
#' @description
#' Stops the virtual interface failover test.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_stop_bgp_failover_test/](https://www.paws-r-sdk.com/docs/directconnect_stop_bgp_failover_test/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual interface you no longer want to test.
#'
#' @keywords internal
#'
#' @rdname directconnect_stop_bgp_failover_test
directconnect_stop_bgp_failover_test <- function(virtualInterfaceId) {
  op <- new_operation(
    name = "StopBgpFailoverTest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$stop_bgp_failover_test_input(virtualInterfaceId = virtualInterfaceId)
  output <- .directconnect$stop_bgp_failover_test_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$stop_bgp_failover_test <- directconnect_stop_bgp_failover_test

#' Adds the specified tags to the specified Direct Connect resource
#'
#' @description
#' Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_tag_resource/](https://www.paws-r-sdk.com/docs/directconnect_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags to add.
#'
#' @keywords internal
#'
#' @rdname directconnect_tag_resource
directconnect_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .directconnect$tag_resource_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$tag_resource <- directconnect_tag_resource

#' Removes one or more tags from the specified Direct Connect resource
#'
#' @description
#' Removes one or more tags from the specified Direct Connect resource.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_untag_resource/](https://www.paws-r-sdk.com/docs/directconnect_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys of the tags to remove.
#'
#' @keywords internal
#'
#' @rdname directconnect_untag_resource
directconnect_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .directconnect$untag_resource_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$untag_resource <- directconnect_untag_resource

#' Updates the Direct Connect dedicated connection configuration
#'
#' @description
#' Updates the Direct Connect dedicated connection configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_update_connection/](https://www.paws-r-sdk.com/docs/directconnect_update_connection/) for full documentation.
#'
#' @param connectionId &#91;required&#93; The ID of the dedicated connection.
#' 
#' You can use [`describe_connections`][directconnect_describe_connections]
#' to retrieve the connection ID.
#' @param connectionName The name of the connection.
#' @param encryptionMode The connection MAC Security (MACsec) encryption mode.
#' 
#' The valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
#'
#' @keywords internal
#'
#' @rdname directconnect_update_connection
directconnect_update_connection <- function(connectionId, connectionName = NULL, encryptionMode = NULL) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_connection_input(connectionId = connectionId, connectionName = connectionName, encryptionMode = encryptionMode)
  output <- .directconnect$update_connection_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_connection <- directconnect_update_connection

#' Updates the name of a current Direct Connect gateway
#'
#' @description
#' Updates the name of a current Direct Connect gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_update_direct_connect_gateway/](https://www.paws-r-sdk.com/docs/directconnect_update_direct_connect_gateway/) for full documentation.
#'
#' @param directConnectGatewayId &#91;required&#93; The ID of the Direct Connect gateway to update.
#' @param newDirectConnectGatewayName &#91;required&#93; The new name for the Direct Connect gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_update_direct_connect_gateway
directconnect_update_direct_connect_gateway <- function(directConnectGatewayId, newDirectConnectGatewayName) {
  op <- new_operation(
    name = "UpdateDirectConnectGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_direct_connect_gateway_input(directConnectGatewayId = directConnectGatewayId, newDirectConnectGatewayName = newDirectConnectGatewayName)
  output <- .directconnect$update_direct_connect_gateway_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_direct_connect_gateway <- directconnect_update_direct_connect_gateway

#' Updates the specified attributes of the Direct Connect gateway
#' association
#'
#' @description
#' Updates the specified attributes of the Direct Connect gateway association.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_update_direct_connect_gateway_association/](https://www.paws-r-sdk.com/docs/directconnect_update_direct_connect_gateway_association/) for full documentation.
#'
#' @param associationId The ID of the Direct Connect gateway association.
#' @param addAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to advertise to the Direct Connect gateway.
#' @param removeAllowedPrefixesToDirectConnectGateway The Amazon VPC prefixes to no longer advertise to the Direct Connect
#' gateway.
#'
#' @keywords internal
#'
#' @rdname directconnect_update_direct_connect_gateway_association
directconnect_update_direct_connect_gateway_association <- function(associationId = NULL, addAllowedPrefixesToDirectConnectGateway = NULL, removeAllowedPrefixesToDirectConnectGateway = NULL) {
  op <- new_operation(
    name = "UpdateDirectConnectGatewayAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_direct_connect_gateway_association_input(associationId = associationId, addAllowedPrefixesToDirectConnectGateway = addAllowedPrefixesToDirectConnectGateway, removeAllowedPrefixesToDirectConnectGateway = removeAllowedPrefixesToDirectConnectGateway)
  output <- .directconnect$update_direct_connect_gateway_association_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_direct_connect_gateway_association <- directconnect_update_direct_connect_gateway_association

#' Updates the attributes of the specified link aggregation group (LAG)
#'
#' @description
#' Updates the attributes of the specified link aggregation group (LAG).
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_update_lag/](https://www.paws-r-sdk.com/docs/directconnect_update_lag/) for full documentation.
#'
#' @param lagId &#91;required&#93; The ID of the LAG.
#' @param lagName The name of the LAG.
#' @param minimumLinks The minimum number of physical connections that must be operational for
#' the LAG itself to be operational.
#' @param encryptionMode The LAG MAC Security (MACsec) encryption mode.
#' 
#' Amazon Web Services applies the value to all connections which are part
#' of the LAG.
#'
#' @keywords internal
#'
#' @rdname directconnect_update_lag
directconnect_update_lag <- function(lagId, lagName = NULL, minimumLinks = NULL, encryptionMode = NULL) {
  op <- new_operation(
    name = "UpdateLag",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_lag_input(lagId = lagId, lagName = lagName, minimumLinks = minimumLinks, encryptionMode = encryptionMode)
  output <- .directconnect$update_lag_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_lag <- directconnect_update_lag

#' Updates the specified attributes of the specified virtual private
#' interface
#'
#' @description
#' Updates the specified attributes of the specified virtual private interface.
#'
#' See [https://www.paws-r-sdk.com/docs/directconnect_update_virtual_interface_attributes/](https://www.paws-r-sdk.com/docs/directconnect_update_virtual_interface_attributes/) for full documentation.
#'
#' @param virtualInterfaceId &#91;required&#93; The ID of the virtual private interface.
#' @param mtu The maximum transmission unit (MTU), in bytes. The supported values are
#' 1500 and 9001. The default value is 1500.
#' @param enableSiteLink Indicates whether to enable or disable SiteLink.
#' @param virtualInterfaceName The name of the virtual private interface.
#'
#' @keywords internal
#'
#' @rdname directconnect_update_virtual_interface_attributes
directconnect_update_virtual_interface_attributes <- function(virtualInterfaceId, mtu = NULL, enableSiteLink = NULL, virtualInterfaceName = NULL) {
  op <- new_operation(
    name = "UpdateVirtualInterfaceAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directconnect$update_virtual_interface_attributes_input(virtualInterfaceId = virtualInterfaceId, mtu = mtu, enableSiteLink = enableSiteLink, virtualInterfaceName = virtualInterfaceName)
  output <- .directconnect$update_virtual_interface_attributes_output()
  config <- get_config()
  svc <- .directconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directconnect$operations$update_virtual_interface_attributes <- directconnect_update_virtual_interface_attributes
