% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_delete_load_balancer_policy}
\alias{elb_delete_load_balancer_policy}
\title{Deletes the specified policy from the specified load balancer}
\usage{
elb_delete_load_balancer_policy(LoadBalancerName, PolicyName)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{PolicyName}{[required] The name of the policy.}
}
\value{
An empty list.
}
\description{
Deletes the specified policy from the specified load balancer. This
policy must not be enabled for any listeners.
}
\section{Request syntax}{
\preformatted{svc$delete_load_balancer_policy(
  LoadBalancerName = "string",
  PolicyName = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the specified policy from the specified load
# balancer. The policy must not be enabled on any listener.
svc$delete_load_balancer_policy(
  LoadBalancerName = "my-load-balancer",
  PolicyName = "my-duration-cookie-policy"
)
}

}
\keyword{internal}
