% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_realtime_log_configs}
\alias{cloudfront_list_realtime_log_configs}
\title{Gets a list of real-time log configurations}
\usage{
cloudfront_list_realtime_log_configs(MaxItems, Marker)
}
\arguments{
\item{MaxItems}{The maximum number of real-time log configurations that you want in the
response.}

\item{Marker}{Use this field when paginating results to indicate where to begin in
your list of real-time log configurations. The response includes
real-time log configurations in the list that occur after the marker. To
get the next page of the list, set this field’s value to the value of
\code{NextMarker} from the current page’s response.}
}
\value{
A list with the following syntax:\preformatted{list(
  RealtimeLogConfigs = list(
    MaxItems = 123,
    Items = list(
      list(
        ARN = "string",
        Name = "string",
        SamplingRate = 123,
        EndPoints = list(
          list(
            StreamType = "string",
            KinesisStreamConfig = list(
              RoleARN = "string",
              StreamARN = "string"
            )
          )
        ),
        Fields = list(
          "string"
        )
      )
    ),
    IsTruncated = TRUE|FALSE,
    Marker = "string",
    NextMarker = "string"
  )
)
}
}
\description{
Gets a list of real-time log configurations.

You can optionally specify the maximum number of items to receive in the
response. If the total number of items in the list exceeds the maximum
that you specify, or the default maximum, the response is paginated. To
get the next page of items, send a subsequent request that specifies the
\code{NextMarker} value from the current response as the \code{Marker} value in
the subsequent request.
}
\section{Request syntax}{
\preformatted{svc$list_realtime_log_configs(
  MaxItems = "string",
  Marker = "string"
)
}
}

\keyword{internal}
