% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_stage}
\alias{apigateway_create_stage}
\title{Creates a new Stage resource that references a pre-existing Deployment
for the API}
\usage{
apigateway_create_stage(restApiId, stageName, deploymentId, description,
  cacheClusterEnabled, cacheClusterSize, variables, documentationVersion,
  canarySettings, tracingEnabled, tags)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{stageName}{[required] [Required] The name for the Stage resource. Stage names can only
contain alphanumeric characters, hyphens, and underscores. Maximum
length is 128 characters.}

\item{deploymentId}{[required] [Required] The identifier of the Deployment resource for the Stage
resource.}

\item{description}{The description of the Stage resource.}

\item{cacheClusterEnabled}{Whether cache clustering is enabled for the stage.}

\item{cacheClusterSize}{The stage's cache cluster size.}

\item{variables}{A map that defines the stage variables for the new Stage resource.
Variable names can have alphanumeric and underscore characters, and the
values must match \verb{\\\[A-Za-z0-9-._~:/?#&amp;=,\\\]+}.}

\item{documentationVersion}{The version of the associated API documentation.}

\item{canarySettings}{The canary deployment settings of this stage.}

\item{tracingEnabled}{Specifies whether active tracing with X-ray is enabled for the Stage.}

\item{tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=.\\_:/]. The tag key can be up to 128 characters and must not
start with \verb{aws:}. The tag value can be up to 256 characters.}
}
\description{
Creates a new Stage resource that references a pre-existing Deployment
for the API.
}
\section{Request syntax}{
\preformatted{svc$create_stage(
  restApiId = "string",
  stageName = "string",
  deploymentId = "string",
  description = "string",
  cacheClusterEnabled = TRUE|FALSE,
  cacheClusterSize = "0.5"|"1.6"|"6.1"|"13.5"|"28.4"|"58.2"|"118"|"237",
  variables = list(
    "string"
  ),
  documentationVersion = "string",
  canarySettings = list(
    percentTraffic = 123.0,
    deploymentId = "string",
    stageVariableOverrides = list(
      "string"
    ),
    useStageCache = TRUE|FALSE
  ),
  tracingEnabled = TRUE|FALSE,
  tags = list(
    "string"
  )
)
}
}

\keyword{internal}
