% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_allocate_public_virtual_interface}
\alias{directconnect_allocate_public_virtual_interface}
\title{Provisions a public virtual interface to be owned by the specified AWS
account}
\usage{
directconnect_allocate_public_virtual_interface(connectionId,
  ownerAccount, newPublicVirtualInterfaceAllocation)
}
\arguments{
\item{connectionId}{[required] The ID of the connection on which the public virtual interface is
provisioned.}

\item{ownerAccount}{[required] The ID of the AWS account that owns the public virtual interface.}

\item{newPublicVirtualInterfaceAllocation}{[required] Information about the public virtual interface.}
}
\description{
Provisions a public virtual interface to be owned by the specified AWS
account.
}
\details{
The owner of a connection calls this function to provision a public
virtual interface to be owned by the specified AWS account.

Virtual interfaces created using this function must be confirmed by the
owner using ConfirmPublicVirtualInterface. Until this step has been
completed, the virtual interface is in the \code{confirming} state and is not
available to handle traffic.

When creating an IPv6 public virtual interface, omit the Amazon address
and customer address. IPv6 addresses are automatically assigned from the
Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
}
\section{Request syntax}{
\preformatted{svc$allocate_public_virtual_interface(
  connectionId = "string",
  ownerAccount = "string",
  newPublicVirtualInterfaceAllocation = list(
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    authKey = "string",
    amazonAddress = "string",
    customerAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    routeFilterPrefixes = list(
      list(
        cidr = "string"
      )
    )
  )
)
}
}

\keyword{internal}
