% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_start_engagement}
\alias{ssmcontacts_start_engagement}
\title{Starts an engagement to a contact or escalation plan}
\usage{
ssmcontacts_start_engagement(
  ContactId,
  Sender,
  Subject,
  Content,
  PublicSubject = NULL,
  PublicContent = NULL,
  IncidentId = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{ContactId}{[required] The Amazon Resource Name (ARN) of the contact being engaged.}

\item{Sender}{[required] The user that started the engagement.}

\item{Subject}{[required] The secure subject of the message that was sent to the contact. Use this
field for engagements to \code{VOICE} or \code{EMAIL}.}

\item{Content}{[required] The secure content of the message that was sent to the contact. Use this
field for engagements to \code{VOICE} or \code{EMAIL}.}

\item{PublicSubject}{The insecure subject of the message that was sent to the contact. Use
this field for engagements to \code{SMS}.}

\item{PublicContent}{The insecure content of the message that was sent to the contact. Use
this field for engagements to \code{SMS}.}

\item{IncidentId}{The ARN of the incident that the engagement is part of.}

\item{IdempotencyToken}{A token ensuring that the operation is called only once with the
specified details.}
}
\description{
Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.

See \url{https://www.paws-r-sdk.com/docs/ssmcontacts_start_engagement/} for full documentation.
}
\keyword{internal}
