# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include prometheusservice_service.R
NULL

#' The CreateAlertManagerDefinition operation creates the alert manager
#' definition in a workspace
#'
#' @description
#' The [`create_alert_manager_definition`][prometheusservice_create_alert_manager_definition] operation creates the alert manager definition in a workspace. If a workspace already has an alert manager definition, don't use this operation to update it. Instead, use [`put_alert_manager_definition`][prometheusservice_put_alert_manager_definition].
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_create_alert_manager_definition/](https://www.paws-r-sdk.com/docs/prometheusservice_create_alert_manager_definition/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param data &#91;required&#93; The alert manager definition to add. A base64-encoded version of the
#' YAML alert manager definition file.
#' 
#' For details about the alert manager definition, see
#' [AlertManagedDefinitionData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html).
#' @param workspaceId &#91;required&#93; The ID of the workspace to add the alert manager definition to.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_alert_manager_definition
prometheusservice_create_alert_manager_definition <- function(clientToken = NULL, data, workspaceId) {
  op <- new_operation(
    name = "CreateAlertManagerDefinition",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$create_alert_manager_definition_input(clientToken = clientToken, data = data, workspaceId = workspaceId)
  output <- .prometheusservice$create_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_alert_manager_definition <- prometheusservice_create_alert_manager_definition

#' The CreateLoggingConfiguration operation creates a logging configuration
#' for the workspace
#'
#' @description
#' The [`create_logging_configuration`][prometheusservice_create_logging_configuration] operation creates a logging configuration for the workspace. Use this operation to set the CloudWatch log group to which the logs will be published to.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_create_logging_configuration/](https://www.paws-r-sdk.com/docs/prometheusservice_create_logging_configuration/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param logGroupArn &#91;required&#93; The ARN of the CloudWatch log group to which the vended log data will be
#' published. This log group must exist prior to calling this API.
#' @param workspaceId &#91;required&#93; The ID of the workspace to create the logging configuration for.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_logging_configuration
prometheusservice_create_logging_configuration <- function(clientToken = NULL, logGroupArn, workspaceId) {
  op <- new_operation(
    name = "CreateLoggingConfiguration",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/logging",
    paginator = list()
  )
  input <- .prometheusservice$create_logging_configuration_input(clientToken = clientToken, logGroupArn = logGroupArn, workspaceId = workspaceId)
  output <- .prometheusservice$create_logging_configuration_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_logging_configuration <- prometheusservice_create_logging_configuration

#' The CreateRuleGroupsNamespace operation creates a rule groups namespace
#' within a workspace
#'
#' @description
#' The [`create_rule_groups_namespace`][prometheusservice_create_rule_groups_namespace] operation creates a rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_create_rule_groups_namespace/](https://www.paws-r-sdk.com/docs/prometheusservice_create_rule_groups_namespace/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param data &#91;required&#93; The rules file to use in the new namespace.
#' 
#' Contains the base64-encoded version of the YAML rules file.
#' 
#' For details about the rule groups namespace structure, see
#' [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
#' @param name &#91;required&#93; The name for the new rule groups namespace.
#' @param tags The list of tag keys and values to associate with the rule groups
#' namespace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to add the rule groups namespace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_rule_groups_namespace
prometheusservice_create_rule_groups_namespace <- function(clientToken = NULL, data, name, tags = NULL, workspaceId) {
  op <- new_operation(
    name = "CreateRuleGroupsNamespace",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces",
    paginator = list()
  )
  input <- .prometheusservice$create_rule_groups_namespace_input(clientToken = clientToken, data = data, name = name, tags = tags, workspaceId = workspaceId)
  output <- .prometheusservice$create_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_rule_groups_namespace <- prometheusservice_create_rule_groups_namespace

#' The CreateScraper operation creates a scraper to collect metrics
#'
#' @description
#' The [`create_scraper`][prometheusservice_create_scraper] operation creates a scraper to collect metrics. A scraper pulls metrics from Prometheus-compatible sources within an Amazon EKS cluster, and sends them to your Amazon Managed Service for Prometheus workspace. You can configure the scraper to control what metrics are collected, and what transformations are applied prior to sending them to your workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_create_scraper/](https://www.paws-r-sdk.com/docs/prometheusservice_create_scraper/) for full documentation.
#'
#' @param alias (optional) a name to associate with the scraper. This is for your use,
#' and does not need to be unique.
#' @param clientToken (Optional) A unique, case-sensitive identifier that you can provide to
#' ensure the idempotency of the request.
#' @param destination &#91;required&#93; The Amazon Managed Service for Prometheus workspace to send metrics to.
#' @param scrapeConfiguration &#91;required&#93; The configuration file to use in the new scraper. For more information,
#' see [Scraper
#' configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration)
#' in the *Amazon Managed Service for Prometheus User Guide*.
#' @param source &#91;required&#93; The Amazon EKS cluster from which the scraper will collect metrics.
#' @param tags (Optional) The list of tag keys and values to associate with the
#' scraper.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_scraper
prometheusservice_create_scraper <- function(alias = NULL, clientToken = NULL, destination, scrapeConfiguration, source, tags = NULL) {
  op <- new_operation(
    name = "CreateScraper",
    http_method = "POST",
    http_path = "/scrapers",
    paginator = list()
  )
  input <- .prometheusservice$create_scraper_input(alias = alias, clientToken = clientToken, destination = destination, scrapeConfiguration = scrapeConfiguration, source = source, tags = tags)
  output <- .prometheusservice$create_scraper_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_scraper <- prometheusservice_create_scraper

#' Creates a Prometheus workspace
#'
#' @description
#' Creates a Prometheus workspace. A workspace is a logical space dedicated to the storage and querying of Prometheus metrics. You can have one or more workspaces in each Region in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_create_workspace/](https://www.paws-r-sdk.com/docs/prometheusservice_create_workspace/) for full documentation.
#'
#' @param alias An alias that you assign to this workspace to help you identify it. It
#' does not need to be unique.
#' 
#' Blank spaces at the beginning or end of the alias that you specify will
#' be trimmed from the value used.
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param kmsKeyArn (optional) The ARN for a customer managed KMS key to use for encrypting
#' data within your workspace. For more information about using your own
#' key in your workspace, see [Encryption at
#' rest](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html)
#' in the *Amazon Managed Service for Prometheus User Guide*.
#' @param tags The list of tag keys and values to associate with the workspace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_workspace
prometheusservice_create_workspace <- function(alias = NULL, clientToken = NULL, kmsKeyArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateWorkspace",
    http_method = "POST",
    http_path = "/workspaces",
    paginator = list()
  )
  input <- .prometheusservice$create_workspace_input(alias = alias, clientToken = clientToken, kmsKeyArn = kmsKeyArn, tags = tags)
  output <- .prometheusservice$create_workspace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_workspace <- prometheusservice_create_workspace

#' Deletes the alert manager definition from a workspace
#'
#' @description
#' Deletes the alert manager definition from a workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_delete_alert_manager_definition/](https://www.paws-r-sdk.com/docs/prometheusservice_delete_alert_manager_definition/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete the alert manager definition from.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_alert_manager_definition
prometheusservice_delete_alert_manager_definition <- function(clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "DeleteAlertManagerDefinition",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$delete_alert_manager_definition_input(clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$delete_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_alert_manager_definition <- prometheusservice_delete_alert_manager_definition

#' Deletes the logging configuration for a workspace
#'
#' @description
#' Deletes the logging configuration for a workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_delete_logging_configuration/](https://www.paws-r-sdk.com/docs/prometheusservice_delete_logging_configuration/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param workspaceId &#91;required&#93; The ID of the workspace containing the logging configuration to delete.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_logging_configuration
prometheusservice_delete_logging_configuration <- function(clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "DeleteLoggingConfiguration",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/logging",
    paginator = list()
  )
  input <- .prometheusservice$delete_logging_configuration_input(clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$delete_logging_configuration_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_logging_configuration <- prometheusservice_delete_logging_configuration

#' Deletes one rule groups namespace and its associated rule groups
#' definition
#'
#' @description
#' Deletes one rule groups namespace and its associated rule groups definition.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_delete_rule_groups_namespace/](https://www.paws-r-sdk.com/docs/prometheusservice_delete_rule_groups_namespace/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param name &#91;required&#93; The name of the rule groups namespace to delete.
#' @param workspaceId &#91;required&#93; The ID of the workspace containing the rule groups namespace and
#' definition to delete.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_rule_groups_namespace
prometheusservice_delete_rule_groups_namespace <- function(clientToken = NULL, name, workspaceId) {
  op <- new_operation(
    name = "DeleteRuleGroupsNamespace",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
    paginator = list()
  )
  input <- .prometheusservice$delete_rule_groups_namespace_input(clientToken = clientToken, name = name, workspaceId = workspaceId)
  output <- .prometheusservice$delete_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_rule_groups_namespace <- prometheusservice_delete_rule_groups_namespace

#' The DeleteScraper operation deletes one scraper, and stops any metrics
#' collection that the scraper performs
#'
#' @description
#' The [`delete_scraper`][prometheusservice_delete_scraper] operation deletes one scraper, and stops any metrics collection that the scraper performs.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_delete_scraper/](https://www.paws-r-sdk.com/docs/prometheusservice_delete_scraper/) for full documentation.
#'
#' @param clientToken (Optional) A unique, case-sensitive identifier that you can provide to
#' ensure the idempotency of the request.
#' @param scraperId &#91;required&#93; The ID of the scraper to delete.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_scraper
prometheusservice_delete_scraper <- function(clientToken = NULL, scraperId) {
  op <- new_operation(
    name = "DeleteScraper",
    http_method = "DELETE",
    http_path = "/scrapers/{scraperId}",
    paginator = list()
  )
  input <- .prometheusservice$delete_scraper_input(clientToken = clientToken, scraperId = scraperId)
  output <- .prometheusservice$delete_scraper_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_scraper <- prometheusservice_delete_scraper

#' Deletes an existing workspace
#'
#' @description
#' Deletes an existing workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_delete_workspace/](https://www.paws-r-sdk.com/docs/prometheusservice_delete_workspace/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_workspace
prometheusservice_delete_workspace <- function(clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "DeleteWorkspace",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .prometheusservice$delete_workspace_input(clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$delete_workspace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_workspace <- prometheusservice_delete_workspace

#' Retrieves the full information about the alert manager definition for a
#' workspace
#'
#' @description
#' Retrieves the full information about the alert manager definition for a workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_describe_alert_manager_definition/](https://www.paws-r-sdk.com/docs/prometheusservice_describe_alert_manager_definition/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to retrieve the alert manager definition from.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_alert_manager_definition
prometheusservice_describe_alert_manager_definition <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeAlertManagerDefinition",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$describe_alert_manager_definition_input(workspaceId = workspaceId)
  output <- .prometheusservice$describe_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_alert_manager_definition <- prometheusservice_describe_alert_manager_definition

#' Returns complete information about the current logging configuration of
#' the workspace
#'
#' @description
#' Returns complete information about the current logging configuration of the workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_describe_logging_configuration/](https://www.paws-r-sdk.com/docs/prometheusservice_describe_logging_configuration/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to describe the logging configuration for.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_logging_configuration
prometheusservice_describe_logging_configuration <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeLoggingConfiguration",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/logging",
    paginator = list()
  )
  input <- .prometheusservice$describe_logging_configuration_input(workspaceId = workspaceId)
  output <- .prometheusservice$describe_logging_configuration_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_logging_configuration <- prometheusservice_describe_logging_configuration

#' Returns complete information about one rule groups namespace
#'
#' @description
#' Returns complete information about one rule groups namespace. To retrieve a list of rule groups namespaces, use [`list_rule_groups_namespaces`][prometheusservice_list_rule_groups_namespaces].
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_describe_rule_groups_namespace/](https://www.paws-r-sdk.com/docs/prometheusservice_describe_rule_groups_namespace/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the rule groups namespace that you want information for.
#' @param workspaceId &#91;required&#93; The ID of the workspace containing the rule groups namespace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_rule_groups_namespace
prometheusservice_describe_rule_groups_namespace <- function(name, workspaceId) {
  op <- new_operation(
    name = "DescribeRuleGroupsNamespace",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
    paginator = list()
  )
  input <- .prometheusservice$describe_rule_groups_namespace_input(name = name, workspaceId = workspaceId)
  output <- .prometheusservice$describe_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_rule_groups_namespace <- prometheusservice_describe_rule_groups_namespace

#' The DescribeScraper operation displays information about an existing
#' scraper
#'
#' @description
#' The [`describe_scraper`][prometheusservice_describe_scraper] operation displays information about an existing scraper.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_describe_scraper/](https://www.paws-r-sdk.com/docs/prometheusservice_describe_scraper/) for full documentation.
#'
#' @param scraperId &#91;required&#93; The ID of the scraper to describe.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_scraper
prometheusservice_describe_scraper <- function(scraperId) {
  op <- new_operation(
    name = "DescribeScraper",
    http_method = "GET",
    http_path = "/scrapers/{scraperId}",
    paginator = list()
  )
  input <- .prometheusservice$describe_scraper_input(scraperId = scraperId)
  output <- .prometheusservice$describe_scraper_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_scraper <- prometheusservice_describe_scraper

#' Returns information about an existing workspace
#'
#' @description
#' Returns information about an existing workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_describe_workspace/](https://www.paws-r-sdk.com/docs/prometheusservice_describe_workspace/) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to describe.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_workspace
prometheusservice_describe_workspace <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspace",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .prometheusservice$describe_workspace_input(workspaceId = workspaceId)
  output <- .prometheusservice$describe_workspace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_workspace <- prometheusservice_describe_workspace

#' The GetDefaultScraperConfiguration operation returns the default scraper
#' configuration used when Amazon EKS creates a scraper for you
#'
#' @description
#' The [`get_default_scraper_configuration`][prometheusservice_get_default_scraper_configuration] operation returns the default scraper configuration used when Amazon EKS creates a scraper for you.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_get_default_scraper_configuration/](https://www.paws-r-sdk.com/docs/prometheusservice_get_default_scraper_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname prometheusservice_get_default_scraper_configuration
prometheusservice_get_default_scraper_configuration <- function() {
  op <- new_operation(
    name = "GetDefaultScraperConfiguration",
    http_method = "GET",
    http_path = "/scraperconfiguration",
    paginator = list()
  )
  input <- .prometheusservice$get_default_scraper_configuration_input()
  output <- .prometheusservice$get_default_scraper_configuration_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$get_default_scraper_configuration <- prometheusservice_get_default_scraper_configuration

#' Returns a list of rule groups namespaces in a workspace
#'
#' @description
#' Returns a list of rule groups namespaces in a workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_list_rule_groups_namespaces/](https://www.paws-r-sdk.com/docs/prometheusservice_list_rule_groups_namespaces/) for full documentation.
#'
#' @param maxResults The maximum number of results to return. The default is 100.
#' @param name Use this parameter to filter the rule groups namespaces that are
#' returned. Only the namespaces with names that begin with the value that
#' you specify are returned.
#' @param nextToken The token for the next set of items to return. You receive this token
#' from a previous call, and use it to get the next page of results. The
#' other parameters must be the same as the initial call.
#' 
#' For example, if your initial request has `maxResults` of 10, and there
#' are 12 rule groups namespaces to return, then your initial request will
#' return 10 and a `nextToken`. Using the next token in a subsequent call
#' will return the remaining 2 namespaces.
#' @param workspaceId &#91;required&#93; The ID of the workspace containing the rule groups namespaces.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_rule_groups_namespaces
prometheusservice_list_rule_groups_namespaces <- function(maxResults = NULL, name = NULL, nextToken = NULL, workspaceId) {
  op <- new_operation(
    name = "ListRuleGroupsNamespaces",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "ruleGroupsNamespaces")
  )
  input <- .prometheusservice$list_rule_groups_namespaces_input(maxResults = maxResults, name = name, nextToken = nextToken, workspaceId = workspaceId)
  output <- .prometheusservice$list_rule_groups_namespaces_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_rule_groups_namespaces <- prometheusservice_list_rule_groups_namespaces

#' The ListScrapers operation lists all of the scrapers in your account
#'
#' @description
#' The [`list_scrapers`][prometheusservice_list_scrapers] operation lists all of the scrapers in your account. This includes scrapers being created or deleted. You can optionally filter the returned list.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_list_scrapers/](https://www.paws-r-sdk.com/docs/prometheusservice_list_scrapers/) for full documentation.
#'
#' @param filters (Optional) A list of key-value pairs to filter the list of scrapers
#' returned. Keys include `status`, `sourceArn`, `destinationArn`, and
#' `alias`.
#' 
#' Filters on the same key are `OR`'d together, and filters on different
#' keys are `AND`'d together. For example,
#' `status=ACTIVE&status=CREATING&alias=Test`, will return all scrapers
#' that have the alias Test, and are either in status ACTIVE or CREATING.
#' 
#' To find all active scrapers that are sending metrics to a specific
#' Amazon Managed Service for Prometheus workspace, you would use the ARN
#' of the workspace in a query:
#' 
#' `status=ACTIVE&destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012`
#' 
#' If this is included, it filters the results to only the scrapers that
#' match the filter.
#' @param maxResults Optional) The maximum number of scrapers to return in one
#' [`list_scrapers`][prometheusservice_list_scrapers] operation. The range
#' is 1-1000.
#' 
#' If you omit this parameter, the default of 100 is used.
#' @param nextToken (Optional) The token for the next set of items to return. (You received
#' this token from a previous call.)
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_scrapers
prometheusservice_list_scrapers <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListScrapers",
    http_method = "GET",
    http_path = "/scrapers",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "scrapers")
  )
  input <- .prometheusservice$list_scrapers_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .prometheusservice$list_scrapers_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_scrapers <- prometheusservice_list_scrapers

#' The ListTagsForResource operation returns the tags that are associated
#' with an Amazon Managed Service for Prometheus resource
#'
#' @description
#' The [`list_tags_for_resource`][prometheusservice_list_tags_for_resource] operation returns the tags that are associated with an Amazon Managed Service for Prometheus resource. Currently, the only resources that can be tagged are workspaces and rule groups namespaces.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/prometheusservice_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to list tages for. Must be a workspace or rule
#' groups namespace resource.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_tags_for_resource
prometheusservice_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .prometheusservice$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .prometheusservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_tags_for_resource <- prometheusservice_list_tags_for_resource

#' Lists all of the Amazon Managed Service for Prometheus workspaces in
#' your account
#'
#' @description
#' Lists all of the Amazon Managed Service for Prometheus workspaces in your account. This includes workspaces being created or deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_list_workspaces/](https://www.paws-r-sdk.com/docs/prometheusservice_list_workspaces/) for full documentation.
#'
#' @param alias If this is included, it filters the results to only the workspaces with
#' names that start with the value that you specify here.
#' 
#' Amazon Managed Service for Prometheus will automatically strip any blank
#' spaces from the beginning and end of the alias that you specify.
#' @param maxResults The maximum number of workspaces to return per request. The default is
#' 100.
#' @param nextToken The token for the next set of items to return. You receive this token
#' from a previous call, and use it to get the next page of results. The
#' other parameters must be the same as the initial call.
#' 
#' For example, if your initial request has `maxResults` of 10, and there
#' are 12 workspaces to return, then your initial request will return 10
#' and a `nextToken`. Using the next token in a subsequent call will return
#' the remaining 2 workspaces.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_workspaces
prometheusservice_list_workspaces <- function(alias = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListWorkspaces",
    http_method = "GET",
    http_path = "/workspaces",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "workspaces")
  )
  input <- .prometheusservice$list_workspaces_input(alias = alias, maxResults = maxResults, nextToken = nextToken)
  output <- .prometheusservice$list_workspaces_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_workspaces <- prometheusservice_list_workspaces

#' Updates an existing alert manager definition in a workspace
#'
#' @description
#' Updates an existing alert manager definition in a workspace. If the workspace does not already have an alert manager definition, don't use this operation to create it. Instead, use [`create_alert_manager_definition`][prometheusservice_create_alert_manager_definition].
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_put_alert_manager_definition/](https://www.paws-r-sdk.com/docs/prometheusservice_put_alert_manager_definition/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param data &#91;required&#93; The alert manager definition to use. A base64-encoded version of the
#' YAML alert manager definition file.
#' 
#' For details about the alert manager definition, see
#' [AlertManagedDefinitionData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html).
#' @param workspaceId &#91;required&#93; The ID of the workspace to update the alert manager definition in.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_put_alert_manager_definition
prometheusservice_put_alert_manager_definition <- function(clientToken = NULL, data, workspaceId) {
  op <- new_operation(
    name = "PutAlertManagerDefinition",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$put_alert_manager_definition_input(clientToken = clientToken, data = data, workspaceId = workspaceId)
  output <- .prometheusservice$put_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$put_alert_manager_definition <- prometheusservice_put_alert_manager_definition

#' Updates an existing rule groups namespace within a workspace
#'
#' @description
#' Updates an existing rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_put_rule_groups_namespace/](https://www.paws-r-sdk.com/docs/prometheusservice_put_rule_groups_namespace/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param data &#91;required&#93; The new rules file to use in the namespace. A base64-encoded version of
#' the YAML rule groups file.
#' 
#' For details about the rule groups namespace structure, see
#' [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
#' @param name &#91;required&#93; The name of the rule groups namespace that you are updating.
#' @param workspaceId &#91;required&#93; The ID of the workspace where you are updating the rule groups
#' namespace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_put_rule_groups_namespace
prometheusservice_put_rule_groups_namespace <- function(clientToken = NULL, data, name, workspaceId) {
  op <- new_operation(
    name = "PutRuleGroupsNamespace",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
    paginator = list()
  )
  input <- .prometheusservice$put_rule_groups_namespace_input(clientToken = clientToken, data = data, name = name, workspaceId = workspaceId)
  output <- .prometheusservice$put_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$put_rule_groups_namespace <- prometheusservice_put_rule_groups_namespace

#' The TagResource operation associates tags with an Amazon Managed Service
#' for Prometheus resource
#'
#' @description
#' The [`tag_resource`][prometheusservice_tag_resource] operation associates tags with an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_tag_resource/](https://www.paws-r-sdk.com/docs/prometheusservice_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the workspace or rule groups namespace to apply tags to.
#' @param tags &#91;required&#93; The list of tag keys and values to associate with the resource.
#' 
#' Keys may not begin with `aws:`.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_tag_resource
prometheusservice_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .prometheusservice$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .prometheusservice$tag_resource_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$tag_resource <- prometheusservice_tag_resource

#' Removes the specified tags from an Amazon Managed Service for Prometheus
#' resource
#'
#' @description
#' Removes the specified tags from an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_untag_resource/](https://www.paws-r-sdk.com/docs/prometheusservice_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the workspace or rule groups namespace.
#' @param tagKeys &#91;required&#93; The keys of the tags to remove.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_untag_resource
prometheusservice_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .prometheusservice$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .prometheusservice$untag_resource_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$untag_resource <- prometheusservice_untag_resource

#' Updates the log group ARN or the workspace ID of the current logging
#' configuration
#'
#' @description
#' Updates the log group ARN or the workspace ID of the current logging configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_update_logging_configuration/](https://www.paws-r-sdk.com/docs/prometheusservice_update_logging_configuration/) for full documentation.
#'
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param logGroupArn &#91;required&#93; The ARN of the CloudWatch log group to which the vended log data will be
#' published.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update the logging configuration for.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_update_logging_configuration
prometheusservice_update_logging_configuration <- function(clientToken = NULL, logGroupArn, workspaceId) {
  op <- new_operation(
    name = "UpdateLoggingConfiguration",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}/logging",
    paginator = list()
  )
  input <- .prometheusservice$update_logging_configuration_input(clientToken = clientToken, logGroupArn = logGroupArn, workspaceId = workspaceId)
  output <- .prometheusservice$update_logging_configuration_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$update_logging_configuration <- prometheusservice_update_logging_configuration

#' Updates the alias of an existing workspace
#'
#' @description
#' Updates the alias of an existing workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/prometheusservice_update_workspace_alias/](https://www.paws-r-sdk.com/docs/prometheusservice_update_workspace_alias/) for full documentation.
#'
#' @param alias The new alias for the workspace. It does not need to be unique.
#' 
#' Amazon Managed Service for Prometheus will automatically strip any blank
#' spaces from the beginning and end of the alias that you specify.
#' @param clientToken A unique identifier that you can provide to ensure the idempotency of
#' the request. Case-sensitive.
#' @param workspaceId &#91;required&#93; The ID of the workspace to update.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_update_workspace_alias
prometheusservice_update_workspace_alias <- function(alias = NULL, clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "UpdateWorkspaceAlias",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/alias",
    paginator = list()
  )
  input <- .prometheusservice$update_workspace_alias_input(alias = alias, clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$update_workspace_alias_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$update_workspace_alias <- prometheusservice_update_workspace_alias
