% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_create_kx_changeset}
\alias{finspace_create_kx_changeset}
\title{Creates a changeset for a kdb database}
\usage{
finspace_create_kx_changeset(
  environmentId,
  databaseName,
  changeRequests,
  clientToken
)
}
\arguments{
\item{environmentId}{[required] A unique identifier of the kdb environment.}

\item{databaseName}{[required] The name of the kdb database.}

\item{changeRequests}{[required] A list of change request objects that are run in order. A change request
object consists of \code{changeType} , \code{s3Path}, and \code{dbPath}. A changeType
can has the following values:
\itemize{
\item PUT – Adds or updates files in a database.
\item DELETE – Deletes files in a database.
}

All the change requests require a mandatory \code{dbPath} attribute that
defines the path within the database directory. All database paths must
start with a leading / and end with a trailing /. The \code{s3Path} attribute
defines the s3 source file path and is required for a PUT change type.
The \code{s3path} must end with a trailing / if it is a directory and must
end without a trailing / if it is a file.

Here are few examples of how you can use the change request object:
\enumerate{
\item This request adds a single sym file at database root location.

\verb{\{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"\}}
\item This request adds files in the given \code{s3Path} under the 2020.01.02
partition of the database.

\verb{\{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"\}}
\item This request adds files in the given \code{s3Path} under the \emph{taq} table
partition of the database.

\verb{[ \{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"\}]}
\item This request deletes the 2020.01.02 partition of the database.

\verb{[\{ "changeType": "DELETE", "dbPath": "/2020.01.02/"\} ]}
\item The \emph{DELETE} request allows you to delete the existing files under
the 2020.01.02 partition of the database, and the \emph{PUT} request adds
a new taq table under it.

\verb{[ \{"changeType": "DELETE", "dbPath":"/2020.01.02/"\}, \{"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"\}]}
}}

\item{clientToken}{[required] A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an ordered list of change requests.

See \url{https://www.paws-r-sdk.com/docs/finspace_create_kx_changeset/} for full documentation.
}
\keyword{internal}
