% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchinternetmonitor_operations.R
\name{cloudwatchinternetmonitor_update_monitor}
\alias{cloudwatchinternetmonitor_update_monitor}
\title{Updates a monitor}
\usage{
cloudwatchinternetmonitor_update_monitor(
  MonitorName,
  ResourcesToAdd = NULL,
  ResourcesToRemove = NULL,
  Status = NULL,
  ClientToken = NULL,
  MaxCityNetworksToMonitor = NULL,
  InternetMeasurementsLogDelivery = NULL,
  TrafficPercentageToMonitor = NULL,
  HealthEventsConfig = NULL
)
}
\arguments{
\item{MonitorName}{[required] The name of the monitor.}

\item{ResourcesToAdd}{The resources to include in a monitor, which you provide as a set of
Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon
CloudFront distributions, or Amazon WorkSpaces directories.

You can add a combination of VPCs and CloudFront distributions, or you
can add WorkSpaces directories, or you can add NLBs. You can't add NLBs
or WorkSpaces directories together with any other resources.

If you add only Amazon Virtual Private Clouds resources, at least one
VPC must have an Internet Gateway attached to it, to make sure that it
has internet connectivity.}

\item{ResourcesToRemove}{The resources to remove from a monitor, which you provide as a set of
Amazon Resource Names (ARNs).}

\item{Status}{The status for a monitor. The accepted values for \code{Status} with the
\code{\link[=cloudwatchinternetmonitor_update_monitor]{update_monitor}} API call
are the following: \code{ACTIVE} and \code{INACTIVE}. The following values are
\emph{not} accepted: \code{PENDING}, and \code{ERROR}.}

\item{ClientToken}{A unique, case-sensitive string of up to 64 ASCII characters that you
specify to make an idempotent API request. You should not reuse the same
client token for other API requests.}

\item{MaxCityNetworksToMonitor}{The maximum number of city-networks to monitor for your application. A
city-network is the location (city) where clients access your
application resources from and the ASN or network provider, such as an
internet service provider (ISP), that clients access the resources
through. Setting this limit can help control billing costs.}

\item{InternetMeasurementsLogDelivery}{Publish internet measurements for Internet Monitor to another location,
such as an Amazon S3 bucket. The measurements are also published to
Amazon CloudWatch Logs.}

\item{TrafficPercentageToMonitor}{The percentage of the internet-facing traffic for your application that
you want to monitor with this monitor. If you set a city-networks
maximum, that limit overrides the traffic percentage that you set.

To learn more, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html}{Choosing an application traffic percentage to monitor}
in the Amazon CloudWatch Internet Monitor section of the \emph{CloudWatch
User Guide}.}

\item{HealthEventsConfig}{The list of health score thresholds. A threshold percentage for health
scores, along with other configuration information, determines when
Internet Monitor creates a health event when there's an internet issue
that affects your application end users.

For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview}{Change health event thresholds}
in the Internet Monitor section of the \emph{CloudWatch User Guide}.}
}
\description{
Updates a monitor. You can update a monitor to change the percentage of traffic to monitor or the maximum number of city-networks (locations and ASNs), to add or remove resources, or to change the status of the monitor. Note that you can't change the name of a monitor.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_update_monitor/} for full documentation.
}
\keyword{internal}
