# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatch_service.R
NULL

#' Deletes the specified alarms
#'
#' @description
#' Deletes the specified alarms. You can delete up to 100 alarms in one operation. However, this total can include no more than one composite alarm. For example, you could delete 99 metric alarms and one composite alarms with one operation, but you can't delete two composite alarms with one operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_delete_alarms/](https://www.paws-r-sdk.com/docs/cloudwatch_delete_alarms/) for full documentation.
#'
#' @param AlarmNames &#91;required&#93; The alarms to be deleted. Do not enclose the alarm names in quote marks.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_alarms
cloudwatch_delete_alarms <- function(AlarmNames) {
  op <- new_operation(
    name = "DeleteAlarms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_alarms_input(AlarmNames = AlarmNames)
  output <- .cloudwatch$delete_alarms_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_alarms <- cloudwatch_delete_alarms

#' Deletes the specified anomaly detection model from your account
#'
#' @description
#' Deletes the specified anomaly detection model from your account. For more information about how to delete an anomaly detection model, see [Deleting an anomaly detection model](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Anomaly_Detection_Alarm.html#Delete_Anomaly_Detection_Model) in the *CloudWatch User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_delete_anomaly_detector/](https://www.paws-r-sdk.com/docs/cloudwatch_delete_anomaly_detector/) for full documentation.
#'
#' @param Namespace The namespace associated with the anomaly detection model to delete.
#' @param MetricName The metric name associated with the anomaly detection model to delete.
#' @param Dimensions The metric dimensions associated with the anomaly detection model to
#' delete.
#' @param Stat The statistic associated with the anomaly detection model to delete.
#' @param SingleMetricAnomalyDetector A single metric anomaly detector to be deleted.
#' 
#' When using `SingleMetricAnomalyDetector`, you cannot include the
#' following parameters in the same operation:
#' 
#' -   `Dimensions`,
#' 
#' -   `MetricName`
#' 
#' -   `Namespace`
#' 
#' -   `Stat`
#' 
#' -   the `MetricMathAnomalyDetector` parameters of
#'     `DeleteAnomalyDetectorInput`
#' 
#' Instead, specify the single metric anomaly detector attributes as part
#' of the `SingleMetricAnomalyDetector` property.
#' @param MetricMathAnomalyDetector The metric math anomaly detector to be deleted.
#' 
#' When using `MetricMathAnomalyDetector`, you cannot include following
#' parameters in the same operation:
#' 
#' -   `Dimensions`,
#' 
#' -   `MetricName`
#' 
#' -   `Namespace`
#' 
#' -   `Stat`
#' 
#' -   the `SingleMetricAnomalyDetector` parameters of
#'     `DeleteAnomalyDetectorInput`
#' 
#' Instead, specify the metric math anomaly detector attributes as part of
#' the `MetricMathAnomalyDetector` property.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_anomaly_detector
cloudwatch_delete_anomaly_detector <- function(Namespace = NULL, MetricName = NULL, Dimensions = NULL, Stat = NULL, SingleMetricAnomalyDetector = NULL, MetricMathAnomalyDetector = NULL) {
  op <- new_operation(
    name = "DeleteAnomalyDetector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_anomaly_detector_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, Stat = Stat, SingleMetricAnomalyDetector = SingleMetricAnomalyDetector, MetricMathAnomalyDetector = MetricMathAnomalyDetector)
  output <- .cloudwatch$delete_anomaly_detector_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_anomaly_detector <- cloudwatch_delete_anomaly_detector

#' Deletes all dashboards that you specify
#'
#' @description
#' Deletes all dashboards that you specify. You can specify up to 100 dashboards to delete. If there is an error during this call, no dashboards are deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_delete_dashboards/](https://www.paws-r-sdk.com/docs/cloudwatch_delete_dashboards/) for full documentation.
#'
#' @param DashboardNames &#91;required&#93; The dashboards to be deleted. This parameter is required.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_dashboards
cloudwatch_delete_dashboards <- function(DashboardNames) {
  op <- new_operation(
    name = "DeleteDashboards",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_dashboards_input(DashboardNames = DashboardNames)
  output <- .cloudwatch$delete_dashboards_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_dashboards <- cloudwatch_delete_dashboards

#' Permanently deletes the specified Contributor Insights rules
#'
#' @description
#' Permanently deletes the specified Contributor Insights rules.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_delete_insight_rules/](https://www.paws-r-sdk.com/docs/cloudwatch_delete_insight_rules/) for full documentation.
#'
#' @param RuleNames &#91;required&#93; An array of the rule names to delete. If you need to find out the names
#' of your rules, use
#' [`describe_insight_rules`][cloudwatch_describe_insight_rules].
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_insight_rules
cloudwatch_delete_insight_rules <- function(RuleNames) {
  op <- new_operation(
    name = "DeleteInsightRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_insight_rules_input(RuleNames = RuleNames)
  output <- .cloudwatch$delete_insight_rules_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_insight_rules <- cloudwatch_delete_insight_rules

#' Permanently deletes the metric stream that you specify
#'
#' @description
#' Permanently deletes the metric stream that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_delete_metric_stream/](https://www.paws-r-sdk.com/docs/cloudwatch_delete_metric_stream/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the metric stream to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_delete_metric_stream
cloudwatch_delete_metric_stream <- function(Name) {
  op <- new_operation(
    name = "DeleteMetricStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$delete_metric_stream_input(Name = Name)
  output <- .cloudwatch$delete_metric_stream_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$delete_metric_stream <- cloudwatch_delete_metric_stream

#' Retrieves the history for the specified alarm
#'
#' @description
#' Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for either all metric alarms or all composite alarms are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_describe_alarm_history/](https://www.paws-r-sdk.com/docs/cloudwatch_describe_alarm_history/) for full documentation.
#'
#' @param AlarmName The name of the alarm.
#' @param AlarmTypes Use this parameter to specify whether you want the operation to return
#' metric alarms or composite alarms. If you omit this parameter, only
#' metric alarms are returned.
#' @param HistoryItemType The type of alarm histories to retrieve.
#' @param StartDate The starting date to retrieve alarm history.
#' @param EndDate The ending date to retrieve alarm history.
#' @param MaxRecords The maximum number of alarm history records to retrieve.
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#' @param ScanBy Specified whether to return the newest or oldest alarm history first.
#' Specify `TimestampDescending` to have the newest event history returned
#' first, and specify `TimestampAscending` to have the oldest history
#' returned first.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_alarm_history
cloudwatch_describe_alarm_history <- function(AlarmName = NULL, AlarmTypes = NULL, HistoryItemType = NULL, StartDate = NULL, EndDate = NULL, MaxRecords = NULL, NextToken = NULL, ScanBy = NULL) {
  op <- new_operation(
    name = "DescribeAlarmHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "AlarmHistoryItems")
  )
  input <- .cloudwatch$describe_alarm_history_input(AlarmName = AlarmName, AlarmTypes = AlarmTypes, HistoryItemType = HistoryItemType, StartDate = StartDate, EndDate = EndDate, MaxRecords = MaxRecords, NextToken = NextToken, ScanBy = ScanBy)
  output <- .cloudwatch$describe_alarm_history_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_alarm_history <- cloudwatch_describe_alarm_history

#' Retrieves the specified alarms
#'
#' @description
#' Retrieves the specified alarms. You can filter the results by specifying a prefix for the alarm name, the alarm state, or a prefix for any action.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_describe_alarms/](https://www.paws-r-sdk.com/docs/cloudwatch_describe_alarms/) for full documentation.
#'
#' @param AlarmNames The names of the alarms to retrieve information about.
#' @param AlarmNamePrefix An alarm name prefix. If you specify this parameter, you receive
#' information about all alarms that have names that start with this
#' prefix.
#' 
#' If this parameter is specified, you cannot specify `AlarmNames`.
#' @param AlarmTypes Use this parameter to specify whether you want the operation to return
#' metric alarms or composite alarms. If you omit this parameter, only
#' metric alarms are returned, even if composite alarms exist in the
#' account.
#' 
#' For example, if you omit this parameter or specify `MetricAlarms`, the
#' operation returns only a list of metric alarms. It does not return any
#' composite alarms, even if composite alarms exist in the account.
#' 
#' If you specify `CompositeAlarms`, the operation returns only a list of
#' composite alarms, and does not return any metric alarms.
#' @param ChildrenOfAlarmName If you use this parameter and specify the name of a composite alarm, the
#' operation returns information about the "children" alarms of the alarm
#' you specify. These are the metric alarms and composite alarms referenced
#' in the `AlarmRule` field of the composite alarm that you specify in
#' `ChildrenOfAlarmName`. Information about the composite alarm that you
#' name in `ChildrenOfAlarmName` is not returned.
#' 
#' If you specify `ChildrenOfAlarmName`, you cannot specify any other
#' parameters in the request except for `MaxRecords` and `NextToken`. If
#' you do so, you receive a validation error.
#' 
#' Only the `Alarm Name`, `ARN`, `StateValue` (OK/ALARM/INSUFFICIENT_DATA),
#' and `StateUpdatedTimestamp` information are returned by this operation
#' when you use this parameter. To get complete information about these
#' alarms, perform another [`describe_alarms`][cloudwatch_describe_alarms]
#' operation and specify the parent alarm names in the `AlarmNames`
#' parameter.
#' @param ParentsOfAlarmName If you use this parameter and specify the name of a metric or composite
#' alarm, the operation returns information about the "parent" alarms of
#' the alarm you specify. These are the composite alarms that have
#' `AlarmRule` parameters that reference the alarm named in
#' `ParentsOfAlarmName`. Information about the alarm that you specify in
#' `ParentsOfAlarmName` is not returned.
#' 
#' If you specify `ParentsOfAlarmName`, you cannot specify any other
#' parameters in the request except for `MaxRecords` and `NextToken`. If
#' you do so, you receive a validation error.
#' 
#' Only the Alarm Name and ARN are returned by this operation when you use
#' this parameter. To get complete information about these alarms, perform
#' another [`describe_alarms`][cloudwatch_describe_alarms] operation and
#' specify the parent alarm names in the `AlarmNames` parameter.
#' @param StateValue Specify this parameter to receive information only about alarms that are
#' currently in the state that you specify.
#' @param ActionPrefix Use this parameter to filter the results of the operation to only those
#' alarms that use a certain alarm action. For example, you could specify
#' the ARN of an SNS topic to find all alarms that send notifications to
#' that topic.
#' @param MaxRecords The maximum number of alarm descriptions to retrieve.
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_alarms
cloudwatch_describe_alarms <- function(AlarmNames = NULL, AlarmNamePrefix = NULL, AlarmTypes = NULL, ChildrenOfAlarmName = NULL, ParentsOfAlarmName = NULL, StateValue = NULL, ActionPrefix = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAlarms",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = list("MetricAlarms", "CompositeAlarms"))
  )
  input <- .cloudwatch$describe_alarms_input(AlarmNames = AlarmNames, AlarmNamePrefix = AlarmNamePrefix, AlarmTypes = AlarmTypes, ChildrenOfAlarmName = ChildrenOfAlarmName, ParentsOfAlarmName = ParentsOfAlarmName, StateValue = StateValue, ActionPrefix = ActionPrefix, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .cloudwatch$describe_alarms_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_alarms <- cloudwatch_describe_alarms

#' Retrieves the alarms for the specified metric
#'
#' @description
#' Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_describe_alarms_for_metric/](https://www.paws-r-sdk.com/docs/cloudwatch_describe_alarms_for_metric/) for full documentation.
#'
#' @param MetricName &#91;required&#93; The name of the metric.
#' @param Namespace &#91;required&#93; The namespace of the metric.
#' @param Statistic The statistic for the metric, other than percentiles. For percentile
#' statistics, use `ExtendedStatistics`.
#' @param ExtendedStatistic The percentile statistic for the metric. Specify a value between p0.0
#' and p100.
#' @param Dimensions The dimensions associated with the metric. If the metric has any
#' associated dimensions, you must specify them in order for the call to
#' succeed.
#' @param Period The period, in seconds, over which the statistic is applied.
#' @param Unit The unit for the metric.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_alarms_for_metric
cloudwatch_describe_alarms_for_metric <- function(MetricName, Namespace, Statistic = NULL, ExtendedStatistic = NULL, Dimensions = NULL, Period = NULL, Unit = NULL) {
  op <- new_operation(
    name = "DescribeAlarmsForMetric",
    http_method = "POST",
    http_path = "/",
    paginator = list(result_key = "MetricAlarms")
  )
  input <- .cloudwatch$describe_alarms_for_metric_input(MetricName = MetricName, Namespace = Namespace, Statistic = Statistic, ExtendedStatistic = ExtendedStatistic, Dimensions = Dimensions, Period = Period, Unit = Unit)
  output <- .cloudwatch$describe_alarms_for_metric_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_alarms_for_metric <- cloudwatch_describe_alarms_for_metric

#' Lists the anomaly detection models that you have created in your account
#'
#' @description
#' Lists the anomaly detection models that you have created in your account. For single metric anomaly detectors, you can list all of the models in your account or filter the results to only the models that are related to a certain namespace, metric name, or metric dimension. For metric math anomaly detectors, you can list them by adding `METRIC_MATH` to the `AnomalyDetectorTypes` array. This will return all metric math anomaly detectors in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_describe_anomaly_detectors/](https://www.paws-r-sdk.com/docs/cloudwatch_describe_anomaly_detectors/) for full documentation.
#'
#' @param NextToken Use the token returned by the previous operation to request the next
#' page of results.
#' @param MaxResults The maximum number of results to return in one operation. The maximum
#' value that you can specify is 100.
#' 
#' To retrieve the remaining results, make another call with the returned
#' `NextToken` value.
#' @param Namespace Limits the results to only the anomaly detection models that are
#' associated with the specified namespace.
#' @param MetricName Limits the results to only the anomaly detection models that are
#' associated with the specified metric name. If there are multiple metrics
#' with this name in different namespaces that have anomaly detection
#' models, they're all returned.
#' @param Dimensions Limits the results to only the anomaly detection models that are
#' associated with the specified metric dimensions. If there are multiple
#' metrics that have these dimensions and have anomaly detection models
#' associated, they're all returned.
#' @param AnomalyDetectorTypes The anomaly detector types to request when using
#' `DescribeAnomalyDetectorsInput`. If empty, defaults to `SINGLE_METRIC`.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_anomaly_detectors
cloudwatch_describe_anomaly_detectors <- function(NextToken = NULL, MaxResults = NULL, Namespace = NULL, MetricName = NULL, Dimensions = NULL, AnomalyDetectorTypes = NULL) {
  op <- new_operation(
    name = "DescribeAnomalyDetectors",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AnomalyDetectors")
  )
  input <- .cloudwatch$describe_anomaly_detectors_input(NextToken = NextToken, MaxResults = MaxResults, Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, AnomalyDetectorTypes = AnomalyDetectorTypes)
  output <- .cloudwatch$describe_anomaly_detectors_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_anomaly_detectors <- cloudwatch_describe_anomaly_detectors

#' Returns a list of all the Contributor Insights rules in your account
#'
#' @description
#' Returns a list of all the Contributor Insights rules in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_describe_insight_rules/](https://www.paws-r-sdk.com/docs/cloudwatch_describe_insight_rules/) for full documentation.
#'
#' @param NextToken Include this value, if it was returned by the previous operation, to get
#' the next set of rules.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default of 500 is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_describe_insight_rules
cloudwatch_describe_insight_rules <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInsightRules",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .cloudwatch$describe_insight_rules_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudwatch$describe_insight_rules_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$describe_insight_rules <- cloudwatch_describe_insight_rules

#' Disables the actions for the specified alarms
#'
#' @description
#' Disables the actions for the specified alarms. When an alarm's actions are disabled, the alarm actions do not execute when the alarm state changes.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_disable_alarm_actions/](https://www.paws-r-sdk.com/docs/cloudwatch_disable_alarm_actions/) for full documentation.
#'
#' @param AlarmNames &#91;required&#93; The names of the alarms.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_disable_alarm_actions
cloudwatch_disable_alarm_actions <- function(AlarmNames) {
  op <- new_operation(
    name = "DisableAlarmActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$disable_alarm_actions_input(AlarmNames = AlarmNames)
  output <- .cloudwatch$disable_alarm_actions_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$disable_alarm_actions <- cloudwatch_disable_alarm_actions

#' Disables the specified Contributor Insights rules
#'
#' @description
#' Disables the specified Contributor Insights rules. When rules are disabled, they do not analyze log groups and do not incur costs.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_disable_insight_rules/](https://www.paws-r-sdk.com/docs/cloudwatch_disable_insight_rules/) for full documentation.
#'
#' @param RuleNames &#91;required&#93; An array of the rule names to disable. If you need to find out the names
#' of your rules, use
#' [`describe_insight_rules`][cloudwatch_describe_insight_rules].
#'
#' @keywords internal
#'
#' @rdname cloudwatch_disable_insight_rules
cloudwatch_disable_insight_rules <- function(RuleNames) {
  op <- new_operation(
    name = "DisableInsightRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$disable_insight_rules_input(RuleNames = RuleNames)
  output <- .cloudwatch$disable_insight_rules_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$disable_insight_rules <- cloudwatch_disable_insight_rules

#' Enables the actions for the specified alarms
#'
#' @description
#' Enables the actions for the specified alarms.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_enable_alarm_actions/](https://www.paws-r-sdk.com/docs/cloudwatch_enable_alarm_actions/) for full documentation.
#'
#' @param AlarmNames &#91;required&#93; The names of the alarms.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_enable_alarm_actions
cloudwatch_enable_alarm_actions <- function(AlarmNames) {
  op <- new_operation(
    name = "EnableAlarmActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$enable_alarm_actions_input(AlarmNames = AlarmNames)
  output <- .cloudwatch$enable_alarm_actions_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$enable_alarm_actions <- cloudwatch_enable_alarm_actions

#' Enables the specified Contributor Insights rules
#'
#' @description
#' Enables the specified Contributor Insights rules. When rules are enabled, they immediately begin analyzing log data.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_enable_insight_rules/](https://www.paws-r-sdk.com/docs/cloudwatch_enable_insight_rules/) for full documentation.
#'
#' @param RuleNames &#91;required&#93; An array of the rule names to enable. If you need to find out the names
#' of your rules, use
#' [`describe_insight_rules`][cloudwatch_describe_insight_rules].
#'
#' @keywords internal
#'
#' @rdname cloudwatch_enable_insight_rules
cloudwatch_enable_insight_rules <- function(RuleNames) {
  op <- new_operation(
    name = "EnableInsightRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$enable_insight_rules_input(RuleNames = RuleNames)
  output <- .cloudwatch$enable_insight_rules_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$enable_insight_rules <- cloudwatch_enable_insight_rules

#' Displays the details of the dashboard that you specify
#'
#' @description
#' Displays the details of the dashboard that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_get_dashboard/](https://www.paws-r-sdk.com/docs/cloudwatch_get_dashboard/) for full documentation.
#'
#' @param DashboardName &#91;required&#93; The name of the dashboard to be described.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_dashboard
cloudwatch_get_dashboard <- function(DashboardName) {
  op <- new_operation(
    name = "GetDashboard",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_dashboard_input(DashboardName = DashboardName)
  output <- .cloudwatch$get_dashboard_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_dashboard <- cloudwatch_get_dashboard

#' This operation returns the time series data collected by a Contributor
#' Insights rule
#'
#' @description
#' This operation returns the time series data collected by a Contributor Insights rule. The data includes the identity and number of contributors to the log group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_get_insight_rule_report/](https://www.paws-r-sdk.com/docs/cloudwatch_get_insight_rule_report/) for full documentation.
#'
#' @param RuleName &#91;required&#93; The name of the rule that you want to see data from.
#' @param StartTime &#91;required&#93; The start time of the data to use in the report. When used in a raw HTTP
#' Query API, it is formatted as `yyyy-MM-dd'T'HH:mm:ss`. For example,
#' `2019-07-01T23:59:59`.
#' @param EndTime &#91;required&#93; The end time of the data to use in the report. When used in a raw HTTP
#' Query API, it is formatted as `yyyy-MM-dd'T'HH:mm:ss`. For example,
#' `2019-07-01T23:59:59`.
#' @param Period &#91;required&#93; The period, in seconds, to use for the statistics in the
#' `InsightRuleMetricDatapoint` results.
#' @param MaxContributorCount The maximum number of contributors to include in the report. The range
#' is 1 to 100. If you omit this, the default of 10 is used.
#' @param Metrics Specifies which metrics to use for aggregation of contributor values for
#' the report. You can specify one or more of the following metrics:
#' 
#' -   `UniqueContributors` -- the number of unique contributors for each
#'     data point.
#' 
#' -   `MaxContributorValue` -- the value of the top contributor for each
#'     data point. The identity of the contributor might change for each
#'     data point in the graph.
#' 
#'     If this rule aggregates by COUNT, the top contributor for each data
#'     point is the contributor with the most occurrences in that period.
#'     If the rule aggregates by SUM, the top contributor is the
#'     contributor with the highest sum in the log field specified by the
#'     rule's `Value`, during that period.
#' 
#' -   `SampleCount` -- the number of data points matched by the rule.
#' 
#' -   `Sum` -- the sum of the values from all contributors during the time
#'     period represented by that data point.
#' 
#' -   `Minimum` -- the minimum value from a single observation during the
#'     time period represented by that data point.
#' 
#' -   `Maximum` -- the maximum value from a single observation during the
#'     time period represented by that data point.
#' 
#' -   `Average` -- the average value from all contributors during the time
#'     period represented by that data point.
#' @param OrderBy Determines what statistic to use to rank the contributors. Valid values
#' are `Sum` and `Maximum`.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_insight_rule_report
cloudwatch_get_insight_rule_report <- function(RuleName, StartTime, EndTime, Period, MaxContributorCount = NULL, Metrics = NULL, OrderBy = NULL) {
  op <- new_operation(
    name = "GetInsightRuleReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_insight_rule_report_input(RuleName = RuleName, StartTime = StartTime, EndTime = EndTime, Period = Period, MaxContributorCount = MaxContributorCount, Metrics = Metrics, OrderBy = OrderBy)
  output <- .cloudwatch$get_insight_rule_report_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_insight_rule_report <- cloudwatch_get_insight_rule_report

#' You can use the GetMetricData API to retrieve CloudWatch metric values
#'
#' @description
#' You can use the [`get_metric_data`][cloudwatch_get_metric_data] API to retrieve CloudWatch metric values. The operation can also include a CloudWatch Metrics Insights query, and one or more metric math functions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_data/](https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_data/) for full documentation.
#'
#' @param MetricDataQueries &#91;required&#93; The metric queries to be returned. A single
#' [`get_metric_data`][cloudwatch_get_metric_data] call can include as many
#' as 500 `MetricDataQuery` structures. Each of these structures can
#' specify either a metric to retrieve, a Metrics Insights query, or a math
#' expression to perform on retrieved data.
#' @param StartTime &#91;required&#93; The time stamp indicating the earliest data to be returned.
#' 
#' The value specified is inclusive; results include data points with the
#' specified time stamp.
#' 
#' CloudWatch rounds the specified time stamp as follows:
#' 
#' -   Start time less than 15 days ago - Round down to the nearest whole
#'     minute. For example, 12:32:34 is rounded down to 12:32:00.
#' 
#' -   Start time between 15 and 63 days ago - Round down to the nearest
#'     5-minute clock interval. For example, 12:32:34 is rounded down to
#'     12:30:00.
#' 
#' -   Start time greater than 63 days ago - Round down to the nearest
#'     1-hour clock interval. For example, 12:32:34 is rounded down to
#'     12:00:00.
#' 
#' If you set `Period` to 5, 10, or 30, the start time of your request is
#' rounded down to the nearest time that corresponds to even 5-, 10-, or
#' 30-second divisions of a minute. For example, if you make a query at
#' (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of
#' your request is rounded down and you receive data from 01:05:10 to
#' 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of
#' data, using a period of 5 seconds, you receive data timestamped between
#' 15:02:15 and 15:07:15.
#' 
#' For better performance, specify `StartTime` and `EndTime` values that
#' align with the value of the metric's `Period` and sync up with the
#' beginning and end of an hour. For example, if the `Period` of a metric
#' is 5 minutes, specifying 12:05 or 12:30 as `StartTime` can get a faster
#' response from CloudWatch than setting 12:07 or 12:29 as the `StartTime`.
#' @param EndTime &#91;required&#93; The time stamp indicating the latest data to be returned.
#' 
#' The value specified is exclusive; results include data points up to the
#' specified time stamp.
#' 
#' For better performance, specify `StartTime` and `EndTime` values that
#' align with the value of the metric's `Period` and sync up with the
#' beginning and end of an hour. For example, if the `Period` of a metric
#' is 5 minutes, specifying 12:05 or 12:30 as `EndTime` can get a faster
#' response from CloudWatch than setting 12:07 or 12:29 as the `EndTime`.
#' @param NextToken Include this value, if it was returned by the previous
#' [`get_metric_data`][cloudwatch_get_metric_data] operation, to get the
#' next set of data points.
#' @param ScanBy The order in which data points should be returned. `TimestampDescending`
#' returns the newest data first and paginates when the `MaxDatapoints`
#' limit is reached. `TimestampAscending` returns the oldest data first and
#' paginates when the `MaxDatapoints` limit is reached.
#' @param MaxDatapoints The maximum number of data points the request should return before
#' paginating. If you omit this, the default of 100,800 is used.
#' @param LabelOptions This structure includes the `Timezone` parameter, which you can use to
#' specify your time zone so that the labels of returned data display the
#' correct time for your time zone.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_data
cloudwatch_get_metric_data <- function(MetricDataQueries, StartTime, EndTime, NextToken = NULL, ScanBy = NULL, MaxDatapoints = NULL, LabelOptions = NULL) {
  op <- new_operation(
    name = "GetMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxDatapoints", output_token = "NextToken", result_key = list("MetricDataResults", "Messages"))
  )
  input <- .cloudwatch$get_metric_data_input(MetricDataQueries = MetricDataQueries, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, ScanBy = ScanBy, MaxDatapoints = MaxDatapoints, LabelOptions = LabelOptions)
  output <- .cloudwatch$get_metric_data_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_data <- cloudwatch_get_metric_data

#' Gets statistics for the specified metric
#'
#' @description
#' Gets statistics for the specified metric.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_statistics/](https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_statistics/) for full documentation.
#'
#' @param Namespace &#91;required&#93; The namespace of the metric, with or without spaces.
#' @param MetricName &#91;required&#93; The name of the metric, with or without spaces.
#' @param Dimensions The dimensions. If the metric contains multiple dimensions, you must
#' include a value for each dimension. CloudWatch treats each unique
#' combination of dimensions as a separate metric. If a specific
#' combination of dimensions was not published, you can't retrieve
#' statistics for it. You must specify the same dimensions that were used
#' when the metrics were created. For an example, see [Dimension
#' Combinations](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations)
#' in the *Amazon CloudWatch User Guide*. For more information about
#' specifying dimensions, see [Publishing
#' Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
#' in the *Amazon CloudWatch User Guide*.
#' @param StartTime &#91;required&#93; The time stamp that determines the first data point to return. Start
#' times are evaluated relative to the time that CloudWatch receives the
#' request.
#' 
#' The value specified is inclusive; results include data points with the
#' specified time stamp. In a raw HTTP query, the time stamp must be in ISO
#' 8601 UTC format (for example, 2016-10-03T23:00:00Z).
#' 
#' CloudWatch rounds the specified time stamp as follows:
#' 
#' -   Start time less than 15 days ago - Round down to the nearest whole
#'     minute. For example, 12:32:34 is rounded down to 12:32:00.
#' 
#' -   Start time between 15 and 63 days ago - Round down to the nearest
#'     5-minute clock interval. For example, 12:32:34 is rounded down to
#'     12:30:00.
#' 
#' -   Start time greater than 63 days ago - Round down to the nearest
#'     1-hour clock interval. For example, 12:32:34 is rounded down to
#'     12:00:00.
#' 
#' If you set `Period` to 5, 10, or 30, the start time of your request is
#' rounded down to the nearest time that corresponds to even 5-, 10-, or
#' 30-second divisions of a minute. For example, if you make a query at
#' (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of
#' your request is rounded down and you receive data from 01:05:10 to
#' 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of
#' data, using a period of 5 seconds, you receive data timestamped between
#' 15:02:15 and 15:07:15.
#' @param EndTime &#91;required&#93; The time stamp that determines the last data point to return.
#' 
#' The value specified is exclusive; results include data points up to the
#' specified time stamp. In a raw HTTP query, the time stamp must be in ISO
#' 8601 UTC format (for example, 2016-10-10T23:00:00Z).
#' @param Period &#91;required&#93; The granularity, in seconds, of the returned data points. For metrics
#' with regular resolution, a period can be as short as one minute (60
#' seconds) and must be a multiple of 60. For high-resolution metrics that
#' are collected at intervals of less than one minute, the period can be 1,
#' 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those
#' metrics stored by a [`put_metric_data`][cloudwatch_put_metric_data] call
#' that includes a `StorageResolution` of 1 second.
#' 
#' If the `StartTime` parameter specifies a time stamp that is greater than
#' 3 hours ago, you must specify the period as follows or no data points in
#' that time range is returned:
#' 
#' -   Start time between 3 hours and 15 days ago - Use a multiple of 60
#'     seconds (1 minute).
#' 
#' -   Start time between 15 and 63 days ago - Use a multiple of 300
#'     seconds (5 minutes).
#' 
#' -   Start time greater than 63 days ago - Use a multiple of 3600 seconds
#'     (1 hour).
#' @param Statistics The metric statistics, other than percentile. For percentile statistics,
#' use `ExtendedStatistics`. When calling
#' [`get_metric_statistics`][cloudwatch_get_metric_statistics], you must
#' specify either `Statistics` or `ExtendedStatistics`, but not both.
#' @param ExtendedStatistics The percentile statistics. Specify values between p0.0 and p100. When
#' calling [`get_metric_statistics`][cloudwatch_get_metric_statistics], you
#' must specify either `Statistics` or `ExtendedStatistics`, but not both.
#' Percentile statistics are not available for metrics when any of the
#' metric values are negative numbers.
#' @param Unit The unit for a given metric. If you omit `Unit`, all data that was
#' collected with any unit is returned, along with the corresponding units
#' that were specified when the data was reported to CloudWatch. If you
#' specify a unit, the operation returns only data that was collected with
#' that unit specified. If you specify a unit that does not match the data
#' collected, the results of the operation are null. CloudWatch does not
#' perform unit conversions.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_statistics
cloudwatch_get_metric_statistics <- function(Namespace, MetricName, Dimensions = NULL, StartTime, EndTime, Period, Statistics = NULL, ExtendedStatistics = NULL, Unit = NULL) {
  op <- new_operation(
    name = "GetMetricStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_metric_statistics_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, StartTime = StartTime, EndTime = EndTime, Period = Period, Statistics = Statistics, ExtendedStatistics = ExtendedStatistics, Unit = Unit)
  output <- .cloudwatch$get_metric_statistics_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_statistics <- cloudwatch_get_metric_statistics

#' Returns information about the metric stream that you specify
#'
#' @description
#' Returns information about the metric stream that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_stream/](https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_stream/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the metric stream to retrieve information about.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_stream
cloudwatch_get_metric_stream <- function(Name) {
  op <- new_operation(
    name = "GetMetricStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_metric_stream_input(Name = Name)
  output <- .cloudwatch$get_metric_stream_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_stream <- cloudwatch_get_metric_stream

#' You can use the GetMetricWidgetImage API to retrieve a snapshot graph of
#' one or more Amazon CloudWatch metrics as a bitmap image
#'
#' @description
#' You can use the [`get_metric_widget_image`][cloudwatch_get_metric_widget_image] API to retrieve a snapshot graph of one or more Amazon CloudWatch metrics as a bitmap image. You can then embed this image into your services and products, such as wiki pages, reports, and documents. You could also retrieve images regularly, such as every minute, and create your own custom live dashboard.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_widget_image/](https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_widget_image/) for full documentation.
#'
#' @param MetricWidget &#91;required&#93; A JSON string that defines the bitmap graph to be retrieved. The string
#' includes the metrics to include in the graph, statistics, annotations,
#' title, axis limits, and so on. You can include only one `MetricWidget`
#' parameter in each
#' [`get_metric_widget_image`][cloudwatch_get_metric_widget_image] call.
#' 
#' For more information about the syntax of `MetricWidget` see
#' [GetMetricWidgetImage: Metric Widget Structure and
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html).
#' 
#' If any metric on the graph could not load all the requested data points,
#' an orange triangle with an exclamation point appears next to the graph
#' legend.
#' @param OutputFormat The format of the resulting image. Only PNG images are supported.
#' 
#' The default is `png`. If you specify `png`, the API returns an HTTP
#' response with the content-type set to `text/xml`. The image data is in a
#' `MetricWidgetImage` field. For example:
#' 
#' ` <GetMetricWidgetImageResponse xmlns=<URLstring>>`
#' 
#' ` <GetMetricWidgetImageResult>`
#' 
#' ` <MetricWidgetImage>`
#' 
#' ` iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...`
#' 
#' ` </MetricWidgetImage>`
#' 
#' ` </GetMetricWidgetImageResult>`
#' 
#' ` <ResponseMetadata>`
#' 
#' ` <RequestId>6f0d4192-4d42-11e8-82c1-f539a07e0e3b</RequestId>`
#' 
#' ` </ResponseMetadata>`
#' 
#' `</GetMetricWidgetImageResponse>`
#' 
#' The `image/png` setting is intended only for custom HTTP requests. For
#' most use cases, and all actions using an Amazon Web Services SDK, you
#' should use `png`. If you specify `image/png`, the HTTP response has a
#' content-type set to `image/png`, and the body of the response is a PNG
#' image.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_get_metric_widget_image
cloudwatch_get_metric_widget_image <- function(MetricWidget, OutputFormat = NULL) {
  op <- new_operation(
    name = "GetMetricWidgetImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$get_metric_widget_image_input(MetricWidget = MetricWidget, OutputFormat = OutputFormat)
  output <- .cloudwatch$get_metric_widget_image_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$get_metric_widget_image <- cloudwatch_get_metric_widget_image

#' Returns a list of the dashboards for your account
#'
#' @description
#' Returns a list of the dashboards for your account. If you include `DashboardNamePrefix`, only those dashboards with names starting with the prefix are listed. Otherwise, all dashboards in your account are listed.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_list_dashboards/](https://www.paws-r-sdk.com/docs/cloudwatch_list_dashboards/) for full documentation.
#'
#' @param DashboardNamePrefix If you specify this parameter, only the dashboards with names starting
#' with the specified string are listed. The maximum length is 255, and
#' valid characters are A-Z, a-z, 0-9, ".", "-", and "_".
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_dashboards
cloudwatch_list_dashboards <- function(DashboardNamePrefix = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDashboards",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "DashboardEntries")
  )
  input <- .cloudwatch$list_dashboards_input(DashboardNamePrefix = DashboardNamePrefix, NextToken = NextToken)
  output <- .cloudwatch$list_dashboards_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_dashboards <- cloudwatch_list_dashboards

#' Returns a list that contains the number of managed Contributor Insights
#' rules in your account
#'
#' @description
#' Returns a list that contains the number of managed Contributor Insights rules in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_list_managed_insight_rules/](https://www.paws-r-sdk.com/docs/cloudwatch_list_managed_insight_rules/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of an Amazon Web Services resource that has managed Contributor
#' Insights rules.
#' @param NextToken Include this value to get the next set of rules if the value was
#' returned by the previous operation.
#' @param MaxResults The maximum number of results to return in one operation. If you omit
#' this parameter, the default number is used. The default number is `100`.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_managed_insight_rules
cloudwatch_list_managed_insight_rules <- function(ResourceARN, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListManagedInsightRules",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .cloudwatch$list_managed_insight_rules_input(ResourceARN = ResourceARN, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudwatch$list_managed_insight_rules_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_managed_insight_rules <- cloudwatch_list_managed_insight_rules

#' Returns a list of metric streams in this account
#'
#' @description
#' Returns a list of metric streams in this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_list_metric_streams/](https://www.paws-r-sdk.com/docs/cloudwatch_list_metric_streams/) for full documentation.
#'
#' @param NextToken Include this value, if it was returned by the previous call, to get the
#' next set of metric streams.
#' @param MaxResults The maximum number of results to return in one operation.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_metric_streams
cloudwatch_list_metric_streams <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMetricStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .cloudwatch$list_metric_streams_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudwatch$list_metric_streams_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_metric_streams <- cloudwatch_list_metric_streams

#' List the specified metrics
#'
#' @description
#' List the specified metrics. You can use the returned metrics with [`get_metric_data`][cloudwatch_get_metric_data] or [`get_metric_statistics`][cloudwatch_get_metric_statistics] to get statistical data.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_list_metrics/](https://www.paws-r-sdk.com/docs/cloudwatch_list_metrics/) for full documentation.
#'
#' @param Namespace The metric namespace to filter against. Only the namespace that matches
#' exactly will be returned.
#' @param MetricName The name of the metric to filter against. Only the metrics with names
#' that match exactly will be returned.
#' @param Dimensions The dimensions to filter against. Only the dimensions that match exactly
#' will be returned.
#' @param NextToken The token returned by a previous call to indicate that there is more
#' data available.
#' @param RecentlyActive To filter the results to show only metrics that have had data points
#' published in the past three hours, specify this parameter with a value
#' of `PT3H`. This is the only valid value for this parameter.
#' 
#' The results that are returned are an approximation of the value you
#' specify. There is a low probability that the returned results include
#' metrics with last published data as much as 40 minutes more than the
#' specified time interval.
#' @param IncludeLinkedAccounts If you are using this operation in a monitoring account, specify `true`
#' to include metrics from source accounts in the returned data.
#' 
#' The default is `false`.
#' @param OwningAccount When you use this operation in a monitoring account, use this field to
#' return metrics only from one source account. To do so, specify that
#' source account ID in this field, and also specify `true` for
#' `IncludeLinkedAccounts`.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_metrics
cloudwatch_list_metrics <- function(Namespace = NULL, MetricName = NULL, Dimensions = NULL, NextToken = NULL, RecentlyActive = NULL, IncludeLinkedAccounts = NULL, OwningAccount = NULL) {
  op <- new_operation(
    name = "ListMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = list( "Metrics", "OwningAccounts"))
  )
  input <- .cloudwatch$list_metrics_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, NextToken = NextToken, RecentlyActive = RecentlyActive, IncludeLinkedAccounts = IncludeLinkedAccounts, OwningAccount = OwningAccount)
  output <- .cloudwatch$list_metrics_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_metrics <- cloudwatch_list_metrics

#' Displays the tags associated with a CloudWatch resource
#'
#' @description
#' Displays the tags associated with a CloudWatch resource. Currently, alarms and Contributor Insights rules support tagging.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatch_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch resource that you want to view tags for.
#' 
#' The ARN format of an alarm is
#' `arn:aws:cloudwatch:Region:account-id:alarm:alarm-name `
#' 
#' The ARN format of a Contributor Insights rule is
#' `arn:aws:cloudwatch:Region:account-id:insight-rule/insight-rule-name `
#' 
#' For more information about ARN format, see [Resource Types Defined by
#' Amazon
#' CloudWatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_list_tags_for_resource
cloudwatch_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloudwatch$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$list_tags_for_resource <- cloudwatch_list_tags_for_resource

#' Creates an anomaly detection model for a CloudWatch metric
#'
#' @description
#' Creates an anomaly detection model for a CloudWatch metric. You can use the model to display a band of expected normal values when the metric is graphed.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_anomaly_detector/](https://www.paws-r-sdk.com/docs/cloudwatch_put_anomaly_detector/) for full documentation.
#'
#' @param Namespace The namespace of the metric to create the anomaly detection model for.
#' @param MetricName The name of the metric to create the anomaly detection model for.
#' @param Dimensions The metric dimensions to create the anomaly detection model for.
#' @param Stat The statistic to use for the metric and the anomaly detection model.
#' @param Configuration The configuration specifies details about how the anomaly detection
#' model is to be trained, including time ranges to exclude when training
#' and updating the model. You can specify as many as 10 time ranges.
#' 
#' The configuration can also include the time zone to use for the metric.
#' @param SingleMetricAnomalyDetector A single metric anomaly detector to be created.
#' 
#' When using `SingleMetricAnomalyDetector`, you cannot include the
#' following parameters in the same operation:
#' 
#' -   `Dimensions`
#' 
#' -   `MetricName`
#' 
#' -   `Namespace`
#' 
#' -   `Stat`
#' 
#' -   the `MetricMatchAnomalyDetector` parameters of
#'     `PutAnomalyDetectorInput`
#' 
#' Instead, specify the single metric anomaly detector attributes as part
#' of the property `SingleMetricAnomalyDetector`.
#' @param MetricMathAnomalyDetector The metric math anomaly detector to be created.
#' 
#' When using `MetricMathAnomalyDetector`, you cannot include the following
#' parameters in the same operation:
#' 
#' -   `Dimensions`
#' 
#' -   `MetricName`
#' 
#' -   `Namespace`
#' 
#' -   `Stat`
#' 
#' -   the `SingleMetricAnomalyDetector` parameters of
#'     `PutAnomalyDetectorInput`
#' 
#' Instead, specify the metric math anomaly detector attributes as part of
#' the property `MetricMathAnomalyDetector`.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_anomaly_detector
cloudwatch_put_anomaly_detector <- function(Namespace = NULL, MetricName = NULL, Dimensions = NULL, Stat = NULL, Configuration = NULL, SingleMetricAnomalyDetector = NULL, MetricMathAnomalyDetector = NULL) {
  op <- new_operation(
    name = "PutAnomalyDetector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_anomaly_detector_input(Namespace = Namespace, MetricName = MetricName, Dimensions = Dimensions, Stat = Stat, Configuration = Configuration, SingleMetricAnomalyDetector = SingleMetricAnomalyDetector, MetricMathAnomalyDetector = MetricMathAnomalyDetector)
  output <- .cloudwatch$put_anomaly_detector_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_anomaly_detector <- cloudwatch_put_anomaly_detector

#' Creates or updates a composite alarm
#'
#' @description
#' Creates or updates a *composite alarm*. When you create a composite alarm, you specify a rule expression for the alarm that takes into account the alarm states of other alarms that you have created. The composite alarm goes into ALARM state only if all conditions of the rule are met.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_composite_alarm/](https://www.paws-r-sdk.com/docs/cloudwatch_put_composite_alarm/) for full documentation.
#'
#' @param ActionsEnabled Indicates whether actions should be executed during any changes to the
#' alarm state of the composite alarm. The default is `TRUE`.
#' @param AlarmActions The actions to execute when this alarm transitions to the `ALARM` state
#' from any other state. Each action is specified as an Amazon Resource
#' Name (ARN).
#' 
#' Valid Values: `arn:aws:sns:region:account-id:sns-topic-name ` |
#' `arn:aws:ssm:region:account-id:opsitem:severity `
#' @param AlarmDescription The description for the composite alarm.
#' @param AlarmName &#91;required&#93; The name for the composite alarm. This name must be unique within the
#' Region.
#' @param AlarmRule &#91;required&#93; An expression that specifies which other alarms are to be evaluated to
#' determine this composite alarm's state. For each alarm that you
#' reference, you designate a function that specifies whether that alarm
#' needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You
#' can use operators (AND, OR and NOT) to combine multiple functions in a
#' single expression. You can use parenthesis to logically group the
#' functions in your expression.
#' 
#' You can use either alarm names or ARNs to reference the other alarms
#' that are to be evaluated.
#' 
#' Functions can include the following:
#' 
#' -   `ALARM("alarm-name or alarm-ARN")` is TRUE if the named alarm is in
#'     ALARM state.
#' 
#' -   `OK("alarm-name or alarm-ARN")` is TRUE if the named alarm is in OK
#'     state.
#' 
#' -   `INSUFFICIENT_DATA("alarm-name or alarm-ARN")` is TRUE if the named
#'     alarm is in INSUFFICIENT_DATA state.
#' 
#' -   `TRUE` always evaluates to TRUE.
#' 
#' -   `FALSE` always evaluates to FALSE.
#' 
#' TRUE and FALSE are useful for testing a complex `AlarmRule` structure,
#' and for testing your alarm actions.
#' 
#' Alarm names specified in `AlarmRule` can be surrounded with
#' double-quotes ("), but do not have to be.
#' 
#' The following are some examples of `AlarmRule`:
#' 
#' -   `ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)`
#'     specifies that the composite alarm goes into ALARM state only if
#'     both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in
#'     ALARM state.
#' 
#' -   `ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)`
#'     specifies that the alarm goes to ALARM state if
#'     CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is
#'     not in ALARM state. This example reduces alarm noise during a known
#'     deployment window.
#' 
#' -   `(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)`
#'     goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh
#'     is in ALARM state, and if NetworkOutTooHigh is in OK state. This
#'     provides another example of using a composite alarm to prevent
#'     noise. This rule ensures that you are not notified with an alarm
#'     action on high CPU or disk usage if a known network problem is also
#'     occurring.
#' 
#' The `AlarmRule` can specify as many as 100 "children" alarms. The
#' `AlarmRule` expression can have as many as 500 elements. Elements are
#' child alarms, TRUE or FALSE statements, and parentheses.
#' @param InsufficientDataActions The actions to execute when this alarm transitions to the
#' `INSUFFICIENT_DATA` state from any other state. Each action is specified
#' as an Amazon Resource Name (ARN).
#' 
#' Valid Values: `arn:aws:sns:region:account-id:sns-topic-name `
#' @param OKActions The actions to execute when this alarm transitions to an `OK` state from
#' any other state. Each action is specified as an Amazon Resource Name
#' (ARN).
#' 
#' Valid Values: `arn:aws:sns:region:account-id:sns-topic-name `
#' @param Tags A list of key-value pairs to associate with the composite alarm. You can
#' associate as many as 50 tags with an alarm.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions, by granting a user permission to
#' access or change only resources with certain tag values.
#' @param ActionsSuppressor Actions will be suppressed if the suppressor alarm is in the `ALARM`
#' state. `ActionsSuppressor` can be an AlarmName or an Amazon Resource
#' Name (ARN) from an existing alarm.
#' @param ActionsSuppressorWaitPeriod The maximum time in seconds that the composite alarm waits for the
#' suppressor alarm to go into the `ALARM` state. After this time, the
#' composite alarm performs its actions.
#' 
#' `WaitPeriod` is required only when `ActionsSuppressor` is specified.
#' @param ActionsSuppressorExtensionPeriod The maximum time in seconds that the composite alarm waits after
#' suppressor alarm goes out of the `ALARM` state. After this time, the
#' composite alarm performs its actions.
#' 
#' `ExtensionPeriod` is required only when `ActionsSuppressor` is
#' specified.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_composite_alarm
cloudwatch_put_composite_alarm <- function(ActionsEnabled = NULL, AlarmActions = NULL, AlarmDescription = NULL, AlarmName, AlarmRule, InsufficientDataActions = NULL, OKActions = NULL, Tags = NULL, ActionsSuppressor = NULL, ActionsSuppressorWaitPeriod = NULL, ActionsSuppressorExtensionPeriod = NULL) {
  op <- new_operation(
    name = "PutCompositeAlarm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_composite_alarm_input(ActionsEnabled = ActionsEnabled, AlarmActions = AlarmActions, AlarmDescription = AlarmDescription, AlarmName = AlarmName, AlarmRule = AlarmRule, InsufficientDataActions = InsufficientDataActions, OKActions = OKActions, Tags = Tags, ActionsSuppressor = ActionsSuppressor, ActionsSuppressorWaitPeriod = ActionsSuppressorWaitPeriod, ActionsSuppressorExtensionPeriod = ActionsSuppressorExtensionPeriod)
  output <- .cloudwatch$put_composite_alarm_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_composite_alarm <- cloudwatch_put_composite_alarm

#' Creates a dashboard if it does not already exist, or updates an existing
#' dashboard
#'
#' @description
#' Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_dashboard/](https://www.paws-r-sdk.com/docs/cloudwatch_put_dashboard/) for full documentation.
#'
#' @param DashboardName &#91;required&#93; The name of the dashboard. If a dashboard with this name already exists,
#' this call modifies that dashboard, replacing its current contents.
#' Otherwise, a new dashboard is created. The maximum length is 255, and
#' valid characters are A-Z, a-z, 0-9, "-", and "_". This parameter is
#' required.
#' @param DashboardBody &#91;required&#93; The detailed information about the dashboard in JSON format, including
#' the widgets to include and their location on the dashboard. This
#' parameter is required.
#' 
#' For more information about the syntax, see [Dashboard Body Structure and
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_dashboard
cloudwatch_put_dashboard <- function(DashboardName, DashboardBody) {
  op <- new_operation(
    name = "PutDashboard",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_dashboard_input(DashboardName = DashboardName, DashboardBody = DashboardBody)
  output <- .cloudwatch$put_dashboard_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_dashboard <- cloudwatch_put_dashboard

#' Creates a Contributor Insights rule
#'
#' @description
#' Creates a Contributor Insights rule. Rules evaluate log events in a CloudWatch Logs log group, enabling you to find contributor data for the log events in that log group. For more information, see [Using Contributor Insights to Analyze High-Cardinality Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_insight_rule/](https://www.paws-r-sdk.com/docs/cloudwatch_put_insight_rule/) for full documentation.
#'
#' @param RuleName &#91;required&#93; A unique name for the rule.
#' @param RuleState The state of the rule. Valid values are ENABLED and DISABLED.
#' @param RuleDefinition &#91;required&#93; The definition of the rule, as a JSON object. For details on the valid
#' syntax, see [Contributor Insights Rule
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html).
#' @param Tags A list of key-value pairs to associate with the Contributor Insights
#' rule. You can associate as many as 50 tags with a rule.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions, by granting a user permission to
#' access or change only the resources that have certain tag values.
#' 
#' To be able to associate tags with a rule, you must have the
#' `cloudwatch:TagResource` permission in addition to the
#' `cloudwatch:PutInsightRule` permission.
#' 
#' If you are using this operation to update an existing Contributor
#' Insights rule, any tags you specify in this parameter are ignored. To
#' change the tags of an existing rule, use
#' [`tag_resource`][cloudwatch_tag_resource].
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_insight_rule
cloudwatch_put_insight_rule <- function(RuleName, RuleState = NULL, RuleDefinition, Tags = NULL) {
  op <- new_operation(
    name = "PutInsightRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_insight_rule_input(RuleName = RuleName, RuleState = RuleState, RuleDefinition = RuleDefinition, Tags = Tags)
  output <- .cloudwatch$put_insight_rule_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_insight_rule <- cloudwatch_put_insight_rule

#' Creates a managed Contributor Insights rule for a specified Amazon Web
#' Services resource
#'
#' @description
#' Creates a managed Contributor Insights rule for a specified Amazon Web Services resource. When you enable a managed rule, you create a Contributor Insights rule that collects data from Amazon Web Services services. You cannot edit these rules with [`put_insight_rule`][cloudwatch_put_insight_rule]. The rules can be enabled, disabled, and deleted using [`enable_insight_rules`][cloudwatch_enable_insight_rules], [`disable_insight_rules`][cloudwatch_disable_insight_rules], and [`delete_insight_rules`][cloudwatch_delete_insight_rules]. If a previously created managed rule is currently disabled, a subsequent call to this API will re-enable it. Use [`list_managed_insight_rules`][cloudwatch_list_managed_insight_rules] to describe all available rules.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_managed_insight_rules/](https://www.paws-r-sdk.com/docs/cloudwatch_put_managed_insight_rules/) for full documentation.
#'
#' @param ManagedRules &#91;required&#93; A list of `ManagedRules` to enable.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_managed_insight_rules
cloudwatch_put_managed_insight_rules <- function(ManagedRules) {
  op <- new_operation(
    name = "PutManagedInsightRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_managed_insight_rules_input(ManagedRules = ManagedRules)
  output <- .cloudwatch$put_managed_insight_rules_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_managed_insight_rules <- cloudwatch_put_managed_insight_rules

#' Creates or updates an alarm and associates it with the specified metric,
#' metric math expression, anomaly detection model, or Metrics Insights
#' query
#'
#' @description
#' Creates or updates an alarm and associates it with the specified metric, metric math expression, anomaly detection model, or Metrics Insights query. For more information about using a Metrics Insights query for an alarm, see [Create alarms on Metrics Insights queries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Metrics_Insights_Alarm.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_alarm/](https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_alarm/) for full documentation.
#'
#' @param AlarmName &#91;required&#93; The name for the alarm. This name must be unique within the Region.
#' 
#' The name must contain only UTF-8 characters, and can't contain ASCII
#' control characters
#' @param AlarmDescription The description for the alarm.
#' @param ActionsEnabled Indicates whether actions should be executed during any changes to the
#' alarm state. The default is `TRUE`.
#' @param OKActions The actions to execute when this alarm transitions to an `OK` state from
#' any other state. Each action is specified as an Amazon Resource Name
#' (ARN). Valid values:
#' 
#' **EC2 actions:**
#' 
#' -   `arn:aws:automate:region:ec2:stop`
#' 
#' -   `arn:aws:automate:region:ec2:terminate`
#' 
#' -   `arn:aws:automate:region:ec2:reboot`
#' 
#' -   `arn:aws:automate:region:ec2:recover`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Recover/1.0`
#' 
#' **Autoscaling action:**
#' 
#' -   `arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name `
#' 
#' **SNS notification action:**
#' 
#' -   `arn:aws:sns:region:account-id:sns-topic-name:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name `
#' 
#' **SSM integration actions:**
#' 
#' -   `arn:aws:ssm:region:account-id:opsitem:severity#CATEGORY=category-name `
#' 
#' -   `arn:aws:ssm-incidents::account-id:responseplan/response-plan-name `
#' @param AlarmActions The actions to execute when this alarm transitions to the `ALARM` state
#' from any other state. Each action is specified as an Amazon Resource
#' Name (ARN). Valid values:
#' 
#' **EC2 actions:**
#' 
#' -   `arn:aws:automate:region:ec2:stop`
#' 
#' -   `arn:aws:automate:region:ec2:terminate`
#' 
#' -   `arn:aws:automate:region:ec2:reboot`
#' 
#' -   `arn:aws:automate:region:ec2:recover`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Recover/1.0`
#' 
#' **Autoscaling action:**
#' 
#' -   `arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name `
#' 
#' **SNS notification action:**
#' 
#' -   `arn:aws:sns:region:account-id:sns-topic-name:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name `
#' 
#' **SSM integration actions:**
#' 
#' -   `arn:aws:ssm:region:account-id:opsitem:severity#CATEGORY=category-name `
#' 
#' -   `arn:aws:ssm-incidents::account-id:responseplan/response-plan-name `
#' @param InsufficientDataActions The actions to execute when this alarm transitions to the
#' `INSUFFICIENT_DATA` state from any other state. Each action is specified
#' as an Amazon Resource Name (ARN). Valid values:
#' 
#' **EC2 actions:**
#' 
#' -   `arn:aws:automate:region:ec2:stop`
#' 
#' -   `arn:aws:automate:region:ec2:terminate`
#' 
#' -   `arn:aws:automate:region:ec2:reboot`
#' 
#' -   `arn:aws:automate:region:ec2:recover`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Stop/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Terminate/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Reboot/1.0`
#' 
#' -   `arn:aws:swf:region:account-id:action/actions/AWS_EC2.InstanceId.Recover/1.0`
#' 
#' **Autoscaling action:**
#' 
#' -   `arn:aws:autoscaling:region:account-id:scalingPolicy:policy-id:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name `
#' 
#' **SNS notification action:**
#' 
#' -   `arn:aws:sns:region:account-id:sns-topic-name:autoScalingGroupName/group-friendly-name:policyName/policy-friendly-name `
#' 
#' **SSM integration actions:**
#' 
#' -   `arn:aws:ssm:region:account-id:opsitem:severity#CATEGORY=category-name `
#' 
#' -   `arn:aws:ssm-incidents::account-id:responseplan/response-plan-name `
#' @param MetricName The name for the metric associated with the alarm. For each
#' [`put_metric_alarm`][cloudwatch_put_metric_alarm] operation, you must
#' specify either `MetricName` or a `Metrics` array.
#' 
#' If you are creating an alarm based on a math expression, you cannot
#' specify this parameter, or any of the `Namespace`, `Dimensions`,
#' `Period`, `Unit`, `Statistic`, or `ExtendedStatistic` parameters.
#' Instead, you specify all this information in the `Metrics` array.
#' @param Namespace The namespace for the metric associated specified in `MetricName`.
#' @param Statistic The statistic for the metric specified in `MetricName`, other than
#' percentile. For percentile statistics, use `ExtendedStatistic`. When you
#' call [`put_metric_alarm`][cloudwatch_put_metric_alarm] and specify a
#' `MetricName`, you must specify either `Statistic` or
#' `ExtendedStatistic,` but not both.
#' @param ExtendedStatistic The extended statistic for the metric specified in `MetricName`. When
#' you call [`put_metric_alarm`][cloudwatch_put_metric_alarm] and specify a
#' `MetricName`, you must specify either `Statistic` or `ExtendedStatistic`
#' but not both.
#' 
#' If you specify `ExtendedStatistic`, the following are valid values:
#' 
#' -   `p90`
#' 
#' -   `tm90`
#' 
#' -   `tc90`
#' 
#' -   `ts90`
#' 
#' -   `wm90`
#' 
#' -   `IQM`
#' 
#' -   `PR(n:m)` where n and m are values of the metric
#' 
#' -   `TC(X%:X%)` where X is between 10 and 90 inclusive.
#' 
#' -   `TM(X%:X%)` where X is between 10 and 90 inclusive.
#' 
#' -   `TS(X%:X%)` where X is between 10 and 90 inclusive.
#' 
#' -   `WM(X%:X%)` where X is between 10 and 90 inclusive.
#' 
#' For more information about these extended statistics, see [CloudWatch
#' statistics
#' definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
#' @param Dimensions The dimensions for the metric specified in `MetricName`.
#' @param Period The length, in seconds, used each time the metric specified in
#' `MetricName` is evaluated. Valid values are 10, 30, and any multiple of
#' 60.
#' 
#' `Period` is required for alarms based on static thresholds. If you are
#' creating an alarm based on a metric math expression, you specify the
#' period for each metric within the objects in the `Metrics` array.
#' 
#' Be sure to specify 10 or 30 only for metrics that are stored by a
#' [`put_metric_data`][cloudwatch_put_metric_data] call with a
#' `StorageResolution` of 1. If you specify a period of 10 or 30 for a
#' metric that does not have sub-minute resolution, the alarm still
#' attempts to gather data at the period rate that you specify. In this
#' case, it does not receive data for the attempts that do not correspond
#' to a one-minute data resolution, and the alarm might often lapse into
#' INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a
#' high-resolution alarm, which has a higher charge than other alarms. For
#' more information about pricing, see [Amazon CloudWatch
#' Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' An alarm's total current evaluation period can be no longer than one
#' day, so `Period` multiplied by `EvaluationPeriods` cannot be more than
#' 86,400 seconds.
#' @param Unit The unit of measure for the statistic. For example, the units for the
#' Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the
#' number of bytes that an instance receives on all network interfaces. You
#' can also specify a unit when you create a custom metric. Units help
#' provide conceptual meaning to your data. Metric data points that specify
#' a unit of measure, such as Percent, are aggregated separately. If you
#' are creating an alarm based on a metric math expression, you can specify
#' the unit for each metric (if needed) within the objects in the `Metrics`
#' array.
#' 
#' If you don't specify `Unit`, CloudWatch retrieves all unit types that
#' have been published for the metric and attempts to evaluate the alarm.
#' Usually, metrics are published with only one unit, so the alarm works as
#' intended.
#' 
#' However, if the metric is published with multiple types of units and you
#' don't specify a unit, the alarm's behavior is not defined and it behaves
#' unpredictably.
#' 
#' We recommend omitting `Unit` so that you don't inadvertently specify an
#' incorrect unit that is not published for this metric. Doing so causes
#' the alarm to be stuck in the `INSUFFICIENT DATA` state.
#' @param EvaluationPeriods &#91;required&#93; The number of periods over which data is compared to the specified
#' threshold. If you are setting an alarm that requires that a number of
#' consecutive data points be breaching to trigger the alarm, this value
#' specifies that number. If you are setting an "M out of N" alarm, this
#' value is the N.
#' 
#' An alarm's total current evaluation period can be no longer than one
#' day, so this number multiplied by `Period` cannot be more than 86,400
#' seconds.
#' @param DatapointsToAlarm The number of data points that must be breaching to trigger the alarm.
#' This is used only if you are setting an "M out of N" alarm. In that
#' case, this value is the M. For more information, see [Evaluating an
#' Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation)
#' in the *Amazon CloudWatch User Guide*.
#' @param Threshold The value against which the specified statistic is compared.
#' 
#' This parameter is required for alarms based on static thresholds, but
#' should not be used for alarms based on anomaly detection models.
#' @param ComparisonOperator &#91;required&#93; The arithmetic operation to use when comparing the specified statistic
#' and threshold. The specified statistic value is used as the first
#' operand.
#' 
#' The values `LessThanLowerOrGreaterThanUpperThreshold`,
#' `LessThanLowerThreshold`, and `GreaterThanUpperThreshold` are used only
#' for alarms based on anomaly detection models.
#' @param TreatMissingData Sets how this alarm is to handle missing data points. If
#' `TreatMissingData` is omitted, the default behavior of `missing` is
#' used. For more information, see [Configuring How CloudWatch Alarms
#' Treats Missing
#' Data](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data).
#' 
#' Valid Values: `breaching | notBreaching | ignore | missing`
#' 
#' Alarms that evaluate metrics in the `AWS/DynamoDB` namespace always
#' `ignore` missing data even if you choose a different option for
#' `TreatMissingData`. When an `AWS/DynamoDB` metric has missing data,
#' alarms that evaluate that metric remain in their current state.
#' @param EvaluateLowSampleCountPercentile Used only for alarms based on percentiles. If you specify `ignore`, the
#' alarm state does not change during periods with too few data points to
#' be statistically significant. If you specify `evaluate` or omit this
#' parameter, the alarm is always evaluated and possibly changes state no
#' matter how many data points are available. For more information, see
#' [Percentile-Based CloudWatch Alarms and Low Data
#' Samples](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples).
#' 
#' Valid Values: `evaluate | ignore`
#' @param Metrics An array of `MetricDataQuery` structures that enable you to create an
#' alarm based on the result of a metric math expression. For each
#' [`put_metric_alarm`][cloudwatch_put_metric_alarm] operation, you must
#' specify either `MetricName` or a `Metrics` array.
#' 
#' Each item in the `Metrics` array either retrieves a metric or performs a
#' math expression.
#' 
#' One item in the `Metrics` array is the expression that the alarm
#' watches. You designate this expression by setting `ReturnData` to true
#' for this object in the array. For more information, see
#' [MetricDataQuery](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDataQuery.html).
#' 
#' If you use the `Metrics` parameter, you cannot include the `Namespace`,
#' `MetricName`, `Dimensions`, `Period`, `Unit`, `Statistic`, or
#' `ExtendedStatistic` parameters of
#' [`put_metric_alarm`][cloudwatch_put_metric_alarm] in the same operation.
#' Instead, you retrieve the metrics you are using in your math expression
#' as part of the `Metrics` array.
#' @param Tags A list of key-value pairs to associate with the alarm. You can associate
#' as many as 50 tags with an alarm. To be able to associate tags with the
#' alarm when you create the alarm, you must have the
#' `cloudwatch:TagResource` permission.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' If you are using this operation to update an existing alarm, any tags
#' you specify in this parameter are ignored. To change the tags of an
#' existing alarm, use [`tag_resource`][cloudwatch_tag_resource] or
#' [`untag_resource`][cloudwatch_untag_resource].
#' @param ThresholdMetricId If this is an alarm based on an anomaly detection model, make this value
#' match the ID of the `ANOMALY_DETECTION_BAND` function.
#' 
#' For an example of how to use this parameter, see the **Anomaly Detection
#' Model Alarm** example on this page.
#' 
#' If your alarm uses this parameter, it cannot have Auto Scaling actions.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_metric_alarm
cloudwatch_put_metric_alarm <- function(AlarmName, AlarmDescription = NULL, ActionsEnabled = NULL, OKActions = NULL, AlarmActions = NULL, InsufficientDataActions = NULL, MetricName = NULL, Namespace = NULL, Statistic = NULL, ExtendedStatistic = NULL, Dimensions = NULL, Period = NULL, Unit = NULL, EvaluationPeriods, DatapointsToAlarm = NULL, Threshold = NULL, ComparisonOperator, TreatMissingData = NULL, EvaluateLowSampleCountPercentile = NULL, Metrics = NULL, Tags = NULL, ThresholdMetricId = NULL) {
  op <- new_operation(
    name = "PutMetricAlarm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_metric_alarm_input(AlarmName = AlarmName, AlarmDescription = AlarmDescription, ActionsEnabled = ActionsEnabled, OKActions = OKActions, AlarmActions = AlarmActions, InsufficientDataActions = InsufficientDataActions, MetricName = MetricName, Namespace = Namespace, Statistic = Statistic, ExtendedStatistic = ExtendedStatistic, Dimensions = Dimensions, Period = Period, Unit = Unit, EvaluationPeriods = EvaluationPeriods, DatapointsToAlarm = DatapointsToAlarm, Threshold = Threshold, ComparisonOperator = ComparisonOperator, TreatMissingData = TreatMissingData, EvaluateLowSampleCountPercentile = EvaluateLowSampleCountPercentile, Metrics = Metrics, Tags = Tags, ThresholdMetricId = ThresholdMetricId)
  output <- .cloudwatch$put_metric_alarm_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_metric_alarm <- cloudwatch_put_metric_alarm

#' Publishes metric data points to Amazon CloudWatch
#'
#' @description
#' Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metric. If the specified metric does not exist, CloudWatch creates the metric. When CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to [`list_metrics`][cloudwatch_list_metrics].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_data/](https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_data/) for full documentation.
#'
#' @param Namespace &#91;required&#93; The namespace for the metric data. You can use ASCII characters for the
#' namespace, except for control characters which are not supported.
#' 
#' To avoid conflicts with Amazon Web Services service namespaces, you
#' should not specify a namespace that begins with `AWS/`
#' @param MetricData &#91;required&#93; The data for the metric. The array can include no more than 1000 metrics
#' per call.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_metric_data
cloudwatch_put_metric_data <- function(Namespace, MetricData) {
  op <- new_operation(
    name = "PutMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_metric_data_input(Namespace = Namespace, MetricData = MetricData)
  output <- .cloudwatch$put_metric_data_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_metric_data <- cloudwatch_put_metric_data

#' Creates or updates a metric stream
#'
#' @description
#' Creates or updates a metric stream. Metric streams can automatically stream CloudWatch metrics to Amazon Web Services destinations, including Amazon S3, and to many third-party solutions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_stream/](https://www.paws-r-sdk.com/docs/cloudwatch_put_metric_stream/) for full documentation.
#'
#' @param Name &#91;required&#93; If you are creating a new metric stream, this is the name for the new
#' stream. The name must be different than the names of other metric
#' streams in this account and Region.
#' 
#' If you are updating a metric stream, specify the name of that stream
#' here.
#' 
#' Valid characters are A-Z, a-z, 0-9, "-" and "_".
#' @param IncludeFilters If you specify this parameter, the stream sends only the metrics from
#' the metric namespaces that you specify here.
#' 
#' You cannot include `IncludeFilters` and `ExcludeFilters` in the same
#' operation.
#' @param ExcludeFilters If you specify this parameter, the stream sends metrics from all metric
#' namespaces except for the namespaces that you specify here.
#' 
#' You cannot include `ExcludeFilters` and `IncludeFilters` in the same
#' operation.
#' @param FirehoseArn &#91;required&#93; The ARN of the Amazon Kinesis Data Firehose delivery stream to use for
#' this metric stream. This Amazon Kinesis Data Firehose delivery stream
#' must already exist and must be in the same account as the metric stream.
#' @param RoleArn &#91;required&#93; The ARN of an IAM role that this metric stream will use to access Amazon
#' Kinesis Data Firehose resources. This IAM role must already exist and
#' must be in the same account as the metric stream. This IAM role must
#' include the following permissions:
#' 
#' -   firehose:PutRecord
#' 
#' -   firehose:PutRecordBatch
#' @param OutputFormat &#91;required&#93; The output format for the stream. Valid values are `json`,
#' `opentelemetry1.0`, and `opentelemetry0.7`. For more information about
#' metric stream output formats, see [Metric streams output
#' formats](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-metric-streams-formats.html).
#' @param Tags A list of key-value pairs to associate with the metric stream. You can
#' associate as many as 50 tags with a metric stream.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' You can use this parameter only when you are creating a new metric
#' stream. If you are using this operation to update an existing metric
#' stream, any tags you specify in this parameter are ignored. To change
#' the tags of an existing metric stream, use
#' [`tag_resource`][cloudwatch_tag_resource] or
#' [`untag_resource`][cloudwatch_untag_resource].
#' @param StatisticsConfigurations By default, a metric stream always sends the `MAX`, `MIN`, `SUM`, and
#' `SAMPLECOUNT` statistics for each metric that is streamed. You can use
#' this parameter to have the metric stream also send additional statistics
#' in the stream. This array can have up to 100 members.
#' 
#' For each entry in this array, you specify one or more metrics and the
#' list of additional statistics to stream for those metrics. The
#' additional statistics that you can stream depend on the stream's
#' `OutputFormat`. If the `OutputFormat` is `json`, you can stream any
#' additional statistic that is supported by CloudWatch, listed in
#' [CloudWatch statistics
#' definitions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/).
#' If the `OutputFormat` is `opentelemetry1.0` or `opentelemetry0.7`, you
#' can stream percentile statistics such as p95, p99.9, and so on.
#' @param IncludeLinkedAccountsMetrics If you are creating a metric stream in a monitoring account, specify
#' `true` to include metrics from source accounts in the metric stream.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_put_metric_stream
cloudwatch_put_metric_stream <- function(Name, IncludeFilters = NULL, ExcludeFilters = NULL, FirehoseArn, RoleArn, OutputFormat, Tags = NULL, StatisticsConfigurations = NULL, IncludeLinkedAccountsMetrics = NULL) {
  op <- new_operation(
    name = "PutMetricStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$put_metric_stream_input(Name = Name, IncludeFilters = IncludeFilters, ExcludeFilters = ExcludeFilters, FirehoseArn = FirehoseArn, RoleArn = RoleArn, OutputFormat = OutputFormat, Tags = Tags, StatisticsConfigurations = StatisticsConfigurations, IncludeLinkedAccountsMetrics = IncludeLinkedAccountsMetrics)
  output <- .cloudwatch$put_metric_stream_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$put_metric_stream <- cloudwatch_put_metric_stream

#' Temporarily sets the state of an alarm for testing purposes
#'
#' @description
#' Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to `ALARM` sends an SNS message.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_set_alarm_state/](https://www.paws-r-sdk.com/docs/cloudwatch_set_alarm_state/) for full documentation.
#'
#' @param AlarmName &#91;required&#93; The name of the alarm.
#' @param StateValue &#91;required&#93; The value of the state.
#' @param StateReason &#91;required&#93; The reason that this alarm is set to this specific state, in text
#' format.
#' @param StateReasonData The reason that this alarm is set to this specific state, in JSON
#' format.
#' 
#' For SNS or EC2 alarm actions, this is just informational. But for EC2
#' Auto Scaling or application Auto Scaling alarm actions, the Auto Scaling
#' policy uses the information in this field to take the correct action.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_set_alarm_state
cloudwatch_set_alarm_state <- function(AlarmName, StateValue, StateReason, StateReasonData = NULL) {
  op <- new_operation(
    name = "SetAlarmState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$set_alarm_state_input(AlarmName = AlarmName, StateValue = StateValue, StateReason = StateReason, StateReasonData = StateReasonData)
  output <- .cloudwatch$set_alarm_state_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$set_alarm_state <- cloudwatch_set_alarm_state

#' Starts the streaming of metrics for one or more of your metric streams
#'
#' @description
#' Starts the streaming of metrics for one or more of your metric streams.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_start_metric_streams/](https://www.paws-r-sdk.com/docs/cloudwatch_start_metric_streams/) for full documentation.
#'
#' @param Names &#91;required&#93; The array of the names of metric streams to start streaming.
#' 
#' This is an "all or nothing" operation. If you do not have permission to
#' access all of the metric streams that you list here, then none of the
#' streams that you list in the operation will start streaming.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_start_metric_streams
cloudwatch_start_metric_streams <- function(Names) {
  op <- new_operation(
    name = "StartMetricStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$start_metric_streams_input(Names = Names)
  output <- .cloudwatch$start_metric_streams_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$start_metric_streams <- cloudwatch_start_metric_streams

#' Stops the streaming of metrics for one or more of your metric streams
#'
#' @description
#' Stops the streaming of metrics for one or more of your metric streams.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_stop_metric_streams/](https://www.paws-r-sdk.com/docs/cloudwatch_stop_metric_streams/) for full documentation.
#'
#' @param Names &#91;required&#93; The array of the names of metric streams to stop streaming.
#' 
#' This is an "all or nothing" operation. If you do not have permission to
#' access all of the metric streams that you list here, then none of the
#' streams that you list in the operation will stop streaming.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_stop_metric_streams
cloudwatch_stop_metric_streams <- function(Names) {
  op <- new_operation(
    name = "StopMetricStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$stop_metric_streams_input(Names = Names)
  output <- .cloudwatch$stop_metric_streams_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$stop_metric_streams <- cloudwatch_stop_metric_streams

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch resource. Currently, the only CloudWatch resources that can be tagged are alarms and Contributor Insights rules.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatch_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch resource that you're adding tags to.
#' 
#' The ARN format of an alarm is
#' `arn:aws:cloudwatch:Region:account-id:alarm:alarm-name `
#' 
#' The ARN format of a Contributor Insights rule is
#' `arn:aws:cloudwatch:Region:account-id:insight-rule/insight-rule-name `
#' 
#' For more information about ARN format, see [Resource Types Defined by
#' Amazon
#' CloudWatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
#' in the *Amazon Web Services General Reference*.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the alarm.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_tag_resource
cloudwatch_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloudwatch$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$tag_resource <- cloudwatch_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatch_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatch_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch resource that you're removing tags from.
#' 
#' The ARN format of an alarm is
#' `arn:aws:cloudwatch:Region:account-id:alarm:alarm-name `
#' 
#' The ARN format of a Contributor Insights rule is
#' `arn:aws:cloudwatch:Region:account-id:insight-rule/insight-rule-name `
#' 
#' For more information about ARN format, see [Resource Types Defined by
#' Amazon
#' CloudWatch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies)
#' in the *Amazon Web Services General Reference*.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatch_untag_resource
cloudwatch_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatch$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloudwatch$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatch$operations$untag_resource <- cloudwatch_untag_resource
