% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_reset_service_setting}
\alias{ssm_reset_service_setting}
\title{ServiceSetting is an account-level setting for an Amazon Web Services
service}
\usage{
ssm_reset_service_setting(SettingId)
}
\arguments{
\item{SettingId}{[required] The Amazon Resource Name (ARN) of the service setting to reset. The
setting ID can be one of the following.
\itemize{
\item \verb{/ssm/automation/customer-script-log-destination}
\item \verb{/ssm/automation/customer-script-log-group-name}
\item \verb{/ssm/documents/console/public-sharing-permission}
\item \verb{/ssm/managed-instance/activation-tier}
\item \verb{/ssm/opsinsights/opscenter}
\item \verb{/ssm/parameter-store/default-parameter-tier}
\item \verb{/ssm/parameter-store/high-throughput-enabled}
}}
}
\description{
\code{ServiceSetting} is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.

See \url{https://paws-r.github.io/docs/ssm/reset_service_setting.html} for full documentation.
}
\keyword{internal}
