% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_evaluate_feature}
\alias{cloudwatchevidently_evaluate_feature}
\title{This operation assigns a feature variation to one given user session}
\usage{
cloudwatchevidently_evaluate_feature(
  entityId,
  evaluationContext = NULL,
  feature,
  project
)
}
\arguments{
\item{entityId}{[required] An internal ID that represents a unique user of the application. This
\code{entityID} is checked against any override rules assigned for this
feature.}

\item{evaluationContext}{A JSON object of attributes that you can optionally pass in as part of
the evaluation event sent to Evidently from the user session. Evidently
can use this value to match user sessions with defined audience
segments. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html}{Use segments to focus your audience}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ <p>If you include this parameter, the value must be a JSON object. A JSON array is not supported.</p>
}\if{html}{\out{</div>}}}

\item{feature}{[required] The name of the feature being evaluated.}

\item{project}{[required] The name or ARN of the project that contains this feature.}
}
\description{
This operation assigns a feature variation to one given user session. You pass in an \code{entityID} that represents the user. Evidently then checks the evaluation rules and assigns the variation.

See \url{https://paws-r.github.io/docs/cloudwatchevidently/evaluate_feature.html} for full documentation.
}
\keyword{internal}
