% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_enable_metrics_collection}
\alias{autoscaling_enable_metrics_collection}
\title{Enables group metrics collection for the specified Auto Scaling group}
\usage{
autoscaling_enable_metrics_collection(
  AutoScalingGroupName,
  Metrics = NULL,
  Granularity
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{Metrics}{Identifies the metrics to enable.

You can specify one or more of the following metrics:
\itemize{
\item \code{GroupMinSize}
\item \code{GroupMaxSize}
\item \code{GroupDesiredCapacity}
\item \code{GroupInServiceInstances}
\item \code{GroupPendingInstances}
\item \code{GroupStandbyInstances}
\item \code{GroupTerminatingInstances}
\item \code{GroupTotalInstances}
\item \code{GroupInServiceCapacity}
\item \code{GroupPendingCapacity}
\item \code{GroupStandbyCapacity}
\item \code{GroupTerminatingCapacity}
\item \code{GroupTotalCapacity}
\item \code{WarmPoolDesiredCapacity}
\item \code{WarmPoolWarmedCapacity}
\item \code{WarmPoolPendingCapacity}
\item \code{WarmPoolTerminatingCapacity}
\item \code{WarmPoolTotalCapacity}
\item \code{GroupAndWarmPoolDesiredCapacity}
\item \code{GroupAndWarmPoolTotalCapacity}
}

If you specify \code{Granularity} and don't specify any metrics, all metrics
are enabled.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics}{Auto Scaling group metrics}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{Granularity}{[required] The frequency at which Amazon EC2 Auto Scaling sends aggregated data to
CloudWatch. The only valid value is \verb{1Minute}.}
}
\description{
Enables group metrics collection for the specified Auto Scaling group.

See \url{https://paws-r.github.io/docs/autoscaling/enable_metrics_collection.html} for full documentation.
}
\keyword{internal}
