% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroupstaggingapi_operations.R
\name{resourcegroupstaggingapi_tag_resources}
\alias{resourcegroupstaggingapi_tag_resources}
\title{Applies one or more tags to the specified resources}
\usage{
resourcegroupstaggingapi_tag_resources(ResourceARNList, Tags)
}
\arguments{
\item{ResourceARNList}{[required] A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a
resource. For more information, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{Tags}{[required] The tags that you want to add to the specified resources. A tag consists
of a key and a value that you define.}
}
\description{
Applies one or more tags to the specified resources. Note the following:
}
\details{
\itemize{
\item Not all resources can have tags. For a list of services that support
tagging, see \href{http://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/Welcome.html}{this list}.
\item Each resource can have up to 50 tags. For other limits, see \href{http://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions}{Tag Naming and Usage Conventions}
in the \emph{AWS General Reference.}
\item You can only tag resources that are located in the specified Region
for the AWS account.
\item To add tags to a resource, you need the necessary permissions for
the service that the resource belongs to as well as permissions for
adding tags. For more information, see \href{http://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/Welcome.html}{this list}.
}
}
\section{Request syntax}{
\preformatted{svc$tag_resources(
  ResourceARNList = list(
    "string"
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
