% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_create_service_action}
\alias{servicecatalog_create_service_action}
\title{Creates a self-service action}
\usage{
servicecatalog_create_service_action(Name, DefinitionType, Definition,
  Description, AcceptLanguage, IdempotencyToken)
}
\arguments{
\item{Name}{[required] The self-service action name.}

\item{DefinitionType}{[required] The service action definition type. For example, \code{SSM_AUTOMATION}.}

\item{Definition}{[required] The self-service action definition. Can be one of the following:

Name

:   The name of the AWS Systems Manager Document. For example,
\code{AWS-RestartEC2Instance}.

Version

:   The AWS Systems Manager automation document version. For example,
\code{"Version": "1"}

AssumeRole

:   The Amazon Resource Name (ARN) of the role that performs the
self-service actions on your behalf. For example,
\code{"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"}.\preformatted{To reuse the provisioned product launch role, set to
`"AssumeRole": "LAUNCH_ROLE"`.
}

Parameters

:   The list of parameters in JSON format.\preformatted{For example: `\\\[\\\{\\"Name\\":\\"InstanceId\\",\\"Type\\":\\"TARGET\\"\\\}\\\]`.
}}

\item{Description}{The self-service action description.}

\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Creates a self-service action.
}
\section{Request syntax}{
\preformatted{svc$create_service_action(
  Name = "string",
  DefinitionType = "SSM_AUTOMATION",
  Definition = list(
    "string"
  ),
  Description = "string",
  AcceptLanguage = "string",
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
