% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_cases}
\alias{support_describe_cases}
\title{Returns a list of cases that you specify by passing one or more case IDs}
\usage{
support_describe_cases(caseIdList, displayId, afterTime, beforeTime,
  includeResolvedCases, nextToken, maxResults, language,
  includeCommunications)
}
\arguments{
\item{caseIdList}{A list of ID numbers of the support cases you want returned. The maximum
number of cases is 100.}

\item{displayId}{The ID displayed for a case in the AWS Support Center user interface.}

\item{afterTime}{The start date for a filtered date search on support case
communications. Case communications are available for 12 months after
creation.}

\item{beforeTime}{The end date for a filtered date search on support case communications.
Case communications are available for 12 months after creation.}

\item{includeResolvedCases}{Specifies whether resolved support cases should be included in the
DescribeCases results. The default is \emph{false}.}

\item{nextToken}{A resumption point for pagination.}

\item{maxResults}{The maximum number of results to return before paginating.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English ("en") and Japanese ("ja").
Language parameters must be passed explicitly for operations that take
them.}

\item{includeCommunications}{Specifies whether communications should be included in the DescribeCases
results. The default is \emph{true}.}
}
\description{
Returns a list of cases that you specify by passing one or more case
IDs. In addition, you can filter the cases by date by setting values for
the \code{afterTime} and \code{beforeTime} request parameters. You can set values
for the \code{includeResolvedCases} and \code{includeCommunications} request
parameters to control how much information is returned.
}
\details{
Case data is available for 12 months after creation. If a case was
created more than 12 months ago, a request for data might cause an
error.

The response returns the following in JSON format:
\itemize{
\item One or more CaseDetails data types.
\item One or more \code{nextToken} values, which specify where to paginate the
returned records represented by the \code{CaseDetails} objects.
}
}
\section{Request syntax}{
\preformatted{svc$describe_cases(
  caseIdList = list(
    "string"
  ),
  displayId = "string",
  afterTime = "string",
  beforeTime = "string",
  includeResolvedCases = TRUE|FALSE,
  nextToken = "string",
  maxResults = 123,
  language = "string",
  includeCommunications = TRUE|FALSE
)
}
}

\keyword{internal}
