% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationautoscaling_operations.R
\name{applicationautoscaling_deregister_scalable_target}
\alias{applicationautoscaling_deregister_scalable_target}
\title{Deregisters a scalable target}
\usage{
applicationautoscaling_deregister_scalable_target(ServiceNamespace,
  ResourceId, ScalableDimension)
}
\arguments{
\item{ServiceNamespace}{[required] The namespace of the AWS service that provides the resource or
\code{custom-resource} for a resource provided by your own application or
service. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces}{AWS Service Namespaces}
in the \emph{Amazon Web Services General Reference}.}

\item{ResourceId}{[required] The identifier of the resource associated with the scalable target. This
string consists of the resource type and unique identifier.
\itemize{
\item ECS service - The resource type is \code{service} and the unique
identifier is the cluster name and service name. Example:
\code{service/default/sample-webapp}.
\item Spot fleet request - The resource type is \code{spot-fleet-request} and
the unique identifier is the Spot fleet request ID. Example:
\code{spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE}.
\item EMR cluster - The resource type is \code{instancegroup} and the unique
identifier is the cluster ID and instance group ID. Example:
\code{instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0}.
\item AppStream 2.0 fleet - The resource type is \code{fleet} and the unique
identifier is the fleet name. Example: \code{fleet/sample-fleet}.
\item DynamoDB table - The resource type is \code{table} and the unique
identifier is the resource ID. Example: \code{table/my-table}.
\item DynamoDB global secondary index - The resource type is \code{index} and
the unique identifier is the resource ID. Example:
\code{table/my-table/index/my-table-index}.
\item Aurora DB cluster - The resource type is \code{cluster} and the unique
identifier is the cluster name. Example: \code{cluster:my-db-cluster}.
\item Amazon SageMaker endpoint variants - The resource type is \code{variant}
and the unique identifier is the resource ID. Example:
\code{endpoint/my-end-point/variant/KMeansClustering}.
\item Custom resources are not supported with a resource type. This
parameter must specify the \code{OutputValue} from the CloudFormation
template stack used to access the resources. The unique identifier
is defined by the service provider. More information is available in
our \href{https://github.com/aws/aws-auto-scaling-custom-resource}{GitHub repository}.
}}

\item{ScalableDimension}{[required] The scalable dimension associated with the scalable target. This string
consists of the service namespace, resource type, and scaling property.
\itemize{
\item \code{ecs:service:DesiredCount} - The desired task count of an ECS
service.
\item \code{ec2:spot-fleet-request:TargetCapacity} - The target capacity of a
Spot fleet request.
\item \code{elasticmapreduce:instancegroup:InstanceCount} - The instance count
of an EMR Instance Group.
\item \code{appstream:fleet:DesiredCapacity} - The desired capacity of an
AppStream 2.0 fleet.
\item \code{dynamodb:table:ReadCapacityUnits} - The provisioned read capacity
for a DynamoDB table.
\item \code{dynamodb:table:WriteCapacityUnits} - The provisioned write capacity
for a DynamoDB table.
\item \code{dynamodb:index:ReadCapacityUnits} - The provisioned read capacity
for a DynamoDB global secondary index.
\item \code{dynamodb:index:WriteCapacityUnits} - The provisioned write capacity
for a DynamoDB global secondary index.
\item \code{rds:cluster:ReadReplicaCount} - The count of Aurora Replicas in an
Aurora DB cluster. Available for Aurora MySQL-compatible edition and
Aurora PostgreSQL-compatible edition.
\item \code{sagemaker:variant:DesiredInstanceCount} - The number of EC2
instances for an Amazon SageMaker model endpoint variant.
\item \code{custom-resource:ResourceType:Property} - The scalable dimension for
a custom resource provided by your own application or service.
}}
}
\description{
Deregisters a scalable target.
}
\details{
Deregistering a scalable target deletes the scaling policies that are
associated with it.

To create a scalable target or update an existing one, see
RegisterScalableTarget.
}
\section{Request syntax}{
\preformatted{svc$deregister_scalable_target(
  ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource",
  ResourceId = "string",
  ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"
)
}
}

\examples{
# This example deregisters a scalable target for an Amazon ECS service
# called web-app that is running in the default cluster.
\donttest{svc$deregister_scalable_target(
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs"
)}

}
\keyword{internal}
