# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Health APIs and Notifications
#'
#' @description
#' AWS Health
#' 
#' The AWS Health API provides programmatic access to the AWS Health
#' information that is presented in the [AWS Personal Health
#' Dashboard](https://phd.aws.amazon.com/phd/home#/). You can get
#' information about events that affect your AWS resources:
#' 
#' -   DescribeEvents: Summary information about events.
#' 
#' -   DescribeEventDetails: Detailed information about one or more events.
#' 
#' -   DescribeAffectedEntities: Information about AWS resources that are
#'     affected by one or more events.
#' 
#' In addition, these operations provide information about event types and
#' summary counts of events or affected entities:
#' 
#' -   DescribeEventTypes: Information about the kinds of events that AWS
#'     Health tracks.
#' 
#' -   DescribeEventAggregates: A count of the number of events that meet
#'     specified criteria.
#' 
#' -   DescribeEntityAggregates: A count of the number of affected entities
#'     that meet specified criteria.
#' 
#' The Health API requires a Business or Enterprise support plan from [AWS
#' Support](http://aws.amazon.com/premiumsupport/). Calling the Health API
#' from an account that does not have a Business or Enterprise support plan
#' causes a `SubscriptionRequiredException`.
#' 
#' For authentication of requests, AWS Health uses the [Signature Version 4
#' Signing
#' Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' See the [AWS Health User
#' Guide](https://docs.aws.amazon.com/health/latest/ug/what-is-aws-health.html)
#' for information about how to use the API.
#' 
#' **Service Endpoint**
#' 
#' The HTTP endpoint for the AWS Health API is:
#' 
#' -   https://health.us-east-1.amazonaws.com
#'
#' @examples
#' \donttest{svc <- health()
#' svc$describe_affected_entities(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=health_describe_affected_entities]{describe_affected_entities} \tab Returns a list of entities that have been affected by the specified events, based on the specified filter criteria\cr
#'  \link[=health_describe_entity_aggregates]{describe_entity_aggregates} \tab Returns the number of entities that are affected by each of the specified events \cr
#'  \link[=health_describe_event_aggregates]{describe_event_aggregates} \tab Returns the number of events of each event type (issue, scheduled change, and account notification) \cr
#'  \link[=health_describe_event_details]{describe_event_details} \tab Returns detailed information about one or more specified events \cr
#'  \link[=health_describe_event_types]{describe_event_types} \tab Returns the event types that meet the specified filter criteria \cr
#'  \link[=health_describe_events]{describe_events} \tab Returns information about events that meet the specified filter criteria 
#' }
#'
#' @rdname health
#' @export
health <- function() {
  .health$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.health <- list()

.health$operations <- list()

.health$metadata <- list(
  service_name = "health",
  endpoints = list("*" = list(endpoint = "health.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "health.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Health",
  api_version = "2016-08-04",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSHealth_20160804"
)

.health$handlers <- new_handlers("jsonrpc", "v4")

.health$service <- function() {
  new_service(.health$metadata, .health$handlers)
}
