% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_delete_backup}
\alias{opsworkscm_delete_backup}
\title{Deletes a backup}
\usage{
opsworkscm_delete_backup(BackupId)
}
\arguments{
\item{BackupId}{[required] The ID of the backup to delete. Run the DescribeBackups command to get a
list of backup IDs. Backup IDs are in the format
\code{ServerName-yyyyMMddHHmmssSSS}.}
}
\value{
An empty list.
}
\description{
Deletes a backup. You can delete both manual and automated backups. This
operation is asynchronous.

An \code{InvalidStateException} is thrown when a backup deletion is already
in progress. A \code{ResourceNotFoundException} is thrown when the backup
does not exist. A \code{ValidationException} is thrown when parameters of the
request are not valid.
}
\section{Request syntax}{
\preformatted{svc$delete_backup(
  BackupId = "string"
)
}
}

\keyword{internal}
