% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_describe_archive}
\alias{cloudwatchevents_describe_archive}
\title{Retrieves details about an archive}
\usage{
cloudwatchevents_describe_archive(ArchiveName)
}
\arguments{
\item{ArchiveName}{[required] The name of the archive to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  ArchiveArn = "string",
  ArchiveName = "string",
  EventSourceArn = "string",
  Description = "string",
  EventPattern = "string",
  State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
  StateReason = "string",
  RetentionDays = 123,
  SizeBytes = 123,
  EventCount = 123,
  CreationTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Retrieves details about an archive.
}
\section{Request syntax}{
\preformatted{svc$describe_archive(
  ArchiveName = "string"
)
}
}

\keyword{internal}
