# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include servicecatalog_service.R
NULL

#' Accepts an offer to share the specified portfolio
#'
#' @description
#' Accepts an offer to share the specified portfolio.
#'
#' @usage
#' servicecatalog_accept_portfolio_share(AcceptLanguage, PortfolioId,
#'   PortfolioShareType)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PortfolioShareType The type of shared portfolios to accept. The default is to accept
#' imported portfolios.
#' 
#' -   `AWS_ORGANIZATIONS` - Accept portfolios shared by the management
#'     account of your organization.
#' 
#' -   `IMPORTED` - Accept imported portfolios.
#' 
#' -   `AWS_SERVICECATALOG` - Not supported. (Throws
#'     ResourceNotFoundException.)
#' 
#' For example,
#' `aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS`
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$accept_portfolio_share(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   PortfolioShareType = "IMPORTED"|"AWS_SERVICECATALOG"|"AWS_ORGANIZATIONS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_accept_portfolio_share
servicecatalog_accept_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, PortfolioShareType = NULL) {
  op <- new_operation(
    name = "AcceptPortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$accept_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PortfolioShareType = PortfolioShareType)
  output <- .servicecatalog$accept_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$accept_portfolio_share <- servicecatalog_accept_portfolio_share

#' Associates the specified budget with the specified resource
#'
#' @description
#' Associates the specified budget with the specified resource.
#'
#' @usage
#' servicecatalog_associate_budget_with_resource(BudgetName, ResourceId)
#'
#' @param BudgetName &#91;required&#93; The name of the budget you want to associate.
#' @param ResourceId &#91;required&#93; The resource identifier. Either a portfolio-id or a product-id.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_budget_with_resource(
#'   BudgetName = "string",
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_budget_with_resource
servicecatalog_associate_budget_with_resource <- function(BudgetName, ResourceId) {
  op <- new_operation(
    name = "AssociateBudgetWithResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_budget_with_resource_input(BudgetName = BudgetName, ResourceId = ResourceId)
  output <- .servicecatalog$associate_budget_with_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_budget_with_resource <- servicecatalog_associate_budget_with_resource

#' Associates the specified principal ARN with the specified portfolio
#'
#' @description
#' Associates the specified principal ARN with the specified portfolio.
#'
#' @usage
#' servicecatalog_associate_principal_with_portfolio(AcceptLanguage,
#'   PortfolioId, PrincipalARN, PrincipalType)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PrincipalARN &#91;required&#93; The ARN of the principal (IAM user, role, or group).
#' @param PrincipalType &#91;required&#93; The principal type. The supported value is `IAM`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_principal_with_portfolio(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   PrincipalARN = "string",
#'   PrincipalType = "IAM"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_principal_with_portfolio
servicecatalog_associate_principal_with_portfolio <- function(AcceptLanguage = NULL, PortfolioId, PrincipalARN, PrincipalType) {
  op <- new_operation(
    name = "AssociatePrincipalWithPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_principal_with_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PrincipalARN = PrincipalARN, PrincipalType = PrincipalType)
  output <- .servicecatalog$associate_principal_with_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_principal_with_portfolio <- servicecatalog_associate_principal_with_portfolio

#' Associates the specified product with the specified portfolio
#'
#' @description
#' Associates the specified product with the specified portfolio.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_associate_product_with_portfolio(AcceptLanguage,
#'   ProductId, PortfolioId, SourcePortfolioId)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param SourcePortfolioId The identifier of the source portfolio.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_product_with_portfolio(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   PortfolioId = "string",
#'   SourcePortfolioId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_product_with_portfolio
servicecatalog_associate_product_with_portfolio <- function(AcceptLanguage = NULL, ProductId, PortfolioId, SourcePortfolioId = NULL) {
  op <- new_operation(
    name = "AssociateProductWithPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_product_with_portfolio_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PortfolioId = PortfolioId, SourcePortfolioId = SourcePortfolioId)
  output <- .servicecatalog$associate_product_with_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_product_with_portfolio <- servicecatalog_associate_product_with_portfolio

#' Associates a self-service action with a provisioning artifact
#'
#' @description
#' Associates a self-service action with a provisioning artifact.
#'
#' @usage
#' servicecatalog_associate_service_action_with_provisioning_artifact(
#'   ProductId, ProvisioningArtifactId, ServiceActionId, AcceptLanguage)
#'
#' @param ProductId &#91;required&#93; The product identifier. For example, `prod-abcdzk7xy33qa`.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact. For example,
#' `pa-4abcdjnxjj6ne`.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_service_action_with_provisioning_artifact(
#'   ProductId = "string",
#'   ProvisioningArtifactId = "string",
#'   ServiceActionId = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_service_action_with_provisioning_artifact
servicecatalog_associate_service_action_with_provisioning_artifact <- function(ProductId, ProvisioningArtifactId, ServiceActionId, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "AssociateServiceActionWithProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_service_action_with_provisioning_artifact_input(ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, ServiceActionId = ServiceActionId, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$associate_service_action_with_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_service_action_with_provisioning_artifact <- servicecatalog_associate_service_action_with_provisioning_artifact

#' Associate the specified TagOption with the specified portfolio or
#' product
#'
#' @description
#' Associate the specified TagOption with the specified portfolio or
#' product.
#'
#' @usage
#' servicecatalog_associate_tag_option_with_resource(ResourceId,
#'   TagOptionId)
#'
#' @param ResourceId &#91;required&#93; The resource identifier.
#' @param TagOptionId &#91;required&#93; The TagOption identifier.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_tag_option_with_resource(
#'   ResourceId = "string",
#'   TagOptionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_tag_option_with_resource
servicecatalog_associate_tag_option_with_resource <- function(ResourceId, TagOptionId) {
  op <- new_operation(
    name = "AssociateTagOptionWithResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_tag_option_with_resource_input(ResourceId = ResourceId, TagOptionId = TagOptionId)
  output <- .servicecatalog$associate_tag_option_with_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_tag_option_with_resource <- servicecatalog_associate_tag_option_with_resource

#' Associates multiple self-service actions with provisioning artifacts
#'
#' @description
#' Associates multiple self-service actions with provisioning artifacts.
#'
#' @usage
#' servicecatalog_batch_associate_service_action_with_provisioning_artifact(
#'   ServiceActionAssociations, AcceptLanguage)
#'
#' @param ServiceActionAssociations &#91;required&#93; One or more associations, each consisting of the Action ID, the Product
#' ID, and the Provisioning Artifact ID.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedServiceActionAssociations = list(
#'     list(
#'       ServiceActionId = "string",
#'       ProductId = "string",
#'       ProvisioningArtifactId = "string",
#'       ErrorCode = "DUPLICATE_RESOURCE"|"INTERNAL_FAILURE"|"LIMIT_EXCEEDED"|"RESOURCE_NOT_FOUND"|"THROTTLING",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_associate_service_action_with_provisioning_artifact(
#'   ServiceActionAssociations = list(
#'     list(
#'       ServiceActionId = "string",
#'       ProductId = "string",
#'       ProvisioningArtifactId = "string"
#'     )
#'   ),
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_batch_associate_service_action_with_provisioning_artifact
servicecatalog_batch_associate_service_action_with_provisioning_artifact <- function(ServiceActionAssociations, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "BatchAssociateServiceActionWithProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$batch_associate_service_action_with_provisioning_artifact_input(ServiceActionAssociations = ServiceActionAssociations, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$batch_associate_service_action_with_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$batch_associate_service_action_with_provisioning_artifact <- servicecatalog_batch_associate_service_action_with_provisioning_artifact

#' Disassociates a batch of self-service actions from the specified
#' provisioning artifact
#'
#' @description
#' Disassociates a batch of self-service actions from the specified
#' provisioning artifact.
#'
#' @usage
#' servicecatalog_batch_disassociate_service_action_from_provisioning_artifact(
#'   ServiceActionAssociations, AcceptLanguage)
#'
#' @param ServiceActionAssociations &#91;required&#93; One or more associations, each consisting of the Action ID, the Product
#' ID, and the Provisioning Artifact ID.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedServiceActionAssociations = list(
#'     list(
#'       ServiceActionId = "string",
#'       ProductId = "string",
#'       ProvisioningArtifactId = "string",
#'       ErrorCode = "DUPLICATE_RESOURCE"|"INTERNAL_FAILURE"|"LIMIT_EXCEEDED"|"RESOURCE_NOT_FOUND"|"THROTTLING",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_disassociate_service_action_from_provisioning_artifact(
#'   ServiceActionAssociations = list(
#'     list(
#'       ServiceActionId = "string",
#'       ProductId = "string",
#'       ProvisioningArtifactId = "string"
#'     )
#'   ),
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_batch_disassociate_service_action_from_provisioning_artifact
servicecatalog_batch_disassociate_service_action_from_provisioning_artifact <- function(ServiceActionAssociations, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "BatchDisassociateServiceActionFromProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$batch_disassociate_service_action_from_provisioning_artifact_input(ServiceActionAssociations = ServiceActionAssociations, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$batch_disassociate_service_action_from_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$batch_disassociate_service_action_from_provisioning_artifact <- servicecatalog_batch_disassociate_service_action_from_provisioning_artifact

#' Copies the specified source product to the specified target product or a
#' new product
#'
#' @description
#' Copies the specified source product to the specified target product or a
#' new product.
#' 
#' You can copy a product to the same account or another account. You can
#' copy a product to the same region or another region.
#' 
#' This operation is performed asynchronously. To track the progress of the
#' operation, use
#' [`describe_copy_product_status`][servicecatalog_describe_copy_product_status].
#'
#' @usage
#' servicecatalog_copy_product(AcceptLanguage, SourceProductArn,
#'   TargetProductId, TargetProductName,
#'   SourceProvisioningArtifactIdentifiers, CopyOptions, IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param SourceProductArn &#91;required&#93; The Amazon Resource Name (ARN) of the source product.
#' @param TargetProductId The identifier of the target product. By default, a new product is
#' created.
#' @param TargetProductName A name for the target product. The default is the name of the source
#' product.
#' @param SourceProvisioningArtifactIdentifiers The identifiers of the provisioning artifacts (also known as versions)
#' of the product to copy. By default, all provisioning artifacts are
#' copied.
#' @param CopyOptions The copy options. If the value is `CopyTags`, the tags from the source
#' product are copied to the target product.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CopyProductToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_product(
#'   AcceptLanguage = "string",
#'   SourceProductArn = "string",
#'   TargetProductId = "string",
#'   TargetProductName = "string",
#'   SourceProvisioningArtifactIdentifiers = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   CopyOptions = list(
#'     "CopyTags"
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_copy_product
servicecatalog_copy_product <- function(AcceptLanguage = NULL, SourceProductArn, TargetProductId = NULL, TargetProductName = NULL, SourceProvisioningArtifactIdentifiers = NULL, CopyOptions = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CopyProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$copy_product_input(AcceptLanguage = AcceptLanguage, SourceProductArn = SourceProductArn, TargetProductId = TargetProductId, TargetProductName = TargetProductName, SourceProvisioningArtifactIdentifiers = SourceProvisioningArtifactIdentifiers, CopyOptions = CopyOptions, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$copy_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$copy_product <- servicecatalog_copy_product

#' Creates a constraint
#'
#' @description
#' Creates a constraint.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_create_constraint(AcceptLanguage, PortfolioId, ProductId,
#'   Parameters, Type, Description, IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param ProductId &#91;required&#93; The product identifier.
#' @param Parameters &#91;required&#93; The constraint parameters, in JSON format. The syntax depends on the
#' constraint type as follows:
#' 
#' ### LAUNCH
#' 
#' You are required to specify either the `RoleArn` or the `LocalRoleName`
#' but can't use both.
#' 
#' Specify the `RoleArn` property as follows:
#' 
#' `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
#' 
#' Specify the `LocalRoleName` property as follows:
#' 
#' `{"LocalRoleName": "SCBasicLaunchRole"}`
#' 
#' If you specify the `LocalRoleName` property, when an account uses the
#' launch constraint, the IAM role with that name in the account will be
#' used. This allows launch-role constraints to be account-agnostic so the
#' administrator can create fewer resources per shared account.
#' 
#' The given role name must exist in the account used to create the launch
#' constraint and the account of the user who launches a product with this
#' launch constraint.
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `LAUNCH` constraint on a product and
#' portfolio.
#' 
#' ### NOTIFICATION
#' 
#' Specify the `NotificationArns` property as follows:
#' 
#' `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
#' 
#' ### RESOURCE_UPDATE
#' 
#' Specify the `TagUpdatesOnProvisionedProduct` property as follows:
#' 
#' `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
#' 
#' The `TagUpdatesOnProvisionedProduct` property accepts a string value of
#' `ALLOWED` or `NOT_ALLOWED`.
#' 
#' ### STACKSET
#' 
#' Specify the `Parameters` property as follows:
#' 
#' `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `STACKSET` constraint on a product
#' and portfolio.
#' 
#' Products with a `STACKSET` constraint will launch an AWS CloudFormation
#' stack set.
#' 
#' ### TEMPLATE
#' 
#' Specify the `Rules` property. For more information, see [Template
#' Constraint
#' Rules](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
#' @param Type &#91;required&#93; The type of constraint.
#' 
#' -   `LAUNCH`
#' 
#' -   `NOTIFICATION`
#' 
#' -   `RESOURCE_UPDATE`
#' 
#' -   `STACKSET`
#' 
#' -   `TEMPLATE`
#' @param Description The description of the constraint.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConstraintDetail = list(
#'     ConstraintId = "string",
#'     Type = "string",
#'     Description = "string",
#'     Owner = "string",
#'     ProductId = "string",
#'     PortfolioId = "string"
#'   ),
#'   ConstraintParameters = "string",
#'   Status = "AVAILABLE"|"CREATING"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_constraint(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   ProductId = "string",
#'   Parameters = "string",
#'   Type = "string",
#'   Description = "string",
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_constraint
servicecatalog_create_constraint <- function(AcceptLanguage = NULL, PortfolioId, ProductId, Parameters, Type, Description = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreateConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_constraint_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, ProductId = ProductId, Parameters = Parameters, Type = Type, Description = Description, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_constraint <- servicecatalog_create_constraint

#' Creates a portfolio
#'
#' @description
#' Creates a portfolio.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_create_portfolio(AcceptLanguage, DisplayName,
#'   Description, ProviderName, Tags, IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param DisplayName &#91;required&#93; The name to use for display purposes.
#' @param Description The description of the portfolio.
#' @param ProviderName &#91;required&#93; The name of the portfolio provider.
#' @param Tags One or more tags.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioDetail = list(
#'     Id = "string",
#'     ARN = "string",
#'     DisplayName = "string",
#'     Description = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProviderName = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_portfolio(
#'   AcceptLanguage = "string",
#'   DisplayName = "string",
#'   Description = "string",
#'   ProviderName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_portfolio
servicecatalog_create_portfolio <- function(AcceptLanguage = NULL, DisplayName, Description = NULL, ProviderName, Tags = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreatePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_portfolio_input(AcceptLanguage = AcceptLanguage, DisplayName = DisplayName, Description = Description, ProviderName = ProviderName, Tags = Tags, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_portfolio <- servicecatalog_create_portfolio

#' Shares the specified portfolio with the specified account or
#' organization node
#'
#' @description
#' Shares the specified portfolio with the specified account or
#' organization node. Shares to an organization node can only be created by
#' the management account of an organization or by a delegated
#' administrator. You can share portfolios to an organization, an
#' organizational unit, or a specific account.
#' 
#' Note that if a delegated admin is de-registered, they can no longer
#' create portfolio shares.
#' 
#' `AWSOrganizationsAccess` must be enabled in order to create a portfolio
#' share to an organization node.
#' 
#' You can't share a shared resource, including portfolios that contain a
#' shared product.
#' 
#' If the portfolio share with the specified account or organization node
#' already exists, this action will have no effect and will not return an
#' error. To update an existing share, you must use the
#' [`update_portfolio_share`][servicecatalog_update_portfolio_share] API
#' instead.
#'
#' @usage
#' servicecatalog_create_portfolio_share(AcceptLanguage, PortfolioId,
#'   AccountId, OrganizationNode, ShareTagOptions)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param AccountId The AWS account ID. For example, `123456789012`.
#' @param OrganizationNode The organization node to whom you are going to share. If
#' `OrganizationNode` is passed in, `PortfolioShare` will be created for
#' the node an ListOrganizationPortfolioAccessd its children (when
#' applies), and a `PortfolioShareToken` will be returned in the output in
#' order for the administrator to monitor the status of the
#' `PortfolioShare` creation process.
#' @param ShareTagOptions Enables or disables `TagOptions ` sharing when creating the portfolio
#' share. If this flag is not provided, TagOptions sharing is disabled.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioShareToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_portfolio_share(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   AccountId = "string",
#'   OrganizationNode = list(
#'     Type = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
#'     Value = "string"
#'   ),
#'   ShareTagOptions = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_portfolio_share
servicecatalog_create_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, AccountId = NULL, OrganizationNode = NULL, ShareTagOptions = NULL) {
  op <- new_operation(
    name = "CreatePortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, AccountId = AccountId, OrganizationNode = OrganizationNode, ShareTagOptions = ShareTagOptions)
  output <- .servicecatalog$create_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_portfolio_share <- servicecatalog_create_portfolio_share

#' Creates a product
#'
#' @description
#' Creates a product.
#' 
#' A delegated admin is authorized to invoke this command.
#' 
#' The user or role that performs this operation must have the
#' `cloudformation:GetTemplate` IAM policy permission. This policy
#' permission is required when using the `ImportFromPhysicalId` template
#' source in the information data section.
#'
#' @usage
#' servicecatalog_create_product(AcceptLanguage, Name, Owner, Description,
#'   Distributor, SupportDescription, SupportEmail, SupportUrl, ProductType,
#'   Tags, ProvisioningArtifactParameters, IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Name &#91;required&#93; The name of the product.
#' @param Owner &#91;required&#93; The owner of the product.
#' @param Description The description of the product.
#' @param Distributor The distributor of the product.
#' @param SupportDescription The support information about the product.
#' @param SupportEmail The contact email for product support.
#' @param SupportUrl The contact URL for product support.
#' 
#' `^https?:\/\// `/ is the pattern used to validate SupportUrl.
#' @param ProductType &#91;required&#93; The type of product.
#' @param Tags One or more tags.
#' @param ProvisioningArtifactParameters &#91;required&#93; The configuration of the provisioning artifact.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewDetail = list(
#'     ProductViewSummary = list(
#'       Id = "string",
#'       ProductId = "string",
#'       Name = "string",
#'       Owner = "string",
#'       ShortDescription = "string",
#'       Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'       Distributor = "string",
#'       HasDefaultPath = TRUE|FALSE,
#'       SupportEmail = "string",
#'       SupportDescription = "string",
#'       SupportUrl = "string"
#'     ),
#'     Status = "AVAILABLE"|"CREATING"|"FAILED",
#'     ProductARN = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   ProvisioningArtifactDetail = list(
#'     Id = "string",
#'     Name = "string",
#'     Description = "string",
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Active = TRUE|FALSE,
#'     Guidance = "DEFAULT"|"DEPRECATED"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_product(
#'   AcceptLanguage = "string",
#'   Name = "string",
#'   Owner = "string",
#'   Description = "string",
#'   Distributor = "string",
#'   SupportDescription = "string",
#'   SupportEmail = "string",
#'   SupportUrl = "string",
#'   ProductType = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ProvisioningArtifactParameters = list(
#'     Name = "string",
#'     Description = "string",
#'     Info = list(
#'       "string"
#'     ),
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'     DisableTemplateValidation = TRUE|FALSE
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_product
servicecatalog_create_product <- function(AcceptLanguage = NULL, Name, Owner, Description = NULL, Distributor = NULL, SupportDescription = NULL, SupportEmail = NULL, SupportUrl = NULL, ProductType, Tags = NULL, ProvisioningArtifactParameters, IdempotencyToken) {
  op <- new_operation(
    name = "CreateProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_product_input(AcceptLanguage = AcceptLanguage, Name = Name, Owner = Owner, Description = Description, Distributor = Distributor, SupportDescription = SupportDescription, SupportEmail = SupportEmail, SupportUrl = SupportUrl, ProductType = ProductType, Tags = Tags, ProvisioningArtifactParameters = ProvisioningArtifactParameters, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_product <- servicecatalog_create_product

#' Creates a plan
#'
#' @description
#' Creates a plan. A plan includes the list of resources to be created
#' (when provisioning a new product) or modified (when updating a
#' provisioned product) when the plan is executed.
#' 
#' You can create one plan per provisioned product. To create a plan for an
#' existing provisioned product, the product status must be AVAILBLE or
#' TAINTED.
#' 
#' To view the resource changes in the change set, use
#' [`describe_provisioned_product_plan`][servicecatalog_describe_provisioned_product_plan].
#' To create or modify the provisioned product, use
#' [`execute_provisioned_product_plan`][servicecatalog_execute_provisioned_product_plan].
#'
#' @usage
#' servicecatalog_create_provisioned_product_plan(AcceptLanguage, PlanName,
#'   PlanType, NotificationArns, PathId, ProductId, ProvisionedProductName,
#'   ProvisioningArtifactId, ProvisioningParameters, IdempotencyToken, Tags)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanName &#91;required&#93; The name of the plan.
#' @param PlanType &#91;required&#93; The plan type.
#' @param NotificationArns Passed to CloudFormation. The SNS topic ARNs to which to publish
#' stack-related events.
#' @param PathId The path identifier of the product. This value is optional if the
#' product has a default path, and required if the product has more than
#' one path. To list the paths for a product, use
#' [`list_launch_paths`][servicecatalog_list_launch_paths].
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisionedProductName &#91;required&#93; A user-friendly name for the provisioned product. This value must be
#' unique for the AWS account and cannot be updated after the product is
#' provisioned.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#' @param ProvisioningParameters Parameters specified by the administrator that are required for
#' provisioning the product.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#' @param Tags One or more tags.
#' 
#' If the plan is for an existing provisioned product, the product must
#' have a `RESOURCE_UPDATE` constraint with
#' `TagUpdatesOnProvisionedProduct` set to `ALLOWED` to allow tag updates.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlanName = "string",
#'   PlanId = "string",
#'   ProvisionProductId = "string",
#'   ProvisionedProductName = "string",
#'   ProvisioningArtifactId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_provisioned_product_plan(
#'   AcceptLanguage = "string",
#'   PlanName = "string",
#'   PlanType = "CLOUDFORMATION",
#'   NotificationArns = list(
#'     "string"
#'   ),
#'   PathId = "string",
#'   ProductId = "string",
#'   ProvisionedProductName = "string",
#'   ProvisioningArtifactId = "string",
#'   ProvisioningParameters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       UsePreviousValue = TRUE|FALSE
#'     )
#'   ),
#'   IdempotencyToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_provisioned_product_plan
servicecatalog_create_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanName, PlanType, NotificationArns = NULL, PathId = NULL, ProductId, ProvisionedProductName, ProvisioningArtifactId, ProvisioningParameters = NULL, IdempotencyToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanName = PlanName, PlanType = PlanType, NotificationArns = NotificationArns, PathId = PathId, ProductId = ProductId, ProvisionedProductName = ProvisionedProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningParameters = ProvisioningParameters, IdempotencyToken = IdempotencyToken, Tags = Tags)
  output <- .servicecatalog$create_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_provisioned_product_plan <- servicecatalog_create_provisioned_product_plan

#' Creates a provisioning artifact (also known as a version) for the
#' specified product
#'
#' @description
#' Creates a provisioning artifact (also known as a version) for the
#' specified product.
#' 
#' You cannot create a provisioning artifact for a product that was shared
#' with you.
#' 
#' The user or role that performs this operation must have the
#' `cloudformation:GetTemplate` IAM policy permission. This policy
#' permission is required when using the `ImportFromPhysicalId` template
#' source in the information data section.
#'
#' @usage
#' servicecatalog_create_provisioning_artifact(AcceptLanguage, ProductId,
#'   Parameters, IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param Parameters &#91;required&#93; The configuration for the provisioning artifact.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisioningArtifactDetail = list(
#'     Id = "string",
#'     Name = "string",
#'     Description = "string",
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Active = TRUE|FALSE,
#'     Guidance = "DEFAULT"|"DEPRECATED"
#'   ),
#'   Info = list(
#'     "string"
#'   ),
#'   Status = "AVAILABLE"|"CREATING"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_provisioning_artifact(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   Parameters = list(
#'     Name = "string",
#'     Description = "string",
#'     Info = list(
#'       "string"
#'     ),
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'     DisableTemplateValidation = TRUE|FALSE
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_provisioning_artifact
servicecatalog_create_provisioning_artifact <- function(AcceptLanguage = NULL, ProductId, Parameters, IdempotencyToken) {
  op <- new_operation(
    name = "CreateProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, Parameters = Parameters, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_provisioning_artifact <- servicecatalog_create_provisioning_artifact

#' Creates a self-service action
#'
#' @description
#' Creates a self-service action.
#'
#' @usage
#' servicecatalog_create_service_action(Name, DefinitionType, Definition,
#'   Description, AcceptLanguage, IdempotencyToken)
#'
#' @param Name &#91;required&#93; The self-service action name.
#' @param DefinitionType &#91;required&#93; The service action definition type. For example, `SSM_AUTOMATION`.
#' @param Definition &#91;required&#93; The self-service action definition. Can be one of the following:
#' 
#' ### Name
#' 
#' The name of the AWS Systems Manager document (SSM document). For
#' example, `AWS-RestartEC2Instance`.
#' 
#' If you are using a shared SSM document, you must provide the ARN instead
#' of the name.
#' 
#' ### Version
#' 
#' The AWS Systems Manager automation document version. For example,
#' `"Version": "1"`
#' 
#' ### AssumeRole
#' 
#' The Amazon Resource Name (ARN) of the role that performs the
#' self-service actions on your behalf. For example,
#' `"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"`.
#' 
#' To reuse the provisioned product launch role, set to
#' `"AssumeRole": "LAUNCH_ROLE"`.
#' 
#' ### Parameters
#' 
#' The list of parameters in JSON format.
#' 
#' For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or
#' `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
#' @param Description The self-service action description.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceActionDetail = list(
#'     ServiceActionSummary = list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       DefinitionType = "SSM_AUTOMATION"
#'     ),
#'     Definition = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_service_action(
#'   Name = "string",
#'   DefinitionType = "SSM_AUTOMATION",
#'   Definition = list(
#'     "string"
#'   ),
#'   Description = "string",
#'   AcceptLanguage = "string",
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_service_action
servicecatalog_create_service_action <- function(Name, DefinitionType, Definition, Description = NULL, AcceptLanguage = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreateServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_service_action_input(Name = Name, DefinitionType = DefinitionType, Definition = Definition, Description = Description, AcceptLanguage = AcceptLanguage, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_service_action <- servicecatalog_create_service_action

#' Creates a TagOption
#'
#' @description
#' Creates a TagOption.
#'
#' @usage
#' servicecatalog_create_tag_option(Key, Value)
#'
#' @param Key &#91;required&#93; The TagOption key.
#' @param Value &#91;required&#93; The TagOption value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TagOptionDetail = list(
#'     Key = "string",
#'     Value = "string",
#'     Active = TRUE|FALSE,
#'     Id = "string",
#'     Owner = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_tag_option(
#'   Key = "string",
#'   Value = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_tag_option
servicecatalog_create_tag_option <- function(Key, Value) {
  op <- new_operation(
    name = "CreateTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_tag_option_input(Key = Key, Value = Value)
  output <- .servicecatalog$create_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_tag_option <- servicecatalog_create_tag_option

#' Deletes the specified constraint
#'
#' @description
#' Deletes the specified constraint.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_delete_constraint(AcceptLanguage, Id)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The identifier of the constraint.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_constraint(
#'   AcceptLanguage = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_constraint
servicecatalog_delete_constraint <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DeleteConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_constraint_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$delete_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_constraint <- servicecatalog_delete_constraint

#' Deletes the specified portfolio
#'
#' @description
#' Deletes the specified portfolio.
#' 
#' You cannot delete a portfolio if it was shared with you or if it has
#' associated products, users, constraints, or shared accounts.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_delete_portfolio(AcceptLanguage, Id)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The portfolio identifier.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_portfolio(
#'   AcceptLanguage = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_portfolio
servicecatalog_delete_portfolio <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DeletePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_portfolio_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$delete_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_portfolio <- servicecatalog_delete_portfolio

#' Stops sharing the specified portfolio with the specified account or
#' organization node
#'
#' @description
#' Stops sharing the specified portfolio with the specified account or
#' organization node. Shares to an organization node can only be deleted by
#' the management account of an organization or by a delegated
#' administrator.
#' 
#' Note that if a delegated admin is de-registered, portfolio shares
#' created from that account are removed.
#'
#' @usage
#' servicecatalog_delete_portfolio_share(AcceptLanguage, PortfolioId,
#'   AccountId, OrganizationNode)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param AccountId The AWS account ID.
#' @param OrganizationNode The organization node to whom you are going to stop sharing.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioShareToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_portfolio_share(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   AccountId = "string",
#'   OrganizationNode = list(
#'     Type = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
#'     Value = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_portfolio_share
servicecatalog_delete_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, AccountId = NULL, OrganizationNode = NULL) {
  op <- new_operation(
    name = "DeletePortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, AccountId = AccountId, OrganizationNode = OrganizationNode)
  output <- .servicecatalog$delete_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_portfolio_share <- servicecatalog_delete_portfolio_share

#' Deletes the specified product
#'
#' @description
#' Deletes the specified product.
#' 
#' You cannot delete a product if it was shared with you or is associated
#' with a portfolio.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_delete_product(AcceptLanguage, Id)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The product identifier.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_product(
#'   AcceptLanguage = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_product
servicecatalog_delete_product <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DeleteProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_product_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$delete_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_product <- servicecatalog_delete_product

#' Deletes the specified plan
#'
#' @description
#' Deletes the specified plan.
#'
#' @usage
#' servicecatalog_delete_provisioned_product_plan(AcceptLanguage, PlanId,
#'   IgnoreErrors)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanId &#91;required&#93; The plan identifier.
#' @param IgnoreErrors If set to true, AWS Service Catalog stops managing the specified
#' provisioned product even if it cannot delete the underlying resources.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_provisioned_product_plan(
#'   AcceptLanguage = "string",
#'   PlanId = "string",
#'   IgnoreErrors = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_provisioned_product_plan
servicecatalog_delete_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanId, IgnoreErrors = NULL) {
  op <- new_operation(
    name = "DeleteProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanId = PlanId, IgnoreErrors = IgnoreErrors)
  output <- .servicecatalog$delete_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_provisioned_product_plan <- servicecatalog_delete_provisioned_product_plan

#' Deletes the specified provisioning artifact (also known as a version)
#' for the specified product
#'
#' @description
#' Deletes the specified provisioning artifact (also known as a version)
#' for the specified product.
#' 
#' You cannot delete a provisioning artifact associated with a product that
#' was shared with you. You cannot delete the last provisioning artifact
#' for a product, because a product must have at least one provisioning
#' artifact.
#'
#' @usage
#' servicecatalog_delete_provisioning_artifact(AcceptLanguage, ProductId,
#'   ProvisioningArtifactId)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_provisioning_artifact(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   ProvisioningArtifactId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_provisioning_artifact
servicecatalog_delete_provisioning_artifact <- function(AcceptLanguage = NULL, ProductId, ProvisioningArtifactId) {
  op <- new_operation(
    name = "DeleteProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId)
  output <- .servicecatalog$delete_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_provisioning_artifact <- servicecatalog_delete_provisioning_artifact

#' Deletes a self-service action
#'
#' @description
#' Deletes a self-service action.
#'
#' @usage
#' servicecatalog_delete_service_action(Id, AcceptLanguage)
#'
#' @param Id &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_service_action(
#'   Id = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_service_action
servicecatalog_delete_service_action <- function(Id, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DeleteServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_service_action_input(Id = Id, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$delete_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_service_action <- servicecatalog_delete_service_action

#' Deletes the specified TagOption
#'
#' @description
#' Deletes the specified TagOption.
#' 
#' You cannot delete a TagOption if it is associated with a product or
#' portfolio.
#'
#' @usage
#' servicecatalog_delete_tag_option(Id)
#'
#' @param Id &#91;required&#93; The TagOption identifier.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tag_option(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_tag_option
servicecatalog_delete_tag_option <- function(Id) {
  op <- new_operation(
    name = "DeleteTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_tag_option_input(Id = Id)
  output <- .servicecatalog$delete_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_tag_option <- servicecatalog_delete_tag_option

#' Gets information about the specified constraint
#'
#' @description
#' Gets information about the specified constraint.
#'
#' @usage
#' servicecatalog_describe_constraint(AcceptLanguage, Id)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The identifier of the constraint.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConstraintDetail = list(
#'     ConstraintId = "string",
#'     Type = "string",
#'     Description = "string",
#'     Owner = "string",
#'     ProductId = "string",
#'     PortfolioId = "string"
#'   ),
#'   ConstraintParameters = "string",
#'   Status = "AVAILABLE"|"CREATING"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_constraint(
#'   AcceptLanguage = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_constraint
servicecatalog_describe_constraint <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DescribeConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_constraint_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$describe_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_constraint <- servicecatalog_describe_constraint

#' Gets the status of the specified copy product operation
#'
#' @description
#' Gets the status of the specified copy product operation.
#'
#' @usage
#' servicecatalog_describe_copy_product_status(AcceptLanguage,
#'   CopyProductToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param CopyProductToken &#91;required&#93; The token for the copy product operation. This token is returned by
#' [`copy_product`][servicecatalog_copy_product].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CopyProductStatus = "SUCCEEDED"|"IN_PROGRESS"|"FAILED",
#'   TargetProductId = "string",
#'   StatusDetail = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_copy_product_status(
#'   AcceptLanguage = "string",
#'   CopyProductToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_copy_product_status
servicecatalog_describe_copy_product_status <- function(AcceptLanguage = NULL, CopyProductToken) {
  op <- new_operation(
    name = "DescribeCopyProductStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_copy_product_status_input(AcceptLanguage = AcceptLanguage, CopyProductToken = CopyProductToken)
  output <- .servicecatalog$describe_copy_product_status_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_copy_product_status <- servicecatalog_describe_copy_product_status

#' Gets information about the specified portfolio
#'
#' @description
#' Gets information about the specified portfolio.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_describe_portfolio(AcceptLanguage, Id)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The portfolio identifier.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioDetail = list(
#'     Id = "string",
#'     ARN = "string",
#'     DisplayName = "string",
#'     Description = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProviderName = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TagOptions = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Active = TRUE|FALSE,
#'       Id = "string",
#'       Owner = "string"
#'     )
#'   ),
#'   Budgets = list(
#'     list(
#'       BudgetName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_portfolio(
#'   AcceptLanguage = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_portfolio
servicecatalog_describe_portfolio <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DescribePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_portfolio_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$describe_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_portfolio <- servicecatalog_describe_portfolio

#' Gets the status of the specified portfolio share operation
#'
#' @description
#' Gets the status of the specified portfolio share operation. This API can
#' only be called by the management account in the organization or by a
#' delegated admin.
#'
#' @usage
#' servicecatalog_describe_portfolio_share_status(PortfolioShareToken)
#'
#' @param PortfolioShareToken &#91;required&#93; The token for the portfolio share operation. This token is returned
#' either by CreatePortfolioShare or by DeletePortfolioShare.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioShareToken = "string",
#'   PortfolioId = "string",
#'   OrganizationNodeValue = "string",
#'   Status = "NOT_STARTED"|"IN_PROGRESS"|"COMPLETED"|"COMPLETED_WITH_ERRORS"|"ERROR",
#'   ShareDetails = list(
#'     SuccessfulShares = list(
#'       "string"
#'     ),
#'     ShareErrors = list(
#'       list(
#'         Accounts = list(
#'           "string"
#'         ),
#'         Message = "string",
#'         Error = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_portfolio_share_status(
#'   PortfolioShareToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_portfolio_share_status
servicecatalog_describe_portfolio_share_status <- function(PortfolioShareToken) {
  op <- new_operation(
    name = "DescribePortfolioShareStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_portfolio_share_status_input(PortfolioShareToken = PortfolioShareToken)
  output <- .servicecatalog$describe_portfolio_share_status_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_portfolio_share_status <- servicecatalog_describe_portfolio_share_status

#' Returns a summary of each of the portfolio shares that were created for
#' the specified portfolio
#'
#' @description
#' Returns a summary of each of the portfolio shares that were created for
#' the specified portfolio.
#' 
#' You can use this API to determine which accounts or organizational nodes
#' this portfolio have been shared, whether the recipient entity has
#' imported the share, and whether TagOptions are included with the share.
#' 
#' The `PortfolioId` and `Type` parameters are both required.
#'
#' @usage
#' servicecatalog_describe_portfolio_shares(PortfolioId, Type, PageToken,
#'   PageSize)
#'
#' @param PortfolioId &#91;required&#93; The unique identifier of the portfolio for which shares will be
#' retrieved.
#' @param Type &#91;required&#93; The type of portfolio share to summarize. This field acts as a filter on
#' the type of portfolio share, which can be one of the following:
#' 
#' 1\. `ACCOUNT` - Represents an external account to account share.
#' 
#' 2\. `ORGANIZATION` - Represents a share to an organization. This share
#' is available to every account in the organization.
#' 
#' 3\. `ORGANIZATIONAL_UNIT` - Represents a share to an organizational
#' unit.
#' 
#' 4\. `ORGANIZATION_MEMBER_ACCOUNT` - Represents a share to an account in
#' the organization.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextPageToken = "string",
#'   PortfolioShareDetails = list(
#'     list(
#'       PrincipalId = "string",
#'       Type = "ACCOUNT"|"ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ORGANIZATION_MEMBER_ACCOUNT",
#'       Accepted = TRUE|FALSE,
#'       ShareTagOptions = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_portfolio_shares(
#'   PortfolioId = "string",
#'   Type = "ACCOUNT"|"ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ORGANIZATION_MEMBER_ACCOUNT",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_portfolio_shares
servicecatalog_describe_portfolio_shares <- function(PortfolioId, Type, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribePortfolioShares",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_portfolio_shares_input(PortfolioId = PortfolioId, Type = Type, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$describe_portfolio_shares_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_portfolio_shares <- servicecatalog_describe_portfolio_shares

#' Gets information about the specified product
#'
#' @description
#' Gets information about the specified product.
#'
#' @usage
#' servicecatalog_describe_product(AcceptLanguage, Id, Name)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id The product identifier.
#' @param Name The product name.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewSummary = list(
#'     Id = "string",
#'     ProductId = "string",
#'     Name = "string",
#'     Owner = "string",
#'     ShortDescription = "string",
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'     Distributor = "string",
#'     HasDefaultPath = TRUE|FALSE,
#'     SupportEmail = "string",
#'     SupportDescription = "string",
#'     SupportUrl = "string"
#'   ),
#'   ProvisioningArtifacts = list(
#'     list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Guidance = "DEFAULT"|"DEPRECATED"
#'     )
#'   ),
#'   Budgets = list(
#'     list(
#'       BudgetName = "string"
#'     )
#'   ),
#'   LaunchPaths = list(
#'     list(
#'       Id = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_product(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_product
servicecatalog_describe_product <- function(AcceptLanguage = NULL, Id = NULL, Name = NULL) {
  op <- new_operation(
    name = "DescribeProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_product_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name)
  output <- .servicecatalog$describe_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_product <- servicecatalog_describe_product

#' Gets information about the specified product
#'
#' @description
#' Gets information about the specified product. This operation is run with
#' administrator access.
#'
#' @usage
#' servicecatalog_describe_product_as_admin(AcceptLanguage, Id, Name,
#'   SourcePortfolioId)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id The product identifier.
#' @param Name The product name.
#' @param SourcePortfolioId The unique identifier of the shared portfolio that the specified product
#' is associated with.
#' 
#' You can provide this parameter to retrieve the shared TagOptions
#' associated with the product. If this parameter is provided and if
#' TagOptions sharing is enabled in the portfolio share, the API returns
#' both local and shared TagOptions associated with the product. Otherwise
#' only local TagOptions will be returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewDetail = list(
#'     ProductViewSummary = list(
#'       Id = "string",
#'       ProductId = "string",
#'       Name = "string",
#'       Owner = "string",
#'       ShortDescription = "string",
#'       Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'       Distributor = "string",
#'       HasDefaultPath = TRUE|FALSE,
#'       SupportEmail = "string",
#'       SupportDescription = "string",
#'       SupportUrl = "string"
#'     ),
#'     Status = "AVAILABLE"|"CREATING"|"FAILED",
#'     ProductARN = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   ProvisioningArtifactSummaries = list(
#'     list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ProvisioningArtifactMetadata = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TagOptions = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Active = TRUE|FALSE,
#'       Id = "string",
#'       Owner = "string"
#'     )
#'   ),
#'   Budgets = list(
#'     list(
#'       BudgetName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_product_as_admin(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   Name = "string",
#'   SourcePortfolioId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_product_as_admin
servicecatalog_describe_product_as_admin <- function(AcceptLanguage = NULL, Id = NULL, Name = NULL, SourcePortfolioId = NULL) {
  op <- new_operation(
    name = "DescribeProductAsAdmin",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_product_as_admin_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name, SourcePortfolioId = SourcePortfolioId)
  output <- .servicecatalog$describe_product_as_admin_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_product_as_admin <- servicecatalog_describe_product_as_admin

#' Gets information about the specified product
#'
#' @description
#' Gets information about the specified product.
#'
#' @usage
#' servicecatalog_describe_product_view(AcceptLanguage, Id)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The product view identifier.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewSummary = list(
#'     Id = "string",
#'     ProductId = "string",
#'     Name = "string",
#'     Owner = "string",
#'     ShortDescription = "string",
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'     Distributor = "string",
#'     HasDefaultPath = TRUE|FALSE,
#'     SupportEmail = "string",
#'     SupportDescription = "string",
#'     SupportUrl = "string"
#'   ),
#'   ProvisioningArtifacts = list(
#'     list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Guidance = "DEFAULT"|"DEPRECATED"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_product_view(
#'   AcceptLanguage = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_product_view
servicecatalog_describe_product_view <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DescribeProductView",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_product_view_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$describe_product_view_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_product_view <- servicecatalog_describe_product_view

#' Gets information about the specified provisioned product
#'
#' @description
#' Gets information about the specified provisioned product.
#'
#' @usage
#' servicecatalog_describe_provisioned_product(AcceptLanguage, Id, Name)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id The provisioned product identifier. You must provide the name or ID, but
#' not both.
#' 
#' If you do not provide a name or ID, or you provide both name and ID, an
#' `InvalidParametersException` will occur.
#' @param Name The name of the provisioned product. You must provide the name or ID,
#' but not both.
#' 
#' If you do not provide a name or ID, or you provide both name and ID, an
#' `InvalidParametersException` will occur.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisionedProductDetail = list(
#'     Name = "string",
#'     Arn = "string",
#'     Type = "string",
#'     Id = "string",
#'     Status = "AVAILABLE"|"UNDER_CHANGE"|"TAINTED"|"ERROR"|"PLAN_IN_PROGRESS",
#'     StatusMessage = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     IdempotencyToken = "string",
#'     LastRecordId = "string",
#'     LastProvisioningRecordId = "string",
#'     LastSuccessfulProvisioningRecordId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     LaunchRoleArn = "string"
#'   ),
#'   CloudWatchDashboards = list(
#'     list(
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_provisioned_product(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioned_product
servicecatalog_describe_provisioned_product <- function(AcceptLanguage = NULL, Id = NULL, Name = NULL) {
  op <- new_operation(
    name = "DescribeProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioned_product_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name)
  output <- .servicecatalog$describe_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioned_product <- servicecatalog_describe_provisioned_product

#' Gets information about the resource changes for the specified plan
#'
#' @description
#' Gets information about the resource changes for the specified plan.
#'
#' @usage
#' servicecatalog_describe_provisioned_product_plan(AcceptLanguage, PlanId,
#'   PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanId &#91;required&#93; The plan identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisionedProductPlanDetails = list(
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PathId = "string",
#'     ProductId = "string",
#'     PlanName = "string",
#'     PlanId = "string",
#'     ProvisionProductId = "string",
#'     ProvisionProductName = "string",
#'     PlanType = "CLOUDFORMATION",
#'     ProvisioningArtifactId = "string",
#'     Status = "CREATE_IN_PROGRESS"|"CREATE_SUCCESS"|"CREATE_FAILED"|"EXECUTE_IN_PROGRESS"|"EXECUTE_SUCCESS"|"EXECUTE_FAILED",
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     NotificationArns = list(
#'       "string"
#'     ),
#'     ProvisioningParameters = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         UsePreviousValue = TRUE|FALSE
#'       )
#'     ),
#'     Tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     StatusMessage = "string"
#'   ),
#'   ResourceChanges = list(
#'     list(
#'       Action = "ADD"|"MODIFY"|"REMOVE",
#'       LogicalResourceId = "string",
#'       PhysicalResourceId = "string",
#'       ResourceType = "string",
#'       Replacement = "TRUE"|"FALSE"|"CONDITIONAL",
#'       Scope = list(
#'         "PROPERTIES"|"METADATA"|"CREATIONPOLICY"|"UPDATEPOLICY"|"DELETIONPOLICY"|"TAGS"
#'       ),
#'       Details = list(
#'         list(
#'           Target = list(
#'             Attribute = "PROPERTIES"|"METADATA"|"CREATIONPOLICY"|"UPDATEPOLICY"|"DELETIONPOLICY"|"TAGS",
#'             Name = "string",
#'             RequiresRecreation = "NEVER"|"CONDITIONALLY"|"ALWAYS"
#'           ),
#'           Evaluation = "STATIC"|"DYNAMIC",
#'           CausingEntity = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_provisioned_product_plan(
#'   AcceptLanguage = "string",
#'   PlanId = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioned_product_plan
servicecatalog_describe_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "DescribeProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanId = PlanId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$describe_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioned_product_plan <- servicecatalog_describe_provisioned_product_plan

#' Gets information about the specified provisioning artifact (also known
#' as a version) for the specified product
#'
#' @description
#' Gets information about the specified provisioning artifact (also known
#' as a version) for the specified product.
#'
#' @usage
#' servicecatalog_describe_provisioning_artifact(AcceptLanguage,
#'   ProvisioningArtifactId, ProductId, ProvisioningArtifactName,
#'   ProductName, Verbose)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisioningArtifactId The identifier of the provisioning artifact.
#' @param ProductId The product identifier.
#' @param ProvisioningArtifactName The provisioning artifact name.
#' @param ProductName The product name.
#' @param Verbose Indicates whether a verbose level of detail is enabled.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisioningArtifactDetail = list(
#'     Id = "string",
#'     Name = "string",
#'     Description = "string",
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Active = TRUE|FALSE,
#'     Guidance = "DEFAULT"|"DEPRECATED"
#'   ),
#'   Info = list(
#'     "string"
#'   ),
#'   Status = "AVAILABLE"|"CREATING"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_provisioning_artifact(
#'   AcceptLanguage = "string",
#'   ProvisioningArtifactId = "string",
#'   ProductId = "string",
#'   ProvisioningArtifactName = "string",
#'   ProductName = "string",
#'   Verbose = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioning_artifact
servicecatalog_describe_provisioning_artifact <- function(AcceptLanguage = NULL, ProvisioningArtifactId = NULL, ProductId = NULL, ProvisioningArtifactName = NULL, ProductName = NULL, Verbose = NULL) {
  op <- new_operation(
    name = "DescribeProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProvisioningArtifactId = ProvisioningArtifactId, ProductId = ProductId, ProvisioningArtifactName = ProvisioningArtifactName, ProductName = ProductName, Verbose = Verbose)
  output <- .servicecatalog$describe_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioning_artifact <- servicecatalog_describe_provisioning_artifact

#' Gets information about the configuration required to provision the
#' specified product using the specified provisioning artifact
#'
#' @description
#' Gets information about the configuration required to provision the
#' specified product using the specified provisioning artifact.
#' 
#' If the output contains a TagOption key with an empty list of values,
#' there is a TagOption conflict for that key. The end user cannot take
#' action to fix the conflict, and launch is not blocked. In subsequent
#' calls to [`provision_product`][servicecatalog_provision_product], do not
#' include conflicted TagOption keys as tags, or this causes the error
#' "Parameter validation failed: Missing required parameter in
#' Tags\[*N*\]:*Value*". Tag the provisioned product with the value
#' `sc-tagoption-conflict-portfolioId-productId`.
#'
#' @usage
#' servicecatalog_describe_provisioning_parameters(AcceptLanguage,
#'   ProductId, ProductName, ProvisioningArtifactId,
#'   ProvisioningArtifactName, PathId, PathName)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId The product identifier. You must provide the product name or ID, but not
#' both.
#' @param ProductName The name of the product. You must provide the name or ID, but not both.
#' @param ProvisioningArtifactId The identifier of the provisioning artifact. You must provide the name
#' or ID, but not both.
#' @param ProvisioningArtifactName The name of the provisioning artifact. You must provide the name or ID,
#' but not both.
#' @param PathId The path identifier of the product. This value is optional if the
#' product has a default path, and required if the product has more than
#' one path. To list the paths for a product, use
#' [`list_launch_paths`][servicecatalog_list_launch_paths]. You must
#' provide the name or ID, but not both.
#' @param PathName The name of the path. You must provide the name or ID, but not both.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisioningArtifactParameters = list(
#'     list(
#'       ParameterKey = "string",
#'       DefaultValue = "string",
#'       ParameterType = "string",
#'       IsNoEcho = TRUE|FALSE,
#'       Description = "string",
#'       ParameterConstraints = list(
#'         AllowedValues = list(
#'           "string"
#'         ),
#'         AllowedPattern = "string",
#'         ConstraintDescription = "string",
#'         MaxLength = "string",
#'         MinLength = "string",
#'         MaxValue = "string",
#'         MinValue = "string"
#'       )
#'     )
#'   ),
#'   ConstraintSummaries = list(
#'     list(
#'       Type = "string",
#'       Description = "string"
#'     )
#'   ),
#'   UsageInstructions = list(
#'     list(
#'       Type = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TagOptions = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ProvisioningArtifactPreferences = list(
#'     StackSetAccounts = list(
#'       "string"
#'     ),
#'     StackSetRegions = list(
#'       "string"
#'     )
#'   ),
#'   ProvisioningArtifactOutputs = list(
#'     list(
#'       Key = "string",
#'       Description = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_provisioning_parameters(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   ProductName = "string",
#'   ProvisioningArtifactId = "string",
#'   ProvisioningArtifactName = "string",
#'   PathId = "string",
#'   PathName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioning_parameters
servicecatalog_describe_provisioning_parameters <- function(AcceptLanguage = NULL, ProductId = NULL, ProductName = NULL, ProvisioningArtifactId = NULL, ProvisioningArtifactName = NULL, PathId = NULL, PathName = NULL) {
  op <- new_operation(
    name = "DescribeProvisioningParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioning_parameters_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProductName = ProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningArtifactName = ProvisioningArtifactName, PathId = PathId, PathName = PathName)
  output <- .servicecatalog$describe_provisioning_parameters_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioning_parameters <- servicecatalog_describe_provisioning_parameters

#' Gets information about the specified request operation
#'
#' @description
#' Gets information about the specified request operation.
#' 
#' Use this operation after calling a request operation (for example,
#' [`provision_product`][servicecatalog_provision_product],
#' [`terminate_provisioned_product`][servicecatalog_terminate_provisioned_product],
#' or
#' [`update_provisioned_product`][servicecatalog_update_provisioned_product]).
#' 
#' If a provisioned product was transferred to a new owner using
#' [`update_provisioned_product_properties`][servicecatalog_update_provisioned_product_properties],
#' the new owner will be able to describe all past records for that
#' product. The previous owner will no longer be able to describe the
#' records, but will be able to use
#' [`list_record_history`][servicecatalog_list_record_history] to see the
#' product's history from when he was the owner.
#'
#' @usage
#' servicecatalog_describe_record(AcceptLanguage, Id, PageToken, PageSize)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The record identifier of the provisioned product. This identifier is
#' returned by the request operation.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   ),
#'   RecordOutputs = list(
#'     list(
#'       OutputKey = "string",
#'       OutputValue = "string",
#'       Description = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_record(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_record
servicecatalog_describe_record <- function(AcceptLanguage = NULL, Id, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeRecord",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_record_input(AcceptLanguage = AcceptLanguage, Id = Id, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$describe_record_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_record <- servicecatalog_describe_record

#' Describes a self-service action
#'
#' @description
#' Describes a self-service action.
#'
#' @usage
#' servicecatalog_describe_service_action(Id, AcceptLanguage)
#'
#' @param Id &#91;required&#93; The self-service action identifier.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceActionDetail = list(
#'     ServiceActionSummary = list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       DefinitionType = "SSM_AUTOMATION"
#'     ),
#'     Definition = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_service_action(
#'   Id = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_service_action
servicecatalog_describe_service_action <- function(Id, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DescribeServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_service_action_input(Id = Id, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$describe_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_service_action <- servicecatalog_describe_service_action

#' Finds the default parameters for a specific self-service action on a
#' specific provisioned product and returns a map of the results to the
#' user
#'
#' @description
#' Finds the default parameters for a specific self-service action on a
#' specific provisioned product and returns a map of the results to the
#' user.
#'
#' @usage
#' servicecatalog_describe_service_action_execution_parameters(
#'   ProvisionedProductId, ServiceActionId, AcceptLanguage)
#'
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceActionParameters = list(
#'     list(
#'       Name = "string",
#'       Type = "string",
#'       DefaultValues = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_service_action_execution_parameters(
#'   ProvisionedProductId = "string",
#'   ServiceActionId = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_service_action_execution_parameters
servicecatalog_describe_service_action_execution_parameters <- function(ProvisionedProductId, ServiceActionId, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DescribeServiceActionExecutionParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_service_action_execution_parameters_input(ProvisionedProductId = ProvisionedProductId, ServiceActionId = ServiceActionId, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$describe_service_action_execution_parameters_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_service_action_execution_parameters <- servicecatalog_describe_service_action_execution_parameters

#' Gets information about the specified TagOption
#'
#' @description
#' Gets information about the specified TagOption.
#'
#' @usage
#' servicecatalog_describe_tag_option(Id)
#'
#' @param Id &#91;required&#93; The TagOption identifier.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TagOptionDetail = list(
#'     Key = "string",
#'     Value = "string",
#'     Active = TRUE|FALSE,
#'     Id = "string",
#'     Owner = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_tag_option(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_tag_option
servicecatalog_describe_tag_option <- function(Id) {
  op <- new_operation(
    name = "DescribeTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_tag_option_input(Id = Id)
  output <- .servicecatalog$describe_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_tag_option <- servicecatalog_describe_tag_option

#' Disable portfolio sharing through AWS Organizations feature
#'
#' @description
#' Disable portfolio sharing through AWS Organizations feature. This
#' feature will not delete your current shares but it will prevent you from
#' creating new shares throughout your organization. Current shares will
#' not be in sync with your organization structure if it changes after
#' calling this API. This API can only be called by the management account
#' in the organization.
#' 
#' This API can't be invoked if there are active delegated administrators
#' in the organization.
#' 
#' Note that a delegated administrator is not authorized to invoke
#' [`disable_aws_organizations_access`][servicecatalog_disable_aws_organizations_access].
#'
#' @usage
#' servicecatalog_disable_aws_organizations_access()
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disable_aws_organizations_access()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disable_aws_organizations_access
servicecatalog_disable_aws_organizations_access <- function() {
  op <- new_operation(
    name = "DisableAWSOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disable_aws_organizations_access_input()
  output <- .servicecatalog$disable_aws_organizations_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disable_aws_organizations_access <- servicecatalog_disable_aws_organizations_access

#' Disassociates the specified budget from the specified resource
#'
#' @description
#' Disassociates the specified budget from the specified resource.
#'
#' @usage
#' servicecatalog_disassociate_budget_from_resource(BudgetName, ResourceId)
#'
#' @param BudgetName &#91;required&#93; The name of the budget you want to disassociate.
#' @param ResourceId &#91;required&#93; The resource identifier you want to disassociate from. Either a
#' portfolio-id or a product-id.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_budget_from_resource(
#'   BudgetName = "string",
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_budget_from_resource
servicecatalog_disassociate_budget_from_resource <- function(BudgetName, ResourceId) {
  op <- new_operation(
    name = "DisassociateBudgetFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_budget_from_resource_input(BudgetName = BudgetName, ResourceId = ResourceId)
  output <- .servicecatalog$disassociate_budget_from_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_budget_from_resource <- servicecatalog_disassociate_budget_from_resource

#' Disassociates a previously associated principal ARN from a specified
#' portfolio
#'
#' @description
#' Disassociates a previously associated principal ARN from a specified
#' portfolio.
#'
#' @usage
#' servicecatalog_disassociate_principal_from_portfolio(AcceptLanguage,
#'   PortfolioId, PrincipalARN)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PrincipalARN &#91;required&#93; The ARN of the principal (IAM user, role, or group).
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_principal_from_portfolio(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   PrincipalARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_principal_from_portfolio
servicecatalog_disassociate_principal_from_portfolio <- function(AcceptLanguage = NULL, PortfolioId, PrincipalARN) {
  op <- new_operation(
    name = "DisassociatePrincipalFromPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_principal_from_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PrincipalARN = PrincipalARN)
  output <- .servicecatalog$disassociate_principal_from_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_principal_from_portfolio <- servicecatalog_disassociate_principal_from_portfolio

#' Disassociates the specified product from the specified portfolio
#'
#' @description
#' Disassociates the specified product from the specified portfolio.
#' 
#' A delegated admin is authorized to invoke this command.
#'
#' @usage
#' servicecatalog_disassociate_product_from_portfolio(AcceptLanguage,
#'   ProductId, PortfolioId)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_product_from_portfolio(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   PortfolioId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_product_from_portfolio
servicecatalog_disassociate_product_from_portfolio <- function(AcceptLanguage = NULL, ProductId, PortfolioId) {
  op <- new_operation(
    name = "DisassociateProductFromPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_product_from_portfolio_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PortfolioId = PortfolioId)
  output <- .servicecatalog$disassociate_product_from_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_product_from_portfolio <- servicecatalog_disassociate_product_from_portfolio

#' Disassociates the specified self-service action association from the
#' specified provisioning artifact
#'
#' @description
#' Disassociates the specified self-service action association from the
#' specified provisioning artifact.
#'
#' @usage
#' servicecatalog_disassociate_service_action_from_provisioning_artifact(
#'   ProductId, ProvisioningArtifactId, ServiceActionId, AcceptLanguage)
#'
#' @param ProductId &#91;required&#93; The product identifier. For example, `prod-abcdzk7xy33qa`.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact. For example,
#' `pa-4abcdjnxjj6ne`.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_service_action_from_provisioning_artifact(
#'   ProductId = "string",
#'   ProvisioningArtifactId = "string",
#'   ServiceActionId = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_service_action_from_provisioning_artifact
servicecatalog_disassociate_service_action_from_provisioning_artifact <- function(ProductId, ProvisioningArtifactId, ServiceActionId, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DisassociateServiceActionFromProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_service_action_from_provisioning_artifact_input(ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, ServiceActionId = ServiceActionId, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$disassociate_service_action_from_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_service_action_from_provisioning_artifact <- servicecatalog_disassociate_service_action_from_provisioning_artifact

#' Disassociates the specified TagOption from the specified resource
#'
#' @description
#' Disassociates the specified TagOption from the specified resource.
#'
#' @usage
#' servicecatalog_disassociate_tag_option_from_resource(ResourceId,
#'   TagOptionId)
#'
#' @param ResourceId &#91;required&#93; The resource identifier.
#' @param TagOptionId &#91;required&#93; The TagOption identifier.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_tag_option_from_resource(
#'   ResourceId = "string",
#'   TagOptionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_tag_option_from_resource
servicecatalog_disassociate_tag_option_from_resource <- function(ResourceId, TagOptionId) {
  op <- new_operation(
    name = "DisassociateTagOptionFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_tag_option_from_resource_input(ResourceId = ResourceId, TagOptionId = TagOptionId)
  output <- .servicecatalog$disassociate_tag_option_from_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_tag_option_from_resource <- servicecatalog_disassociate_tag_option_from_resource

#' Enable portfolio sharing feature through AWS Organizations
#'
#' @description
#' Enable portfolio sharing feature through AWS Organizations. This API
#' will allow Service Catalog to receive updates on your organization in
#' order to sync your shares with the current structure. This API can only
#' be called by the management account in the organization.
#' 
#' By calling this API Service Catalog will make a call to
#' organizations:EnableAWSServiceAccess on your behalf so that your shares
#' can be in sync with any changes in your AWS Organizations structure.
#' 
#' Note that a delegated administrator is not authorized to invoke
#' [`enable_aws_organizations_access`][servicecatalog_enable_aws_organizations_access].
#'
#' @usage
#' servicecatalog_enable_aws_organizations_access()
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$enable_aws_organizations_access()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_enable_aws_organizations_access
servicecatalog_enable_aws_organizations_access <- function() {
  op <- new_operation(
    name = "EnableAWSOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$enable_aws_organizations_access_input()
  output <- .servicecatalog$enable_aws_organizations_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$enable_aws_organizations_access <- servicecatalog_enable_aws_organizations_access

#' Provisions or modifies a product based on the resource changes for the
#' specified plan
#'
#' @description
#' Provisions or modifies a product based on the resource changes for the
#' specified plan.
#'
#' @usage
#' servicecatalog_execute_provisioned_product_plan(AcceptLanguage, PlanId,
#'   IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanId &#91;required&#93; The plan identifier.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$execute_provisioned_product_plan(
#'   AcceptLanguage = "string",
#'   PlanId = "string",
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_execute_provisioned_product_plan
servicecatalog_execute_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanId, IdempotencyToken) {
  op <- new_operation(
    name = "ExecuteProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$execute_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanId = PlanId, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$execute_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$execute_provisioned_product_plan <- servicecatalog_execute_provisioned_product_plan

#' Executes a self-service action against a provisioned product
#'
#' @description
#' Executes a self-service action against a provisioned product.
#'
#' @usage
#' servicecatalog_execute_provisioned_product_service_action(
#'   ProvisionedProductId, ServiceActionId, ExecuteToken, AcceptLanguage,
#'   Parameters)
#'
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param ExecuteToken &#91;required&#93; An idempotency token that uniquely identifies the execute request.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Parameters A map of all self-service action parameters and their values. If a
#' provided parameter is of a special type, such as `TARGET`, the provided
#' value will override the default value generated by AWS Service Catalog.
#' If the parameters field is not provided, no additional parameters are
#' passed and default values will be used for any special parameters such
#' as `TARGET`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$execute_provisioned_product_service_action(
#'   ProvisionedProductId = "string",
#'   ServiceActionId = "string",
#'   ExecuteToken = "string",
#'   AcceptLanguage = "string",
#'   Parameters = list(
#'     list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_execute_provisioned_product_service_action
servicecatalog_execute_provisioned_product_service_action <- function(ProvisionedProductId, ServiceActionId, ExecuteToken, AcceptLanguage = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ExecuteProvisionedProductServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$execute_provisioned_product_service_action_input(ProvisionedProductId = ProvisionedProductId, ServiceActionId = ServiceActionId, ExecuteToken = ExecuteToken, AcceptLanguage = AcceptLanguage, Parameters = Parameters)
  output <- .servicecatalog$execute_provisioned_product_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$execute_provisioned_product_service_action <- servicecatalog_execute_provisioned_product_service_action

#' Get the Access Status for AWS Organization portfolio share feature
#'
#' @description
#' Get the Access Status for AWS Organization portfolio share feature. This
#' API can only be called by the management account in the organization or
#' by a delegated admin.
#'
#' @usage
#' servicecatalog_get_aws_organizations_access_status()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AccessStatus = "ENABLED"|"UNDER_CHANGE"|"DISABLED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_aws_organizations_access_status()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_get_aws_organizations_access_status
servicecatalog_get_aws_organizations_access_status <- function() {
  op <- new_operation(
    name = "GetAWSOrganizationsAccessStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$get_aws_organizations_access_status_input()
  output <- .servicecatalog$get_aws_organizations_access_status_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$get_aws_organizations_access_status <- servicecatalog_get_aws_organizations_access_status

#' This API takes either a ProvisonedProductId or a ProvisionedProductName,
#' along with a list of one or more output keys, and responds with the
#' key/value pairs of those outputs
#'
#' @description
#' This API takes either a `ProvisonedProductId` or a
#' `ProvisionedProductName`, along with a list of one or more output keys,
#' and responds with the key/value pairs of those outputs.
#'
#' @usage
#' servicecatalog_get_provisioned_product_outputs(AcceptLanguage,
#'   ProvisionedProductId, ProvisionedProductName, OutputKeys, PageSize,
#'   PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductId The identifier of the provisioned product that you want the outputs
#' from.
#' @param ProvisionedProductName The name of the provisioned product that you want the outputs from.
#' @param OutputKeys The list of keys that the API should return with their values. If none
#' are provided, the API will return all outputs of the provisioned
#' product.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Outputs = list(
#'     list(
#'       OutputKey = "string",
#'       OutputValue = "string",
#'       Description = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_provisioned_product_outputs(
#'   AcceptLanguage = "string",
#'   ProvisionedProductId = "string",
#'   ProvisionedProductName = "string",
#'   OutputKeys = list(
#'     "string"
#'   ),
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_get_provisioned_product_outputs
servicecatalog_get_provisioned_product_outputs <- function(AcceptLanguage = NULL, ProvisionedProductId = NULL, ProvisionedProductName = NULL, OutputKeys = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "GetProvisionedProductOutputs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$get_provisioned_product_outputs_input(AcceptLanguage = AcceptLanguage, ProvisionedProductId = ProvisionedProductId, ProvisionedProductName = ProvisionedProductName, OutputKeys = OutputKeys, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$get_provisioned_product_outputs_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$get_provisioned_product_outputs <- servicecatalog_get_provisioned_product_outputs

#' Requests the import of a resource as a Service Catalog provisioned
#' product that is associated to a Service Catalog product and provisioning
#' artifact
#'
#' @description
#' Requests the import of a resource as a Service Catalog provisioned
#' product that is associated to a Service Catalog product and provisioning
#' artifact. Once imported, all supported Service Catalog governance
#' actions are supported on the provisioned product.
#' 
#' Resource import only supports CloudFormation stack ARNs. CloudFormation
#' StackSets and non-root nested stacks are not supported.
#' 
#' The CloudFormation stack must have one of the following statuses to be
#' imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`,
#' `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`,
#' `IMPORT_ROLLBACK_COMPLETE`.
#' 
#' Import of the resource requires that the CloudFormation stack template
#' matches the associated Service Catalog product provisioning artifact.
#' 
#' The user or role that performs this operation must have the
#' `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM
#' policy permissions.
#'
#' @usage
#' servicecatalog_import_as_provisioned_product(AcceptLanguage, ProductId,
#'   ProvisioningArtifactId, ProvisionedProductName, PhysicalId,
#'   IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#' @param ProvisionedProductName &#91;required&#93; The user-friendly name of the provisioned product. The value must be
#' unique for the AWS account. The name cannot be updated after the product
#' is provisioned.
#' @param PhysicalId &#91;required&#93; The unique identifier of the resource to be imported. It only currently
#' supports CloudFormation stack IDs.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$import_as_provisioned_product(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   ProvisioningArtifactId = "string",
#'   ProvisionedProductName = "string",
#'   PhysicalId = "string",
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_import_as_provisioned_product
servicecatalog_import_as_provisioned_product <- function(AcceptLanguage = NULL, ProductId, ProvisioningArtifactId, ProvisionedProductName, PhysicalId, IdempotencyToken) {
  op <- new_operation(
    name = "ImportAsProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$import_as_provisioned_product_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, ProvisionedProductName = ProvisionedProductName, PhysicalId = PhysicalId, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$import_as_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$import_as_provisioned_product <- servicecatalog_import_as_provisioned_product

#' Lists all portfolios for which sharing was accepted by this account
#'
#' @description
#' Lists all portfolios for which sharing was accepted by this account.
#'
#' @usage
#' servicecatalog_list_accepted_portfolio_shares(AcceptLanguage, PageToken,
#'   PageSize, PortfolioShareType)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#' @param PortfolioShareType The type of shared portfolios to list. The default is to list imported
#' portfolios.
#' 
#' -   `AWS_ORGANIZATIONS` - List portfolios shared by the management
#'     account of your organization
#' 
#' -   `AWS_SERVICECATALOG` - List default portfolios
#' 
#' -   `IMPORTED` - List imported portfolios
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioDetails = list(
#'     list(
#'       Id = "string",
#'       ARN = "string",
#'       DisplayName = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ProviderName = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_accepted_portfolio_shares(
#'   AcceptLanguage = "string",
#'   PageToken = "string",
#'   PageSize = 123,
#'   PortfolioShareType = "IMPORTED"|"AWS_SERVICECATALOG"|"AWS_ORGANIZATIONS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_accepted_portfolio_shares
servicecatalog_list_accepted_portfolio_shares <- function(AcceptLanguage = NULL, PageToken = NULL, PageSize = NULL, PortfolioShareType = NULL) {
  op <- new_operation(
    name = "ListAcceptedPortfolioShares",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_accepted_portfolio_shares_input(AcceptLanguage = AcceptLanguage, PageToken = PageToken, PageSize = PageSize, PortfolioShareType = PortfolioShareType)
  output <- .servicecatalog$list_accepted_portfolio_shares_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_accepted_portfolio_shares <- servicecatalog_list_accepted_portfolio_shares

#' Lists all the budgets associated to the specified resource
#'
#' @description
#' Lists all the budgets associated to the specified resource.
#'
#' @usage
#' servicecatalog_list_budgets_for_resource(AcceptLanguage, ResourceId,
#'   PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ResourceId &#91;required&#93; The resource identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Budgets = list(
#'     list(
#'       BudgetName = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_budgets_for_resource(
#'   AcceptLanguage = "string",
#'   ResourceId = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_budgets_for_resource
servicecatalog_list_budgets_for_resource <- function(AcceptLanguage = NULL, ResourceId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListBudgetsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_budgets_for_resource_input(AcceptLanguage = AcceptLanguage, ResourceId = ResourceId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_budgets_for_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_budgets_for_resource <- servicecatalog_list_budgets_for_resource

#' Lists the constraints for the specified portfolio and product
#'
#' @description
#' Lists the constraints for the specified portfolio and product.
#'
#' @usage
#' servicecatalog_list_constraints_for_portfolio(AcceptLanguage,
#'   PortfolioId, ProductId, PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param ProductId The product identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConstraintDetails = list(
#'     list(
#'       ConstraintId = "string",
#'       Type = "string",
#'       Description = "string",
#'       Owner = "string",
#'       ProductId = "string",
#'       PortfolioId = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_constraints_for_portfolio(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   ProductId = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_constraints_for_portfolio
servicecatalog_list_constraints_for_portfolio <- function(AcceptLanguage = NULL, PortfolioId, ProductId = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListConstraintsForPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_constraints_for_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, ProductId = ProductId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_constraints_for_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_constraints_for_portfolio <- servicecatalog_list_constraints_for_portfolio

#' Lists the paths to the specified product
#'
#' @description
#' Lists the paths to the specified product. A path is how the user has
#' access to a specified product, and is necessary when provisioning a
#' product. A path also determines the constraints put on the product.
#'
#' @usage
#' servicecatalog_list_launch_paths(AcceptLanguage, ProductId, PageSize,
#'   PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LaunchPathSummaries = list(
#'     list(
#'       Id = "string",
#'       ConstraintSummaries = list(
#'         list(
#'           Type = "string",
#'           Description = "string"
#'         )
#'       ),
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Name = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_launch_paths(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_launch_paths
servicecatalog_list_launch_paths <- function(AcceptLanguage = NULL, ProductId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListLaunchPaths",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_launch_paths_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_launch_paths_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_launch_paths <- servicecatalog_list_launch_paths

#' Lists the organization nodes that have access to the specified portfolio
#'
#' @description
#' Lists the organization nodes that have access to the specified
#' portfolio. This API can only be called by the management account in the
#' organization or by a delegated admin.
#' 
#' If a delegated admin is de-registered, they can no longer perform this
#' operation.
#'
#' @usage
#' servicecatalog_list_organization_portfolio_access(AcceptLanguage,
#'   PortfolioId, OrganizationNodeType, PageToken, PageSize)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier. For example, `port-2abcdext3y5fk`.
#' @param OrganizationNodeType &#91;required&#93; The organization node type that will be returned in the output.
#' 
#' -   `ORGANIZATION` - Organization that has access to the portfolio.
#' 
#' -   `ORGANIZATIONAL_UNIT` - Organizational unit that has access to the
#'     portfolio within your organization.
#' 
#' -   `ACCOUNT` - Account that has access to the portfolio within your
#'     organization.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   OrganizationNodes = list(
#'     list(
#'       Type = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
#'       Value = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_organization_portfolio_access(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   OrganizationNodeType = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_organization_portfolio_access
servicecatalog_list_organization_portfolio_access <- function(AcceptLanguage = NULL, PortfolioId, OrganizationNodeType, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListOrganizationPortfolioAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_organization_portfolio_access_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, OrganizationNodeType = OrganizationNodeType, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_organization_portfolio_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_organization_portfolio_access <- servicecatalog_list_organization_portfolio_access

#' Lists the account IDs that have access to the specified portfolio
#'
#' @description
#' Lists the account IDs that have access to the specified portfolio.
#' 
#' A delegated admin can list the accounts that have access to the shared
#' portfolio. Note that if a delegated admin is de-registered, they can no
#' longer perform this operation.
#'
#' @usage
#' servicecatalog_list_portfolio_access(AcceptLanguage, PortfolioId,
#'   OrganizationParentId, PageToken, PageSize)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param OrganizationParentId The ID of an organization node the portfolio is shared with. All
#' children of this node with an inherited portfolio share will be
#' returned.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   AccountIds = list(
#'     "string"
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_portfolio_access(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   OrganizationParentId = "string",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_portfolio_access
servicecatalog_list_portfolio_access <- function(AcceptLanguage = NULL, PortfolioId, OrganizationParentId = NULL, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListPortfolioAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_portfolio_access_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, OrganizationParentId = OrganizationParentId, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_portfolio_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_portfolio_access <- servicecatalog_list_portfolio_access

#' Lists all portfolios in the catalog
#'
#' @description
#' Lists all portfolios in the catalog.
#'
#' @usage
#' servicecatalog_list_portfolios(AcceptLanguage, PageToken, PageSize)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioDetails = list(
#'     list(
#'       Id = "string",
#'       ARN = "string",
#'       DisplayName = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ProviderName = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_portfolios(
#'   AcceptLanguage = "string",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_portfolios
servicecatalog_list_portfolios <- function(AcceptLanguage = NULL, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListPortfolios",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_portfolios_input(AcceptLanguage = AcceptLanguage, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_portfolios_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_portfolios <- servicecatalog_list_portfolios

#' Lists all portfolios that the specified product is associated with
#'
#' @description
#' Lists all portfolios that the specified product is associated with.
#'
#' @usage
#' servicecatalog_list_portfolios_for_product(AcceptLanguage, ProductId,
#'   PageToken, PageSize)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioDetails = list(
#'     list(
#'       Id = "string",
#'       ARN = "string",
#'       DisplayName = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ProviderName = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_portfolios_for_product(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_portfolios_for_product
servicecatalog_list_portfolios_for_product <- function(AcceptLanguage = NULL, ProductId, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListPortfoliosForProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_portfolios_for_product_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_portfolios_for_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_portfolios_for_product <- servicecatalog_list_portfolios_for_product

#' Lists all principal ARNs associated with the specified portfolio
#'
#' @description
#' Lists all principal ARNs associated with the specified portfolio.
#'
#' @usage
#' servicecatalog_list_principals_for_portfolio(AcceptLanguage,
#'   PortfolioId, PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Principals = list(
#'     list(
#'       PrincipalARN = "string",
#'       PrincipalType = "IAM"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_principals_for_portfolio(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_principals_for_portfolio
servicecatalog_list_principals_for_portfolio <- function(AcceptLanguage = NULL, PortfolioId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListPrincipalsForPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_principals_for_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_principals_for_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_principals_for_portfolio <- servicecatalog_list_principals_for_portfolio

#' Lists the plans for the specified provisioned product or all plans to
#' which the user has access
#'
#' @description
#' Lists the plans for the specified provisioned product or all plans to
#' which the user has access.
#'
#' @usage
#' servicecatalog_list_provisioned_product_plans(AcceptLanguage,
#'   ProvisionProductId, PageSize, PageToken, AccessLevelFilter)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionProductId The product identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisionedProductPlans = list(
#'     list(
#'       PlanName = "string",
#'       PlanId = "string",
#'       ProvisionProductId = "string",
#'       ProvisionProductName = "string",
#'       PlanType = "CLOUDFORMATION",
#'       ProvisioningArtifactId = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_provisioned_product_plans(
#'   AcceptLanguage = "string",
#'   ProvisionProductId = "string",
#'   PageSize = 123,
#'   PageToken = "string",
#'   AccessLevelFilter = list(
#'     Key = "Account"|"Role"|"User",
#'     Value = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_provisioned_product_plans
servicecatalog_list_provisioned_product_plans <- function(AcceptLanguage = NULL, ProvisionProductId = NULL, PageSize = NULL, PageToken = NULL, AccessLevelFilter = NULL) {
  op <- new_operation(
    name = "ListProvisionedProductPlans",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_provisioned_product_plans_input(AcceptLanguage = AcceptLanguage, ProvisionProductId = ProvisionProductId, PageSize = PageSize, PageToken = PageToken, AccessLevelFilter = AccessLevelFilter)
  output <- .servicecatalog$list_provisioned_product_plans_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_provisioned_product_plans <- servicecatalog_list_provisioned_product_plans

#' Lists all provisioning artifacts (also known as versions) for the
#' specified product
#'
#' @description
#' Lists all provisioning artifacts (also known as versions) for the
#' specified product.
#'
#' @usage
#' servicecatalog_list_provisioning_artifacts(AcceptLanguage, ProductId)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisioningArtifactDetails = list(
#'     list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Active = TRUE|FALSE,
#'       Guidance = "DEFAULT"|"DEPRECATED"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_provisioning_artifacts(
#'   AcceptLanguage = "string",
#'   ProductId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_provisioning_artifacts
servicecatalog_list_provisioning_artifacts <- function(AcceptLanguage = NULL, ProductId) {
  op <- new_operation(
    name = "ListProvisioningArtifacts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_provisioning_artifacts_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId)
  output <- .servicecatalog$list_provisioning_artifacts_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_provisioning_artifacts <- servicecatalog_list_provisioning_artifacts

#' Lists all provisioning artifacts (also known as versions) for the
#' specified self-service action
#'
#' @description
#' Lists all provisioning artifacts (also known as versions) for the
#' specified self-service action.
#'
#' @usage
#' servicecatalog_list_provisioning_artifacts_for_service_action(
#'   ServiceActionId, PageSize, PageToken, AcceptLanguage)
#'
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisioningArtifactViews = list(
#'     list(
#'       ProductViewSummary = list(
#'         Id = "string",
#'         ProductId = "string",
#'         Name = "string",
#'         Owner = "string",
#'         ShortDescription = "string",
#'         Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'         Distributor = "string",
#'         HasDefaultPath = TRUE|FALSE,
#'         SupportEmail = "string",
#'         SupportDescription = "string",
#'         SupportUrl = "string"
#'       ),
#'       ProvisioningArtifact = list(
#'         Id = "string",
#'         Name = "string",
#'         Description = "string",
#'         CreatedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Guidance = "DEFAULT"|"DEPRECATED"
#'       )
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_provisioning_artifacts_for_service_action(
#'   ServiceActionId = "string",
#'   PageSize = 123,
#'   PageToken = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_provisioning_artifacts_for_service_action
servicecatalog_list_provisioning_artifacts_for_service_action <- function(ServiceActionId, PageSize = NULL, PageToken = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "ListProvisioningArtifactsForServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_provisioning_artifacts_for_service_action_input(ServiceActionId = ServiceActionId, PageSize = PageSize, PageToken = PageToken, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$list_provisioning_artifacts_for_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_provisioning_artifacts_for_service_action <- servicecatalog_list_provisioning_artifacts_for_service_action

#' Lists the specified requests or all performed requests
#'
#' @description
#' Lists the specified requests or all performed requests.
#'
#' @usage
#' servicecatalog_list_record_history(AcceptLanguage, AccessLevelFilter,
#'   SearchFilter, PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#' @param SearchFilter The search filter to scope the results.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetails = list(
#'     list(
#'       RecordId = "string",
#'       ProvisionedProductName = "string",
#'       Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       UpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ProvisionedProductType = "string",
#'       RecordType = "string",
#'       ProvisionedProductId = "string",
#'       ProductId = "string",
#'       ProvisioningArtifactId = "string",
#'       PathId = "string",
#'       RecordErrors = list(
#'         list(
#'           Code = "string",
#'           Description = "string"
#'         )
#'       ),
#'       RecordTags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       LaunchRoleArn = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_record_history(
#'   AcceptLanguage = "string",
#'   AccessLevelFilter = list(
#'     Key = "Account"|"Role"|"User",
#'     Value = "string"
#'   ),
#'   SearchFilter = list(
#'     Key = "string",
#'     Value = "string"
#'   ),
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_record_history
servicecatalog_list_record_history <- function(AcceptLanguage = NULL, AccessLevelFilter = NULL, SearchFilter = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListRecordHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_record_history_input(AcceptLanguage = AcceptLanguage, AccessLevelFilter = AccessLevelFilter, SearchFilter = SearchFilter, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_record_history_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_record_history <- servicecatalog_list_record_history

#' Lists the resources associated with the specified TagOption
#'
#' @description
#' Lists the resources associated with the specified TagOption.
#'
#' @usage
#' servicecatalog_list_resources_for_tag_option(TagOptionId, ResourceType,
#'   PageSize, PageToken)
#'
#' @param TagOptionId &#91;required&#93; The TagOption identifier.
#' @param ResourceType The resource type.
#' 
#' -   `Portfolio`
#' 
#' -   `Product`
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ResourceDetails = list(
#'     list(
#'       Id = "string",
#'       ARN = "string",
#'       Name = "string",
#'       Description = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   PageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_resources_for_tag_option(
#'   TagOptionId = "string",
#'   ResourceType = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_resources_for_tag_option
servicecatalog_list_resources_for_tag_option <- function(TagOptionId, ResourceType = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListResourcesForTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_resources_for_tag_option_input(TagOptionId = TagOptionId, ResourceType = ResourceType, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_resources_for_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_resources_for_tag_option <- servicecatalog_list_resources_for_tag_option

#' Lists all self-service actions
#'
#' @description
#' Lists all self-service actions.
#'
#' @usage
#' servicecatalog_list_service_actions(AcceptLanguage, PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceActionSummaries = list(
#'     list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       DefinitionType = "SSM_AUTOMATION"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_service_actions(
#'   AcceptLanguage = "string",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_service_actions
servicecatalog_list_service_actions <- function(AcceptLanguage = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListServiceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_service_actions_input(AcceptLanguage = AcceptLanguage, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_service_actions_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_service_actions <- servicecatalog_list_service_actions

#' Returns a paginated list of self-service actions associated with the
#' specified Product ID and Provisioning Artifact ID
#'
#' @description
#' Returns a paginated list of self-service actions associated with the
#' specified Product ID and Provisioning Artifact ID.
#'
#' @usage
#' servicecatalog_list_service_actions_for_provisioning_artifact(ProductId,
#'   ProvisioningArtifactId, PageSize, PageToken, AcceptLanguage)
#'
#' @param ProductId &#91;required&#93; The product identifier. For example, `prod-abcdzk7xy33qa`.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact. For example,
#' `pa-4abcdjnxjj6ne`.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceActionSummaries = list(
#'     list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       DefinitionType = "SSM_AUTOMATION"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_service_actions_for_provisioning_artifact(
#'   ProductId = "string",
#'   ProvisioningArtifactId = "string",
#'   PageSize = 123,
#'   PageToken = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_service_actions_for_provisioning_artifact
servicecatalog_list_service_actions_for_provisioning_artifact <- function(ProductId, ProvisioningArtifactId, PageSize = NULL, PageToken = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "ListServiceActionsForProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_service_actions_for_provisioning_artifact_input(ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, PageSize = PageSize, PageToken = PageToken, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$list_service_actions_for_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_service_actions_for_provisioning_artifact <- servicecatalog_list_service_actions_for_provisioning_artifact

#' Returns summary information about stack instances that are associated
#' with the specified CFN_STACKSET type provisioned product
#'
#' @description
#' Returns summary information about stack instances that are associated
#' with the specified `CFN_STACKSET` type provisioned product. You can
#' filter for stack instances that are associated with a specific AWS
#' account name or region.
#'
#' @usage
#' servicecatalog_list_stack_instances_for_provisioned_product(
#'   AcceptLanguage, ProvisionedProductId, PageToken, PageSize)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StackInstances = list(
#'     list(
#'       Account = "string",
#'       Region = "string",
#'       StackInstanceStatus = "CURRENT"|"OUTDATED"|"INOPERABLE"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_stack_instances_for_provisioned_product(
#'   AcceptLanguage = "string",
#'   ProvisionedProductId = "string",
#'   PageToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_stack_instances_for_provisioned_product
servicecatalog_list_stack_instances_for_provisioned_product <- function(AcceptLanguage = NULL, ProvisionedProductId, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListStackInstancesForProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_stack_instances_for_provisioned_product_input(AcceptLanguage = AcceptLanguage, ProvisionedProductId = ProvisionedProductId, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_stack_instances_for_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_stack_instances_for_provisioned_product <- servicecatalog_list_stack_instances_for_provisioned_product

#' Lists the specified TagOptions or all TagOptions
#'
#' @description
#' Lists the specified TagOptions or all TagOptions.
#'
#' @usage
#' servicecatalog_list_tag_options(Filters, PageSize, PageToken)
#'
#' @param Filters The search filters. If no search filters are specified, the output
#' includes all TagOptions.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TagOptionDetails = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Active = TRUE|FALSE,
#'       Id = "string",
#'       Owner = "string"
#'     )
#'   ),
#'   PageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tag_options(
#'   Filters = list(
#'     Key = "string",
#'     Value = "string",
#'     Active = TRUE|FALSE
#'   ),
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_tag_options
servicecatalog_list_tag_options <- function(Filters = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListTagOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_tag_options_input(Filters = Filters, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_tag_options_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_tag_options <- servicecatalog_list_tag_options

#' Provisions the specified product
#'
#' @description
#' Provisions the specified product.
#' 
#' A provisioned product is a resourced instance of a product. For example,
#' provisioning a product based on a CloudFormation template launches a
#' CloudFormation stack and its underlying resources. You can check the
#' status of this request using
#' [`describe_record`][servicecatalog_describe_record].
#' 
#' If the request contains a tag key with an empty list of values, there is
#' a tag conflict for that key. Do not include conflicted keys as tags, or
#' this causes the error "Parameter validation failed: Missing required
#' parameter in Tags\[*N*\]:*Value*".
#'
#' @usage
#' servicecatalog_provision_product(AcceptLanguage, ProductId, ProductName,
#'   ProvisioningArtifactId, ProvisioningArtifactName, PathId, PathName,
#'   ProvisionedProductName, ProvisioningParameters, ProvisioningPreferences,
#'   Tags, NotificationArns, ProvisionToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId The product identifier. You must provide the name or ID, but not both.
#' @param ProductName The name of the product. You must provide the name or ID, but not both.
#' @param ProvisioningArtifactId The identifier of the provisioning artifact. You must provide the name
#' or ID, but not both.
#' @param ProvisioningArtifactName The name of the provisioning artifact. You must provide the name or ID,
#' but not both.
#' @param PathId The path identifier of the product. This value is optional if the
#' product has a default path, and required if the product has more than
#' one path. To list the paths for a product, use
#' [`list_launch_paths`][servicecatalog_list_launch_paths]. You must
#' provide the name or ID, but not both.
#' @param PathName The name of the path. You must provide the name or ID, but not both.
#' @param ProvisionedProductName &#91;required&#93; A user-friendly name for the provisioned product. This value must be
#' unique for the AWS account and cannot be updated after the product is
#' provisioned.
#' @param ProvisioningParameters Parameters specified by the administrator that are required for
#' provisioning the product.
#' @param ProvisioningPreferences An object that contains information about the provisioning preferences
#' for a stack set.
#' @param Tags One or more tags.
#' @param NotificationArns Passed to CloudFormation. The SNS topic ARNs to which to publish
#' stack-related events.
#' @param ProvisionToken &#91;required&#93; An idempotency token that uniquely identifies the provisioning request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$provision_product(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   ProductName = "string",
#'   ProvisioningArtifactId = "string",
#'   ProvisioningArtifactName = "string",
#'   PathId = "string",
#'   PathName = "string",
#'   ProvisionedProductName = "string",
#'   ProvisioningParameters = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ProvisioningPreferences = list(
#'     StackSetAccounts = list(
#'       "string"
#'     ),
#'     StackSetRegions = list(
#'       "string"
#'     ),
#'     StackSetFailureToleranceCount = 123,
#'     StackSetFailureTolerancePercentage = 123,
#'     StackSetMaxConcurrencyCount = 123,
#'     StackSetMaxConcurrencyPercentage = 123
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   NotificationArns = list(
#'     "string"
#'   ),
#'   ProvisionToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_provision_product
servicecatalog_provision_product <- function(AcceptLanguage = NULL, ProductId = NULL, ProductName = NULL, ProvisioningArtifactId = NULL, ProvisioningArtifactName = NULL, PathId = NULL, PathName = NULL, ProvisionedProductName, ProvisioningParameters = NULL, ProvisioningPreferences = NULL, Tags = NULL, NotificationArns = NULL, ProvisionToken) {
  op <- new_operation(
    name = "ProvisionProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$provision_product_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProductName = ProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningArtifactName = ProvisioningArtifactName, PathId = PathId, PathName = PathName, ProvisionedProductName = ProvisionedProductName, ProvisioningParameters = ProvisioningParameters, ProvisioningPreferences = ProvisioningPreferences, Tags = Tags, NotificationArns = NotificationArns, ProvisionToken = ProvisionToken)
  output <- .servicecatalog$provision_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$provision_product <- servicecatalog_provision_product

#' Rejects an offer to share the specified portfolio
#'
#' @description
#' Rejects an offer to share the specified portfolio.
#'
#' @usage
#' servicecatalog_reject_portfolio_share(AcceptLanguage, PortfolioId,
#'   PortfolioShareType)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PortfolioShareType The type of shared portfolios to reject. The default is to reject
#' imported portfolios.
#' 
#' -   `AWS_ORGANIZATIONS` - Reject portfolios shared by the management
#'     account of your organization.
#' 
#' -   `IMPORTED` - Reject imported portfolios.
#' 
#' -   `AWS_SERVICECATALOG` - Not supported. (Throws
#'     ResourceNotFoundException.)
#' 
#' For example,
#' `aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS`
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$reject_portfolio_share(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   PortfolioShareType = "IMPORTED"|"AWS_SERVICECATALOG"|"AWS_ORGANIZATIONS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_reject_portfolio_share
servicecatalog_reject_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, PortfolioShareType = NULL) {
  op <- new_operation(
    name = "RejectPortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$reject_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PortfolioShareType = PortfolioShareType)
  output <- .servicecatalog$reject_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$reject_portfolio_share <- servicecatalog_reject_portfolio_share

#' Lists the provisioned products that are available (not terminated)
#'
#' @description
#' Lists the provisioned products that are available (not terminated).
#' 
#' To use additional filtering, see
#' [`search_provisioned_products`][servicecatalog_search_provisioned_products].
#'
#' @usage
#' servicecatalog_scan_provisioned_products(AcceptLanguage,
#'   AccessLevelFilter, PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisionedProducts = list(
#'     list(
#'       Name = "string",
#'       Arn = "string",
#'       Type = "string",
#'       Id = "string",
#'       Status = "AVAILABLE"|"UNDER_CHANGE"|"TAINTED"|"ERROR"|"PLAN_IN_PROGRESS",
#'       StatusMessage = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       IdempotencyToken = "string",
#'       LastRecordId = "string",
#'       LastProvisioningRecordId = "string",
#'       LastSuccessfulProvisioningRecordId = "string",
#'       ProductId = "string",
#'       ProvisioningArtifactId = "string",
#'       LaunchRoleArn = "string"
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$scan_provisioned_products(
#'   AcceptLanguage = "string",
#'   AccessLevelFilter = list(
#'     Key = "Account"|"Role"|"User",
#'     Value = "string"
#'   ),
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_scan_provisioned_products
servicecatalog_scan_provisioned_products <- function(AcceptLanguage = NULL, AccessLevelFilter = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ScanProvisionedProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$scan_provisioned_products_input(AcceptLanguage = AcceptLanguage, AccessLevelFilter = AccessLevelFilter, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$scan_provisioned_products_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$scan_provisioned_products <- servicecatalog_scan_provisioned_products

#' Gets information about the products to which the caller has access
#'
#' @description
#' Gets information about the products to which the caller has access.
#'
#' @usage
#' servicecatalog_search_products(AcceptLanguage, Filters, PageSize,
#'   SortBy, SortOrder, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Filters The search filters. If no search filters are specified, the output
#' includes all products to which the caller has access.
#' @param PageSize The maximum number of items to return with this call.
#' @param SortBy The sort field. If no value is specified, the results are not sorted.
#' @param SortOrder The sort order. If no value is specified, the results are not sorted.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewSummaries = list(
#'     list(
#'       Id = "string",
#'       ProductId = "string",
#'       Name = "string",
#'       Owner = "string",
#'       ShortDescription = "string",
#'       Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'       Distributor = "string",
#'       HasDefaultPath = TRUE|FALSE,
#'       SupportEmail = "string",
#'       SupportDescription = "string",
#'       SupportUrl = "string"
#'     )
#'   ),
#'   ProductViewAggregations = list(
#'     list(
#'       list(
#'         Value = "string",
#'         ApproximateCount = 123
#'       )
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$search_products(
#'   AcceptLanguage = "string",
#'   Filters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   PageSize = 123,
#'   SortBy = "Title"|"VersionCount"|"CreationDate",
#'   SortOrder = "ASCENDING"|"DESCENDING",
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_search_products
servicecatalog_search_products <- function(AcceptLanguage = NULL, Filters = NULL, PageSize = NULL, SortBy = NULL, SortOrder = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "SearchProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$search_products_input(AcceptLanguage = AcceptLanguage, Filters = Filters, PageSize = PageSize, SortBy = SortBy, SortOrder = SortOrder, PageToken = PageToken)
  output <- .servicecatalog$search_products_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$search_products <- servicecatalog_search_products

#' Gets information about the products for the specified portfolio or all
#' products
#'
#' @description
#' Gets information about the products for the specified portfolio or all
#' products.
#'
#' @usage
#' servicecatalog_search_products_as_admin(AcceptLanguage, PortfolioId,
#'   Filters, SortBy, SortOrder, PageToken, PageSize, ProductSource)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId The portfolio identifier.
#' @param Filters The search filters. If no search filters are specified, the output
#' includes all products to which the administrator has access.
#' @param SortBy The sort field. If no value is specified, the results are not sorted.
#' @param SortOrder The sort order. If no value is specified, the results are not sorted.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#' @param ProductSource Access level of the source of the product.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewDetails = list(
#'     list(
#'       ProductViewSummary = list(
#'         Id = "string",
#'         ProductId = "string",
#'         Name = "string",
#'         Owner = "string",
#'         ShortDescription = "string",
#'         Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'         Distributor = "string",
#'         HasDefaultPath = TRUE|FALSE,
#'         SupportEmail = "string",
#'         SupportDescription = "string",
#'         SupportUrl = "string"
#'       ),
#'       Status = "AVAILABLE"|"CREATING"|"FAILED",
#'       ProductARN = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$search_products_as_admin(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   Filters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   SortBy = "Title"|"VersionCount"|"CreationDate",
#'   SortOrder = "ASCENDING"|"DESCENDING",
#'   PageToken = "string",
#'   PageSize = 123,
#'   ProductSource = "ACCOUNT"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_search_products_as_admin
servicecatalog_search_products_as_admin <- function(AcceptLanguage = NULL, PortfolioId = NULL, Filters = NULL, SortBy = NULL, SortOrder = NULL, PageToken = NULL, PageSize = NULL, ProductSource = NULL) {
  op <- new_operation(
    name = "SearchProductsAsAdmin",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$search_products_as_admin_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, Filters = Filters, SortBy = SortBy, SortOrder = SortOrder, PageToken = PageToken, PageSize = PageSize, ProductSource = ProductSource)
  output <- .servicecatalog$search_products_as_admin_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$search_products_as_admin <- servicecatalog_search_products_as_admin

#' Gets information about the provisioned products that meet the specified
#' criteria
#'
#' @description
#' Gets information about the provisioned products that meet the specified
#' criteria.
#'
#' @usage
#' servicecatalog_search_provisioned_products(AcceptLanguage,
#'   AccessLevelFilter, Filters, SortBy, SortOrder, PageSize, PageToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#' @param Filters The search filters.
#' 
#' When the key is `SearchQuery`, the searchable fields are `arn`,
#' `createdTime`, `id`, `lastRecordId`, `idempotencyToken`, `name`,
#' `physicalId`, `productId`, `provisioningArtifact`, `type`, `status`,
#' `tags`, `userArn`, `userArnSession`, `lastProvisioningRecordId`,
#' `lastSuccessfulProvisioningRecordId`, `productName`, and
#' `provisioningArtifactName`.
#' 
#' Example: `"SearchQuery":["status:AVAILABLE"]`
#' @param SortBy The sort field. If no value is specified, the results are not sorted.
#' The valid values are `arn`, `id`, `name`, and `lastRecordId`.
#' @param SortOrder The sort order. If no value is specified, the results are not sorted.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisionedProducts = list(
#'     list(
#'       Name = "string",
#'       Arn = "string",
#'       Type = "string",
#'       Id = "string",
#'       Status = "AVAILABLE"|"UNDER_CHANGE"|"TAINTED"|"ERROR"|"PLAN_IN_PROGRESS",
#'       StatusMessage = "string",
#'       CreatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       IdempotencyToken = "string",
#'       LastRecordId = "string",
#'       LastProvisioningRecordId = "string",
#'       LastSuccessfulProvisioningRecordId = "string",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       PhysicalId = "string",
#'       ProductId = "string",
#'       ProductName = "string",
#'       ProvisioningArtifactId = "string",
#'       ProvisioningArtifactName = "string",
#'       UserArn = "string",
#'       UserArnSession = "string"
#'     )
#'   ),
#'   TotalResultsCount = 123,
#'   NextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$search_provisioned_products(
#'   AcceptLanguage = "string",
#'   AccessLevelFilter = list(
#'     Key = "Account"|"Role"|"User",
#'     Value = "string"
#'   ),
#'   Filters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   SortBy = "string",
#'   SortOrder = "ASCENDING"|"DESCENDING",
#'   PageSize = 123,
#'   PageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_search_provisioned_products
servicecatalog_search_provisioned_products <- function(AcceptLanguage = NULL, AccessLevelFilter = NULL, Filters = NULL, SortBy = NULL, SortOrder = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "SearchProvisionedProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$search_provisioned_products_input(AcceptLanguage = AcceptLanguage, AccessLevelFilter = AccessLevelFilter, Filters = Filters, SortBy = SortBy, SortOrder = SortOrder, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$search_provisioned_products_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$search_provisioned_products <- servicecatalog_search_provisioned_products

#' Terminates the specified provisioned product
#'
#' @description
#' Terminates the specified provisioned product.
#' 
#' This operation does not delete any records associated with the
#' provisioned product.
#' 
#' You can check the status of this request using
#' [`describe_record`][servicecatalog_describe_record].
#'
#' @usage
#' servicecatalog_terminate_provisioned_product(ProvisionedProductName,
#'   ProvisionedProductId, TerminateToken, IgnoreErrors, AcceptLanguage,
#'   RetainPhysicalResources)
#'
#' @param ProvisionedProductName The name of the provisioned product. You cannot specify both
#' `ProvisionedProductName` and `ProvisionedProductId`.
#' @param ProvisionedProductId The identifier of the provisioned product. You cannot specify both
#' `ProvisionedProductName` and `ProvisionedProductId`.
#' @param TerminateToken &#91;required&#93; An idempotency token that uniquely identifies the termination request.
#' This token is only valid during the termination process. After the
#' provisioned product is terminated, subsequent requests to terminate the
#' same provisioned product always return **ResourceNotFound**.
#' @param IgnoreErrors If set to true, AWS Service Catalog stops managing the specified
#' provisioned product even if it cannot delete the underlying resources.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param RetainPhysicalResources When this boolean parameter is set to true, the
#' [`terminate_provisioned_product`][servicecatalog_terminate_provisioned_product]
#' API deletes the Service Catalog provisioned product. However, it does
#' not remove the CloudFormation stack, stack set, or the underlying
#' resources of the deleted provisioned product. The default value is
#' false.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$terminate_provisioned_product(
#'   ProvisionedProductName = "string",
#'   ProvisionedProductId = "string",
#'   TerminateToken = "string",
#'   IgnoreErrors = TRUE|FALSE,
#'   AcceptLanguage = "string",
#'   RetainPhysicalResources = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_terminate_provisioned_product
servicecatalog_terminate_provisioned_product <- function(ProvisionedProductName = NULL, ProvisionedProductId = NULL, TerminateToken, IgnoreErrors = NULL, AcceptLanguage = NULL, RetainPhysicalResources = NULL) {
  op <- new_operation(
    name = "TerminateProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$terminate_provisioned_product_input(ProvisionedProductName = ProvisionedProductName, ProvisionedProductId = ProvisionedProductId, TerminateToken = TerminateToken, IgnoreErrors = IgnoreErrors, AcceptLanguage = AcceptLanguage, RetainPhysicalResources = RetainPhysicalResources)
  output <- .servicecatalog$terminate_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$terminate_provisioned_product <- servicecatalog_terminate_provisioned_product

#' Updates the specified constraint
#'
#' @description
#' Updates the specified constraint.
#'
#' @usage
#' servicecatalog_update_constraint(AcceptLanguage, Id, Description,
#'   Parameters)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The identifier of the constraint.
#' @param Description The updated description of the constraint.
#' @param Parameters The constraint parameters, in JSON format. The syntax depends on the
#' constraint type as follows:
#' 
#' ### LAUNCH
#' 
#' You are required to specify either the `RoleArn` or the `LocalRoleName`
#' but can't use both.
#' 
#' Specify the `RoleArn` property as follows:
#' 
#' `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
#' 
#' Specify the `LocalRoleName` property as follows:
#' 
#' `{"LocalRoleName": "SCBasicLaunchRole"}`
#' 
#' If you specify the `LocalRoleName` property, when an account uses the
#' launch constraint, the IAM role with that name in the account will be
#' used. This allows launch-role constraints to be account-agnostic so the
#' administrator can create fewer resources per shared account.
#' 
#' The given role name must exist in the account used to create the launch
#' constraint and the account of the user who launches a product with this
#' launch constraint.
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `LAUNCH` constraint on a product and
#' portfolio.
#' 
#' ### NOTIFICATION
#' 
#' Specify the `NotificationArns` property as follows:
#' 
#' `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
#' 
#' ### RESOURCE_UPDATE
#' 
#' Specify the `TagUpdatesOnProvisionedProduct` property as follows:
#' 
#' `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
#' 
#' The `TagUpdatesOnProvisionedProduct` property accepts a string value of
#' `ALLOWED` or `NOT_ALLOWED`.
#' 
#' ### STACKSET
#' 
#' Specify the `Parameters` property as follows:
#' 
#' `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `STACKSET` constraint on a product
#' and portfolio.
#' 
#' Products with a `STACKSET` constraint will launch an AWS CloudFormation
#' stack set.
#' 
#' ### TEMPLATE
#' 
#' Specify the `Rules` property. For more information, see [Template
#' Constraint
#' Rules](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConstraintDetail = list(
#'     ConstraintId = "string",
#'     Type = "string",
#'     Description = "string",
#'     Owner = "string",
#'     ProductId = "string",
#'     PortfolioId = "string"
#'   ),
#'   ConstraintParameters = "string",
#'   Status = "AVAILABLE"|"CREATING"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_constraint(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   Description = "string",
#'   Parameters = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_constraint
servicecatalog_update_constraint <- function(AcceptLanguage = NULL, Id, Description = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "UpdateConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_constraint_input(AcceptLanguage = AcceptLanguage, Id = Id, Description = Description, Parameters = Parameters)
  output <- .servicecatalog$update_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_constraint <- servicecatalog_update_constraint

#' Updates the specified portfolio
#'
#' @description
#' Updates the specified portfolio.
#' 
#' You cannot update a product that was shared with you.
#'
#' @usage
#' servicecatalog_update_portfolio(AcceptLanguage, Id, DisplayName,
#'   Description, ProviderName, AddTags, RemoveTags)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The portfolio identifier.
#' @param DisplayName The name to use for display purposes.
#' @param Description The updated description of the portfolio.
#' @param ProviderName The updated name of the portfolio provider.
#' @param AddTags The tags to add.
#' @param RemoveTags The tags to remove.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioDetail = list(
#'     Id = "string",
#'     ARN = "string",
#'     DisplayName = "string",
#'     Description = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProviderName = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_portfolio(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   DisplayName = "string",
#'   Description = "string",
#'   ProviderName = "string",
#'   AddTags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   RemoveTags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_portfolio
servicecatalog_update_portfolio <- function(AcceptLanguage = NULL, Id, DisplayName = NULL, Description = NULL, ProviderName = NULL, AddTags = NULL, RemoveTags = NULL) {
  op <- new_operation(
    name = "UpdatePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_portfolio_input(AcceptLanguage = AcceptLanguage, Id = Id, DisplayName = DisplayName, Description = Description, ProviderName = ProviderName, AddTags = AddTags, RemoveTags = RemoveTags)
  output <- .servicecatalog$update_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_portfolio <- servicecatalog_update_portfolio

#' Updates the specified portfolio share
#'
#' @description
#' Updates the specified portfolio share. You can use this API to enable or
#' disable TagOptions sharing for an existing portfolio share.
#' 
#' The portfolio share cannot be updated if the
#' [`create_portfolio_share`][servicecatalog_create_portfolio_share]
#' operation is `IN_PROGRESS`, as the share is not available to recipient
#' entities. In this case, you must wait for the portfolio share to be
#' COMPLETED.
#' 
#' You must provide the `accountId` or organization node in the input, but
#' not both.
#' 
#' If the portfolio is shared to both an external account and an
#' organization node, and both shares need to be updated, you must invoke
#' [`update_portfolio_share`][servicecatalog_update_portfolio_share]
#' separately for each share type.
#' 
#' This API cannot be used for removing the portfolio share. You must use
#' [`delete_portfolio_share`][servicecatalog_delete_portfolio_share] API
#' for that action.
#'
#' @usage
#' servicecatalog_update_portfolio_share(AcceptLanguage, PortfolioId,
#'   AccountId, OrganizationNode, ShareTagOptions)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The unique identifier of the portfolio for which the share will be
#' updated.
#' @param AccountId The AWS Account Id of the recipient account. This field is required when
#' updating an external account to account type share.
#' @param OrganizationNode 
#' @param ShareTagOptions A flag to enable or disable TagOptions sharing for the portfolio share.
#' If this field is not provided, the current state of TagOptions sharing
#' on the portfolio share will not be modified.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PortfolioShareToken = "string",
#'   Status = "NOT_STARTED"|"IN_PROGRESS"|"COMPLETED"|"COMPLETED_WITH_ERRORS"|"ERROR"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_portfolio_share(
#'   AcceptLanguage = "string",
#'   PortfolioId = "string",
#'   AccountId = "string",
#'   OrganizationNode = list(
#'     Type = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
#'     Value = "string"
#'   ),
#'   ShareTagOptions = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_portfolio_share
servicecatalog_update_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, AccountId = NULL, OrganizationNode = NULL, ShareTagOptions = NULL) {
  op <- new_operation(
    name = "UpdatePortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, AccountId = AccountId, OrganizationNode = OrganizationNode, ShareTagOptions = ShareTagOptions)
  output <- .servicecatalog$update_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_portfolio_share <- servicecatalog_update_portfolio_share

#' Updates the specified product
#'
#' @description
#' Updates the specified product.
#'
#' @usage
#' servicecatalog_update_product(AcceptLanguage, Id, Name, Owner,
#'   Description, Distributor, SupportDescription, SupportEmail, SupportUrl,
#'   AddTags, RemoveTags)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The product identifier.
#' @param Name The updated product name.
#' @param Owner The updated owner of the product.
#' @param Description The updated description of the product.
#' @param Distributor The updated distributor of the product.
#' @param SupportDescription The updated support description for the product.
#' @param SupportEmail The updated support email for the product.
#' @param SupportUrl The updated support URL for the product.
#' @param AddTags The tags to add to the product.
#' @param RemoveTags The tags to remove from the product.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProductViewDetail = list(
#'     ProductViewSummary = list(
#'       Id = "string",
#'       ProductId = "string",
#'       Name = "string",
#'       Owner = "string",
#'       ShortDescription = "string",
#'       Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE",
#'       Distributor = "string",
#'       HasDefaultPath = TRUE|FALSE,
#'       SupportEmail = "string",
#'       SupportDescription = "string",
#'       SupportUrl = "string"
#'     ),
#'     Status = "AVAILABLE"|"CREATING"|"FAILED",
#'     ProductARN = "string",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_product(
#'   AcceptLanguage = "string",
#'   Id = "string",
#'   Name = "string",
#'   Owner = "string",
#'   Description = "string",
#'   Distributor = "string",
#'   SupportDescription = "string",
#'   SupportEmail = "string",
#'   SupportUrl = "string",
#'   AddTags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   RemoveTags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_product
servicecatalog_update_product <- function(AcceptLanguage = NULL, Id, Name = NULL, Owner = NULL, Description = NULL, Distributor = NULL, SupportDescription = NULL, SupportEmail = NULL, SupportUrl = NULL, AddTags = NULL, RemoveTags = NULL) {
  op <- new_operation(
    name = "UpdateProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_product_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name, Owner = Owner, Description = Description, Distributor = Distributor, SupportDescription = SupportDescription, SupportEmail = SupportEmail, SupportUrl = SupportUrl, AddTags = AddTags, RemoveTags = RemoveTags)
  output <- .servicecatalog$update_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_product <- servicecatalog_update_product

#' Requests updates to the configuration of the specified provisioned
#' product
#'
#' @description
#' Requests updates to the configuration of the specified provisioned
#' product.
#' 
#' If there are tags associated with the object, they cannot be updated or
#' added. Depending on the specific updates requested, this operation can
#' update with no interruption, with some interruption, or replace the
#' provisioned product entirely.
#' 
#' You can check the status of this request using
#' [`describe_record`][servicecatalog_describe_record].
#'
#' @usage
#' servicecatalog_update_provisioned_product(AcceptLanguage,
#'   ProvisionedProductName, ProvisionedProductId, ProductId, ProductName,
#'   ProvisioningArtifactId, ProvisioningArtifactName, PathId, PathName,
#'   ProvisioningParameters, ProvisioningPreferences, Tags, UpdateToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductName The name of the provisioned product. You cannot specify both
#' `ProvisionedProductName` and `ProvisionedProductId`.
#' @param ProvisionedProductId The identifier of the provisioned product. You must provide the name or
#' ID, but not both.
#' @param ProductId The identifier of the product. You must provide the name or ID, but not
#' both.
#' @param ProductName The name of the product. You must provide the name or ID, but not both.
#' @param ProvisioningArtifactId The identifier of the provisioning artifact.
#' @param ProvisioningArtifactName The name of the provisioning artifact. You must provide the name or ID,
#' but not both.
#' @param PathId The path identifier. This value is optional if the product has a default
#' path, and required if the product has more than one path. You must
#' provide the name or ID, but not both.
#' @param PathName The name of the path. You must provide the name or ID, but not both.
#' @param ProvisioningParameters The new parameters.
#' @param ProvisioningPreferences An object that contains information about the provisioning preferences
#' for a stack set.
#' @param Tags One or more tags. Requires the product to have `RESOURCE_UPDATE`
#' constraint with `TagUpdatesOnProvisionedProduct` set to `ALLOWED` to
#' allow tag updates.
#' @param UpdateToken &#91;required&#93; The idempotency token that uniquely identifies the provisioning update
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RecordDetail = list(
#'     RecordId = "string",
#'     ProvisionedProductName = "string",
#'     Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ProvisionedProductType = "string",
#'     RecordType = "string",
#'     ProvisionedProductId = "string",
#'     ProductId = "string",
#'     ProvisioningArtifactId = "string",
#'     PathId = "string",
#'     RecordErrors = list(
#'       list(
#'         Code = "string",
#'         Description = "string"
#'       )
#'     ),
#'     RecordTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     LaunchRoleArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_provisioned_product(
#'   AcceptLanguage = "string",
#'   ProvisionedProductName = "string",
#'   ProvisionedProductId = "string",
#'   ProductId = "string",
#'   ProductName = "string",
#'   ProvisioningArtifactId = "string",
#'   ProvisioningArtifactName = "string",
#'   PathId = "string",
#'   PathName = "string",
#'   ProvisioningParameters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       UsePreviousValue = TRUE|FALSE
#'     )
#'   ),
#'   ProvisioningPreferences = list(
#'     StackSetAccounts = list(
#'       "string"
#'     ),
#'     StackSetRegions = list(
#'       "string"
#'     ),
#'     StackSetFailureToleranceCount = 123,
#'     StackSetFailureTolerancePercentage = 123,
#'     StackSetMaxConcurrencyCount = 123,
#'     StackSetMaxConcurrencyPercentage = 123,
#'     StackSetOperationType = "CREATE"|"UPDATE"|"DELETE"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UpdateToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_provisioned_product
servicecatalog_update_provisioned_product <- function(AcceptLanguage = NULL, ProvisionedProductName = NULL, ProvisionedProductId = NULL, ProductId = NULL, ProductName = NULL, ProvisioningArtifactId = NULL, ProvisioningArtifactName = NULL, PathId = NULL, PathName = NULL, ProvisioningParameters = NULL, ProvisioningPreferences = NULL, Tags = NULL, UpdateToken) {
  op <- new_operation(
    name = "UpdateProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_provisioned_product_input(AcceptLanguage = AcceptLanguage, ProvisionedProductName = ProvisionedProductName, ProvisionedProductId = ProvisionedProductId, ProductId = ProductId, ProductName = ProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningArtifactName = ProvisioningArtifactName, PathId = PathId, PathName = PathName, ProvisioningParameters = ProvisioningParameters, ProvisioningPreferences = ProvisioningPreferences, Tags = Tags, UpdateToken = UpdateToken)
  output <- .servicecatalog$update_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_provisioned_product <- servicecatalog_update_provisioned_product

#' Requests updates to the properties of the specified provisioned product
#'
#' @description
#' Requests updates to the properties of the specified provisioned product.
#'
#' @usage
#' servicecatalog_update_provisioned_product_properties(AcceptLanguage,
#'   ProvisionedProductId, ProvisionedProductProperties, IdempotencyToken)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param ProvisionedProductProperties &#91;required&#93; A map that contains the provisioned product properties to be updated.
#' 
#' The `LAUNCH_ROLE` key accepts role ARNs. This key allows an
#' administrator to call
#' [`update_provisioned_product_properties`][servicecatalog_update_provisioned_product_properties]
#' to update the launch role that is associated with a provisioned product.
#' This role is used when an end user calls a provisioning operation such
#' as
#' [`update_provisioned_product`][servicecatalog_update_provisioned_product],
#' [`terminate_provisioned_product`][servicecatalog_terminate_provisioned_product],
#' or
#' [`execute_provisioned_product_service_action`][servicecatalog_execute_provisioned_product_service_action].
#' Only a role ARN is valid. A user ARN is invalid.
#' 
#' The `OWNER` key accepts user ARNs and role ARNs. The owner is the user
#' that has permission to see, update, terminate, and execute service
#' actions in the provisioned product.
#' 
#' The administrator can change the owner of a provisioned product to
#' another IAM user within the same account. Both end user owners and
#' administrators can see ownership history of the provisioned product
#' using the [`list_record_history`][servicecatalog_list_record_history]
#' API. The new owner can describe all past records for the provisioned
#' product using the [`describe_record`][servicecatalog_describe_record]
#' API. The previous owner can no longer use
#' [`describe_record`][servicecatalog_describe_record], but can still see
#' the product's history from when he was an owner using
#' [`list_record_history`][servicecatalog_list_record_history].
#' 
#' If a provisioned product ownership is assigned to an end user, they can
#' see and perform any action through the API or Service Catalog console
#' such as update, terminate, and execute service actions. If an end user
#' provisions a product and the owner is updated to someone else, they will
#' no longer be able to see or perform any actions through API or the
#' Service Catalog console on that provisioned product.
#' @param IdempotencyToken &#91;required&#93; The idempotency token that uniquely identifies the provisioning product
#' update request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisionedProductId = "string",
#'   ProvisionedProductProperties = list(
#'     "string"
#'   ),
#'   RecordId = "string",
#'   Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_provisioned_product_properties(
#'   AcceptLanguage = "string",
#'   ProvisionedProductId = "string",
#'   ProvisionedProductProperties = list(
#'     "string"
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_provisioned_product_properties
servicecatalog_update_provisioned_product_properties <- function(AcceptLanguage = NULL, ProvisionedProductId, ProvisionedProductProperties, IdempotencyToken) {
  op <- new_operation(
    name = "UpdateProvisionedProductProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_provisioned_product_properties_input(AcceptLanguage = AcceptLanguage, ProvisionedProductId = ProvisionedProductId, ProvisionedProductProperties = ProvisionedProductProperties, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$update_provisioned_product_properties_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_provisioned_product_properties <- servicecatalog_update_provisioned_product_properties

#' Updates the specified provisioning artifact (also known as a version)
#' for the specified product
#'
#' @description
#' Updates the specified provisioning artifact (also known as a version)
#' for the specified product.
#' 
#' You cannot update a provisioning artifact for a product that was shared
#' with you.
#'
#' @usage
#' servicecatalog_update_provisioning_artifact(AcceptLanguage, ProductId,
#'   ProvisioningArtifactId, Name, Description, Active, Guidance)
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#' @param Name The updated name of the provisioning artifact.
#' @param Description The updated description of the provisioning artifact.
#' @param Active Indicates whether the product version is active.
#' 
#' Inactive provisioning artifacts are invisible to end users. End users
#' cannot launch or update a provisioned product from an inactive
#' provisioning artifact.
#' @param Guidance Information set by the administrator to provide guidance to end users
#' about which provisioning artifacts to use.
#' 
#' The `DEFAULT` value indicates that the product version is active.
#' 
#' The administrator can set the guidance to `DEPRECATED` to inform users
#' that the product version is deprecated. Users are able to make updates
#' to a provisioned product of a deprecated version but cannot launch new
#' provisioned products using a deprecated version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ProvisioningArtifactDetail = list(
#'     Id = "string",
#'     Name = "string",
#'     Description = "string",
#'     Type = "CLOUD_FORMATION_TEMPLATE"|"MARKETPLACE_AMI"|"MARKETPLACE_CAR",
#'     CreatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Active = TRUE|FALSE,
#'     Guidance = "DEFAULT"|"DEPRECATED"
#'   ),
#'   Info = list(
#'     "string"
#'   ),
#'   Status = "AVAILABLE"|"CREATING"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_provisioning_artifact(
#'   AcceptLanguage = "string",
#'   ProductId = "string",
#'   ProvisioningArtifactId = "string",
#'   Name = "string",
#'   Description = "string",
#'   Active = TRUE|FALSE,
#'   Guidance = "DEFAULT"|"DEPRECATED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_provisioning_artifact
servicecatalog_update_provisioning_artifact <- function(AcceptLanguage = NULL, ProductId, ProvisioningArtifactId, Name = NULL, Description = NULL, Active = NULL, Guidance = NULL) {
  op <- new_operation(
    name = "UpdateProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, Name = Name, Description = Description, Active = Active, Guidance = Guidance)
  output <- .servicecatalog$update_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_provisioning_artifact <- servicecatalog_update_provisioning_artifact

#' Updates a self-service action
#'
#' @description
#' Updates a self-service action.
#'
#' @usage
#' servicecatalog_update_service_action(Id, Name, Definition, Description,
#'   AcceptLanguage)
#'
#' @param Id &#91;required&#93; The self-service action identifier.
#' @param Name The self-service action name.
#' @param Definition A map that defines the self-service action.
#' @param Description The self-service action description.
#' @param AcceptLanguage The language code.
#' 
#' -   `en` - English (default)
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceActionDetail = list(
#'     ServiceActionSummary = list(
#'       Id = "string",
#'       Name = "string",
#'       Description = "string",
#'       DefinitionType = "SSM_AUTOMATION"
#'     ),
#'     Definition = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_service_action(
#'   Id = "string",
#'   Name = "string",
#'   Definition = list(
#'     "string"
#'   ),
#'   Description = "string",
#'   AcceptLanguage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_service_action
servicecatalog_update_service_action <- function(Id, Name = NULL, Definition = NULL, Description = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "UpdateServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_service_action_input(Id = Id, Name = Name, Definition = Definition, Description = Description, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$update_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_service_action <- servicecatalog_update_service_action

#' Updates the specified TagOption
#'
#' @description
#' Updates the specified TagOption.
#'
#' @usage
#' servicecatalog_update_tag_option(Id, Value, Active)
#'
#' @param Id &#91;required&#93; The TagOption identifier.
#' @param Value The updated value.
#' @param Active The updated active state.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TagOptionDetail = list(
#'     Key = "string",
#'     Value = "string",
#'     Active = TRUE|FALSE,
#'     Id = "string",
#'     Owner = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_tag_option(
#'   Id = "string",
#'   Value = "string",
#'   Active = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_tag_option
servicecatalog_update_tag_option <- function(Id, Value = NULL, Active = NULL) {
  op <- new_operation(
    name = "UpdateTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_tag_option_input(Id = Id, Value = Value, Active = Active)
  output <- .servicecatalog$update_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_tag_option <- servicecatalog_update_tag_option
