% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_checkout_borrow_license}
\alias{licensemanager_checkout_borrow_license}
\title{Checks out the specified license for offline use}
\usage{
licensemanager_checkout_borrow_license(LicenseArn, Entitlements,
  DigitalSignatureMethod, NodeId, CheckoutMetadata, ClientToken)
}
\arguments{
\item{LicenseArn}{[required] Amazon Resource Name (ARN) of the license. The license must use the
borrow consumption configuration.}

\item{Entitlements}{[required] License entitlements. Partial checkouts are not supported.}

\item{DigitalSignatureMethod}{[required] Digital signature method. The possible value is JSON Web Signature (JWS)
algorithm PS384. For more information, see \href{https://tools.ietf.org/html/rfc7518#section-3.5}{RFC 7518 Digital Signature with RSASSA-PSS}.}

\item{NodeId}{Node ID.}

\item{CheckoutMetadata}{Information about constraints.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  LicenseArn = "string",
  LicenseConsumptionToken = "string",
  EntitlementsAllowed = list(
    list(
      Name = "string",
      Value = "string",
      Unit = "Count"|"None"|"Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"
    )
  ),
  NodeId = "string",
  SignedToken = "string",
  IssuedAt = "string",
  Expiration = "string",
  CheckoutMetadata = list(
    list(
      Name = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Checks out the specified license for offline use.
}
\section{Request syntax}{
\preformatted{svc$checkout_borrow_license(
  LicenseArn = "string",
  Entitlements = list(
    list(
      Name = "string",
      Value = "string",
      Unit = "Count"|"None"|"Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"
    )
  ),
  DigitalSignatureMethod = "JWT_PS384",
  NodeId = "string",
  CheckoutMetadata = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
