% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_scaling_policy}
\alias{autoscaling_put_scaling_policy}
\title{Creates or updates a scaling policy for an Auto Scaling group}
\usage{
autoscaling_put_scaling_policy(AutoScalingGroupName, PolicyName,
  PolicyType, AdjustmentType, MinAdjustmentStep, MinAdjustmentMagnitude,
  ScalingAdjustment, Cooldown, MetricAggregationType, StepAdjustments,
  EstimatedInstanceWarmup, TargetTrackingConfiguration, Enabled)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{PolicyName}{[required] The name of the policy.}

\item{PolicyType}{One of the following policy types:
\itemize{
\item \code{TargetTrackingScaling}
\item \code{StepScaling}
\item \code{SimpleScaling} (default)
}}

\item{AdjustmentType}{Specifies how the scaling adjustment is interpreted (for example, an
absolute number or a percentage). The valid values are
\code{ChangeInCapacity}, \code{ExactCapacity}, and \code{PercentChangeInCapacity}.

Required if the policy type is \code{StepScaling} or \code{SimpleScaling}. For
more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment}{Scaling adjustment types}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MinAdjustmentStep}{Available for backward compatibility. Use \code{MinAdjustmentMagnitude}
instead.}

\item{MinAdjustmentMagnitude}{The minimum value to scale by when the adjustment type is
\code{PercentChangeInCapacity}. For example, suppose that you create a step
scaling policy to scale out an Auto Scaling group by 25 percent and you
specify a \code{MinAdjustmentMagnitude} of 2. If the group has 4 instances
and the scaling policy is performed, 25 percent of 4 is 1. However,
because you specified a \code{MinAdjustmentMagnitude} of 2, Amazon EC2 Auto
Scaling scales out the group by 2 instances.

Valid only if the policy type is \code{StepScaling} or \code{SimpleScaling}. For
more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment}{Scaling adjustment types}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Some Auto Scaling groups use instance weights. In this case, set the
\code{MinAdjustmentMagnitude} to a value that is at least as large as your
largest instance weight.}

\item{ScalingAdjustment}{The amount by which to scale, based on the specified adjustment type. A
positive value adds to the current capacity while a negative number
removes from the current capacity. For exact capacity, you must specify
a positive value.

Required if the policy type is \code{SimpleScaling}. (Not used with any other
policy type.)}

\item{Cooldown}{The duration of the policy's cooldown period, in seconds. When a
cooldown period is specified here, it overrides the default cooldown
period defined for the Auto Scaling group.

Valid only if the policy type is \code{SimpleScaling}. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html}{Scaling cooldowns for Amazon EC2 Auto Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MetricAggregationType}{The aggregation type for the CloudWatch metrics. The valid values are
\code{Minimum}, \code{Maximum}, and \code{Average}. If the aggregation type is null,
the value is treated as \code{Average}.

Valid only if the policy type is \code{StepScaling}.}

\item{StepAdjustments}{A set of adjustments that enable you to scale based on the size of the
alarm breach.

Required if the policy type is \code{StepScaling}. (Not used with any other
policy type.)}

\item{EstimatedInstanceWarmup}{The estimated time, in seconds, until a newly launched instance can
contribute to the CloudWatch metrics. If not provided, the default is to
use the value from the default cooldown period for the Auto Scaling
group.

Valid only if the policy type is \code{TargetTrackingScaling} or
\code{StepScaling}.}

\item{TargetTrackingConfiguration}{A target tracking scaling policy. Includes support for predefined or
customized metrics.

The following predefined metrics are available:
\itemize{
\item \code{ASGAverageCPUUtilization}
\item \code{ASGAverageNetworkIn}
\item \code{ASGAverageNetworkOut}
\item \code{ALBRequestCountPerTarget}
}

If you specify \code{ALBRequestCountPerTarget} for the metric, you must
specify the \code{ResourceLabel} parameter with the
\code{PredefinedMetricSpecification}.

For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html}{TargetTrackingConfiguration}
in the \emph{Amazon EC2 Auto Scaling API Reference}.

Required if the policy type is \code{TargetTrackingScaling}.}

\item{Enabled}{Indicates whether the scaling policy is enabled or disabled. The default
is enabled. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html}{Disabling a scaling policy for an Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  PolicyARN = "string",
  Alarms = list(
    list(
      AlarmName = "string",
      AlarmARN = "string"
    )
  )
)
}
}
\description{
Creates or updates a scaling policy for an Auto Scaling group.

For more information about using scaling policies to scale your Auto
Scaling group, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html}{Target tracking scaling policies}
and \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html}{Step and simple scaling policies}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_scaling_policy(
  AutoScalingGroupName = "string",
  PolicyName = "string",
  PolicyType = "string",
  AdjustmentType = "string",
  MinAdjustmentStep = 123,
  MinAdjustmentMagnitude = 123,
  ScalingAdjustment = 123,
  Cooldown = 123,
  MetricAggregationType = "string",
  StepAdjustments = list(
    list(
      MetricIntervalLowerBound = 123.0,
      MetricIntervalUpperBound = 123.0,
      ScalingAdjustment = 123
    )
  ),
  EstimatedInstanceWarmup = 123,
  TargetTrackingConfiguration = list(
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"ALBRequestCountPerTarget",
      ResourceLabel = "string"
    ),
    CustomizedMetricSpecification = list(
      MetricName = "string",
      Namespace = "string",
      Dimensions = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
      Unit = "string"
    ),
    TargetValue = 123.0,
    DisableScaleIn = TRUE|FALSE
  ),
  Enabled = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example adds the specified policy to the specified Auto Scaling
# group.
svc$put_scaling_policy(
  AutoScalingGroupName = "my-auto-scaling-group",
  PolicyName = "alb1000-target-tracking-scaling-policy",
  PolicyType = "TargetTrackingScaling",
  TargetTrackingConfiguration = list(
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "ALBRequestCountPerTarget",
      ResourceLabel = "app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targe..."
    ),
    TargetValue = 1000
  )
)
}

}
\keyword{internal}
