% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_refresh_trusted_advisor_check}
\alias{support_refresh_trusted_advisor_check}
\title{Refreshes the AWS Trusted Advisor check that you specify using the check
ID}
\usage{
support_refresh_trusted_advisor_check(checkId)
}
\arguments{
\item{checkId}{[required] The unique identifier for the Trusted Advisor check to refresh.
\strong{Note:} Specifying the check ID of a check that is automatically
refreshed causes an \code{InvalidParameterValue} error.}
}
\description{
Refreshes the AWS Trusted Advisor check that you specify using the check
ID. You can get the check IDs by calling the
DescribeTrustedAdvisorChecks operation.

Some checks are refreshed automatically. If you call the
\code{RefreshTrustedAdvisorCheck} operation to refresh them, you might see
the \code{InvalidParameterValue} error.

The response contains a TrustedAdvisorCheckRefreshStatus object.
\itemize{
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}
}
\section{Request syntax}{
\preformatted{svc$refresh_trusted_advisor_check(
  checkId = "string"
)
}
}

\keyword{internal}
