% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_activation}
\alias{ssm_create_activation}
\title{Generates an activation code and activation ID you can use to register
your on-premises server or virtual machine (VM) with Systems Manager}
\usage{
ssm_create_activation(Description, DefaultInstanceName, IamRole,
  RegistrationLimit, ExpirationDate, Tags)
}
\arguments{
\item{Description}{A user-defined description of the resource that you want to register
with Systems Manager.

Do not enter personally identifiable information in this field.}

\item{DefaultInstanceName}{The name of the registered, managed instance as it will appear in the
Systems Manager console or when you use the AWS command line tools to
list Systems Manager resources.

Do not enter personally identifiable information in this field.}

\item{IamRole}{[required] The Amazon Identity and Access Management (IAM) role that you want to
assign to the managed instance. This IAM role must provide AssumeRole
permissions for the Systems Manager service principal
\code{ssm.amazonaws.com}. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html}{Create an IAM service role for a hybrid environment}
in the \emph{AWS Systems Manager User Guide}.}

\item{RegistrationLimit}{Specify the maximum number of managed instances you want to register.
The default value is 1 instance.}

\item{ExpirationDate}{The date by which this activation request should expire. The default
value is 24 hours.}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag an activation to
identify which servers or virtual machines (VMs) in your on-premises
environment you intend to activate. In this case, you could specify the
following key name/value pairs:
\itemize{
\item \verb{Key=OS,Value=Windows}
\item \verb{Key=Environment,Value=Production}
}

When you install SSM Agent on your on-premises servers and VMs, you
specify an activation ID and code. When you specify the activation ID
and code, tags assigned to the activation are automatically applied to
the on-premises servers or VMs.

You can't add tags to or delete tags from an existing activation. You
can tag your on-premises servers and VMs after they connect to Systems
Manager for the first time and are assigned a managed instance ID. This
means they are listed in the AWS Systems Manager console with an ID that
is prefixed with "mi-". For information about how to add tags to your
managed instances, see AddTagsToResource. For information about how to
remove tags from your managed instances, see RemoveTagsFromResource.}
}
\description{
Generates an activation code and activation ID you can use to register
your on-premises server or virtual machine (VM) with Systems Manager.
Registering these machines with Systems Manager makes it possible to
manage them using Systems Manager capabilities. You use the activation
code and ID when installing SSM Agent on machines in your hybrid
environment. For more information about requirements for managing
on-premises instances and VMs using Systems Manager, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html}{Setting up AWS Systems Manager for hybrid environments}
in the \emph{AWS Systems Manager User Guide}.

On-premises servers or VMs that are registered with Systems Manager and
EC2 instances that you manage with Systems Manager are all called
\emph{managed instances}.
}
\section{Request syntax}{
\preformatted{svc$create_activation(
  Description = "string",
  DefaultInstanceName = "string",
  IamRole = "string",
  RegistrationLimit = 123,
  ExpirationDate = as.POSIXct(
    "2015-01-01"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
