% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_effective_policy}
\alias{organizations_describe_effective_policy}
\title{Returns the contents of the effective policy for specified policy type
and account}
\usage{
organizations_describe_effective_policy(PolicyType, TargetId)
}
\arguments{
\item{PolicyType}{[required] The type of policy that you want information about. You can specify one
of the following values:
\itemize{
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html}{AISERVICES\\_OPT\\_OUT\\_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html}{BACKUP\\_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html}{TAG\\_POLICY}
}}

\item{TargetId}{When you're signed in as the management account, specify the ID of the
account that you want details about. Specifying an organization root or
organizational unit (OU) as the target is not supported.}
}
\description{
Returns the contents of the effective policy for specified policy type
and account. The effective policy is the aggregation of any policies of
the specified type that the account inherits, plus any policy of that
type that is directly attached to the account.

This operation applies only to policy types \emph{other} than service control
policies (SCPs).

For more information about policy inheritance, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{How Policy Inheritance Works} in
the \emph{AWS Organizations User Guide}.

This operation can be called only from the organization's management
account or by a member account that is a delegated administrator for an
AWS service.
}
\section{Request syntax}{
\preformatted{svc$describe_effective_policy(
  PolicyType = "TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY",
  TargetId = "string"
)
}
}

\keyword{internal}
