% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_resource_config_history}
\alias{configservice_get_resource_config_history}
\title{Returns a list of configuration items for the specified resource}
\usage{
configservice_get_resource_config_history(resourceType, resourceId,
  laterTime, earlierTime, chronologicalOrder, limit, nextToken)
}
\arguments{
\item{resourceType}{[required] The resource type.}

\item{resourceId}{[required] The ID of the resource (for example., \code{sg-xxxxxx}).}

\item{laterTime}{The time stamp that indicates a later time. If not specified, current
time is taken.}

\item{earlierTime}{The time stamp that indicates an earlier time. If not specified, the
action returns paginated results that contain configuration items that
start when the first configuration item was recorded.}

\item{chronologicalOrder}{The chronological order for configuration items listed. By default, the
results are listed in reverse chronological order.}

\item{limit}{The maximum number of configuration items returned on each page. The
default is 10. You cannot specify a number greater than 100. If you
specify 0, AWS Config uses the default.}

\item{nextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns a list of configuration items for the specified resource. The
list contains details about each state of the resource during the
specified time interval. If you specified a retention period to retain
your \code{ConfigurationItems} between a minimum of 30 days and a maximum of
7 years (2557 days), AWS Config returns the \code{ConfigurationItems} for the
specified retention period.

The response is paginated. By default, AWS Config returns a limit of 10
configuration items per page. You can customize this number with the
\code{limit} parameter. The response includes a \code{nextToken} string. To get
the next page of results, run the request again and specify the string
for the \code{nextToken} parameter.

Each call to the API is limited to span a duration of seven days. It is
likely that the number of records returned is smaller than the specified
\code{limit}. In such cases, you can make another call, using the
\code{nextToken}.
}
\section{Request syntax}{
\preformatted{svc$get_resource_config_history(
  resourceType = "AWS::EC2::CustomerGateway"|"AWS::EC2::EIP"|"AWS::EC2::Host"|"AWS::EC2::Instance"|"AWS::EC2::InternetGateway"|"AWS::EC2::NetworkAcl"|"AWS::EC2::NetworkInterface"|"AWS::EC2::RouteTable"|"AWS::EC2::SecurityGroup"|"AWS::EC2::Subnet"|"AWS::CloudTrail::Trail"|"AWS::EC2::Volume"|"AWS::EC2::VPC"|"AWS::EC2::VPNConnection"|"AWS::EC2::VPNGateway"|"AWS::EC2::RegisteredHAInstance"|"AWS::EC2::NatGateway"|"AWS::EC2::EgressOnlyInternetGateway"|"AWS::EC2::VPCEndpoint"|"AWS::EC2::VPCEndpointService"|"AWS::EC2::FlowLog"|"AWS::EC2::VPCPeeringConnection"|"AWS::Elasticsearch::Domain"|"AWS::IAM::Group"|"AWS::IAM::Policy"|"AWS::IAM::Role"|"AWS::IAM::User"|"AWS::ElasticLoadBalancingV2::LoadBalancer"|"AWS::ACM::Certificate"|"AWS::RDS::DBInstance"|"AWS::RDS::DBSubnetGroup"|"AWS::RDS::DBSecurityGroup"|"AWS::RDS::DBSnapshot"|"AWS::RDS::DBCluster"|"AWS::RDS::DBClusterSnapshot"|"AWS::RDS::EventSubscription"|"AWS::S3::Bucket"|"AWS::S3::AccountPublicAccessBlock"|"AWS::Redshift::Cluster"|"AWS::Redshift::ClusterSnapshot"|"AWS::Redshift::ClusterParameterGroup"|"AWS::Redshift::ClusterSecurityGroup"|"AWS::Redshift::ClusterSubnetGroup"|"AWS::Redshift::EventSubscription"|"AWS::SSM::ManagedInstanceInventory"|"AWS::CloudWatch::Alarm"|"AWS::CloudFormation::Stack"|"AWS::ElasticLoadBalancing::LoadBalancer"|"AWS::AutoScaling::AutoScalingGroup"|"AWS::AutoScaling::LaunchConfiguration"|"AWS::AutoScaling::ScalingPolicy"|"AWS::AutoScaling::ScheduledAction"|"AWS::DynamoDB::Table"|"AWS::CodeBuild::Project"|"AWS::WAF::RateBasedRule"|"AWS::WAF::Rule"|"AWS::WAF::RuleGroup"|"AWS::WAF::WebACL"|"AWS::WAFRegional::RateBasedRule"|"AWS::WAFRegional::Rule"|"AWS::WAFRegional::RuleGroup"|"AWS::WAFRegional::WebACL"|"AWS::CloudFront::Distribution"|"AWS::CloudFront::StreamingDistribution"|"AWS::Lambda::Function"|"AWS::NetworkFirewall::Firewall"|"AWS::NetworkFirewall::FirewallPolicy"|"AWS::NetworkFirewall::RuleGroup"|"AWS::ElasticBeanstalk::Application"|"AWS::ElasticBeanstalk::ApplicationVersion"|"AWS::ElasticBeanstalk::Environment"|"AWS::WAFv2::WebACL"|"AWS::WAFv2::RuleGroup"|"AWS::WAFv2::IPSet"|"AWS::WAFv2::RegexPatternSet"|"AWS::WAFv2::ManagedRuleSet"|"AWS::XRay::EncryptionConfig"|"AWS::SSM::AssociationCompliance"|"AWS::SSM::PatchCompliance"|"AWS::Shield::Protection"|"AWS::ShieldRegional::Protection"|"AWS::Config::ResourceCompliance"|"AWS::ApiGateway::Stage"|"AWS::ApiGateway::RestApi"|"AWS::ApiGatewayV2::Stage"|"AWS::ApiGatewayV2::Api"|"AWS::CodePipeline::Pipeline"|"AWS::ServiceCatalog::CloudFormationProvisionedProduct"|"AWS::ServiceCatalog::CloudFormationProduct"|"AWS::ServiceCatalog::Portfolio"|"AWS::SQS::Queue"|"AWS::KMS::Key"|"AWS::QLDB::Ledger"|"AWS::SecretsManager::Secret"|"AWS::SNS::Topic"|"AWS::SSM::FileData",
  resourceId = "string",
  laterTime = as.POSIXct(
    "2015-01-01"
  ),
  earlierTime = as.POSIXct(
    "2015-01-01"
  ),
  chronologicalOrder = "Reverse"|"Forward",
  limit = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
