# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Application Auto Scaling
#'
#' @description
#' With Application Auto Scaling, you can configure automatic scaling for
#' the following resources:
#' 
#' -   Amazon ECS services
#' 
#' -   Amazon EC2 Spot Fleet requests
#' 
#' -   Amazon EMR clusters
#' 
#' -   Amazon AppStream 2.0 fleets
#' 
#' -   Amazon DynamoDB tables and global secondary indexes throughput
#'     capacity
#' 
#' -   Amazon Aurora Replicas
#' 
#' -   Amazon SageMaker endpoint variants
#' 
#' -   Custom resources provided by your own applications or services
#' 
#' -   Amazon Comprehend document classification and entity recognizer
#'     endpoints
#' 
#' -   AWS Lambda function provisioned concurrency
#' 
#' -   Amazon Keyspaces (for Apache Cassandra) tables
#' 
#' -   Amazon Managed Streaming for Apache Kafka cluster storage
#' 
#' **API Summary**
#' 
#' The Application Auto Scaling service API includes three key sets of
#' actions:
#' 
#' -   Register and manage scalable targets - Register AWS or custom
#'     resources as scalable targets (a resource that Application Auto
#'     Scaling can scale), set minimum and maximum capacity limits, and
#'     retrieve information on existing scalable targets.
#' 
#' -   Configure and manage automatic scaling - Define scaling policies to
#'     dynamically scale your resources in response to CloudWatch alarms,
#'     schedule one-time or recurring scaling actions, and retrieve your
#'     recent scaling activity history.
#' 
#' -   Suspend and resume scaling - Temporarily suspend and later resume
#'     automatic scaling by calling the
#'     [RegisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
#'     API action for any Application Auto Scaling scalable target. You can
#'     suspend and resume (individually or in combination) scale-out
#'     activities that are triggered by a scaling policy, scale-in
#'     activities that are triggered by a scaling policy, and scheduled
#'     scaling.
#' 
#' To learn more about Application Auto Scaling, including information
#' about granting IAM users required permissions for Application Auto
#' Scaling actions, see the [Application Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- applicationautoscaling(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- applicationautoscaling()
#' # This example deletes a scaling policy for the Amazon ECS service called
#' # web-app, which is running in the default cluster.
#' svc$delete_scaling_policy(
#'   PolicyName = "web-app-cpu-lt-25",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=applicationautoscaling_delete_scaling_policy]{delete_scaling_policy} \tab Deletes the specified scaling policy for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified scheduled action for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_deregister_scalable_target]{deregister_scalable_target} \tab Deregisters an Application Auto Scaling scalable target when you have finished using it\cr
#'  \link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets} \tab Gets information about the scalable targets in the specified namespace\cr
#'  \link[=applicationautoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks\cr
#'  \link[=applicationautoscaling_describe_scaling_policies]{describe_scaling_policies} \tab Describes the Application Auto Scaling scaling policies for the specified service namespace\cr
#'  \link[=applicationautoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Describes the Application Auto Scaling scheduled actions for the specified service namespace\cr
#'  \link[=applicationautoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a scaling policy for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_put_scheduled_action]{put_scheduled_action} \tab Creates or updates a scheduled action for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_register_scalable_target]{register_scalable_target} \tab Registers or updates a scalable target
#' }
#'
#' @rdname applicationautoscaling
#' @export
applicationautoscaling <- function(config = list()) {
  svc <- .applicationautoscaling$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.applicationautoscaling <- list()

.applicationautoscaling$operations <- list()

.applicationautoscaling$metadata <- list(
  service_name = "autoscaling",
  endpoints = list("*" = list(endpoint = "autoscaling.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "autoscaling.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "autoscaling.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "autoscaling.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Application Auto Scaling",
  api_version = "2016-02-06",
  signing_name = "application-autoscaling",
  json_version = "1.1",
  target_prefix = "AnyScaleFrontendService"
)

.applicationautoscaling$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.applicationautoscaling$metadata, handlers, config)
}
