% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimev2_operations.R
\name{lexruntimev2_start_conversation}
\alias{lexruntimev2_start_conversation}
\title{Starts an HTTP/2 bidirectional event stream that enables you to send
audio, text, or DTMF input in real time}
\usage{
lexruntimev2_start_conversation(
  botId,
  botAliasId,
  localeId,
  sessionId,
  conversationMode = NULL,
  requestEventStream
)
}
\arguments{
\item{botId}{[required] The identifier of the bot to process the request.}

\item{botAliasId}{[required] The alias identifier in use for the bot that processes the request.}

\item{localeId}{[required] The locale where the session is in use.}

\item{sessionId}{[required] The identifier of the user session that is having the conversation.}

\item{conversationMode}{The conversation type that you are using the Amazon Lex V2. If the
conversation mode is \code{AUDIO} you can send both audio and DTMF
information. If the mode is \code{TEXT} you can only send text.}

\item{requestEventStream}{[required] Represents the stream of events to Amazon Lex V2 from your application.
The events are encoded as HTTP/2 data frames.}
}
\description{
Starts an HTTP/2 bidirectional event stream that enables you to send audio, text, or DTMF input in real time. After your application starts a conversation, users send input to Amazon Lex V2 as a stream of events. Amazon Lex V2 processes the incoming events and responds with streaming text or audio events.

See \url{https://www.paws-r-sdk.com/docs/lexruntimev2_start_conversation/} for full documentation.
}
\keyword{internal}
