% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_model_customization_jobs}
\alias{bedrock_list_model_customization_jobs}
\title{Returns a list of model customization jobs that you have submitted}
\usage{
bedrock_list_model_customization_jobs(
  creationTimeAfter = NULL,
  creationTimeBefore = NULL,
  statusEquals = NULL,
  nameContains = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{creationTimeAfter}{Return customization jobs created after the specified time.}

\item{creationTimeBefore}{Return customization jobs created before the specified time.}

\item{statusEquals}{Return customization jobs with the specified status.}

\item{nameContains}{Return customization jobs only if the job name contains these
characters.}

\item{maxResults}{The maximum number of results to return in the response. If the total
number of results is greater than this value, use the token returned in
the response in the \code{nextToken} field when making another request to
return the next batch of results.}

\item{nextToken}{If the total number of results is greater than the \code{maxResults} value
provided in the request, enter the token returned in the \code{nextToken}
field in the response in this field to return the next batch of results.}

\item{sortBy}{The field to sort by in the returned list of jobs.}

\item{sortOrder}{The sort order of the results.}
}
\description{
Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on one or more criteria.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_model_customization_jobs/} for full documentation.
}
\keyword{internal}
