% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_face_detection}
\alias{rekognition_start_face_detection}
\title{Starts asynchronous detection of faces in a stored video}
\usage{
rekognition_start_face_detection(
  Video,
  ClientRequestToken = NULL,
  NotificationChannel = NULL,
  FaceAttributes = NULL,
  JobTag = NULL
)
}
\arguments{
\item{Video}{[required] The video in which you want to detect faces. The video must be stored in
an Amazon S3 bucket.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple
\code{\link[=rekognition_start_face_detection]{start_face_detection}} requests, the
same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the same
job from being accidently started more than once.}

\item{NotificationChannel}{The ARN of the Amazon SNS topic to which you want Amazon Rekognition
Video to publish the completion status of the face detection operation.
The Amazon SNS topic must have a topic name that begins with
\emph{AmazonRekognition} if you are using the AmazonRekognitionServiceRole
permissions policy.}

\item{FaceAttributes}{The face attributes you want returned.

\code{DEFAULT} - The following subset of facial attributes are returned:
BoundingBox, Confidence, Pose, Quality and Landmarks.

\code{ALL} - All facial attributes are returned.}

\item{JobTag}{An identifier you specify that's returned in the completion notification
that's published to your Amazon Simple Notification Service topic. For
example, you can use \code{JobTag} to group related jobs and identify them in
the completion notification.}
}
\description{
Starts asynchronous detection of faces in a stored video.

See \url{https://paws-r.github.io/docs/rekognition/start_face_detection.html} for full documentation.
}
\keyword{internal}
