% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_start_targeted_sentiment_detection_job}
\alias{comprehend_start_targeted_sentiment_detection_job}
\title{Starts an asynchronous targeted sentiment detection job for a collection
of documents}
\usage{
comprehend_start_targeted_sentiment_detection_job(
  InputDataConfig,
  OutputDataConfig,
  DataAccessRoleArn,
  JobName = NULL,
  LanguageCode,
  ClientRequestToken = NULL,
  VolumeKmsKeyId = NULL,
  VpcConfig = NULL,
  Tags = NULL
)
}
\arguments{
\item{InputDataConfig}{[required]}

\item{OutputDataConfig}{[required] Specifies where to send the output files.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Access Management
(IAM) role that grants Amazon Comprehend read access to your input data.
For more information, see Role-based permissions.}

\item{JobName}{The identifier of the job.}

\item{LanguageCode}{[required] The language of the input documents. Currently, English is the only
valid language.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}

\item{VolumeKmsKeyId}{ID for the KMS key that Amazon Comprehend uses to encrypt data on the
storage volume attached to the ML compute instance(s) that process the
analysis job. The VolumeKmsKeyId can be either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{VpcConfig}{}

\item{Tags}{Tags to be associated with the targeted sentiment detection job. A tag
is a key-value pair that adds metadata to a resource used by Amazon
Comprehend. For example, a tag with "Sales" as the key might be added to
a resource to indicate its use by the sales department.}
}
\description{
Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the operation to track the status of a job.

See \url{https://paws-r.github.io/docs/comprehend/start_targeted_sentiment_detection_job.html} for full documentation.
}
\keyword{internal}
