# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lexmodelsv2_service.R
NULL

#' Builds a bot, its intents, and its slot types into a specific locale
#'
#' @description
#' Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/build_bot_locale.html](https://paws-r.github.io/docs/lexmodelsv2/build_bot_locale.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to build. The identifier is returned in the
#' response from the [`create_bot`][lexmodelsv2_create_bot] operation.
#' @param botVersion &#91;required&#93; The version of the bot to build. This can only be the draft version of
#' the bot.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the bot will be used in.
#' The string must match one of the supported locales. All of the intents,
#' slot types, and slots used in the bot must have the same locale. For
#' more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_build_bot_locale
lexmodelsv2_build_bot_locale <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "BuildBotLocale",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$build_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$build_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$build_bot_locale <- lexmodelsv2_build_bot_locale

#' Creates an Amazon Lex conversational bot
#'
#' @description
#' Creates an Amazon Lex conversational bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_bot.html](https://paws-r.github.io/docs/lexmodelsv2/create_bot.html) for full documentation.
#'
#' @param botName &#91;required&#93; The name of the bot. The bot name must be unique in the account that
#' creates the bot.
#' @param description A description of the bot. It appears in lists to help you identify a
#' particular bot.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that has permission to
#' access the bot.
#' @param dataPrivacy &#91;required&#93; Provides information on additional privacy protections Amazon Lex should
#' use with the bot's data.
#' @param idleSessionTTLInSeconds &#91;required&#93; The time, in seconds, that Amazon Lex should keep information about a
#' user's conversation with the bot.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and Amazon
#' Lex deletes any data provided before the timeout.
#' 
#' You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
#' @param botTags A list of tags to add to the bot. You can only add tags when you create
#' a bot. You can't use the [`update_bot`][lexmodelsv2_update_bot]
#' operation to update tags. To update tags, use the
#' [`tag_resource`][lexmodelsv2_tag_resource] operation.
#' @param testBotAliasTags A list of tags to add to the test alias for a bot. You can only add tags
#' when you create a bot. You can't use the `UpdateAlias` operation to
#' update tags. To update tags on the test alias, use the
#' [`tag_resource`][lexmodelsv2_tag_resource] operation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot
lexmodelsv2_create_bot <- function(botName, description = NULL, roleArn, dataPrivacy, idleSessionTTLInSeconds, botTags = NULL, testBotAliasTags = NULL) {
  op <- new_operation(
    name = "CreateBot",
    http_method = "PUT",
    http_path = "/bots/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_input(botName = botName, description = description, roleArn = roleArn, dataPrivacy = dataPrivacy, idleSessionTTLInSeconds = idleSessionTTLInSeconds, botTags = botTags, testBotAliasTags = testBotAliasTags)
  output <- .lexmodelsv2$create_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot <- lexmodelsv2_create_bot

#' Creates an alias for the specified version of a bot
#'
#' @description
#' Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_bot_alias.html](https://paws-r.github.io/docs/lexmodelsv2/create_bot_alias.html) for full documentation.
#'
#' @param botAliasName &#91;required&#93; The alias to create. The name must be unique for the bot.
#' @param description A description of the alias. Use this description to help identify the
#' alias.
#' @param botVersion The version of the bot that this alias points to. You can use the
#' [`update_bot_alias`][lexmodelsv2_update_bot_alias] operation to change
#' the bot version associated with the alias.
#' @param botAliasLocaleSettings Maps configuration information to a specific locale. You can use this
#' parameter to specify a specific Lambda function to run different
#' functions in different locales.
#' @param conversationLogSettings Specifies whether Amazon Lex logs text and audio for a conversation with
#' the bot. When you enable conversation logs, text logs store text input,
#' transcripts of audio input, and associated metadata in Amazon CloudWatch
#' Logs. Audio logs store audio input in Amazon S3.
#' @param sentimentAnalysisSettings 
#' @param botId &#91;required&#93; The unique identifier of the bot that the alias applies to.
#' @param tags A list of tags to add to the bot alias. You can only add tags when you
#' create an alias, you can't use the
#' [`update_bot_alias`][lexmodelsv2_update_bot_alias] operation to update
#' the tags on a bot alias. To update tags, use the
#' [`tag_resource`][lexmodelsv2_tag_resource] operation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot_alias
lexmodelsv2_create_bot_alias <- function(botAliasName, description = NULL, botVersion = NULL, botAliasLocaleSettings = NULL, conversationLogSettings = NULL, sentimentAnalysisSettings = NULL, botId, tags = NULL) {
  op <- new_operation(
    name = "CreateBotAlias",
    http_method = "PUT",
    http_path = "/bots/{botId}/botaliases/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_alias_input(botAliasName = botAliasName, description = description, botVersion = botVersion, botAliasLocaleSettings = botAliasLocaleSettings, conversationLogSettings = conversationLogSettings, sentimentAnalysisSettings = sentimentAnalysisSettings, botId = botId, tags = tags)
  output <- .lexmodelsv2$create_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot_alias <- lexmodelsv2_create_bot_alias

#' Creates a locale in the bot
#'
#' @description
#' Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_bot_locale.html](https://paws-r.github.io/docs/lexmodelsv2/create_bot_locale.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to create the locale for.
#' @param botVersion &#91;required&#93; The version of the bot to create the locale for. This can only be the
#' draft version of the bot.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the bot will be used in.
#' The string must match one of the supported locales. All of the intents,
#' slot types, and slots used in the bot must have the same locale. For
#' more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param description A description of the bot locale. Use this to help identify the bot
#' locale in lists.
#' @param nluIntentConfidenceThreshold &#91;required&#93; Determines the threshold where Amazon Lex will insert the
#' `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when
#' returning alternative intents. `AMAZON.FallbackIntent` and
#' `AMAZON.KendraSearchIntent` are only inserted if they are configured for
#' the bot.
#' 
#' For example, suppose a bot is configured with the confidence threshold
#' of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three
#' alternative intents with the following confidence scores: IntentA
#' (0.70), IntentB (0.60), IntentC (0.50). The response from the
#' `RecognizeText` operation would be:
#' 
#' -   AMAZON.FallbackIntent
#' 
#' -   IntentA
#' 
#' -   IntentB
#' 
#' -   IntentC
#' @param voiceSettings The Amazon Polly voice ID that Amazon Lex uses for voice interaction
#' with the user.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot_locale
lexmodelsv2_create_bot_locale <- function(botId, botVersion, localeId, description = NULL, nluIntentConfidenceThreshold, voiceSettings = NULL) {
  op <- new_operation(
    name = "CreateBotLocale",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId, description = description, nluIntentConfidenceThreshold = nluIntentConfidenceThreshold, voiceSettings = voiceSettings)
  output <- .lexmodelsv2$create_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot_locale <- lexmodelsv2_create_bot_locale

#' Creates a new version of the bot based on the DRAFT version
#'
#' @description
#' Creates a new version of the bot based on the `DRAFT` version. If the `DRAFT` version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_bot_version.html](https://paws-r.github.io/docs/lexmodelsv2/create_bot_version.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to create the version for.
#' @param description A description of the version. Use the description to help identify the
#' version in lists.
#' @param botVersionLocaleSpecification &#91;required&#93; Specifies the locales that Amazon Lex adds to this version. You can
#' choose the `Draft` version or any other previously published version for
#' each locale. When you specify a source version, the locale data is
#' copied from the source version to the new version.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot_version
lexmodelsv2_create_bot_version <- function(botId, description = NULL, botVersionLocaleSpecification) {
  op <- new_operation(
    name = "CreateBotVersion",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_version_input(botId = botId, description = description, botVersionLocaleSpecification = botVersionLocaleSpecification)
  output <- .lexmodelsv2$create_bot_version_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot_version <- lexmodelsv2_create_bot_version

#' Creates a zip archive containing the contents of a bot or a bot locale
#'
#' @description
#' Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_export.html](https://paws-r.github.io/docs/lexmodelsv2/create_export.html) for full documentation.
#'
#' @param resourceSpecification &#91;required&#93; Specifies the type of resource to export, either a bot or a bot locale.
#' You can only specify one type of resource to export.
#' @param fileFormat &#91;required&#93; The file format of the bot or bot locale definition files.
#' @param filePassword An password to use to encrypt the exported archive. Using a password is
#' optional, but you should encrypt the archive to protect the data in
#' transit between Amazon Lex and your local computer.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_export
lexmodelsv2_create_export <- function(resourceSpecification, fileFormat, filePassword = NULL) {
  op <- new_operation(
    name = "CreateExport",
    http_method = "PUT",
    http_path = "/exports/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_export_input(resourceSpecification = resourceSpecification, fileFormat = fileFormat, filePassword = filePassword)
  output <- .lexmodelsv2$create_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_export <- lexmodelsv2_create_export

#' Creates an intent
#'
#' @description
#' Creates an intent.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_intent.html](https://paws-r.github.io/docs/lexmodelsv2/create_intent.html) for full documentation.
#'
#' @param intentName &#91;required&#93; The name of the intent. Intent names must be unique in the locale that
#' contains the intent and cannot match the name of any built-in intent.
#' @param description A description of the intent. Use the description to help identify the
#' intent in lists.
#' @param parentIntentSignature A unique identifier for the built-in intent to base this intent on.
#' @param sampleUtterances An array of strings that a user might say to signal the intent. For
#' example, "I want a pizza", or "I want a \{PizzaSize\} pizza".
#' 
#' In an utterance, slot names are enclosed in curly braces ("\{", "\}")
#' to indicate where they should be displayed in the utterance shown to the
#' user..
#' @param dialogCodeHook Specifies that Amazon Lex invokes the alias Lambda function for each
#' user input. You can invoke this Lambda function to personalize user
#' interaction.
#' 
#' For example, suppose that your bot determines that the user's name is
#' John. You Lambda function might retrieve John's information from a
#' backend database and prepopulate some of the values. For example, if you
#' find that John is gluten intolerant, you might set the corresponding
#' intent slot, `glutenIntolerant` to `true`. You might find John's phone
#' number and set the corresponding session attribute.
#' @param fulfillmentCodeHook Specifies that Amazon Lex invokes the alias Lambda function when the
#' intent is ready for fulfillment. You can invoke this function to
#' complete the bot's transaction with the user.
#' 
#' For example, in a pizza ordering bot, the Lambda function can look up
#' the closest pizza restaurant to the customer's location and then place
#' an order on the customer's behalf.
#' @param intentConfirmationSetting Provides prompts that Amazon Lex sends to the user to confirm the
#' completion of an intent. If the user answers "no," the settings contain
#' a statement that is sent to the user to end the intent.
#' @param intentClosingSetting Sets the response that Amazon Lex sends to the user when the intent is
#' closed.
#' @param inputContexts A list of contexts that must be active for this intent to be considered
#' by Amazon Lex.
#' 
#' When an intent has an input context list, Amazon Lex only considers
#' using the intent in an interaction with the user when the specified
#' contexts are included in the active context list for the session. If the
#' contexts are not active, then Amazon Lex will not use the intent.
#' 
#' A context can be automatically activated using the `outputContexts`
#' property or it can be set at runtime.
#' 
#' For example, if there are two intents with different input contexts that
#' respond to the same utterances, only the intent with the active context
#' will respond.
#' 
#' An intent may have up to 5 input contexts. If an intent has multiple
#' input contexts, all of the contexts must be active to consider the
#' intent.
#' @param outputContexts A lists of contexts that the intent activates when it is fulfilled.
#' 
#' You can use an output context to indicate the intents that Amazon Lex
#' should consider for the next turn of the conversation with a customer.
#' 
#' When you use the `outputContextsList` property, all of the contexts
#' specified in the list are activated when the intent is fulfilled. You
#' can set up to 10 output contexts. You can also set the number of
#' conversation turns that the context should be active, or the length of
#' time that the context should be active.
#' @param kendraConfiguration Configuration information required to use the
#' `AMAZON.KendraSearchIntent` intent to connect to an Amazon Kendra index.
#' The `AMAZON.KendraSearchIntent` intent is called when Amazon Lex can't
#' determine another intent to invoke.
#' @param botId &#91;required&#93; The identifier of the bot associated with this intent.
#' @param botVersion &#91;required&#93; The identifier of the version of the bot associated with this intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this intent is used. All
#' of the bots, slot types, and slots used by the intent must have the same
#' locale. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_intent
lexmodelsv2_create_intent <- function(intentName, description = NULL, parentIntentSignature = NULL, sampleUtterances = NULL, dialogCodeHook = NULL, fulfillmentCodeHook = NULL, intentConfirmationSetting = NULL, intentClosingSetting = NULL, inputContexts = NULL, outputContexts = NULL, kendraConfiguration = NULL, botId, botVersion, localeId) {
  op <- new_operation(
    name = "CreateIntent",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_intent_input(intentName = intentName, description = description, parentIntentSignature = parentIntentSignature, sampleUtterances = sampleUtterances, dialogCodeHook = dialogCodeHook, fulfillmentCodeHook = fulfillmentCodeHook, intentConfirmationSetting = intentConfirmationSetting, intentClosingSetting = intentClosingSetting, inputContexts = inputContexts, outputContexts = outputContexts, kendraConfiguration = kendraConfiguration, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$create_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_intent <- lexmodelsv2_create_intent

#' Creates a new resource policy with the specified policy statements
#'
#' @description
#' Creates a new resource policy with the specified policy statements.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_resource_policy.html](https://paws-r.github.io/docs/lexmodelsv2/create_resource_policy.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param policy &#91;required&#93; A resource policy to add to the resource. The policy is a JSON structure
#' that contains one or more statements that define the policy. The policy
#' must follow the IAM syntax. For more information about the contents of a
#' JSON policy document, see [IAM JSON policy
#' reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' .
#' 
#' If the policy isn't valid, Amazon Lex returns a validation exception.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_resource_policy
lexmodelsv2_create_resource_policy <- function(resourceArn, policy) {
  op <- new_operation(
    name = "CreateResourcePolicy",
    http_method = "POST",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_resource_policy_input(resourceArn = resourceArn, policy = policy)
  output <- .lexmodelsv2$create_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_resource_policy <- lexmodelsv2_create_resource_policy

#' Adds a new resource policy statement to a bot or bot alias
#'
#' @description
#' Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_resource_policy_statement.html](https://paws-r.github.io/docs/lexmodelsv2/create_resource_policy_statement.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param statementId &#91;required&#93; The name of the statement. The ID is the same as the `Sid` IAM property.
#' The statement name must be unique within the policy. For more
#' information, see [IAM JSON policy elements:
#' Sid](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html).
#' @param effect &#91;required&#93; Determines whether the statement allows or denies access to the
#' resource.
#' @param principal &#91;required&#93; An IAM principal, such as an IAM users, IAM roles, or AWS services that
#' is allowed or denied access to a resource. For more information, see
#' [AWS JSON policy elements:
#' Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
#' @param action &#91;required&#93; The Amazon Lex action that this policy either allows or denies. The
#' action must apply to the resource type of the specified ARN. For more
#' information, see [Actions, resources, and condition keys for Amazon Lex
#' V2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
#' @param condition Specifies a condition when the policy is in effect. If the principal of
#' the policy is a service principal, you must provide two condition
#' blocks, one with a SourceAccount global condition key and one with a
#' SourceArn global condition key.
#' 
#' For more information, see [IAM JSON policy elements:
#' Condition](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html)
#' .
#' @param expectedRevisionId The identifier of the revision of the policy to edit. If this revision
#' ID doesn't match the current revision ID, Amazon Lex throws an
#' exception.
#' 
#' If you don't specify a revision, Amazon Lex overwrites the contents of
#' the policy with the new values.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_resource_policy_statement
lexmodelsv2_create_resource_policy_statement <- function(resourceArn, statementId, effect, principal, action, condition = NULL, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "CreateResourcePolicyStatement",
    http_method = "POST",
    http_path = "/policy/{resourceArn}/statements/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_resource_policy_statement_input(resourceArn = resourceArn, statementId = statementId, effect = effect, principal = principal, action = action, condition = condition, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$create_resource_policy_statement_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_resource_policy_statement <- lexmodelsv2_create_resource_policy_statement

#' Creates a slot in an intent
#'
#' @description
#' Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_slot.html](https://paws-r.github.io/docs/lexmodelsv2/create_slot.html) for full documentation.
#'
#' @param slotName &#91;required&#93; The name of the slot. Slot names must be unique within the bot that
#' contains the slot.
#' @param description A description of the slot. Use this to help identify the slot in lists.
#' @param slotTypeId The unique identifier for the slot type associated with this slot. The
#' slot type determines the values that can be entered into the slot.
#' @param valueElicitationSetting &#91;required&#93; Specifies prompts that Amazon Lex sends to the user to elicit a response
#' that provides the value for the slot.
#' @param obfuscationSetting Determines how slot values are used in Amazon CloudWatch logs. If the
#' value of the `obfuscationSetting` parameter is `DefaultObfuscation`,
#' slot values are obfuscated in the log output. If the value is `None`,
#' the actual value is present in the log output.
#' 
#' The default is to obfuscate values in the CloudWatch logs.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot will be used in.
#' The string must match one of the supported locales. All of the bots,
#' intents, slot types used by the slot must have the same locale. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent that contains the slot.
#' @param multipleValuesSetting Indicates whether the slot returns multiple values in one response.
#' Multi-value slots are only available in the en-US locale. If you set
#' this value to `true` in any other locale, Amazon Lex throws a
#' `ValidationException`.
#' 
#' If the `multipleValuesSetting` is not set, the default value is `false`.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_slot
lexmodelsv2_create_slot <- function(slotName, description = NULL, slotTypeId = NULL, valueElicitationSetting, obfuscationSetting = NULL, botId, botVersion, localeId, intentId, multipleValuesSetting = NULL) {
  op <- new_operation(
    name = "CreateSlot",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_slot_input(slotName = slotName, description = description, slotTypeId = slotTypeId, valueElicitationSetting = valueElicitationSetting, obfuscationSetting = obfuscationSetting, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId, multipleValuesSetting = multipleValuesSetting)
  output <- .lexmodelsv2$create_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_slot <- lexmodelsv2_create_slot

#' Creates a custom slot type
#'
#' @description
#' Creates a custom slot type
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_slot_type.html](https://paws-r.github.io/docs/lexmodelsv2/create_slot_type.html) for full documentation.
#'
#' @param slotTypeName &#91;required&#93; The name for the slot. A slot type name must be unique within the
#' account.
#' @param description A description of the slot type. Use the description to help identify the
#' slot type in lists.
#' @param slotTypeValues A list of `SlotTypeValue` objects that defines the values that the slot
#' type can take. Each value can have a list of synonyms, additional values
#' that help train the machine learning model about the values that it
#' resolves for a slot.
#' @param valueSelectionSetting Determines the strategy that Amazon Lex uses to select a value from the
#' list of possible values. The field can be set to one of the following
#' values:
#' 
#' -   `OriginalValue` - Returns the value entered by the user, if the user
#'     value is similar to the slot value.
#' 
#' -   `TopResolution` - If there is a resolution list for the slot, return
#'     the first value in the resolution list. If there is no resolution
#'     list, return null.
#' 
#' If you don't specify the `valueSelectionSetting` parameter, the default
#' is `OriginalValue`.
#' @param parentSlotTypeSignature The built-in slot type used as a parent of this slot type. When you
#' define a parent slot type, the new slot type has the configuration of
#' the parent slot type.
#' 
#' Only `AMAZON.AlphaNumeric` is supported.
#' @param botId &#91;required&#93; The identifier of the bot associated with this slot type.
#' @param botVersion &#91;required&#93; The identifier of the bot version associated with this slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot type will be
#' used in. The string must match one of the supported locales. All of the
#' bots, intents, and slots used by the slot type must have the same
#' locale. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param externalSourceSetting Sets the type of external information used to create the slot type.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_slot_type
lexmodelsv2_create_slot_type <- function(slotTypeName, description = NULL, slotTypeValues = NULL, valueSelectionSetting = NULL, parentSlotTypeSignature = NULL, botId, botVersion, localeId, externalSourceSetting = NULL) {
  op <- new_operation(
    name = "CreateSlotType",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_slot_type_input(slotTypeName = slotTypeName, description = description, slotTypeValues = slotTypeValues, valueSelectionSetting = valueSelectionSetting, parentSlotTypeSignature = parentSlotTypeSignature, botId = botId, botVersion = botVersion, localeId = localeId, externalSourceSetting = externalSourceSetting)
  output <- .lexmodelsv2$create_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_slot_type <- lexmodelsv2_create_slot_type

#' Gets a pre-signed S3 write URL that you use to upload the zip archive
#' when importing a bot or a bot locale
#'
#' @description
#' Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/create_upload_url.html](https://paws-r.github.io/docs/lexmodelsv2/create_upload_url.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_upload_url
lexmodelsv2_create_upload_url <- function() {
  op <- new_operation(
    name = "CreateUploadUrl",
    http_method = "POST",
    http_path = "/createuploadurl/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_upload_url_input()
  output <- .lexmodelsv2$create_upload_url_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_upload_url <- lexmodelsv2_create_upload_url

#' Deletes all versions of a bot, including the Draft version
#'
#' @description
#' Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the [`delete_bot_version`][lexmodelsv2_delete_bot_version] operation.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_bot.html](https://paws-r.github.io/docs/lexmodelsv2/delete_bot.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to delete.
#' @param skipResourceInUseCheck When `true`, Amazon Lex doesn't check to see if another resource, such
#' as an alias, is using the bot before it is deleted.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot
lexmodelsv2_delete_bot <- function(botId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteBot",
    http_method = "DELETE",
    http_path = "/bots/{botId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_input(botId = botId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot <- lexmodelsv2_delete_bot

#' Deletes the specified bot alias
#'
#' @description
#' Deletes the specified bot alias.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_bot_alias.html](https://paws-r.github.io/docs/lexmodelsv2/delete_bot_alias.html) for full documentation.
#'
#' @param botAliasId &#91;required&#93; The unique identifier of the bot alias to delete.
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the alias to delete.
#' @param skipResourceInUseCheck When this parameter is true, Amazon Lex doesn't check to see if any
#' other resource is using the alias before it is deleted.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot_alias
lexmodelsv2_delete_bot_alias <- function(botAliasId, botId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteBotAlias",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botaliases/{botAliasId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_alias_input(botAliasId = botAliasId, botId = botId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot_alias <- lexmodelsv2_delete_bot_alias

#' Removes a locale from a bot
#'
#' @description
#' Removes a locale from a bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_bot_locale.html](https://paws-r.github.io/docs/lexmodelsv2/delete_bot_locale.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the locale.
#' @param botVersion &#91;required&#93; The version of the bot that contains the locale.
#' @param localeId &#91;required&#93; The identifier of the language and locale that will be deleted. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot_locale
lexmodelsv2_delete_bot_locale <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DeleteBotLocale",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$delete_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot_locale <- lexmodelsv2_delete_bot_locale

#' Deletes a specific version of a bot
#'
#' @description
#' Deletes a specific version of a bot. To delete all version of a bot, use the [`delete_bot`][lexmodelsv2_delete_bot] operation.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_bot_version.html](https://paws-r.github.io/docs/lexmodelsv2/delete_bot_version.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that contains the version.
#' @param botVersion &#91;required&#93; The version of the bot to delete.
#' @param skipResourceInUseCheck By default, the [`delete_bot_version`][lexmodelsv2_delete_bot_version]
#' operations throws a `ResourceInUseException` exception if you try to
#' delete a bot version that has an alias pointing at it. Set the
#' `skipResourceInUseCheck` parameter to `true` to skip this check and
#' remove the version even if an alias points to it.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot_version
lexmodelsv2_delete_bot_version <- function(botId, botVersion, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteBotVersion",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_version_input(botId = botId, botVersion = botVersion, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_bot_version_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot_version <- lexmodelsv2_delete_bot_version

#' Removes a custom vocabulary from the specified locale in the specified
#' bot
#'
#' @description
#' Removes a custom vocabulary from the specified locale in the specified bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_custom_vocabulary.html](https://paws-r.github.io/docs/lexmodelsv2/delete_custom_vocabulary.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot to remove the custom vocabulary from.
#' @param botVersion &#91;required&#93; The version of the bot to remove the custom vocabulary from.
#' @param localeId &#91;required&#93; The locale identifier for the locale that contains the custom vocabulary
#' to remove.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_custom_vocabulary
lexmodelsv2_delete_custom_vocabulary <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DeleteCustomVocabulary",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_custom_vocabulary_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$delete_custom_vocabulary_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_custom_vocabulary <- lexmodelsv2_delete_custom_vocabulary

#' Removes a previous export and the associated files stored in an S3
#' bucket
#'
#' @description
#' Removes a previous export and the associated files stored in an S3 bucket.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_export.html](https://paws-r.github.io/docs/lexmodelsv2/delete_export.html) for full documentation.
#'
#' @param exportId &#91;required&#93; The unique identifier of the export to delete.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_export
lexmodelsv2_delete_export <- function(exportId) {
  op <- new_operation(
    name = "DeleteExport",
    http_method = "DELETE",
    http_path = "/exports/{exportId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_export_input(exportId = exportId)
  output <- .lexmodelsv2$delete_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_export <- lexmodelsv2_delete_export

#' Removes a previous import and the associated file stored in an S3 bucket
#'
#' @description
#' Removes a previous import and the associated file stored in an S3 bucket.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_import.html](https://paws-r.github.io/docs/lexmodelsv2/delete_import.html) for full documentation.
#'
#' @param importId &#91;required&#93; The unique identifier of the import to delete.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_import
lexmodelsv2_delete_import <- function(importId) {
  op <- new_operation(
    name = "DeleteImport",
    http_method = "DELETE",
    http_path = "/imports/{importId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_import_input(importId = importId)
  output <- .lexmodelsv2$delete_import_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_import <- lexmodelsv2_delete_import

#' Removes the specified intent
#'
#' @description
#' Removes the specified intent.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_intent.html](https://paws-r.github.io/docs/lexmodelsv2/delete_intent.html) for full documentation.
#'
#' @param intentId &#91;required&#93; The unique identifier of the intent to delete.
#' @param botId &#91;required&#93; The identifier of the bot associated with the intent.
#' @param botVersion &#91;required&#93; The version of the bot associated with the intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale where the bot will be deleted.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_intent
lexmodelsv2_delete_intent <- function(intentId, botId, botVersion, localeId) {
  op <- new_operation(
    name = "DeleteIntent",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_intent_input(intentId = intentId, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$delete_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_intent <- lexmodelsv2_delete_intent

#' Removes an existing policy from a bot or bot alias
#'
#' @description
#' Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_resource_policy.html](https://paws-r.github.io/docs/lexmodelsv2/delete_resource_policy.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that has the
#' resource policy attached.
#' @param expectedRevisionId The identifier of the revision to edit. If this ID doesn't match the
#' current revision number, Amazon Lex returns an exception
#' 
#' If you don't specify a revision ID, Amazon Lex will delete the current
#' policy.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_resource_policy
lexmodelsv2_delete_resource_policy <- function(resourceArn, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "DELETE",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_resource_policy_input(resourceArn = resourceArn, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$delete_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_resource_policy <- lexmodelsv2_delete_resource_policy

#' Deletes a policy statement from a resource policy
#'
#' @description
#' Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_resource_policy_statement.html](https://paws-r.github.io/docs/lexmodelsv2/delete_resource_policy_statement.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param statementId &#91;required&#93; The name of the statement (SID) to delete from the policy.
#' @param expectedRevisionId The identifier of the revision of the policy to delete the statement
#' from. If this revision ID doesn't match the current revision ID, Amazon
#' Lex throws an exception.
#' 
#' If you don't specify a revision, Amazon Lex removes the current contents
#' of the statement.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_resource_policy_statement
lexmodelsv2_delete_resource_policy_statement <- function(resourceArn, statementId, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicyStatement",
    http_method = "DELETE",
    http_path = "/policy/{resourceArn}/statements/{statementId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_resource_policy_statement_input(resourceArn = resourceArn, statementId = statementId, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$delete_resource_policy_statement_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_resource_policy_statement <- lexmodelsv2_delete_resource_policy_statement

#' Deletes the specified slot from an intent
#'
#' @description
#' Deletes the specified slot from an intent.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_slot.html](https://paws-r.github.io/docs/lexmodelsv2/delete_slot.html) for full documentation.
#'
#' @param slotId &#91;required&#93; The identifier of the slot to delete.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot to delete.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot to delete.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot will be deleted
#' from. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent associated with the slot.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_slot
lexmodelsv2_delete_slot <- function(slotId, botId, botVersion, localeId, intentId) {
  op <- new_operation(
    name = "DeleteSlot",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_slot_input(slotId = slotId, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId)
  output <- .lexmodelsv2$delete_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_slot <- lexmodelsv2_delete_slot

#' Deletes a slot type from a bot locale
#'
#' @description
#' Deletes a slot type from a bot locale.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_slot_type.html](https://paws-r.github.io/docs/lexmodelsv2/delete_slot_type.html) for full documentation.
#'
#' @param slotTypeId &#91;required&#93; The identifier of the slot type to delete.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot type.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot type will be
#' deleted from. The string must match one of the supported locales. For
#' more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param skipResourceInUseCheck By default, the [`delete_slot_type`][lexmodelsv2_delete_slot_type]
#' operations throws a `ResourceInUseException` exception if you try to
#' delete a slot type used by a slot. Set the `skipResourceInUseCheck`
#' parameter to `true` to skip this check and remove the slot type even if
#' a slot uses it.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_slot_type
lexmodelsv2_delete_slot_type <- function(slotTypeId, botId, botVersion, localeId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteSlotType",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_slot_type_input(slotTypeId = slotTypeId, botId = botId, botVersion = botVersion, localeId = localeId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_slot_type <- lexmodelsv2_delete_slot_type

#' Deletes stored utterances
#'
#' @description
#' Deletes stored utterances.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/delete_utterances.html](https://paws-r.github.io/docs/lexmodelsv2/delete_utterances.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the utterances.
#' @param localeId The identifier of the language and locale where the utterances were
#' collected. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sessionId The unique identifier of the session with the user. The ID is returned
#' in the response from the
#' [RecognizeText](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeText.html)
#' and
#' [RecognizeUtterance](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeUtterance.html)
#' operations.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_utterances
lexmodelsv2_delete_utterances <- function(botId, localeId = NULL, sessionId = NULL) {
  op <- new_operation(
    name = "DeleteUtterances",
    http_method = "DELETE",
    http_path = "/bots/{botId}/utterances/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_utterances_input(botId = botId, localeId = localeId, sessionId = sessionId)
  output <- .lexmodelsv2$delete_utterances_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_utterances <- lexmodelsv2_delete_utterances

#' Provides metadata information about a bot
#'
#' @description
#' Provides metadata information about a bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_bot.html](https://paws-r.github.io/docs/lexmodelsv2/describe_bot.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot
lexmodelsv2_describe_bot <- function(botId) {
  op <- new_operation(
    name = "DescribeBot",
    http_method = "GET",
    http_path = "/bots/{botId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_input(botId = botId)
  output <- .lexmodelsv2$describe_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot <- lexmodelsv2_describe_bot

#' Get information about a specific bot alias
#'
#' @description
#' Get information about a specific bot alias.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_bot_alias.html](https://paws-r.github.io/docs/lexmodelsv2/describe_bot_alias.html) for full documentation.
#'
#' @param botAliasId &#91;required&#93; The identifier of the bot alias to describe.
#' @param botId &#91;required&#93; The identifier of the bot associated with the bot alias to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_alias
lexmodelsv2_describe_bot_alias <- function(botAliasId, botId) {
  op <- new_operation(
    name = "DescribeBotAlias",
    http_method = "GET",
    http_path = "/bots/{botId}/botaliases/{botAliasId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_alias_input(botAliasId = botAliasId, botId = botId)
  output <- .lexmodelsv2$describe_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_alias <- lexmodelsv2_describe_bot_alias

#' Describes the settings that a bot has for a specific locale
#'
#' @description
#' Describes the settings that a bot has for a specific locale.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_bot_locale.html](https://paws-r.github.io/docs/lexmodelsv2/describe_bot_locale.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot associated with the locale.
#' @param botVersion &#91;required&#93; The identifier of the version of the bot associated with the locale.
#' @param localeId &#91;required&#93; The unique identifier of the locale to describe. The string must match
#' one of the supported locales. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_locale
lexmodelsv2_describe_bot_locale <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeBotLocale",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_locale <- lexmodelsv2_describe_bot_locale

#' Provides metadata information about a bot recommendation
#'
#' @description
#' Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_bot_recommendation.html](https://paws-r.github.io/docs/lexmodelsv2/describe_bot_recommendation.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the bot recommendation.
#' @param botVersion &#91;required&#93; The version of the bot associated with the bot recommendation.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' describe. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param botRecommendationId &#91;required&#93; The identifier of the bot recommendation to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_recommendation
lexmodelsv2_describe_bot_recommendation <- function(botId, botVersion, localeId, botRecommendationId) {
  op <- new_operation(
    name = "DescribeBotRecommendation",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId)
  output <- .lexmodelsv2$describe_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_recommendation <- lexmodelsv2_describe_bot_recommendation

#' Provides metadata about a version of a bot
#'
#' @description
#' Provides metadata about a version of a bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_bot_version.html](https://paws-r.github.io/docs/lexmodelsv2/describe_bot_version.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot containing the version to return metadata for.
#' @param botVersion &#91;required&#93; The version of the bot to return metadata for.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_version
lexmodelsv2_describe_bot_version <- function(botId, botVersion) {
  op <- new_operation(
    name = "DescribeBotVersion",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_version_input(botId = botId, botVersion = botVersion)
  output <- .lexmodelsv2$describe_bot_version_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_version <- lexmodelsv2_describe_bot_version

#' Provides metadata information about a custom vocabulary
#'
#' @description
#' Provides metadata information about a custom vocabulary.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_custom_vocabulary_metadata.html](https://paws-r.github.io/docs/lexmodelsv2/describe_custom_vocabulary_metadata.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the custom vocabulary.
#' @param botVersion &#91;required&#93; The bot version of the bot to return metadata for.
#' @param localeId &#91;required&#93; The locale to return the custom vocabulary information for. The locale
#' must be `en_GB`.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_custom_vocabulary_metadata
lexmodelsv2_describe_custom_vocabulary_metadata <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeCustomVocabularyMetadata",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/metadata",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_custom_vocabulary_metadata_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_custom_vocabulary_metadata_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_custom_vocabulary_metadata <- lexmodelsv2_describe_custom_vocabulary_metadata

#' Gets information about a specific export
#'
#' @description
#' Gets information about a specific export.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_export.html](https://paws-r.github.io/docs/lexmodelsv2/describe_export.html) for full documentation.
#'
#' @param exportId &#91;required&#93; The unique identifier of the export to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_export
lexmodelsv2_describe_export <- function(exportId) {
  op <- new_operation(
    name = "DescribeExport",
    http_method = "GET",
    http_path = "/exports/{exportId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_export_input(exportId = exportId)
  output <- .lexmodelsv2$describe_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_export <- lexmodelsv2_describe_export

#' Gets information about a specific import
#'
#' @description
#' Gets information about a specific import.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_import.html](https://paws-r.github.io/docs/lexmodelsv2/describe_import.html) for full documentation.
#'
#' @param importId &#91;required&#93; The unique identifier of the import to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_import
lexmodelsv2_describe_import <- function(importId) {
  op <- new_operation(
    name = "DescribeImport",
    http_method = "GET",
    http_path = "/imports/{importId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_import_input(importId = importId)
  output <- .lexmodelsv2$describe_import_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_import <- lexmodelsv2_describe_import

#' Returns metadata about an intent
#'
#' @description
#' Returns metadata about an intent.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_intent.html](https://paws-r.github.io/docs/lexmodelsv2/describe_intent.html) for full documentation.
#'
#' @param intentId &#91;required&#93; The identifier of the intent to describe.
#' @param botId &#91;required&#93; The identifier of the bot associated with the intent.
#' @param botVersion &#91;required&#93; The version of the bot associated with the intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the intent to describe. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_intent
lexmodelsv2_describe_intent <- function(intentId, botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeIntent",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_intent_input(intentId = intentId, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_intent <- lexmodelsv2_describe_intent

#' Gets the resource policy and policy revision for a bot or bot alias
#'
#' @description
#' Gets the resource policy and policy revision for a bot or bot alias.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_resource_policy.html](https://paws-r.github.io/docs/lexmodelsv2/describe_resource_policy.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_resource_policy
lexmodelsv2_describe_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "DescribeResourcePolicy",
    http_method = "GET",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_resource_policy_input(resourceArn = resourceArn)
  output <- .lexmodelsv2$describe_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_resource_policy <- lexmodelsv2_describe_resource_policy

#' Gets metadata information about a slot
#'
#' @description
#' Gets metadata information about a slot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_slot.html](https://paws-r.github.io/docs/lexmodelsv2/describe_slot.html) for full documentation.
#'
#' @param slotId &#91;required&#93; The unique identifier for the slot.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot to describe. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent that contains the slot.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_slot
lexmodelsv2_describe_slot <- function(slotId, botId, botVersion, localeId, intentId) {
  op <- new_operation(
    name = "DescribeSlot",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_slot_input(slotId = slotId, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId)
  output <- .lexmodelsv2$describe_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_slot <- lexmodelsv2_describe_slot

#' Gets metadata information about a slot type
#'
#' @description
#' Gets metadata information about a slot type.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/describe_slot_type.html](https://paws-r.github.io/docs/lexmodelsv2/describe_slot_type.html) for full documentation.
#'
#' @param slotTypeId &#91;required&#93; The identifier of the slot type.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot type.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot type to describe.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_slot_type
lexmodelsv2_describe_slot_type <- function(slotTypeId, botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeSlotType",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_slot_type_input(slotTypeId = slotTypeId, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_slot_type <- lexmodelsv2_describe_slot_type

#' Provides a list of utterances that users have sent to the bot
#'
#' @description
#' Provides a list of utterances that users have sent to the bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_aggregated_utterances.html](https://paws-r.github.io/docs/lexmodelsv2/list_aggregated_utterances.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with this request.
#' @param botAliasId The identifier of the bot alias associated with this request. If you
#' specify the bot alias, you can't specify the bot version.
#' @param botVersion The identifier of the bot version associated with this request. If you
#' specify the bot version, you can't specify the bot alias.
#' @param localeId &#91;required&#93; The identifier of the language and locale where the utterances were
#' collected. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param aggregationDuration &#91;required&#93; The time window for aggregating the utterance information. You can
#' specify a time between one hour and two weeks.
#' @param sortBy Specifies sorting parameters for the list of utterances. You can sort by
#' the hit count, the missed count, or the number of distinct sessions the
#' utterance appeared in.
#' @param filters Provides the specification of a filter used to limit the utterances in
#' the response to only those that match the filter specification. You can
#' only specify one filter and one string to filter on.
#' @param maxResults The maximum number of utterances to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned. If you don't specify the `maxResults`
#' parameter, 1,000 results are returned.
#' @param nextToken If the response from the
#' [`list_aggregated_utterances`][lexmodelsv2_list_aggregated_utterances]
#' operation contains more results that specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_aggregated_utterances
lexmodelsv2_list_aggregated_utterances <- function(botId, botAliasId = NULL, botVersion = NULL, localeId, aggregationDuration, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAggregatedUtterances",
    http_method = "POST",
    http_path = "/bots/{botId}/aggregatedutterances/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_aggregated_utterances_input(botId = botId, botAliasId = botAliasId, botVersion = botVersion, localeId = localeId, aggregationDuration = aggregationDuration, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_aggregated_utterances_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_aggregated_utterances <- lexmodelsv2_list_aggregated_utterances

#' Gets a list of aliases for the specified bot
#'
#' @description
#' Gets a list of aliases for the specified bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_bot_aliases.html](https://paws-r.github.io/docs/lexmodelsv2/list_bot_aliases.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to list aliases for.
#' @param maxResults The maximum number of aliases to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the
#' [`list_bot_aliases`][lexmodelsv2_list_bot_aliases] operation contains
#' more results than specified in the `maxResults` parameter, a token is
#' returned in the response. Use that token in the `nextToken` parameter to
#' return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_aliases
lexmodelsv2_list_bot_aliases <- function(botId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotAliases",
    http_method = "POST",
    http_path = "/bots/{botId}/botaliases/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_bot_aliases_input(botId = botId, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_aliases_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_aliases <- lexmodelsv2_list_bot_aliases

#' Gets a list of locales for the specified bot
#'
#' @description
#' Gets a list of locales for the specified bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_bot_locales.html](https://paws-r.github.io/docs/lexmodelsv2/list_bot_locales.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to list locales for.
#' @param botVersion &#91;required&#93; The version of the bot to list locales for.
#' @param sortBy Specifies sorting parameters for the list of locales. You can sort by
#' locale name in ascending or descending order.
#' @param filters Provides the specification for a filter used to limit the response to
#' only those locales that match the filter specification. You can only
#' specify one filter and one value to filter on.
#' @param maxResults The maximum number of aliases to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the
#' [`list_bot_locales`][lexmodelsv2_list_bot_locales] operation contains
#' more results than specified in the `maxResults` parameter, a token is
#' returned in the response. Use that token as the `nextToken` parameter to
#' return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_locales
lexmodelsv2_list_bot_locales <- function(botId, botVersion, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotLocales",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_bot_locales_input(botId = botId, botVersion = botVersion, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_locales_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_locales <- lexmodelsv2_list_bot_locales

#' Get a list of bot recommendations that meet the specified criteria
#'
#' @description
#' Get a list of bot recommendations that meet the specified criteria.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_bot_recommendations.html](https://paws-r.github.io/docs/lexmodelsv2/list_bot_recommendations.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the bot recommendation
#' list.
#' @param botVersion &#91;required&#93; The version of the bot that contains the bot recommendation list.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation
#' list.
#' @param maxResults The maximum number of bot recommendations to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextToken If the response from the ListBotRecommendation operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response. Use that token in the nextToken parameter to return the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_recommendations
lexmodelsv2_list_bot_recommendations <- function(botId, botVersion, localeId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotRecommendations",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_bot_recommendations_input(botId = botId, botVersion = botVersion, localeId = localeId, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_recommendations_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_recommendations <- lexmodelsv2_list_bot_recommendations

#' Gets information about all of the versions of a bot
#'
#' @description
#' Gets information about all of the versions of a bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_bot_versions.html](https://paws-r.github.io/docs/lexmodelsv2/list_bot_versions.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to list versions for.
#' @param sortBy Specifies sorting parameters for the list of versions. You can specify
#' that the list be sorted by version name in either ascending or
#' descending order.
#' @param maxResults The maximum number of versions to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response to the `ListBotVersion` operation contains more results
#' than specified in the `maxResults` parameter, a token is returned in the
#' response. Use that token in the `nextToken` parameter to return the next
#' page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_versions
lexmodelsv2_list_bot_versions <- function(botId, sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotVersions",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_bot_versions_input(botId = botId, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_versions_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_versions <- lexmodelsv2_list_bot_versions

#' Gets a list of available bots
#'
#' @description
#' Gets a list of available bots.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_bots.html](https://paws-r.github.io/docs/lexmodelsv2/list_bots.html) for full documentation.
#'
#' @param sortBy Specifies sorting parameters for the list of bots. You can specify that
#' the list be sorted by bot name in ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the bots in the
#' response to only those that match the filter specification. You can only
#' specify one filter and one string to filter on.
#' @param maxResults The maximum number of bots to return in each page of results. If there
#' are fewer results than the maximum page size, only the actual number of
#' results are returned.
#' @param nextToken If the response from the [`list_bots`][lexmodelsv2_list_bots] operation
#' contains more results than specified in the `maxResults` parameter, a
#' token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_bots`][lexmodelsv2_list_bots] request to return the next page of
#' results. For a complete set of results, call the
#' [`list_bots`][lexmodelsv2_list_bots] operation until the `nextToken`
#' returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bots
lexmodelsv2_list_bots <- function(sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBots",
    http_method = "POST",
    http_path = "/bots/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_bots_input(sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bots_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bots <- lexmodelsv2_list_bots

#' Gets a list of built-in intents provided by Amazon Lex that you can use
#' in your bot
#'
#' @description
#' Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_built_in_intents.html](https://paws-r.github.io/docs/lexmodelsv2/list_built_in_intents.html) for full documentation.
#'
#' @param localeId &#91;required&#93; The identifier of the language and locale of the intents to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Specifies sorting parameters for the list of built-in intents. You can
#' specify that the list be sorted by the built-in intent signature in
#' either ascending or descending order.
#' @param maxResults The maximum number of built-in intents to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextToken If the response from the
#' [`list_built_in_intents`][lexmodelsv2_list_built_in_intents] operation
#' contains more results than specified in the `maxResults` parameter, a
#' token is returned in the response. Use that token in the `nextToken`
#' parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_built_in_intents
lexmodelsv2_list_built_in_intents <- function(localeId, sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuiltInIntents",
    http_method = "POST",
    http_path = "/builtins/locales/{localeId}/intents/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_built_in_intents_input(localeId = localeId, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_built_in_intents_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_built_in_intents <- lexmodelsv2_list_built_in_intents

#' Gets a list of built-in slot types that meet the specified criteria
#'
#' @description
#' Gets a list of built-in slot types that meet the specified criteria.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_built_in_slot_types.html](https://paws-r.github.io/docs/lexmodelsv2/list_built_in_slot_types.html) for full documentation.
#'
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot types to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Determines the sort order for the response from the
#' [`list_built_in_slot_types`][lexmodelsv2_list_built_in_slot_types]
#' operation. You can choose to sort by the slot type signature in either
#' ascending or descending order.
#' @param maxResults The maximum number of built-in slot types to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextToken If the response from the
#' [`list_built_in_slot_types`][lexmodelsv2_list_built_in_slot_types]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_built_in_slot_types
lexmodelsv2_list_built_in_slot_types <- function(localeId, sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuiltInSlotTypes",
    http_method = "POST",
    http_path = "/builtins/locales/{localeId}/slottypes/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_built_in_slot_types_input(localeId = localeId, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_built_in_slot_types_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_built_in_slot_types <- lexmodelsv2_list_built_in_slot_types

#' Lists the exports for a bot, bot locale, or custom vocabulary
#'
#' @description
#' Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_exports.html](https://paws-r.github.io/docs/lexmodelsv2/list_exports.html) for full documentation.
#'
#' @param botId The unique identifier that Amazon Lex assigned to the bot.
#' @param botVersion The version of the bot to list exports for.
#' @param sortBy Determines the field that the list of exports is sorted by. You can sort
#' by the `LastUpdatedDateTime` field in ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the exports in the
#' response to only those that match the filter specification. You can only
#' specify one filter and one string to filter on.
#' @param maxResults The maximum number of exports to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the [`list_exports`][lexmodelsv2_list_exports]
#' operation contains more results that specified in the `maxResults`
#' parameter, a token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_exports`][lexmodelsv2_list_exports] request to return the next
#' page of results. For a complete set of results, call the
#' [`list_exports`][lexmodelsv2_list_exports] operation until the
#' `nextToken` returned in the response is null.
#' @param localeId Specifies the resources that should be exported. If you don't specify a
#' resource type in the `filters` parameter, both bot locales and custom
#' vocabularies are exported.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_exports
lexmodelsv2_list_exports <- function(botId = NULL, botVersion = NULL, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL, localeId = NULL) {
  op <- new_operation(
    name = "ListExports",
    http_method = "POST",
    http_path = "/exports/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_exports_input(botId = botId, botVersion = botVersion, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken, localeId = localeId)
  output <- .lexmodelsv2$list_exports_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_exports <- lexmodelsv2_list_exports

#' Lists the imports for a bot, bot locale, or custom vocabulary
#'
#' @description
#' Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_imports.html](https://paws-r.github.io/docs/lexmodelsv2/list_imports.html) for full documentation.
#'
#' @param botId The unique identifier that Amazon Lex assigned to the bot.
#' @param botVersion The version of the bot to list imports for.
#' @param sortBy Determines the field that the list of imports is sorted by. You can sort
#' by the `LastUpdatedDateTime` field in ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the bots in the
#' response to only those that match the filter specification. You can only
#' specify one filter and one string to filter on.
#' @param maxResults The maximum number of imports to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the [`list_imports`][lexmodelsv2_list_imports]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_imports`][lexmodelsv2_list_imports] request to return the next
#' page of results. For a complete set of results, call the
#' [`list_imports`][lexmodelsv2_list_imports] operation until the
#' `nextToken` returned in the response is null.
#' @param localeId Specifies the locale that should be present in the list. If you don't
#' specify a resource type in the `filters` parameter, the list contains
#' both bot locales and custom vocabularies.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_imports
lexmodelsv2_list_imports <- function(botId = NULL, botVersion = NULL, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL, localeId = NULL) {
  op <- new_operation(
    name = "ListImports",
    http_method = "POST",
    http_path = "/imports/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_imports_input(botId = botId, botVersion = botVersion, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken, localeId = localeId)
  output <- .lexmodelsv2$list_imports_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_imports <- lexmodelsv2_list_imports

#' Get a list of intents that meet the specified criteria
#'
#' @description
#' Get a list of intents that meet the specified criteria.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_intents.html](https://paws-r.github.io/docs/lexmodelsv2/list_intents.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the intent.
#' @param botVersion &#91;required&#93; The version of the bot that contains the intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the intents to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Determines the sort order for the response from the
#' [`list_intents`][lexmodelsv2_list_intents] operation. You can choose to
#' sort by the intent name or last updated date in either ascending or
#' descending order.
#' @param filters Provides the specification of a filter used to limit the intents in the
#' response to only those that match the filter specification. You can only
#' specify one filter and only one string to filter on.
#' @param maxResults The maximum number of intents to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the [`list_intents`][lexmodelsv2_list_intents]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_intents`][lexmodelsv2_list_intents] request to return the next
#' page of results. For a complete set of results, call the
#' [`list_intents`][lexmodelsv2_list_intents] operation until the
#' `nextToken` returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_intents
lexmodelsv2_list_intents <- function(botId, botVersion, localeId, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIntents",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_intents_input(botId = botId, botVersion = botVersion, localeId = localeId, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_intents_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_intents <- lexmodelsv2_list_intents

#' Gets a list of recommended intents provided by the bot recommendation
#' that you can use in your bot
#'
#' @description
#' Gets a list of recommended intents provided by the bot recommendation that you can use in your bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_recommended_intents.html](https://paws-r.github.io/docs/lexmodelsv2/list_recommended_intents.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the recommended
#' intents.
#' @param botVersion &#91;required&#93; The version of the bot that contains the recommended intents.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the recommended intents.
#' @param botRecommendationId &#91;required&#93; The identifier of the bot recommendation that contains the recommended
#' intents.
#' @param nextToken If the response from the ListRecommendedIntents operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response. Use that token in the nextToken parameter to return the
#' next page of results.
#' @param maxResults The maximum number of bot recommendations to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_recommended_intents
lexmodelsv2_list_recommended_intents <- function(botId, botVersion, localeId, botRecommendationId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRecommendedIntents",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/intents",
    paginator = list()
  )
  input <- .lexmodelsv2$list_recommended_intents_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelsv2$list_recommended_intents_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_recommended_intents <- lexmodelsv2_list_recommended_intents

#' Gets a list of slot types that match the specified criteria
#'
#' @description
#' Gets a list of slot types that match the specified criteria.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_slot_types.html](https://paws-r.github.io/docs/lexmodelsv2/list_slot_types.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the slot types.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot types to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Determines the sort order for the response from the
#' [`list_slot_types`][lexmodelsv2_list_slot_types] operation. You can
#' choose to sort by the slot type name or last updated date in either
#' ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the slot types in
#' the response to only those that match the filter specification. You can
#' only specify one filter and only one string to filter on.
#' @param maxResults The maximum number of slot types to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the
#' [`list_slot_types`][lexmodelsv2_list_slot_types] operation contains more
#' results than specified in the `maxResults` parameter, a token is
#' returned in the response. Use that token in the `nextToken` parameter to
#' return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_slot_types
lexmodelsv2_list_slot_types <- function(botId, botVersion, localeId, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSlotTypes",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_slot_types_input(botId = botId, botVersion = botVersion, localeId = localeId, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_slot_types_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_slot_types <- lexmodelsv2_list_slot_types

#' Gets a list of slots that match the specified criteria
#'
#' @description
#' Gets a list of slots that match the specified criteria.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_slots.html](https://paws-r.github.io/docs/lexmodelsv2/list_slots.html) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that contains the slot.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slots to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The unique identifier of the intent that contains the slot.
#' @param sortBy Determines the sort order for the response from the
#' [`list_slots`][lexmodelsv2_list_slots] operation. You can choose to sort
#' by the slot name or last updated date in either ascending or descending
#' order.
#' @param filters Provides the specification of a filter used to limit the slots in the
#' response to only those that match the filter specification. You can only
#' specify one filter and only one string to filter on.
#' @param maxResults The maximum number of slots to return in each page of results. If there
#' are fewer results than the max page size, only the actual number of
#' results are returned.
#' @param nextToken If the response from the [`list_slots`][lexmodelsv2_list_slots]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_slots
lexmodelsv2_list_slots <- function(botId, botVersion, localeId, intentId, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSlots",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
    paginator = list()
  )
  input <- .lexmodelsv2$list_slots_input(botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_slots_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_slots <- lexmodelsv2_list_slots

#' Gets a list of tags associated with a resource
#'
#' @description
#' Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/list_tags_for_resource.html](https://paws-r.github.io/docs/lexmodelsv2/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get a list of tags
#' for.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_tags_for_resource
lexmodelsv2_list_tags_for_resource <- function(resourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceARN}",
    paginator = list()
  )
  input <- .lexmodelsv2$list_tags_for_resource_input(resourceARN = resourceARN)
  output <- .lexmodelsv2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_tags_for_resource <- lexmodelsv2_list_tags_for_resource

#' Search for associated transcripts that meet the specified criteria
#'
#' @description
#' Search for associated transcripts that meet the specified criteria.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/search_associated_transcripts.html](https://paws-r.github.io/docs/lexmodelsv2/search_associated_transcripts.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the transcripts that
#' you are searching.
#' @param botVersion &#91;required&#93; The version of the bot containing the transcripts that you are
#' searching.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the transcripts to search.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param botRecommendationId &#91;required&#93; The unique identifier of the bot recommendation associated with the
#' transcripts to search.
#' @param searchOrder How SearchResults are ordered. Valid values are Ascending or Descending.
#' The default is Descending.
#' @param filters &#91;required&#93; A list of filter objects.
#' @param maxResults The maximum number of bot recommendations to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextIndex If the response from the SearchAssociatedTranscriptsRequest operation
#' contains more results than specified in the maxResults parameter, an
#' index is returned in the response. Use that index in the nextIndex
#' parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_search_associated_transcripts
lexmodelsv2_search_associated_transcripts <- function(botId, botVersion, localeId, botRecommendationId, searchOrder = NULL, filters, maxResults = NULL, nextIndex = NULL) {
  op <- new_operation(
    name = "SearchAssociatedTranscripts",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/associatedtranscripts",
    paginator = list()
  )
  input <- .lexmodelsv2$search_associated_transcripts_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId, searchOrder = searchOrder, filters = filters, maxResults = maxResults, nextIndex = nextIndex)
  output <- .lexmodelsv2$search_associated_transcripts_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$search_associated_transcripts <- lexmodelsv2_search_associated_transcripts

#' Use this to provide your transcript data, and to start the bot
#' recommendation process
#'
#' @description
#' Use this to provide your transcript data, and to start the bot recommendation process.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/start_bot_recommendation.html](https://paws-r.github.io/docs/lexmodelsv2/start_bot_recommendation.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot containing the bot recommendation.
#' @param botVersion &#91;required&#93; The version of the bot containing the bot recommendation.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' start. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param transcriptSourceSetting &#91;required&#93; The object representing the Amazon S3 bucket containing the transcript,
#' as well as the associated metadata.
#' @param encryptionSetting The object representing the passwords that will be used to encrypt the
#' data related to the bot recommendation results, as well as the KMS key
#' ARN used to encrypt the associated metadata.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_start_bot_recommendation
lexmodelsv2_start_bot_recommendation <- function(botId, botVersion, localeId, transcriptSourceSetting, encryptionSetting = NULL) {
  op <- new_operation(
    name = "StartBotRecommendation",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
    paginator = list()
  )
  input <- .lexmodelsv2$start_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, transcriptSourceSetting = transcriptSourceSetting, encryptionSetting = encryptionSetting)
  output <- .lexmodelsv2$start_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$start_bot_recommendation <- lexmodelsv2_start_bot_recommendation

#' Starts importing a bot, bot locale, or custom vocabulary from a zip
#' archive that you uploaded to an S3 bucket
#'
#' @description
#' Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/start_import.html](https://paws-r.github.io/docs/lexmodelsv2/start_import.html) for full documentation.
#'
#' @param importId &#91;required&#93; The unique identifier for the import. It is included in the response
#' from the [`create_upload_url`][lexmodelsv2_create_upload_url] operation.
#' @param resourceSpecification &#91;required&#93; Parameters for creating the bot, bot locale or custom vocabulary.
#' @param mergeStrategy &#91;required&#93; The strategy to use when there is a name conflict between the imported
#' resource and an existing resource. When the merge strategy is
#' `FailOnConflict` existing resources are not overwritten and the import
#' fails.
#' @param filePassword The password used to encrypt the zip archive that contains the resource
#' definition. You should always encrypt the zip archive to protect it
#' during transit between your site and Amazon Lex.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_start_import
lexmodelsv2_start_import <- function(importId, resourceSpecification, mergeStrategy, filePassword = NULL) {
  op <- new_operation(
    name = "StartImport",
    http_method = "PUT",
    http_path = "/imports/",
    paginator = list()
  )
  input <- .lexmodelsv2$start_import_input(importId = importId, resourceSpecification = resourceSpecification, mergeStrategy = mergeStrategy, filePassword = filePassword)
  output <- .lexmodelsv2$start_import_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$start_import <- lexmodelsv2_start_import

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/tag_resource.html](https://paws-r.github.io/docs/lexmodelsv2/tag_resource.html) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to
#' tag.
#' @param tags &#91;required&#93; A list of tag keys to add to the resource. If a tag key already exists,
#' the existing value is replaced with the new value.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_tag_resource
lexmodelsv2_tag_resource <- function(resourceARN, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceARN}",
    paginator = list()
  )
  input <- .lexmodelsv2$tag_resource_input(resourceARN = resourceARN, tags = tags)
  output <- .lexmodelsv2$tag_resource_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$tag_resource <- lexmodelsv2_tag_resource

#' Removes tags from a bot, bot alias, or bot channel
#'
#' @description
#' Removes tags from a bot, bot alias, or bot channel.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/untag_resource.html](https://paws-r.github.io/docs/lexmodelsv2/untag_resource.html) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove the tags from.
#' @param tagKeys &#91;required&#93; A list of tag keys to remove from the resource. If a tag key does not
#' exist on the resource, it is ignored.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_untag_resource
lexmodelsv2_untag_resource <- function(resourceARN, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceARN}",
    paginator = list()
  )
  input <- .lexmodelsv2$untag_resource_input(resourceARN = resourceARN, tagKeys = tagKeys)
  output <- .lexmodelsv2$untag_resource_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$untag_resource <- lexmodelsv2_untag_resource

#' Updates the configuration of an existing bot
#'
#' @description
#' Updates the configuration of an existing bot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_bot.html](https://paws-r.github.io/docs/lexmodelsv2/update_bot.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot to update. This identifier is returned
#' by the [`create_bot`][lexmodelsv2_create_bot] operation.
#' @param botName &#91;required&#93; The new name of the bot. The name must be unique in the account that
#' creates the bot.
#' @param description A description of the bot.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the bot.
#' @param dataPrivacy &#91;required&#93; Provides information on additional privacy protections Amazon Lex should
#' use with the bot's data.
#' @param idleSessionTTLInSeconds &#91;required&#93; The time, in seconds, that Amazon Lex should keep information about a
#' user's conversation with the bot.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and Amazon
#' Lex deletes any data provided before the timeout.
#' 
#' You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot
lexmodelsv2_update_bot <- function(botId, botName, description = NULL, roleArn, dataPrivacy, idleSessionTTLInSeconds) {
  op <- new_operation(
    name = "UpdateBot",
    http_method = "PUT",
    http_path = "/bots/{botId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_input(botId = botId, botName = botName, description = description, roleArn = roleArn, dataPrivacy = dataPrivacy, idleSessionTTLInSeconds = idleSessionTTLInSeconds)
  output <- .lexmodelsv2$update_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot <- lexmodelsv2_update_bot

#' Updates the configuration of an existing bot alias
#'
#' @description
#' Updates the configuration of an existing bot alias.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_bot_alias.html](https://paws-r.github.io/docs/lexmodelsv2/update_bot_alias.html) for full documentation.
#'
#' @param botAliasId &#91;required&#93; The unique identifier of the bot alias.
#' @param botAliasName &#91;required&#93; The new name to assign to the bot alias.
#' @param description The new description to assign to the bot alias.
#' @param botVersion The new bot version to assign to the bot alias.
#' @param botAliasLocaleSettings The new Lambda functions to use in each locale for the bot alias.
#' @param conversationLogSettings The new settings for storing conversation logs in Amazon CloudWatch Logs
#' and Amazon S3 buckets.
#' @param sentimentAnalysisSettings 
#' @param botId &#91;required&#93; The identifier of the bot with the updated alias.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot_alias
lexmodelsv2_update_bot_alias <- function(botAliasId, botAliasName, description = NULL, botVersion = NULL, botAliasLocaleSettings = NULL, conversationLogSettings = NULL, sentimentAnalysisSettings = NULL, botId) {
  op <- new_operation(
    name = "UpdateBotAlias",
    http_method = "PUT",
    http_path = "/bots/{botId}/botaliases/{botAliasId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_alias_input(botAliasId = botAliasId, botAliasName = botAliasName, description = description, botVersion = botVersion, botAliasLocaleSettings = botAliasLocaleSettings, conversationLogSettings = conversationLogSettings, sentimentAnalysisSettings = sentimentAnalysisSettings, botId = botId)
  output <- .lexmodelsv2$update_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot_alias <- lexmodelsv2_update_bot_alias

#' Updates the settings that a bot has for a specific locale
#'
#' @description
#' Updates the settings that a bot has for a specific locale.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_bot_locale.html](https://paws-r.github.io/docs/lexmodelsv2/update_bot_locale.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the locale.
#' @param botVersion &#91;required&#93; The version of the bot that contains the locale to be updated. The
#' version can only be the `DRAFT` version.
#' @param localeId &#91;required&#93; The identifier of the language and locale to update. The string must
#' match one of the supported locales. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param description The new description of the locale.
#' @param nluIntentConfidenceThreshold &#91;required&#93; The new confidence threshold where Amazon Lex inserts the
#' `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` intents in the
#' list of possible intents for an utterance.
#' @param voiceSettings The new Amazon Polly voice Amazon Lex should use for voice interaction
#' with the user.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot_locale
lexmodelsv2_update_bot_locale <- function(botId, botVersion, localeId, description = NULL, nluIntentConfidenceThreshold, voiceSettings = NULL) {
  op <- new_operation(
    name = "UpdateBotLocale",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId, description = description, nluIntentConfidenceThreshold = nluIntentConfidenceThreshold, voiceSettings = voiceSettings)
  output <- .lexmodelsv2$update_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot_locale <- lexmodelsv2_update_bot_locale

#' Updates an existing bot recommendation request
#'
#' @description
#' Updates an existing bot recommendation request.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_bot_recommendation.html](https://paws-r.github.io/docs/lexmodelsv2/update_bot_recommendation.html) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot containing the bot recommendation to be
#' updated.
#' @param botVersion &#91;required&#93; The version of the bot containing the bot recommendation to be updated.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' update. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param botRecommendationId &#91;required&#93; The unique identifier of the bot recommendation to be updated.
#' @param encryptionSetting &#91;required&#93; The object representing the passwords that will be used to encrypt the
#' data related to the bot recommendation results, as well as the KMS key
#' ARN used to encrypt the associated metadata.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot_recommendation
lexmodelsv2_update_bot_recommendation <- function(botId, botVersion, localeId, botRecommendationId, encryptionSetting) {
  op <- new_operation(
    name = "UpdateBotRecommendation",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId, encryptionSetting = encryptionSetting)
  output <- .lexmodelsv2$update_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot_recommendation <- lexmodelsv2_update_bot_recommendation

#' Updates the password used to protect an export zip archive
#'
#' @description
#' Updates the password used to protect an export zip archive.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_export.html](https://paws-r.github.io/docs/lexmodelsv2/update_export.html) for full documentation.
#'
#' @param exportId &#91;required&#93; The unique identifier Amazon Lex assigned to the export.
#' @param filePassword The new password to use to encrypt the export zip archive.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_export
lexmodelsv2_update_export <- function(exportId, filePassword = NULL) {
  op <- new_operation(
    name = "UpdateExport",
    http_method = "PUT",
    http_path = "/exports/{exportId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_export_input(exportId = exportId, filePassword = filePassword)
  output <- .lexmodelsv2$update_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_export <- lexmodelsv2_update_export

#' Updates the settings for an intent
#'
#' @description
#' Updates the settings for an intent.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_intent.html](https://paws-r.github.io/docs/lexmodelsv2/update_intent.html) for full documentation.
#'
#' @param intentId &#91;required&#93; The unique identifier of the intent to update.
#' @param intentName &#91;required&#93; The new name for the intent.
#' @param description The new description of the intent.
#' @param parentIntentSignature The signature of the new built-in intent to use as the parent of this
#' intent.
#' @param sampleUtterances New utterances used to invoke the intent.
#' @param dialogCodeHook The new Lambda function to use between each turn of the conversation
#' with the bot.
#' @param fulfillmentCodeHook The new Lambda function to call when all of the intents required slots
#' are provided and the intent is ready for fulfillment.
#' @param slotPriorities A new list of slots and their priorities that are contained by the
#' intent.
#' @param intentConfirmationSetting New prompts that Amazon Lex sends to the user to confirm the completion
#' of an intent.
#' @param intentClosingSetting The new response that Amazon Lex sends the user when the intent is
#' closed.
#' @param inputContexts A new list of contexts that must be active in order for Amazon Lex to
#' consider the intent.
#' @param outputContexts A new list of contexts that Amazon Lex activates when the intent is
#' fulfilled.
#' @param kendraConfiguration New configuration settings for connecting to an Amazon Kendra index.
#' @param botId &#91;required&#93; The identifier of the bot that contains the intent.
#' @param botVersion &#91;required&#93; The version of the bot that contains the intent. Must be `DRAFT`.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this intent is used. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_intent
lexmodelsv2_update_intent <- function(intentId, intentName, description = NULL, parentIntentSignature = NULL, sampleUtterances = NULL, dialogCodeHook = NULL, fulfillmentCodeHook = NULL, slotPriorities = NULL, intentConfirmationSetting = NULL, intentClosingSetting = NULL, inputContexts = NULL, outputContexts = NULL, kendraConfiguration = NULL, botId, botVersion, localeId) {
  op <- new_operation(
    name = "UpdateIntent",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_intent_input(intentId = intentId, intentName = intentName, description = description, parentIntentSignature = parentIntentSignature, sampleUtterances = sampleUtterances, dialogCodeHook = dialogCodeHook, fulfillmentCodeHook = fulfillmentCodeHook, slotPriorities = slotPriorities, intentConfirmationSetting = intentConfirmationSetting, intentClosingSetting = intentClosingSetting, inputContexts = inputContexts, outputContexts = outputContexts, kendraConfiguration = kendraConfiguration, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$update_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_intent <- lexmodelsv2_update_intent

#' Replaces the existing resource policy for a bot or bot alias with a new
#' one
#'
#' @description
#' Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_resource_policy.html](https://paws-r.github.io/docs/lexmodelsv2/update_resource_policy.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param policy &#91;required&#93; A resource policy to add to the resource. The policy is a JSON structure
#' that contains one or more statements that define the policy. The policy
#' must follow the IAM syntax. For more information about the contents of a
#' JSON policy document, see [IAM JSON policy
#' reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' .
#' 
#' If the policy isn't valid, Amazon Lex returns a validation exception.
#' @param expectedRevisionId The identifier of the revision of the policy to update. If this revision
#' ID doesn't match the current revision ID, Amazon Lex throws an
#' exception.
#' 
#' If you don't specify a revision, Amazon Lex overwrites the contents of
#' the policy with the new values.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_resource_policy
lexmodelsv2_update_resource_policy <- function(resourceArn, policy, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "UpdateResourcePolicy",
    http_method = "PUT",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_resource_policy_input(resourceArn = resourceArn, policy = policy, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$update_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_resource_policy <- lexmodelsv2_update_resource_policy

#' Updates the settings for a slot
#'
#' @description
#' Updates the settings for a slot.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_slot.html](https://paws-r.github.io/docs/lexmodelsv2/update_slot.html) for full documentation.
#'
#' @param slotId &#91;required&#93; The unique identifier for the slot to update.
#' @param slotName &#91;required&#93; The new name for the slot.
#' @param description The new description for the slot.
#' @param slotTypeId The unique identifier of the new slot type to associate with this slot.
#' @param valueElicitationSetting &#91;required&#93; A new set of prompts that Amazon Lex sends to the user to elicit a
#' response the provides a value for the slot.
#' @param obfuscationSetting New settings that determine how slot values are formatted in Amazon
#' CloudWatch logs.
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the slot.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot. Must always be `DRAFT`.
#' @param localeId &#91;required&#93; The identifier of the language and locale that contains the slot. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent that contains the slot.
#' @param multipleValuesSetting Determines whether the slot accepts multiple values in one response.
#' Multiple value slots are only available in the en-US locale. If you set
#' this value to `true` in any other locale, Amazon Lex throws a
#' `ValidationException`.
#' 
#' If the `multipleValuesSetting` is not set, the default value is `false`.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_slot
lexmodelsv2_update_slot <- function(slotId, slotName, description = NULL, slotTypeId = NULL, valueElicitationSetting, obfuscationSetting = NULL, botId, botVersion, localeId, intentId, multipleValuesSetting = NULL) {
  op <- new_operation(
    name = "UpdateSlot",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_slot_input(slotId = slotId, slotName = slotName, description = description, slotTypeId = slotTypeId, valueElicitationSetting = valueElicitationSetting, obfuscationSetting = obfuscationSetting, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId, multipleValuesSetting = multipleValuesSetting)
  output <- .lexmodelsv2$update_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_slot <- lexmodelsv2_update_slot

#' Updates the configuration of an existing slot type
#'
#' @description
#' Updates the configuration of an existing slot type.
#'
#' See [https://paws-r.github.io/docs/lexmodelsv2/update_slot_type.html](https://paws-r.github.io/docs/lexmodelsv2/update_slot_type.html) for full documentation.
#'
#' @param slotTypeId &#91;required&#93; The unique identifier of the slot type to update.
#' @param slotTypeName &#91;required&#93; The new name of the slot type.
#' @param description The new description of the slot type.
#' @param slotTypeValues A new list of values and their optional synonyms that define the values
#' that the slot type can take.
#' @param valueSelectionSetting The strategy that Amazon Lex should use when deciding on a value from
#' the list of slot type values.
#' @param parentSlotTypeSignature The new built-in slot type that should be used as the parent of this
#' slot type.
#' @param botId &#91;required&#93; The identifier of the bot that contains the slot type.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot type. Must be `DRAFT`.
#' @param localeId &#91;required&#93; The identifier of the language and locale that contains the slot type.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param externalSourceSetting 
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_slot_type
lexmodelsv2_update_slot_type <- function(slotTypeId, slotTypeName, description = NULL, slotTypeValues = NULL, valueSelectionSetting = NULL, parentSlotTypeSignature = NULL, botId, botVersion, localeId, externalSourceSetting = NULL) {
  op <- new_operation(
    name = "UpdateSlotType",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_slot_type_input(slotTypeId = slotTypeId, slotTypeName = slotTypeName, description = description, slotTypeValues = slotTypeValues, valueSelectionSetting = valueSelectionSetting, parentSlotTypeSignature = parentSlotTypeSignature, botId = botId, botVersion = botVersion, localeId = localeId, externalSourceSetting = externalSourceSetting)
  output <- .lexmodelsv2$update_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_slot_type <- lexmodelsv2_update_slot_type
