% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_tags}
\alias{sagemaker_list_tags}
\title{Returns the tags for the specified Amazon SageMaker resource}
\usage{
sagemaker_list_tags(ResourceArn, NextToken, MaxResults)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource whose tags you want to
retrieve.}

\item{NextToken}{If the response to the previous \code{ListTags} request is truncated, Amazon
SageMaker returns this token. To retrieve the next set of tags, use it
in the subsequent request.}

\item{MaxResults}{Maximum number of tags to return.}
}
\description{
Returns the tags for the specified Amazon SageMaker resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags(
  ResourceArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
