% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_training_jobs_for_hyper_parameter_tuning_job}
\alias{sagemaker_list_training_jobs_for_hyper_parameter_tuning_job}
\title{Gets a list of TrainingJobSummary objects that describe the training
jobs that a hyperparameter tuning job launched}
\usage{
sagemaker_list_training_jobs_for_hyper_parameter_tuning_job(
  HyperParameterTuningJobName, NextToken, MaxResults, StatusEquals,
  SortBy, SortOrder)
}
\arguments{
\item{HyperParameterTuningJobName}{[required] The name of the tuning job whose training jobs you want to list.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_training_jobs_for_hyper_parameter_tuning_job]{list_training_jobs_for_hyper_parameter_tuning_job}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of training jobs, use the token in the next request.}

\item{MaxResults}{The maximum number of training jobs to return. The default value is 10.}

\item{StatusEquals}{A filter that returns only training jobs with the specified status.}

\item{SortBy}{The field to sort results by. The default is \code{Name}.

If the value of this field is \code{FinalObjectiveMetricValue}, any training
jobs that did not return an objective metric are not listed.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TrainingJobSummaries = list(
    list(
      TrainingJobDefinitionName = "string",
      TrainingJobName = "string",
      TrainingJobArn = "string",
      TuningJobName = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      TrainingStartTime = as.POSIXct(
        "2015-01-01"
      ),
      TrainingEndTime = as.POSIXct(
        "2015-01-01"
      ),
      TrainingJobStatus = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
      TunedHyperParameters = list(
        "string"
      ),
      FailureReason = "string",
      FinalHyperParameterTuningJobObjectiveMetric = list(
        Type = "Maximize"|"Minimize",
        MetricName = "string",
        Value = 123.0
      ),
      ObjectiveStatus = "Succeeded"|"Pending"|"Failed"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of TrainingJobSummary objects that describe the training
jobs that a hyperparameter tuning job launched.
}
\section{Request syntax}{
\preformatted{svc$list_training_jobs_for_hyper_parameter_tuning_job(
  HyperParameterTuningJobName = "string",
  NextToken = "string",
  MaxResults = 123,
  StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
  SortBy = "Name"|"CreationTime"|"Status"|"FinalObjectiveMetricValue",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
