% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_describe_batch_inference_job}
\alias{personalize_describe_batch_inference_job}
\title{Gets the properties of a batch inference job including name, Amazon
Resource Name (ARN), status, input and output configurations, and the
ARN of the solution version used to generate the recommendations}
\usage{
personalize_describe_batch_inference_job(batchInferenceJobArn)
}
\arguments{
\item{batchInferenceJobArn}{[required] The ARN of the batch inference job to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  batchInferenceJob = list(
    jobName = "string",
    batchInferenceJobArn = "string",
    filterArn = "string",
    failureReason = "string",
    solutionVersionArn = "string",
    numResults = 123,
    jobInput = list(
      s3DataSource = list(
        path = "string",
        kmsKeyArn = "string"
      )
    ),
    jobOutput = list(
      s3DataDestination = list(
        path = "string",
        kmsKeyArn = "string"
      )
    ),
    batchInferenceJobConfig = list(
      itemExplorationConfig = list(
        "string"
      )
    ),
    roleArn = "string",
    status = "string",
    creationDateTime = as.POSIXct(
      "2015-01-01"
    ),
    lastUpdatedDateTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Gets the properties of a batch inference job including name, Amazon
Resource Name (ARN), status, input and output configurations, and the
ARN of the solution version used to generate the recommendations.
}
\section{Request syntax}{
\preformatted{svc$describe_batch_inference_job(
  batchInferenceJobArn = "string"
)
}
}

\keyword{internal}
