% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_segment_detection}
\alias{rekognition_start_segment_detection}
\title{Starts asynchronous detection of segment detection in a stored video}
\usage{
rekognition_start_segment_detection(Video, ClientRequestToken,
  NotificationChannel, JobTag, Filters, SegmentTypes)
}
\arguments{
\item{Video}{[required]}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple \code{StartSegmentDetection} requests, the same \code{JobId}
is returned. Use \code{ClientRequestToken} to prevent the same job from being
accidently started more than once.}

\item{NotificationChannel}{The ARN of the Amazon SNS topic to which you want Amazon Rekognition
Video to publish the completion status of the segment detection
operation.}

\item{JobTag}{An identifier you specify that's returned in the completion notification
that's published to your Amazon Simple Notification Service topic. For
example, you can use \code{JobTag} to group related jobs and identify them in
the completion notification.}

\item{Filters}{Filters for technical cue or shot detection.}

\item{SegmentTypes}{[required] An array of segment types to detect in the video. Valid values are
TECHNICAL\\_CUE and SHOT.}
}
\description{
Starts asynchronous detection of segment detection in a stored video.

Amazon Rekognition Video can detect segments in a video stored in an
Amazon S3 bucket. Use Video to specify the bucket name and the filename
of the video. \code{StartSegmentDetection} returns a job identifier (\code{JobId})
which you use to get the results of the operation. When segment
detection is finished, Amazon Rekognition Video publishes a completion
status to the Amazon Simple Notification Service topic that you specify
in \code{NotificationChannel}.

You can use the \code{Filters} (StartSegmentDetectionFilters) input parameter
to specify the minimum detection confidence returned in the response.
Within \code{Filters}, use \code{ShotFilter} (StartShotDetectionFilter) to filter
detected shots. Use \code{TechnicalCueFilter}
(StartTechnicalCueDetectionFilter) to filter technical cues.

To get the results of the segment detection operation, first check that
the status value published to the Amazon SNS topic is \code{SUCCEEDED}. if
so, call GetSegmentDetection and pass the job identifier (\code{JobId}) from
the initial call to \code{StartSegmentDetection}.

For more information, see Detecting Video Segments in Stored Video in
the Amazon Rekognition Developer Guide.
}
\section{Request syntax}{
\preformatted{svc$start_segment_detection(
  Video = list(
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  ClientRequestToken = "string",
  NotificationChannel = list(
    SNSTopicArn = "string",
    RoleArn = "string"
  ),
  JobTag = "string",
  Filters = list(
    TechnicalCueFilter = list(
      MinSegmentConfidence = 123.0
    ),
    ShotFilter = list(
      MinSegmentConfidence = 123.0
    )
  ),
  SegmentTypes = list(
    "TECHNICAL_CUE"|"SHOT"
  )
)
}
}

\keyword{internal}
