% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_put_lexicon}
\alias{polly_put_lexicon}
\title{Stores a pronunciation lexicon in an AWS Region}
\usage{
polly_put_lexicon(Name, Content)
}
\arguments{
\item{Name}{[required] Name of the lexicon. The name must follow the regular express format
[0-9A-Za-z]\{1,20\}. That is, the name is a case-sensitive alphanumeric
string up to 20 characters long.}

\item{Content}{[required] Content of the PLS lexicon as string data.}
}
\description{
Stores a pronunciation lexicon in an AWS Region. If a lexicon with the
same name already exists in the region, it is overwritten by the new
lexicon. Lexicon operations have eventual consistency, therefore, it
might take some time before the lexicon is available to the
SynthesizeSpeech operation.

For more information, see \href{https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html}{Managing Lexicons}.
}
\section{Request syntax}{
\preformatted{svc$put_lexicon(
  Name = "string",
  Content = "string"
)
}
}

\examples{
\dontrun{
# Stores a pronunciation lexicon in an AWS Region.
svc$put_lexicon(
  Content = "file://example.pls",
  Name = "W3C"
)
}

}
\keyword{internal}
