% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_face_detection}
\alias{rekognition_start_face_detection}
\title{Starts asynchronous detection of faces in a stored video}
\usage{
rekognition_start_face_detection(Video, ClientRequestToken,
  NotificationChannel, FaceAttributes, JobTag)
}
\arguments{
\item{Video}{[required] The video in which you want to detect faces. The video must be stored in
an Amazon S3 bucket.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple \code{StartFaceDetection} requests, the same \code{JobId} is
returned. Use \code{ClientRequestToken} to prevent the same job from being
accidently started more than once.}

\item{NotificationChannel}{The ARN of the Amazon SNS topic to which you want Amazon Rekognition
Video to publish the completion status of the face detection operation.}

\item{FaceAttributes}{The face attributes you want returned.

\code{DEFAULT} - The following subset of facial attributes are returned:
BoundingBox, Confidence, Pose, Quality and Landmarks.

\code{ALL} - All facial attributes are returned.}

\item{JobTag}{Unique identifier you specify to identify the job in the completion
status published to the Amazon Simple Notification Service topic.}
}
\description{
Starts asynchronous detection of faces in a stored video.
}
\details{
Amazon Rekognition Video can detect faces in a video stored in an Amazon
S3 bucket. Use Video to specify the bucket name and the filename of the
video. \code{StartFaceDetection} returns a job identifier (\code{JobId}) that you
use to get the results of the operation. When face detection is
finished, Amazon Rekognition Video publishes a completion status to the
Amazon Simple Notification Service topic that you specify in
\code{NotificationChannel}. To get the results of the face detection
operation, first check that the status value published to the Amazon SNS
topic is \code{SUCCEEDED}. If so, call GetFaceDetection and pass the job
identifier (\code{JobId}) from the initial call to \code{StartFaceDetection}.

For more information, see Detecting Faces in a Stored Video in the
Amazon Rekognition Developer Guide.
}
\section{Request syntax}{
\preformatted{svc$start_face_detection(
  Video = list(
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  ClientRequestToken = "string",
  NotificationChannel = list(
    SNSTopicArn = "string",
    RoleArn = "string"
  ),
  FaceAttributes = "DEFAULT"|"ALL",
  JobTag = "string"
)
}
}

\keyword{internal}
