% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimblestudio_operations.R
\name{nimblestudio_create_studio}
\alias{nimblestudio_create_studio}
\title{Create a new Studio}
\usage{
nimblestudio_create_studio(
  adminRoleArn,
  clientToken = NULL,
  displayName,
  studioEncryptionConfiguration = NULL,
  studioName,
  tags = NULL,
  userRoleArn
)
}
\arguments{
\item{adminRoleArn}{[required] The IAM role that Studio Admins will assume when logging in to the
Nimble Studio portal.}

\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don’t specify a client token, the AWS
SDK automatically generates a client token and uses it for the request
to ensure idempotency.}

\item{displayName}{[required] A friendly name for the studio.}

\item{studioEncryptionConfiguration}{The studio encryption configuration.}

\item{studioName}{[required] The studio name that is used in the URL of the Nimble Studio portal when
accessed by Nimble Studio users.}

\item{tags}{A collection of labels, in the form of key:value pairs, that apply to
this resource.}

\item{userRoleArn}{[required] The IAM role that Studio Users will assume when logging in to the Nimble
Studio portal.}
}
\description{
Create a new Studio.

See \url{https://paws-r.github.io/docs/nimblestudio/create_studio.html} for full documentation.
}
\keyword{internal}
