% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_create_workspaces}
\alias{workspaces_create_workspaces}
\title{Creates one or more WorkSpaces}
\usage{
workspaces_create_workspaces(Workspaces)
}
\arguments{
\item{Workspaces}{[required] The WorkSpaces to create. You can specify up to 25 WorkSpaces.}
}
\value{
A list with the following syntax:\preformatted{list(
  FailedRequests = list(
    list(
      WorkspaceRequest = list(
        DirectoryId = "string",
        UserName = "string",
        BundleId = "string",
        VolumeEncryptionKey = "string",
        UserVolumeEncryptionEnabled = TRUE|FALSE,
        RootVolumeEncryptionEnabled = TRUE|FALSE,
        WorkspaceProperties = list(
          RunningMode = "AUTO_STOP"|"ALWAYS_ON",
          RunningModeAutoStopTimeoutInMinutes = 123,
          RootVolumeSizeGib = 123,
          UserVolumeSizeGib = 123,
          ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
        ),
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      ),
      ErrorCode = "string",
      ErrorMessage = "string"
    )
  ),
  PendingRequests = list(
    list(
      WorkspaceId = "string",
      DirectoryId = "string",
      UserName = "string",
      IpAddress = "string",
      State = "PENDING"|"AVAILABLE"|"IMPAIRED"|"UNHEALTHY"|"REBOOTING"|"STARTING"|"REBUILDING"|"RESTORING"|"MAINTENANCE"|"ADMIN_MAINTENANCE"|"TERMINATING"|"TERMINATED"|"SUSPENDED"|"UPDATING"|"STOPPING"|"STOPPED"|"ERROR",
      BundleId = "string",
      SubnetId = "string",
      ErrorMessage = "string",
      ErrorCode = "string",
      ComputerName = "string",
      VolumeEncryptionKey = "string",
      UserVolumeEncryptionEnabled = TRUE|FALSE,
      RootVolumeEncryptionEnabled = TRUE|FALSE,
      WorkspaceProperties = list(
        RunningMode = "AUTO_STOP"|"ALWAYS_ON",
        RunningModeAutoStopTimeoutInMinutes = 123,
        RootVolumeSizeGib = 123,
        UserVolumeSizeGib = 123,
        ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
      ),
      ModificationStates = list(
        list(
          Resource = "ROOT_VOLUME"|"USER_VOLUME"|"COMPUTE_TYPE",
          State = "UPDATE_INITIATED"|"UPDATE_IN_PROGRESS"
        )
      )
    )
  )
)
}
}
\description{
Creates one or more WorkSpaces.

This operation is asynchronous and returns before the WorkSpaces are
created.
}
\section{Request syntax}{
\preformatted{svc$create_workspaces(
  Workspaces = list(
    list(
      DirectoryId = "string",
      UserName = "string",
      BundleId = "string",
      VolumeEncryptionKey = "string",
      UserVolumeEncryptionEnabled = TRUE|FALSE,
      RootVolumeEncryptionEnabled = TRUE|FALSE,
      WorkspaceProperties = list(
        RunningMode = "AUTO_STOP"|"ALWAYS_ON",
        RunningModeAutoStopTimeoutInMinutes = 123,
        RootVolumeSizeGib = 123,
        UserVolumeSizeGib = 123,
        ComputeTypeName = "VALUE"|"STANDARD"|"PERFORMANCE"|"POWER"|"GRAPHICS"|"POWERPRO"|"GRAPHICSPRO"
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
