% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_get_current_user}
\alias{workdocs_get_current_user}
\title{Retrieves details of the current user for whom the authentication token
was generated}
\usage{
workdocs_get_current_user(AuthenticationToken)
}
\arguments{
\item{AuthenticationToken}{[required] Amazon WorkDocs authentication token.}
}
\value{
A list with the following syntax:\preformatted{list(
  User = list(
    Id = "string",
    Username = "string",
    EmailAddress = "string",
    GivenName = "string",
    Surname = "string",
    OrganizationId = "string",
    RootFolderId = "string",
    RecycleBinFolderId = "string",
    Status = "ACTIVE"|"INACTIVE"|"PENDING",
    Type = "USER"|"ADMIN"|"POWERUSER"|"MINIMALUSER"|"WORKSPACESUSER",
    CreatedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ModifiedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    TimeZoneId = "string",
    Locale = "en"|"fr"|"ko"|"de"|"es"|"ja"|"ru"|"zh_CN"|"zh_TW"|"pt_BR"|"default",
    Storage = list(
      StorageUtilizedInBytes = 123,
      StorageRule = list(
        StorageAllocatedInBytes = 123,
        StorageType = "UNLIMITED"|"QUOTA"
      )
    )
  )
)
}
}
\description{
Retrieves details of the current user for whom the authentication token
was generated. This is not a valid action for SigV4 (administrative API)
clients.

This action requires an authentication token. To get an authentication
token, register an application with Amazon WorkDocs. For more
information, see \href{https://docs.aws.amazon.com/workdocs/latest/developerguide/wd-auth-user.html}{Authentication and Access Control for User Applications}
in the \emph{Amazon WorkDocs Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_current_user(
  AuthenticationToken = "string"
)
}
}

\keyword{internal}
