% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_tag_resource}
\alias{xray_tag_resource}
\title{Applies tags to an existing Amazon Web Services X-Ray group or sampling
rule}
\usage{
xray_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.}

\item{Tags}{[required] A map that contains one or more tag keys and tag values to attach to an
X-Ray group or sampling rule. For more information about ways to use
tags, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}
in the \emph{Amazon Web Services General Reference}.

The following restrictions apply to tags:
\itemize{
\item Maximum number of user-applied tags per resource: 50
\item Maximum tag key length: 128 Unicode characters
\item Maximum tag value length: 256 Unicode characters
\item Valid values for key and value: a-z, A-Z, 0-9, space, and the
following characters: _ . : / = + - and @
\item Tag keys and values are case sensitive.
\item Don't use \verb{aws:} as a prefix for keys; it's reserved for Amazon Web
Services use. You cannot edit or delete system tags.
}}
}
\description{
Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.

See \url{https://www.paws-r-sdk.com/docs/xray_tag_resource/} for full documentation.
}
\keyword{internal}
