% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecatalyst_operations.R
\name{codecatalyst_create_access_token}
\alias{codecatalyst_create_access_token}
\title{Creates a personal access token (PAT) for the current user}
\usage{
codecatalyst_create_access_token(name, expiresTime = NULL)
}
\arguments{
\item{name}{[required] The friendly name of the personal access token.}

\item{expiresTime}{The date and time the personal access token expires, in coordinated
universal time (UTC) timestamp format as specified in \href{https://www.rfc-editor.org/rfc/rfc3339#section-5.6}{RFC 3339}.}
}
\description{
Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user identity for use across all spaces and projects in Amazon CodeCatalyst. You use PATs to access CodeCatalyst from resources that include integrated development environments (IDEs) and Git-based source repositories. PATs represent you in Amazon CodeCatalyst and you can manage them in your user settings.For more information, see \href{https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html}{Managing personal access tokens in Amazon CodeCatalyst}.

See \url{https://www.paws-r-sdk.com/docs/codecatalyst_create_access_token/} for full documentation.
}
\keyword{internal}
