# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codestarconnections_service.R
NULL

#' Creates a connection that can then be given to other Amazon Web Services
#' services like CodePipeline so that it can access third-party code
#' repositories
#'
#' @description
#' Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_create_connection/](https://www.paws-r-sdk.com/docs/codestarconnections_create_connection/) for full documentation.
#'
#' @param ProviderType The name of the external provider where your third-party code repository
#' is configured.
#' @param ConnectionName &#91;required&#93; The name of the connection to be created.
#' @param Tags The key-value pair to use when tagging the resource.
#' @param HostArn The Amazon Resource Name (ARN) of the host associated with the
#' connection to be created.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_create_connection
codestarconnections_create_connection <- function(ProviderType = NULL, ConnectionName, Tags = NULL, HostArn = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$create_connection_input(ProviderType = ProviderType, ConnectionName = ConnectionName, Tags = Tags, HostArn = HostArn)
  output <- .codestarconnections$create_connection_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$create_connection <- codestarconnections_create_connection

#' Creates a resource that represents the infrastructure where a
#' third-party provider is installed
#'
#' @description
#' Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_create_host/](https://www.paws-r-sdk.com/docs/codestarconnections_create_host/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the host to be created.
#' @param ProviderType &#91;required&#93; The name of the installed provider to be associated with your
#' connection. The host resource represents the infrastructure where your
#' provider type is installed. The valid provider type is GitHub Enterprise
#' Server.
#' @param ProviderEndpoint &#91;required&#93; The endpoint of the infrastructure to be represented by the host after
#' it is created.
#' @param VpcConfiguration The VPC configuration to be provisioned for the host. A VPC must be
#' configured and the infrastructure to be represented by the host must
#' already be connected to the VPC.
#' @param Tags Tags for the host to be created.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_create_host
codestarconnections_create_host <- function(Name, ProviderType, ProviderEndpoint, VpcConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$create_host_input(Name = Name, ProviderType = ProviderType, ProviderEndpoint = ProviderEndpoint, VpcConfiguration = VpcConfiguration, Tags = Tags)
  output <- .codestarconnections$create_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$create_host <- codestarconnections_create_host

#' Creates a link to a specified external Git repository
#'
#' @description
#' Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_create_repository_link/](https://www.paws-r-sdk.com/docs/codestarconnections_create_repository_link/) for full documentation.
#'
#' @param ConnectionArn &#91;required&#93; The Amazon Resource Name (ARN) of the connection to be associated with
#' the repository link.
#' @param OwnerId &#91;required&#93; The owner ID for the repository associated with a specific sync
#' configuration, such as the owner ID in GitHub.
#' @param RepositoryName &#91;required&#93; The name of the repository to be associated with the repository link.
#' @param EncryptionKeyArn The Amazon Resource Name (ARN) encryption key for the repository to be
#' associated with the repository link.
#' @param Tags The tags for the repository to be associated with the repository link.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_create_repository_link
codestarconnections_create_repository_link <- function(ConnectionArn, OwnerId, RepositoryName, EncryptionKeyArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateRepositoryLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$create_repository_link_input(ConnectionArn = ConnectionArn, OwnerId = OwnerId, RepositoryName = RepositoryName, EncryptionKeyArn = EncryptionKeyArn, Tags = Tags)
  output <- .codestarconnections$create_repository_link_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$create_repository_link <- codestarconnections_create_repository_link

#' Creates a sync configuration which allows Amazon Web Services to sync
#' content from a Git repository to update a specified Amazon Web Services
#' resource
#'
#' @description
#' Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_create_sync_configuration/](https://www.paws-r-sdk.com/docs/codestarconnections_create_sync_configuration/) for full documentation.
#'
#' @param Branch &#91;required&#93; The branch in the repository from which changes will be synced.
#' @param ConfigFile &#91;required&#93; The file name of the configuration file that manages syncing between the
#' connection and the repository. This configuration file is stored in the
#' repository.
#' @param RepositoryLinkId &#91;required&#93; The ID of the repository link created for the connection. A repository
#' link allows Git sync to monitor and sync changes to files in a specified
#' Git repository.
#' @param ResourceName &#91;required&#93; The name of the Amazon Web Services resource (for example, a
#' CloudFormation stack in the case of CFN_STACK_SYNC) that will be
#' synchronized from the linked repository.
#' @param RoleArn &#91;required&#93; The ARN of the IAM role that grants permission for Amazon Web Services
#' to use Git sync to update a given Amazon Web Services resource on your
#' behalf.
#' @param SyncType &#91;required&#93; The type of sync configuration.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_create_sync_configuration
codestarconnections_create_sync_configuration <- function(Branch, ConfigFile, RepositoryLinkId, ResourceName, RoleArn, SyncType) {
  op <- new_operation(
    name = "CreateSyncConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$create_sync_configuration_input(Branch = Branch, ConfigFile = ConfigFile, RepositoryLinkId = RepositoryLinkId, ResourceName = ResourceName, RoleArn = RoleArn, SyncType = SyncType)
  output <- .codestarconnections$create_sync_configuration_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$create_sync_configuration <- codestarconnections_create_sync_configuration

#' The connection to be deleted
#'
#' @description
#' The connection to be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_delete_connection/](https://www.paws-r-sdk.com/docs/codestarconnections_delete_connection/) for full documentation.
#'
#' @param ConnectionArn &#91;required&#93; The Amazon Resource Name (ARN) of the connection to be deleted.
#' 
#' The ARN is never reused if the connection is deleted.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_delete_connection
codestarconnections_delete_connection <- function(ConnectionArn) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$delete_connection_input(ConnectionArn = ConnectionArn)
  output <- .codestarconnections$delete_connection_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$delete_connection <- codestarconnections_delete_connection

#' The host to be deleted
#'
#' @description
#' The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_delete_host/](https://www.paws-r-sdk.com/docs/codestarconnections_delete_host/) for full documentation.
#'
#' @param HostArn &#91;required&#93; The Amazon Resource Name (ARN) of the host to be deleted.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_delete_host
codestarconnections_delete_host <- function(HostArn) {
  op <- new_operation(
    name = "DeleteHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$delete_host_input(HostArn = HostArn)
  output <- .codestarconnections$delete_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$delete_host <- codestarconnections_delete_host

#' Deletes the association between your connection and a specified external
#' Git repository
#'
#' @description
#' Deletes the association between your connection and a specified external Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_delete_repository_link/](https://www.paws-r-sdk.com/docs/codestarconnections_delete_repository_link/) for full documentation.
#'
#' @param RepositoryLinkId &#91;required&#93; The ID of the repository link to be deleted.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_delete_repository_link
codestarconnections_delete_repository_link <- function(RepositoryLinkId) {
  op <- new_operation(
    name = "DeleteRepositoryLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$delete_repository_link_input(RepositoryLinkId = RepositoryLinkId)
  output <- .codestarconnections$delete_repository_link_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$delete_repository_link <- codestarconnections_delete_repository_link

#' Deletes the sync configuration for a specified repository and connection
#'
#' @description
#' Deletes the sync configuration for a specified repository and connection.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_delete_sync_configuration/](https://www.paws-r-sdk.com/docs/codestarconnections_delete_sync_configuration/) for full documentation.
#'
#' @param SyncType &#91;required&#93; The type of sync configuration to be deleted.
#' @param ResourceName &#91;required&#93; The name of the Amazon Web Services resource associated with the sync
#' configuration to be deleted.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_delete_sync_configuration
codestarconnections_delete_sync_configuration <- function(SyncType, ResourceName) {
  op <- new_operation(
    name = "DeleteSyncConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$delete_sync_configuration_input(SyncType = SyncType, ResourceName = ResourceName)
  output <- .codestarconnections$delete_sync_configuration_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$delete_sync_configuration <- codestarconnections_delete_sync_configuration

#' Returns the connection ARN and details such as status, owner, and
#' provider type
#'
#' @description
#' Returns the connection ARN and details such as status, owner, and provider type.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_connection/](https://www.paws-r-sdk.com/docs/codestarconnections_get_connection/) for full documentation.
#'
#' @param ConnectionArn &#91;required&#93; The Amazon Resource Name (ARN) of a connection.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_connection
codestarconnections_get_connection <- function(ConnectionArn) {
  op <- new_operation(
    name = "GetConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_connection_input(ConnectionArn = ConnectionArn)
  output <- .codestarconnections$get_connection_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_connection <- codestarconnections_get_connection

#' Returns the host ARN and details such as status, provider type,
#' endpoint, and, if applicable, the VPC configuration
#'
#' @description
#' Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_host/](https://www.paws-r-sdk.com/docs/codestarconnections_get_host/) for full documentation.
#'
#' @param HostArn &#91;required&#93; The Amazon Resource Name (ARN) of the requested host.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_host
codestarconnections_get_host <- function(HostArn) {
  op <- new_operation(
    name = "GetHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_host_input(HostArn = HostArn)
  output <- .codestarconnections$get_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_host <- codestarconnections_get_host

#' Returns details about a repository link
#'
#' @description
#' Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files in a specified Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_repository_link/](https://www.paws-r-sdk.com/docs/codestarconnections_get_repository_link/) for full documentation.
#'
#' @param RepositoryLinkId &#91;required&#93; The ID of the repository link to get.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_repository_link
codestarconnections_get_repository_link <- function(RepositoryLinkId) {
  op <- new_operation(
    name = "GetRepositoryLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_repository_link_input(RepositoryLinkId = RepositoryLinkId)
  output <- .codestarconnections$get_repository_link_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_repository_link <- codestarconnections_get_repository_link

#' Returns details about the sync status for a repository
#'
#' @description
#' Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes from your remote repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_repository_sync_status/](https://www.paws-r-sdk.com/docs/codestarconnections_get_repository_sync_status/) for full documentation.
#'
#' @param Branch &#91;required&#93; The branch of the repository link for the requested repository sync
#' status.
#' @param RepositoryLinkId &#91;required&#93; The repository link ID for the requested repository sync status.
#' @param SyncType &#91;required&#93; The sync type of the requested sync status.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_repository_sync_status
codestarconnections_get_repository_sync_status <- function(Branch, RepositoryLinkId, SyncType) {
  op <- new_operation(
    name = "GetRepositorySyncStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_repository_sync_status_input(Branch = Branch, RepositoryLinkId = RepositoryLinkId, SyncType = SyncType)
  output <- .codestarconnections$get_repository_sync_status_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_repository_sync_status <- codestarconnections_get_repository_sync_status

#' Returns the status of the sync with the Git repository for a specific
#' Amazon Web Services resource
#'
#' @description
#' Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_resource_sync_status/](https://www.paws-r-sdk.com/docs/codestarconnections_get_resource_sync_status/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The name of the Amazon Web Services resource for the sync status with
#' the Git repository.
#' @param SyncType &#91;required&#93; The sync type for the sync status with the Git repository.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_resource_sync_status
codestarconnections_get_resource_sync_status <- function(ResourceName, SyncType) {
  op <- new_operation(
    name = "GetResourceSyncStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_resource_sync_status_input(ResourceName = ResourceName, SyncType = SyncType)
  output <- .codestarconnections$get_resource_sync_status_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_resource_sync_status <- codestarconnections_get_resource_sync_status

#' Returns a list of the most recent sync blockers
#'
#' @description
#' Returns a list of the most recent sync blockers.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_sync_blocker_summary/](https://www.paws-r-sdk.com/docs/codestarconnections_get_sync_blocker_summary/) for full documentation.
#'
#' @param SyncType &#91;required&#93; The sync type for the sync blocker summary.
#' @param ResourceName &#91;required&#93; The name of the Amazon Web Services resource currently blocked from
#' automatically being synced from a Git repository.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_sync_blocker_summary
codestarconnections_get_sync_blocker_summary <- function(SyncType, ResourceName) {
  op <- new_operation(
    name = "GetSyncBlockerSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_sync_blocker_summary_input(SyncType = SyncType, ResourceName = ResourceName)
  output <- .codestarconnections$get_sync_blocker_summary_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_sync_blocker_summary <- codestarconnections_get_sync_blocker_summary

#' Returns details about a sync configuration, including the sync type and
#' resource name
#'
#' @description
#' Returns details about a sync configuration, including the sync type and resource name. A sync configuration allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_get_sync_configuration/](https://www.paws-r-sdk.com/docs/codestarconnections_get_sync_configuration/) for full documentation.
#'
#' @param SyncType &#91;required&#93; The sync type for the sync configuration for which you want to retrieve
#' information.
#' @param ResourceName &#91;required&#93; The name of the Amazon Web Services resource for the sync configuration
#' for which you want to retrieve information.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_get_sync_configuration
codestarconnections_get_sync_configuration <- function(SyncType, ResourceName) {
  op <- new_operation(
    name = "GetSyncConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$get_sync_configuration_input(SyncType = SyncType, ResourceName = ResourceName)
  output <- .codestarconnections$get_sync_configuration_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$get_sync_configuration <- codestarconnections_get_sync_configuration

#' Lists the connections associated with your account
#'
#' @description
#' Lists the connections associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_list_connections/](https://www.paws-r-sdk.com/docs/codestarconnections_list_connections/) for full documentation.
#'
#' @param ProviderTypeFilter Filters the list of connections to those associated with a specified
#' provider, such as Bitbucket.
#' @param HostArnFilter Filters the list of connections to those associated with a specified
#' host.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token that was returned from the previous
#' [`list_connections`][codestarconnections_list_connections] call, which
#' can be used to return the next set of connections in the list.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_connections
codestarconnections_list_connections <- function(ProviderTypeFilter = NULL, HostArnFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .codestarconnections$list_connections_input(ProviderTypeFilter = ProviderTypeFilter, HostArnFilter = HostArnFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .codestarconnections$list_connections_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_connections <- codestarconnections_list_connections

#' Lists the hosts associated with your account
#'
#' @description
#' Lists the hosts associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_list_hosts/](https://www.paws-r-sdk.com/docs/codestarconnections_list_hosts/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token that was returned from the previous
#' [`list_hosts`][codestarconnections_list_hosts] call, which can be used
#' to return the next set of hosts in the list.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_hosts
codestarconnections_list_hosts <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .codestarconnections$list_hosts_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .codestarconnections$list_hosts_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_hosts <- codestarconnections_list_hosts

#' Lists the repository links created for connections in your account
#'
#' @description
#' Lists the repository links created for connections in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_list_repository_links/](https://www.paws-r-sdk.com/docs/codestarconnections_list_repository_links/) for full documentation.
#'
#' @param MaxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#' @param NextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_repository_links
codestarconnections_list_repository_links <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRepositoryLinks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .codestarconnections$list_repository_links_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .codestarconnections$list_repository_links_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_repository_links <- codestarconnections_list_repository_links

#' Lists the repository sync definitions for repository links in your
#' account
#'
#' @description
#' Lists the repository sync definitions for repository links in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_list_repository_sync_definitions/](https://www.paws-r-sdk.com/docs/codestarconnections_list_repository_sync_definitions/) for full documentation.
#'
#' @param RepositoryLinkId &#91;required&#93; The ID of the repository link for the sync definition for which you want
#' to retrieve information.
#' @param SyncType &#91;required&#93; The sync type of the repository link for the the sync definition for
#' which you want to retrieve information.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_repository_sync_definitions
codestarconnections_list_repository_sync_definitions <- function(RepositoryLinkId, SyncType) {
  op <- new_operation(
    name = "ListRepositorySyncDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$list_repository_sync_definitions_input(RepositoryLinkId = RepositoryLinkId, SyncType = SyncType)
  output <- .codestarconnections$list_repository_sync_definitions_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_repository_sync_definitions <- codestarconnections_list_repository_sync_definitions

#' Returns a list of sync configurations for a specified repository
#'
#' @description
#' Returns a list of sync configurations for a specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_list_sync_configurations/](https://www.paws-r-sdk.com/docs/codestarconnections_list_sync_configurations/) for full documentation.
#'
#' @param MaxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#' @param NextToken An enumeration token that allows the operation to batch the results of
#' the operation.
#' @param RepositoryLinkId &#91;required&#93; The ID of the repository link for the requested list of sync
#' configurations.
#' @param SyncType &#91;required&#93; The sync type for the requested list of sync configurations.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_sync_configurations
codestarconnections_list_sync_configurations <- function(MaxResults = NULL, NextToken = NULL, RepositoryLinkId, SyncType) {
  op <- new_operation(
    name = "ListSyncConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .codestarconnections$list_sync_configurations_input(MaxResults = MaxResults, NextToken = NextToken, RepositoryLinkId = RepositoryLinkId, SyncType = SyncType)
  output <- .codestarconnections$list_sync_configurations_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_sync_configurations <- codestarconnections_list_sync_configurations

#' Gets the set of key-value pairs (metadata) that are used to manage the
#' resource
#'
#' @description
#' Gets the set of key-value pairs (metadata) that are used to manage the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codestarconnections_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to get
#' information about tags, if any.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_list_tags_for_resource
codestarconnections_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .codestarconnections$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$list_tags_for_resource <- codestarconnections_list_tags_for_resource

#' Adds to or modifies the tags of the given resource
#'
#' @description
#' Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_tag_resource/](https://www.paws-r-sdk.com/docs/codestarconnections_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which you want to add
#' or update tags.
#' @param Tags &#91;required&#93; The tags you want to modify or add to the resource.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_tag_resource
codestarconnections_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .codestarconnections$tag_resource_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$tag_resource <- codestarconnections_tag_resource

#' Removes tags from an Amazon Web Services resource
#'
#' @description
#' Removes tags from an Amazon Web Services resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_untag_resource/](https://www.paws-r-sdk.com/docs/codestarconnections_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove tags from.
#' @param TagKeys &#91;required&#93; The list of keys for the tags to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_untag_resource
codestarconnections_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .codestarconnections$untag_resource_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$untag_resource <- codestarconnections_untag_resource

#' Updates a specified host with the provided configurations
#'
#' @description
#' Updates a specified host with the provided configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_update_host/](https://www.paws-r-sdk.com/docs/codestarconnections_update_host/) for full documentation.
#'
#' @param HostArn &#91;required&#93; The Amazon Resource Name (ARN) of the host to be updated.
#' @param ProviderEndpoint The URL or endpoint of the host to be updated.
#' @param VpcConfiguration The VPC configuration of the host to be updated. A VPC must be
#' configured and the infrastructure to be represented by the host must
#' already be connected to the VPC.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_update_host
codestarconnections_update_host <- function(HostArn, ProviderEndpoint = NULL, VpcConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateHost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$update_host_input(HostArn = HostArn, ProviderEndpoint = ProviderEndpoint, VpcConfiguration = VpcConfiguration)
  output <- .codestarconnections$update_host_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$update_host <- codestarconnections_update_host

#' Updates the association between your connection and a specified external
#' Git repository
#'
#' @description
#' Updates the association between your connection and a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_update_repository_link/](https://www.paws-r-sdk.com/docs/codestarconnections_update_repository_link/) for full documentation.
#'
#' @param ConnectionArn The Amazon Resource Name (ARN) of the connection for the repository link
#' to be updated. The updated connection ARN must have the same
#' providerType (such as GitHub) as the original connection ARN for the
#' repo link.
#' @param EncryptionKeyArn The Amazon Resource Name (ARN) of the encryption key for the repository
#' link to be updated.
#' @param RepositoryLinkId &#91;required&#93; The ID of the repository link to be updated.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_update_repository_link
codestarconnections_update_repository_link <- function(ConnectionArn = NULL, EncryptionKeyArn = NULL, RepositoryLinkId) {
  op <- new_operation(
    name = "UpdateRepositoryLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$update_repository_link_input(ConnectionArn = ConnectionArn, EncryptionKeyArn = EncryptionKeyArn, RepositoryLinkId = RepositoryLinkId)
  output <- .codestarconnections$update_repository_link_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$update_repository_link <- codestarconnections_update_repository_link

#' Allows you to update the status of a sync blocker, resolving the blocker
#' and allowing syncing to continue
#'
#' @description
#' Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_update_sync_blocker/](https://www.paws-r-sdk.com/docs/codestarconnections_update_sync_blocker/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the sync blocker to be updated.
#' @param SyncType &#91;required&#93; The sync type of the sync blocker to be updated.
#' @param ResourceName &#91;required&#93; The name of the resource for the sync blocker to be updated.
#' @param ResolvedReason &#91;required&#93; The reason for resolving the sync blocker.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_update_sync_blocker
codestarconnections_update_sync_blocker <- function(Id, SyncType, ResourceName, ResolvedReason) {
  op <- new_operation(
    name = "UpdateSyncBlocker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$update_sync_blocker_input(Id = Id, SyncType = SyncType, ResourceName = ResourceName, ResolvedReason = ResolvedReason)
  output <- .codestarconnections$update_sync_blocker_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$update_sync_blocker <- codestarconnections_update_sync_blocker

#' Updates the sync configuration for your connection and a specified
#' external Git repository
#'
#' @description
#' Updates the sync configuration for your connection and a specified external Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codestarconnections_update_sync_configuration/](https://www.paws-r-sdk.com/docs/codestarconnections_update_sync_configuration/) for full documentation.
#'
#' @param Branch The branch for the sync configuration to be updated.
#' @param ConfigFile The configuration file for the sync configuration to be updated.
#' @param RepositoryLinkId The ID of the repository link for the sync configuration to be updated.
#' @param ResourceName &#91;required&#93; The name of the Amazon Web Services resource for the sync configuration
#' to be updated.
#' @param RoleArn The ARN of the IAM role for the sync configuration to be updated.
#' @param SyncType &#91;required&#93; The sync type for the sync configuration to be updated.
#'
#' @keywords internal
#'
#' @rdname codestarconnections_update_sync_configuration
codestarconnections_update_sync_configuration <- function(Branch = NULL, ConfigFile = NULL, RepositoryLinkId = NULL, ResourceName, RoleArn = NULL, SyncType) {
  op <- new_operation(
    name = "UpdateSyncConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codestarconnections$update_sync_configuration_input(Branch = Branch, ConfigFile = ConfigFile, RepositoryLinkId = RepositoryLinkId, ResourceName = ResourceName, RoleArn = RoleArn, SyncType = SyncType)
  output <- .codestarconnections$update_sync_configuration_output()
  config <- get_config()
  svc <- .codestarconnections$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codestarconnections$operations$update_sync_configuration <- codestarconnections_update_sync_configuration
