% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_create_user_profile}
\alias{codestar_create_user_profile}
\title{Creates a profile for a user that includes user preferences, such as the
display name and email address assocciated with the user, in AWS
CodeStar}
\usage{
codestar_create_user_profile(
  userArn,
  displayName,
  emailAddress,
  sshPublicKey = NULL
)
}
\arguments{
\item{userArn}{[required] The Amazon Resource Name (ARN) of the user in IAM.}

\item{displayName}{[required] The name that will be displayed as the friendly name for the user in AWS
CodeStar.}

\item{emailAddress}{[required] The email address that will be displayed as part of the user's profile
in AWS CodeStar.}

\item{sshPublicKey}{The SSH public key associated with the user in AWS CodeStar. If a
project owner allows the user remote access to project resources, this
public key will be used along with the user's private key for SSH
access.}
}
\description{
Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.

See \url{https://www.paws-r-sdk.com/docs/codestar_create_user_profile/} for full documentation.
}
\keyword{internal}
